/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.packet.IPacketHandler;
import xaero.pac.common.packet.payload.PacketPayload;
import xaero.pac.common.packet.type.PacketType;
import xaero.pac.common.packet.type.PacketTypeManager;

public abstract class PacketHandlerFull
implements IPacketHandler {
    protected final PacketTypeManager packetTypeManager;

    protected PacketHandlerFull(PacketTypeManager packetTypeManager) {
        this.packetTypeManager = packetTypeManager;
    }

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, P> decoder, BiConsumer<P, ServerPlayer> serverHandler, Consumer<P> clientHandler) {
        this.packetTypeManager.register(index, type, encoder, decoder, serverHandler, clientHandler);
    }

    public static <T> void encodePacket(PacketType<T> packetType, T packet, FriendlyByteBuf buffer) {
        if (packetType == null) {
            throw new IllegalArgumentException("unregistered packet class!");
        }
        buffer.writeByte(packetType.getIndex());
        packetType.getEncoder().accept(packet, buffer);
    }

    <T> FriendlyByteBuf getPacketBuffer(T packet) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        PacketHandlerFull.encodePacket(this.packetTypeManager.getType(packet), packet, buffer);
        return buffer;
    }

    public PacketType<?> getPacketTypeByIndex(int index) {
        return this.packetTypeManager.getByIndex(index);
    }

    public PacketType<?> getByIndex(int index) {
        return this.packetTypeManager.getByIndex(index);
    }

    public <T> PacketPayload<T> createPayload(T packet) {
        return new PacketPayload<T>(this.packetTypeManager.getType(packet), packet);
    }

    public static abstract class Builder {
        protected Builder() {
        }

        public Builder setDefault() {
            return this;
        }

        public PacketHandlerFull build() {
            PacketTypeManager packetTypeManager = PacketTypeManager.Builder.begin(Int2ObjectOpenHashMap::new, HashMap::new).build();
            return this.buildInternal(packetTypeManager);
        }

        protected abstract PacketHandlerFull buildInternal(PacketTypeManager var1);
    }
}

