/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeConfigSpec;
import xaero.pac.common.player.config.dynamic.PlayerConfigDynamicOptions;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.forceload.ForceLoadTicketManager;
import xaero.pac.common.server.claims.protection.group.ChunkProtectionExceptionGroup;
import xaero.pac.common.server.io.ObjectManagerIOManager;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.dynamic.PlayerConfigDynamicOptionsLoader;
import xaero.pac.common.server.player.config.io.PlayerConfigIO;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.config.sync.PlayerConfigSynchronizer;

public final class PlayerConfigManager<P extends IServerParty<?, ?, ?>, CM extends IServerClaimsManager<?, ?, ?>>
implements IPlayerConfigManager,
ObjectManagerIOManager<PlayerConfig<P>, PlayerConfigManager<P, CM>> {
    private final MinecraftServer server;
    private boolean loaded;
    private PlayerConfig<P> defaultConfig;
    private PlayerConfig<P> wildernessConfig;
    private PlayerConfig<P> serverClaimConfig;
    private PlayerConfig<P> expiredClaimConfig;
    private final ForceLoadTicketManager forceLoadTicketManager;
    private final Map<UUID, PlayerConfig<P>> configs;
    private final Set<PlayerConfig<P>> configsToSave;
    private final PlayerConfigSynchronizer synchronizer;
    private CM claimsManager;
    private final IPartyManager<P> partyManager;
    private PlayerConfigIO<P, CM> io;
    private final PlayerConfigDynamicOptions dynamicOptions;
    private final Set<IPlayerConfigOptionSpecAPI<?>> overridableOptions;
    private final ForgeConfigSpec playerConfigSpec;

    private PlayerConfigManager(MinecraftServer server, ForceLoadTicketManager forceLoadTicketManager, Map<UUID, PlayerConfig<P>> configs, Set<PlayerConfig<P>> configsToSave, PlayerConfigSynchronizer synchronizer, IPartyManager<P> partyManager, PlayerConfigDynamicOptions dynamicOptions, Set<IPlayerConfigOptionSpecAPI<?>> overridableOptions, ForgeConfigSpec playerConfigSpec) {
        this.server = server;
        this.forceLoadTicketManager = forceLoadTicketManager;
        this.configs = configs;
        this.configsToSave = configsToSave;
        this.synchronizer = synchronizer;
        this.partyManager = partyManager;
        this.dynamicOptions = dynamicOptions;
        this.overridableOptions = overridableOptions;
        this.playerConfigSpec = playerConfigSpec;
    }

    public void setClaimsManager(CM claimsManager) {
        if (this.claimsManager != null) {
            throw new IllegalStateException();
        }
        this.claimsManager = claimsManager;
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getLoadedConfig(@Nullable UUID id) {
        if (!this.loaded) {
            throw new IllegalStateException();
        }
        return this.getConfig(id);
    }

    public PlayerConfig<P> getConfig(UUID id) {
        if (id == null) {
            return this.wildernessConfig;
        }
        if (Objects.equals(id, PlayerConfig.SERVER_CLAIM_UUID)) {
            return this.serverClaimConfig;
        }
        if (Objects.equals(id, PlayerConfig.EXPIRED_CLAIM_UUID)) {
            return this.expiredClaimConfig;
        }
        return this.configs.computeIfAbsent(id, i -> ((PlayerConfig.FinalBuilder)((PlayerConfig.FinalBuilder)PlayerConfig.FinalBuilder.begin().setPlayerId((UUID)i)).setManager(this)).build());
    }

    public void onLoad() {
        this.loaded = true;
    }

    @Override
    public Iterable<PlayerConfig<P>> getToSave() {
        return this.configsToSave;
    }

    public void setDefaultConfig(PlayerConfig<P> defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setWildernessConfig(PlayerConfig<P> wildernessConfig) {
        this.wildernessConfig = wildernessConfig;
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getWildernessConfig() {
        return this.wildernessConfig;
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getServerClaimConfig() {
        return this.serverClaimConfig;
    }

    @Override
    @Nonnull
    public PlayerConfig<P> getExpiredClaimConfig() {
        return this.expiredClaimConfig;
    }

    public void setServerClaimConfig(PlayerConfig<P> serverClaimConfig) {
        this.serverClaimConfig = serverClaimConfig;
    }

    public void setExpiredClaimConfig(PlayerConfig<P> expiredClaimConfig) {
        this.expiredClaimConfig = expiredClaimConfig;
    }

    @Override
    public void addToSave(PlayerConfig<P> object) {
        this.configsToSave.add(object);
    }

    public ForceLoadTicketManager getForceLoadTicketManager() {
        return this.forceLoadTicketManager;
    }

    @Override
    public PlayerConfigSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public IPartyManager<P> getPartyManager() {
        return this.partyManager;
    }

    public CM getClaimsManager() {
        return this.claimsManager;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void onSubConfigRemoved(PlayerSubConfig<P> subConfig) {
        this.configsToSave.remove(subConfig);
        if (this.loaded) {
            this.io.delete(subConfig);
        }
    }

    public void setIO(PlayerConfigIO<P, CM> io) {
        if (this.io != null) {
            throw new RuntimeException(new IllegalAccessException());
        }
        this.io = io;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public ForgeConfigSpec getPlayerConfigSpec() {
        return this.playerConfigSpec;
    }

    public PlayerConfigDynamicOptions getDynamicOptions() {
        return this.dynamicOptions;
    }

    public Set<IPlayerConfigOptionSpecAPI<?>> getOverridableOptions() {
        return this.overridableOptions;
    }

    @Override
    @Nonnull
    public Stream<IPlayerConfigOptionSpecAPI<?>> getAllOptionsStream() {
        return Stream.concat(PlayerConfigOptions.OPTIONS.values().stream(), this.dynamicOptions.getOptions().values().stream());
    }

    @Override
    @Nullable
    public IPlayerConfigOptionSpecAPI<?> getOptionForId(@Nonnull String id) {
        IPlayerConfigOptionSpecAPI<?> result;
        if (!((String)id).startsWith("playerConfig.")) {
            id = "playerConfig." + (String)id;
        }
        if ((result = PlayerConfigOptions.OPTIONS.get(id)) == null) {
            result = this.dynamicOptions.getOptions().get(id);
        }
        return result;
    }

    public static final class Builder<P extends IServerParty<?, ?, ?>, CM extends IServerClaimsManager<?, ?, ?>> {
        private MinecraftServer server;
        private IPartyManager<P> partyManager;
        private Map<String, ChunkProtectionExceptionGroup<class_2248>> blockExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1792>> itemExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityBarrierGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> blockAccessEntityGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityAccessEntityGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> droppedItemAccessEntityGroups;

        private Builder() {
        }

        private Builder<P, CM> setDefault() {
            this.setServer(null);
            this.setPartyManager(null);
            return this;
        }

        public Builder<P, CM> setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder<P, CM> setPartyManager(IPartyManager<P> partyManager) {
            this.partyManager = partyManager;
            return this;
        }

        public Builder<P, CM> setBlockExceptionGroups(Map<String, ChunkProtectionExceptionGroup<class_2248>> blockExceptionGroups) {
            this.blockExceptionGroups = blockExceptionGroups;
            return this;
        }

        public Builder<P, CM> setEntityExceptionGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityExceptionGroups) {
            this.entityExceptionGroups = entityExceptionGroups;
            return this;
        }

        public Builder<P, CM> setItemExceptionGroups(Map<String, ChunkProtectionExceptionGroup<class_1792>> itemExceptionGroups) {
            this.itemExceptionGroups = itemExceptionGroups;
            return this;
        }

        public Builder<P, CM> setEntityBarrierGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityBarrierGroups) {
            this.entityBarrierGroups = entityBarrierGroups;
            return this;
        }

        public Builder<P, CM> setBlockAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> blockAccessEntityGroups) {
            this.blockAccessEntityGroups = blockAccessEntityGroups;
            return this;
        }

        public Builder<P, CM> setEntityAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityAccessEntityGroups) {
            this.entityAccessEntityGroups = entityAccessEntityGroups;
            return this;
        }

        public Builder<P, CM> setDroppedItemAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> droppedItemAccessEntityGroups) {
            this.droppedItemAccessEntityGroups = droppedItemAccessEntityGroups;
            return this;
        }

        public PlayerConfigManager<P, CM> build() {
            if (this.server == null || this.partyManager == null || this.blockExceptionGroups == null || this.entityExceptionGroups == null || this.itemExceptionGroups == null || this.entityBarrierGroups == null || this.blockAccessEntityGroups == null || this.entityAccessEntityGroups == null || this.droppedItemAccessEntityGroups == null) {
                throw new IllegalStateException();
            }
            PlayerConfigSynchronizer playerConfigSynchronizer = new PlayerConfigSynchronizer(this.server);
            ForceLoadTicketManager forceLoadTicketManager = ForceLoadTicketManager.Builder.begin().setServer(this.server).build();
            PlayerConfigDynamicOptions.Builder dynamicOptionsBuilder = PlayerConfigDynamicOptions.Builder.begin();
            new PlayerConfigDynamicOptionsLoader().load(dynamicOptionsBuilder, this.blockExceptionGroups, this.entityExceptionGroups, this.itemExceptionGroups, this.entityBarrierGroups, this.blockAccessEntityGroups, this.entityAccessEntityGroups, this.droppedItemAccessEntityGroups);
            PlayerConfigDynamicOptions dynamicOptions = dynamicOptionsBuilder.build();
            ForgeConfigSpec.Builder configSpecBuilder = new ForgeConfigSpec.Builder();
            Consumer<IPlayerConfigOptionSpecAPI> optionConsumer = o -> ((PlayerConfigOptionSpec)o).applyToForgeSpec(configSpecBuilder);
            PlayerConfigOptions.OPTIONS.values().forEach(optionConsumer);
            dynamicOptions.getOptions().values().forEach(optionConsumer);
            HashSet overridableOptions = new HashSet();
            overridableOptions.addAll(PlayerSubConfig.STATIC_OVERRIDABLE_OPTIONS);
            overridableOptions.addAll(dynamicOptions.getOptions().values());
            PlayerConfigManager result = new PlayerConfigManager(this.server, forceLoadTicketManager, new HashMap(), new HashSet(), playerConfigSynchronizer, this.partyManager, dynamicOptions, overridableOptions, configSpecBuilder.build());
            playerConfigSynchronizer.setConfigManager(result);
            return result;
        }

        public static <P extends IServerParty<?, ?, ?>, CM extends IServerClaimsManager<?, ?, ?>> Builder<P, CM> begin() {
            return new Builder<P, CM>().setDefault();
        }
    }
}

