/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class AboutPartyCommand {
    private static final int MAX_MEMBER_COUNT = 32;
    private static final int MAX_ALLY_COUNT = 32;
    private static final int MAX_INVITES_COUNT = 16;

    private static <T> int createLimitedList(class_2561 listComponent, int maxCount, Iterator<T> iterator, Consumer<T> adder) {
        int count = 0;
        while (iterator.hasNext()) {
            adder.accept(iterator.next());
            if (++count != maxCount) continue;
            listComponent.method_10855().add(class_2561.method_43470((String)" ..."));
            break;
        }
        return count;
    }

    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment, CommandRequirementProvider commandRequirementProvider) {
        Command action = context -> {
            Object tooltipPrefix;
            Object targetProfile;
            class_3222 casterPlayer = ((class_2168)context.getSource()).method_9207();
            try {
                Collection profiles = class_2191.method_9330((CommandContext)context, (String)"profile");
                targetProfile = profiles.size() == 1 ? (GameProfile)profiles.iterator().next() : null;
            }
            catch (IllegalArgumentException iae) {
                try {
                    class_3222 inputPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
                    targetProfile = inputPlayer != null ? inputPlayer.method_7334() : null;
                }
                catch (IllegalArgumentException iae2) {
                    targetProfile = casterPlayer.method_7334();
                }
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(((class_2168)context.getSource()).method_9211());
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            if (targetProfile == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_about_invalid_player", new Object[0]));
                return 0;
            }
            GameProfile profile = targetProfile;
            UUID casterPlayerId = casterPlayer.method_5667();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(profile.getId());
            if (playerParty == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_about_no_party", profile.getName()));
                return 0;
            }
            casterPlayer.method_43496((class_2561)class_2561.method_43470((String)""));
            casterPlayer.method_43496((class_2561)class_2561.method_43470((String)"===== Open Parties and Claims").method_27694(s -> s.method_10977(class_124.field_1080)));
            casterPlayer.method_43496((class_2561)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_player", new Object[0]).method_27694(s -> s.method_10977(class_124.field_1065)));
            casterPlayer.method_43496((class_2561)class_2561.method_43470((String)profile.getName()).method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)profile.getId().toString())))));
            casterPlayer.method_43496((class_2561)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_current_party", new Object[0]).method_27694(s -> s.method_10977(class_124.field_1065)));
            String partyName = playerParty.getDefaultName();
            IPlayerConfig ownerConfig = serverData.getPlayerConfigs().getLoadedConfig(playerParty.getOwner().getUUID());
            String partyCustomName = ownerConfig.getEffective(PlayerConfigOptions.PARTY_NAME);
            Object object = tooltipPrefix = !partyCustomName.isEmpty() ? partyName + "\n" : "";
            if (!partyCustomName.isEmpty()) {
                partyName = partyCustomName;
            }
            casterPlayer.method_43496((class_2561)class_2561.method_43470((String)partyName).method_27694(arg_0 -> AboutPartyCommand.lambda$register$4((String)tooltipPrefix, (IServerParty)playerParty, arg_0)));
            casterPlayer.method_43496((class_2561)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_members", playerParty.getMemberCount() + "/" + String.valueOf(ServerConfig.CONFIG.maxPartyMembers.get())).method_27694(s -> s.method_10977(class_124.field_1065)));
            class_5250 partyMembersComponent = class_2561.method_43470((String)"");
            Consumer<IPartyMember> partyMemberConsumer = arg_0 -> AboutPartyCommand.lambda$register$8((class_2561)partyMembersComponent, (IServerParty)playerParty, adaptiveLocalizer, casterPlayer, arg_0);
            int staffCount = AboutPartyCommand.createLimitedList((class_2561)partyMembersComponent, 32, playerParty.getTypedStaffInfoStream().iterator(), partyMemberConsumer);
            if (staffCount < 32) {
                AboutPartyCommand.createLimitedList((class_2561)partyMembersComponent, 32 - staffCount, playerParty.getTypedNonStaffInfoStream().iterator(), partyMemberConsumer);
            }
            casterPlayer.method_43496((class_2561)partyMembersComponent);
            casterPlayer.method_43496((class_2561)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_allies", playerParty.getAllyCount() + "/" + String.valueOf(ServerConfig.CONFIG.maxPartyAllies.get())).method_27694(s -> s.method_10977(class_124.field_1065)));
            class_5250 partyAlliesComponent = class_2561.method_43470((String)"");
            AboutPartyCommand.createLimitedList((class_2561)partyAlliesComponent, 32, playerParty.getTypedAllyPartiesStream().iterator(), arg_0 -> AboutPartyCommand.lambda$register$11((IPartyManager)partyManager, (class_2561)partyAlliesComponent, serverData, arg_0));
            if (partyAlliesComponent.method_10855().isEmpty()) {
                casterPlayer.method_43496((class_2561)class_2561.method_43470((String)"N/A").method_27694(s -> s.method_10977(class_124.field_1080)));
            } else {
                casterPlayer.method_43496((class_2561)partyAlliesComponent);
            }
            casterPlayer.method_43496((class_2561)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_invited", playerParty.getInviteCount() + "/" + String.valueOf(ServerConfig.CONFIG.maxPartyInvites.get())).method_27694(s -> s.method_10977(class_124.field_1065)));
            class_5250 invitedComponent = class_2561.method_43470((String)"");
            AboutPartyCommand.createLimitedList((class_2561)invitedComponent, 16, playerParty.getTypedInvitedPlayersStream().iterator(), arg_0 -> AboutPartyCommand.lambda$register$15((class_2561)invitedComponent, arg_0));
            if (invitedComponent.method_10855().isEmpty()) {
                casterPlayer.method_43496((class_2561)class_2561.method_43470((String)"N/A").method_27694(s -> s.method_10977(class_124.field_1080)));
            } else {
                casterPlayer.method_43496((class_2561)invitedComponent);
            }
            casterPlayer.method_43496((class_2561)class_2561.method_43470((String)"=====").method_27694(s -> s.method_10977(class_124.field_1080)));
            return 1;
        };
        SuggestionProvider suggestions = (context, builder) -> {
            class_3324 playerlist = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9264(playerlist.method_14571().stream().map(targetPlayer -> targetPlayer.method_7334().getName()), (SuggestionsBuilder)builder);
        };
        LiteralArgumentBuilder normalCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(class_2170.method_9247((String)"about").executes(action));
        dispatcher.register(normalCommand);
        LiteralArgumentBuilder targetCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(class_2170.method_9247((String)"about").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(c -> !c.method_9259(2))).suggests(suggestions).executes(action)));
        dispatcher.register(targetCommand);
        LiteralArgumentBuilder opTargetCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(class_2170.method_9247((String)"about").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"profile", (ArgumentType)class_2191.method_9329()).requires(c -> c.method_9259(2))).suggests(suggestions).executes(action)));
        dispatcher.register(opTargetCommand);
    }

    private static /* synthetic */ void lambda$register$15(class_2561 invitedComponent, IPartyPlayerInfo pi) {
        if (!invitedComponent.method_10855().isEmpty()) {
            invitedComponent.method_10855().add(class_2561.method_43470((String)", "));
        }
        invitedComponent.method_10855().add(class_2561.method_43470((String)pi.getUsername()).method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)pi.getUUID().toString())))));
    }

    private static /* synthetic */ void lambda$register$11(IPartyManager partyManager, class_2561 partyAlliesComponent, IServerData serverData, IPartyAlly ally) {
        IServerPartyAPI allyParty = partyManager.getPartyById(ally.getPartyId());
        if (allyParty != null) {
            if (!partyAlliesComponent.method_10855().isEmpty()) {
                partyAlliesComponent.method_10855().add(class_2561.method_43470((String)", "));
            }
            IPlayerConfig allyOwnerConfig = serverData.getPlayerConfigs().getLoadedConfig(allyParty.getOwner().getUUID());
            String configuredAllyName = allyOwnerConfig.getEffective(PlayerConfigOptions.PARTY_NAME);
            String allyDefaultName = allyParty.getDefaultName();
            Object allyTooltipPrefix = !configuredAllyName.isEmpty() ? allyDefaultName + "\n" : "";
            partyAlliesComponent.method_10855().add(class_2561.method_43470((String)(configuredAllyName.isEmpty() ? allyDefaultName : configuredAllyName)).method_27694(arg_0 -> AboutPartyCommand.lambda$register$10((String)allyTooltipPrefix, (IServerParty)allyParty, arg_0)));
        }
    }

    private static /* synthetic */ class_2583 lambda$register$10(String allyTooltipPrefix, IServerParty allyParty, class_2583 s) {
        return s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)(allyTooltipPrefix + allyParty.getId().toString()))));
    }

    private static /* synthetic */ void lambda$register$8(class_2561 partyMembersComponent, IServerParty playerParty, AdaptiveLocalizer adaptiveLocalizer, class_3222 casterPlayer, IPartyMember mi) {
        if (!partyMembersComponent.method_10855().isEmpty()) {
            partyMembersComponent.method_10855().add(class_2561.method_43470((String)", "));
        }
        partyMembersComponent.method_10855().add(class_2561.method_43470((String)mi.getUsername()).method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)mi.getUUID().toString())))));
        if (mi.getRank() != PartyMemberRank.MEMBER) {
            class_5250 rankComponent = class_2561.method_43470((String)(playerParty.getOwner() == mi ? "OWNER" : mi.getRank().toString())).method_27694(s -> s.method_10977(mi.getRank().getColor()));
            partyMembersComponent.method_10855().add(adaptiveLocalizer.getFor(casterPlayer, "[%s]", rankComponent));
        }
    }

    private static /* synthetic */ class_2583 lambda$register$4(String tooltipPrefix, IServerParty playerParty, class_2583 s) {
        return s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)(tooltipPrefix + playerParty.getId().toString()))));
    }
}

