/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.claims.player;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1923;
import net.minecraft.class_2960;
import xaero.pac.client.claims.ClientClaimsManager;
import xaero.pac.client.claims.player.ClientPlayerClaimInfo;
import xaero.pac.client.claims.player.sub.ClientPlayerSubClaimInfo;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.PlayerClaimInfoManager;
import xaero.pac.common.claims.player.PlayerDimensionClaims;
import xaero.pac.common.claims.player.api.IPlayerChunkClaimAPI;
import xaero.pac.common.claims.tracker.ClaimsManagerTracker;
import xaero.pac.common.util.linked.LinkedChain;

public final class ClientPlayerClaimInfoManager
extends PlayerClaimInfoManager<ClientPlayerClaimInfo, ClientPlayerClaimInfoManager> {
    public ClientPlayerClaimInfoManager(Map<UUID, ClientPlayerClaimInfo> storage, LinkedChain<ClientPlayerClaimInfo> linkedPlayerInfo) {
        super(storage, linkedPlayerInfo);
    }

    @Override
    protected ClientPlayerClaimInfo create(String username, UUID playerId, Map<class_2960, PlayerDimensionClaims> claims) {
        return new ClientPlayerClaimInfo(username, playerId, claims, this, (Int2ObjectMap<ClientPlayerSubClaimInfo>)new Int2ObjectOpenHashMap());
    }

    public void updatePlayerInfo(UUID playerId, String username, ClientClaimsManager claimsManager) {
        ClientPlayerClaimInfo playerInfo = (ClientPlayerClaimInfo)this.getInfo(playerId);
        playerInfo.setPlayerUsername(username);
        if (playerInfo.getClaimsColor(-1) == null) {
            this.updateSubClaimInfo(playerId, -1, "", 0, claimsManager);
        }
    }

    public void updateSubClaimInfo(UUID playerId, int subConfigIndex, String claimsName, Integer claimsColor, ClientClaimsManager claimsManager) {
        ClientPlayerClaimInfo playerInfo = (ClientPlayerClaimInfo)this.getInfo(playerId);
        playerInfo.ensureSubClaim(subConfigIndex);
        playerInfo.setClaimsName(subConfigIndex, claimsName);
        Integer oldColor = playerInfo.getClaimsColor(subConfigIndex);
        playerInfo.setClaimsColor(subConfigIndex, claimsColor);
        if (!Objects.equals(oldColor, claimsColor)) {
            boolean notManyClaims = playerInfo.getClaimCount() < 1024;
            boolean isSub = subConfigIndex != -1;
            ClaimsManagerTracker tracker = claimsManager.getTracker();
            playerInfo.getTypedStream().map(Map.Entry::getValue).forEach(dim -> {
                class_2960 dimensionId = dim.getDimension();
                if (notManyClaims) {
                    BiConsumer<PlayerChunkClaim, class_1923> claimConsumer = (claim, pos) -> tracker.onChunkChange(dimensionId, pos.field_9181, pos.field_9180, (IPlayerChunkClaimAPI)claim);
                    dim.getTypedStream().forEach(posList -> {
                        PlayerChunkClaim state = posList.getClaimState();
                        int claimSubConfigIndex = state.getSubConfigIndex();
                        if (claimSubConfigIndex != subConfigIndex && (isSub || playerInfo.getClaimsColor(claimSubConfigIndex) != null)) {
                            return;
                        }
                        posList.getStream().forEach(pos -> claimConsumer.accept(state, (class_1923)pos));
                    });
                } else {
                    tracker.onDimensionChange(dimensionId);
                }
            });
        }
    }
}

