/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundCurrentSubClaimPacket
extends LazyPacket<ClientboundCurrentSubClaimPacket> {
    public static final LazyPacket.Encoder<ClientboundCurrentSubClaimPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final int currentSubConfigIndex;
    private final int currentServerSubConfigIndex;
    private final String currentSubConfigId;
    private final String currentServerSubConfigId;

    public ClientboundCurrentSubClaimPacket(int currentSubConfigIndex, int currentServerSubConfigIndex, String currentSubConfigId, String currentServerSubConfigId) {
        this.currentSubConfigIndex = currentSubConfigIndex;
        this.currentServerSubConfigIndex = currentServerSubConfigIndex;
        this.currentSubConfigId = currentSubConfigId;
        this.currentServerSubConfigId = currentServerSubConfigId;
    }

    @Override
    protected void writeOnPrepare(class_2540 u) {
        class_2487 tag = new class_2487();
        tag.method_10569("i", this.currentSubConfigIndex);
        tag.method_10569("si", this.currentServerSubConfigIndex);
        tag.method_10582("s", this.currentSubConfigId);
        tag.method_10582("ss", this.currentServerSubConfigId);
        u.method_10794((class_2520)tag);
    }

    @Override
    protected Function<class_2540, ClientboundCurrentSubClaimPacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<class_2540, ClientboundCurrentSubClaimPacket> {
        @Override
        public ClientboundCurrentSubClaimPacket apply(class_2540 input) {
            try {
                if (input.readableBytes() > 4096) {
                    return null;
                }
                class_2487 tag = (class_2487)input.method_30616(class_2505.method_53898());
                if (tag == null) {
                    return null;
                }
                int currentSubConfigIndex = tag.method_68083("i", 0);
                int currentServerSubConfigIndex = tag.method_68083("si", 0);
                String currentSubConfigId = tag.method_68564("s", "");
                String currentServerSubConfigId = tag.method_68564("ss", "");
                if (currentSubConfigId.length() > 100 || currentServerSubConfigId.length() > 100) {
                    OpenPartiesAndClaims.LOGGER.info("Player config sub ID string is too long!");
                    return null;
                }
                return new ClientboundCurrentSubClaimPacket(currentSubConfigIndex, currentServerSubConfigIndex, currentSubConfigId, currentServerSubConfigId);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundCurrentSubClaimPacket> {
        @Override
        public void handle(ClientboundCurrentSubClaimPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onSubConfigIndices(t.currentSubConfigIndex, t.currentServerSubConfigIndex, t.currentSubConfigId, t.currentServerSubConfigId);
        }
    }
}

