/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_11560;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;
import xaero.pac.common.server.world.ServerLevelHelper;

public class ConfigCommandUtil {
    static IPlayerConfig getEffectiveConfig(CommandContext<class_2168> context, IPlayerConfig playerConfig) {
        IPlayerConfig effectivePlayerConfig = playerConfig;
        try {
            String subConfigId = StringArgumentType.getString(context, (String)"sub-id");
            effectivePlayerConfig = playerConfig.getSubConfig(subConfigId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return effectivePlayerConfig;
    }

    public static class_11560 getConfigInputPlayer(CommandContext<class_2168> context, class_3222 sourcePlayer, String tooManyTargetMessage, String invalidTargetMessage, AdaptiveLocalizer adaptiveLocalizer) throws CommandSyntaxException {
        class_11560 inputPlayer;
        try {
            Collection profiles = class_2191.method_9330(context, (String)"player");
            if (profiles.size() > 1) {
                if (tooManyTargetMessage != null) {
                    ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, tooManyTargetMessage, new Object[0]));
                }
                return null;
            }
            if (profiles.isEmpty()) {
                if (invalidTargetMessage != null) {
                    ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, invalidTargetMessage, new Object[0]));
                }
                return null;
            }
            inputPlayer = (class_11560)profiles.iterator().next();
        }
        catch (IllegalArgumentException e) {
            inputPlayer = sourcePlayer.method_72498();
        }
        return inputPlayer;
    }

    public static SuggestionProvider<class_2168> getSubConfigSuggestionProvider(PlayerConfigType type) {
        return (context, builder) -> {
            UUID configOwnerId;
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
            MinecraftServer server = ServerLevelHelper.getServer((class_1297)sourcePlayer);
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            if (type != PlayerConfigType.SERVER) {
                class_11560 gameProfile = ConfigCommandUtil.getConfigInputPlayer((CommandContext<class_2168>)context, sourcePlayer, null, null, adaptiveLocalizer);
                if (gameProfile == null) {
                    return class_2172.method_9264(Stream.empty(), (SuggestionsBuilder)builder);
                }
                configOwnerId = gameProfile.comp_4422();
            } else {
                configOwnerId = PlayerConfig.SERVER_CLAIM_UUID;
            }
            String lowerCaseInput = builder.getRemainingLowerCase();
            IPlayerConfig playerConfig = serverData.getPlayerConfigs().getLoadedConfig(configOwnerId);
            List<String> subConfigIds = playerConfig.getSubConfigIds();
            Stream<Object> baseStream = subConfigIds.stream();
            if (!lowerCaseInput.isEmpty()) {
                baseStream = baseStream.filter(s -> s.toLowerCase().startsWith(lowerCaseInput));
            }
            return class_2172.method_9264(baseStream.limit(64L), (SuggestionsBuilder)builder);
        };
    }
}

