/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import com.google.common.collect.Iterators;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10255;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1536;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1564;
import net.minecraft.class_1634;
import net.minecraft.class_1657;
import net.minecraft.class_1669;
import net.minecraft.class_1676;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1749;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1812;
import net.minecraft.class_1819;
import net.minecraft.class_1835;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2538;
import net.minecraft.class_2557;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_3763;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4076;
import net.minecraft.class_4850;
import net.minecraft.class_5321;
import net.minecraft.class_5634;
import net.minecraft.class_6862;
import net.minecraft.class_9334;
import net.minecraft.class_9892;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.function.TriFunction;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.api.IPlayerChunkClaimAPI;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.protection.ChunkProtectionEntityHelper;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionSet;
import xaero.pac.common.server.claims.protection.ChunkProtectionExceptionType;
import xaero.pac.common.server.claims.protection.ExceptionElementType;
import xaero.pac.common.server.claims.protection.WildcardResolver;
import xaero.pac.common.server.claims.protection.api.IChunkProtectionAPI;
import xaero.pac.common.server.claims.protection.group.ChunkProtectionExceptionGroup;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.core.ServerCore;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.system.IPlayerPartySystemManager;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.data.ServerPlayerData;
import xaero.pac.common.server.player.data.api.ServerPlayerDataAPI;
import xaero.pac.common.server.world.ServerLevelHelper;

public class ChunkProtection<CM extends IServerClaimsManager<?, ?, ?>>
implements IChunkProtectionAPI {
    public static final UUID CREATE_DEPLOYER_UUID = UUID.fromString("9e2faded-cafe-4ec2-c314-dad129ae971d");
    public static final UUID CREATE_PLOUGH_UUID = UUID.fromString("9e2faded-eeee-4ec2-c314-dad129ae971d");
    public static final String CREATE_DEPLOYER_CLASS_NAME = "com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer";
    public static final String TAG_PREFIX = "#";
    public static final String BREAK_PREFIX = "break$";
    public static final String HAND_PREFIX = "hand$";
    public static final String ANYTHING_PREFIX = "anything$";
    public static final String INTERACT_PREFIX = "interact$";
    public static final String FULL_PREFIX = "full$";
    private Class<?> createDeployerClass;
    private final TriFunction<IPlayerConfig, class_1297, class_1297, IPlayerConfigOptionSpecAPI<Integer>> usedDroppedItemProtectionOptionGetter = this::getUsedDroppedItemProtectionOption;
    private final TriFunction<IPlayerConfig, class_1297, class_1297, IPlayerConfigOptionSpecAPI<Integer>> usedExperienceOrbProtectionOptionGetter = (c, e, a) -> PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_XP_PICKUP;
    private final class_2561 MAIN_HAND = class_2561.method_43471((String)"gui.xaero_claims_protection_main_hand");
    private final class_2561 OFF_HAND = class_2561.method_43471((String)"gui.xaero_claims_protection_off_hand");
    private final class_2561 CANT_INTERACT_BLOCK = class_2561.method_43471((String)"gui.xaero_claims_protection_interact_block_any").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_INTERACT_BLOCK_MAIN = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_block", (Object[])new Object[]{this.MAIN_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 BLOCK_TRY_EMPTY_MAIN = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_block_try_empty", (Object[])new Object[]{this.MAIN_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 BLOCK_DISABLED = class_2561.method_43471((String)"gui.xaero_claims_protection_block_disabled").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 PROJECTILE_HIT_BLOCK = class_2561.method_43471((String)"gui.xaero_claims_protection_projectile_hit_block").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 USE_ITEM_ANY = class_2561.method_43471((String)"gui.xaero_claims_protection_use_item_any").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 USE_ITEM_MAIN = class_2561.method_43469((String)"gui.xaero_claims_protection_use_item", (Object[])new Object[]{this.MAIN_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_INTERACT_ENTITY = class_2561.method_43471((String)"gui.xaero_claims_protection_interact_entity_any").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_INTERACT_ENTITY_MAIN = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_entity", (Object[])new Object[]{this.MAIN_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 ENTITY_TRY_EMPTY_MAIN = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_entity_try_empty", (Object[])new Object[]{this.MAIN_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 ENTITY_DISABLED = class_2561.method_43471((String)"gui.xaero_claims_protection_entity_disabled").method_27694(s -> s.method_10977(class_124.field_1061));
    public final class_2561 PROJECTILE_HIT_ENTITY = class_2561.method_43471((String)"gui.xaero_claims_protection_projectile_hit_entity").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_APPLY_ITEM_ANY = class_2561.method_43471((String)"gui.xaero_claims_protection_interact_item_apply_any").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_APPLY_ITEM_MAIN = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_item_apply", (Object[])new Object[]{this.MAIN_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_APPLY_ITEM_THIS_CLOSE_MAIN = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_item_apply_too_close", (Object[])new Object[]{this.MAIN_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 ITEM_DISABLED_ANY = class_2561.method_43471((String)"gui.xaero_claims_protection_item_disabled_any").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 ITEM_DISABLED_MAIN = class_2561.method_43469((String)"gui.xaero_claims_protection_item_disabled", (Object[])new Object[]{this.MAIN_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_INTERACT_BLOCK_OFF = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_block", (Object[])new Object[]{this.OFF_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 BLOCK_TRY_EMPTY_OFF = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_block_try_empty", (Object[])new Object[]{this.OFF_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 USE_ITEM_OFF = class_2561.method_43469((String)"gui.xaero_claims_protection_use_item", (Object[])new Object[]{this.OFF_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_APPLY_ITEM_OFF = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_item_apply", (Object[])new Object[]{this.OFF_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_APPLY_ITEM_THIS_CLOSE_OFF = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_item_apply_too_close", (Object[])new Object[]{this.OFF_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 ITEM_DISABLED_OFF = class_2561.method_43469((String)"gui.xaero_claims_protection_item_disabled", (Object[])new Object[]{this.OFF_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_INTERACT_ENTITY_OFF = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_entity", (Object[])new Object[]{this.OFF_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 ENTITY_TRY_EMPTY_OFF = class_2561.method_43469((String)"gui.xaero_claims_protection_interact_entity_try_empty", (Object[])new Object[]{this.OFF_HAND}).method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_CHORUS = class_2561.method_43471((String)"gui.xaero_claims_protection_chorus").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_USE_SUPER_GLUE = class_2561.method_43471((String)"gui.xaero_claims_protection_create_cant_use_glue").method_27694(s -> s.method_10977(class_124.field_1061));
    private final class_2561 CANT_REMOVE_SUPER_GLUE = class_2561.method_43471((String)"gui.xaero_claims_protection_create_cant_remove_glue").method_27694(s -> s.method_10977(class_124.field_1061));
    private final ChunkProtectionEntityHelper entityHelper;
    private IServerData<CM, ?> serverData;
    private final CM claimsManager;
    private final IPlayerPartySystemManager playerPartySystemManager;
    private final ChunkProtectionExceptionSet<class_1299<?>> friendlyEntityList;
    private final ChunkProtectionExceptionSet<class_1299<?>> hostileEntityList;
    private final ChunkProtectionExceptionSet<class_2248> forcedInteractionExceptionBlocks;
    private final ChunkProtectionExceptionSet<class_2248> forcedBreakExceptionBlocks;
    private final ChunkProtectionExceptionSet<class_2248> requiresEmptyHandBlocks;
    private final ChunkProtectionExceptionSet<class_2248> forcedAllowAnyItemBlocks;
    private final ChunkProtectionExceptionSet<class_1299<?>> forcedInteractionExceptionEntities;
    private final ChunkProtectionExceptionSet<class_1299<?>> forcedKillExceptionEntities;
    private final ChunkProtectionExceptionSet<class_1299<?>> requiresEmptyHandEntities;
    private final ChunkProtectionExceptionSet<class_1299<?>> forcedAllowAnyItemEntities;
    private final ChunkProtectionExceptionSet<class_1299<?>> forcedEntityClaimBarrierList;
    private final ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToBreakBlocks;
    private final ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToInteractWithBlocks;
    private final ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToKillEntities;
    private final ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToInteractWithEntities;
    private final ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToGriefDroppedItems;
    private final ChunkProtectionExceptionSet<class_1299<?>> nonBlockGriefingMobs;
    private final ChunkProtectionExceptionSet<class_1299<?>> entityGriefingMobs;
    private final ChunkProtectionExceptionSet<class_1299<?>> droppedItemGriefingMobs;
    private final Set<String> staticFakePlayerUsernames;
    private final Set<UUID> staticFakePlayerIds;
    private final Set<Class<?>> staticFakePlayerClassExceptions;
    private final ChunkProtectionExceptionSet<class_1792> additionalBannedItems;
    private final ChunkProtectionExceptionSet<class_1792> itemUseProtectionExceptions;
    private final ChunkProtectionExceptionSet<class_1792> completelyDisabledItems;
    private final ChunkProtectionExceptionSet<class_2248> completelyDisabledBlocks;
    private final ChunkProtectionExceptionSet<class_1299<?>> completelyDisabledEntities;
    private final Map<String, ChunkProtectionExceptionGroup<class_2248>> blockExceptionGroups;
    private final Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityExceptionGroups;
    private final Map<String, ChunkProtectionExceptionGroup<class_1792>> itemExceptionGroups;
    private final Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityBarrierGroups;
    private final Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> blockAccessEntityGroups;
    private final Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityAccessEntityGroups;
    private final Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> droppedItemAccessEntityGroups;
    private final class_2338.class_2339 reusableBlockPos;
    private boolean ignoreChunkEnter = false;
    private final Map<class_1297, Set<class_1923>> cantPickupItemsInTickCache;
    private final Map<class_1297, Set<class_1923>> cantPickupXPInTickCache;
    private final Set<UUID> fullPasses;
    private boolean fullPassesPaused;

    private ChunkProtection(CM claimsManager, IPlayerPartySystemManager playerPartySystemManager, ChunkProtectionEntityHelper entityHelper, ChunkProtectionExceptionSet<class_1299<?>> friendlyEntityList, ChunkProtectionExceptionSet<class_1299<?>> hostileEntityList, ChunkProtectionExceptionSet<class_2248> forcedInteractionExceptionBlocks, ChunkProtectionExceptionSet<class_2248> forcedBreakExceptionBlocks, ChunkProtectionExceptionSet<class_2248> requiresEmptyHandBlocks, ChunkProtectionExceptionSet<class_2248> forcedAllowAnyItemBlocks, ChunkProtectionExceptionSet<class_2248> completelyDisabledBlocks, ChunkProtectionExceptionSet<class_1299<?>> forcedInteractionExceptionEntities, ChunkProtectionExceptionSet<class_1299<?>> forcedKillExceptionEntities, ChunkProtectionExceptionSet<class_1299<?>> requiresEmptyHandEntities, ChunkProtectionExceptionSet<class_1299<?>> forcedAllowAnyItemEntities, ChunkProtectionExceptionSet<class_1299<?>> forcedEntityClaimBarrierList, ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToBreakBlocks, ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToInteractWithBlocks, ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToKillEntities, ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToInteractWithEntities, ChunkProtectionExceptionSet<class_1299<?>> entitiesAllowedToGriefDroppedItems, ChunkProtectionExceptionSet<class_1299<?>> nonBlockGriefingMobs, ChunkProtectionExceptionSet<class_1299<?>> entityGriefingMobs, ChunkProtectionExceptionSet<class_1299<?>> droppedItemGriefingMobs, Set<String> staticFakePlayerUsernames, Set<UUID> staticFakePlayerIds, Set<Class<?>> staticFakePlayerClassExceptions, ChunkProtectionExceptionSet<class_1792> additionalBannedItems, ChunkProtectionExceptionSet<class_1792> completelyBannedItems, ChunkProtectionExceptionSet<class_1792> itemUseProtectionExceptions, ChunkProtectionExceptionSet<class_1299<?>> completelyDisabledEntities, Map<String, ChunkProtectionExceptionGroup<class_2248>> blockExceptionGroups, Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityExceptionGroups, Map<String, ChunkProtectionExceptionGroup<class_1792>> itemExceptionGroups, Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityBarrierGroups, Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> blockAccessEntityGroups, Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityAccessEntityGroups, Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> droppedItemAccessEntityGroups, class_2338.class_2339 reusableBlockPos, Map<class_1297, Set<class_1923>> cantPickItemsCache, Map<class_1297, Set<class_1923>> cantPickupXPInTickCache, Set<UUID> fullPasses) {
        this.claimsManager = claimsManager;
        this.playerPartySystemManager = playerPartySystemManager;
        this.entityHelper = entityHelper;
        this.friendlyEntityList = friendlyEntityList;
        this.hostileEntityList = hostileEntityList;
        this.forcedInteractionExceptionBlocks = forcedInteractionExceptionBlocks;
        this.forcedBreakExceptionBlocks = forcedBreakExceptionBlocks;
        this.requiresEmptyHandBlocks = requiresEmptyHandBlocks;
        this.forcedAllowAnyItemBlocks = forcedAllowAnyItemBlocks;
        this.completelyDisabledBlocks = completelyDisabledBlocks;
        this.forcedInteractionExceptionEntities = forcedInteractionExceptionEntities;
        this.forcedKillExceptionEntities = forcedKillExceptionEntities;
        this.requiresEmptyHandEntities = requiresEmptyHandEntities;
        this.forcedAllowAnyItemEntities = forcedAllowAnyItemEntities;
        this.forcedEntityClaimBarrierList = forcedEntityClaimBarrierList;
        this.entitiesAllowedToBreakBlocks = entitiesAllowedToBreakBlocks;
        this.entitiesAllowedToInteractWithBlocks = entitiesAllowedToInteractWithBlocks;
        this.entitiesAllowedToKillEntities = entitiesAllowedToKillEntities;
        this.entitiesAllowedToInteractWithEntities = entitiesAllowedToInteractWithEntities;
        this.entitiesAllowedToGriefDroppedItems = entitiesAllowedToGriefDroppedItems;
        this.nonBlockGriefingMobs = nonBlockGriefingMobs;
        this.entityGriefingMobs = entityGriefingMobs;
        this.droppedItemGriefingMobs = droppedItemGriefingMobs;
        this.staticFakePlayerUsernames = staticFakePlayerUsernames;
        this.staticFakePlayerIds = staticFakePlayerIds;
        this.staticFakePlayerClassExceptions = staticFakePlayerClassExceptions;
        this.additionalBannedItems = additionalBannedItems;
        this.completelyDisabledItems = completelyBannedItems;
        this.itemUseProtectionExceptions = itemUseProtectionExceptions;
        this.completelyDisabledEntities = completelyDisabledEntities;
        this.blockExceptionGroups = blockExceptionGroups;
        this.entityExceptionGroups = entityExceptionGroups;
        this.itemExceptionGroups = itemExceptionGroups;
        this.entityBarrierGroups = entityBarrierGroups;
        this.blockAccessEntityGroups = blockAccessEntityGroups;
        this.entityAccessEntityGroups = entityAccessEntityGroups;
        this.droppedItemAccessEntityGroups = droppedItemAccessEntityGroups;
        this.reusableBlockPos = reusableBlockPos;
        this.cantPickupItemsInTickCache = cantPickItemsCache;
        this.cantPickupXPInTickCache = cantPickupXPInTickCache;
        this.fullPasses = fullPasses;
        try {
            this.createDeployerClass = Class.forName(CREATE_DEPLOYER_CLASS_NAME);
        }
        catch (ClassNotFoundException e2) {
            this.createDeployerClass = null;
        }
    }

    public void setServerData(IServerData<CM, ?> serverData) {
        this.serverData = serverData;
    }

    @Override
    public void giveFullPass(@Nonnull UUID entityId) {
        this.fullPasses.add(entityId);
    }

    @Override
    public void removeFullPass(@Nonnull UUID entityId) {
        this.fullPasses.remove(entityId);
    }

    private boolean hasActiveFullPass(class_1297 entity) {
        if (this.fullPassesPaused) {
            return false;
        }
        if (entity instanceof class_1657 && (CREATE_DEPLOYER_UUID.equals(entity.method_5667()) || entity.getClass() == this.createDeployerClass || CREATE_PLOUGH_UUID.equals(entity.method_5667())) && !this.isStaticFakePlayerExceptionClass(entity)) {
            return true;
        }
        return this.fullPasses.contains(entity.method_5667());
    }

    private boolean isStaticFakePlayerExceptionClass(class_1297 entity) {
        for (Class<?> fakePlayerExceptionClass : this.staticFakePlayerClassExceptions) {
            if (!fakePlayerExceptionClass.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    private InteractionTargetResult entityAccessCheck(IPlayerConfigManager playerConfigs, IPlayerConfig claimConfig, class_1297 e, class_1297 from, class_1297 accessor, UUID accessorId, boolean attack, boolean emptyHand, boolean exceptions) {
        return this.entityAccessCheck(playerConfigs, claimConfig, e, from, accessor, accessorId, attack, emptyHand, exceptions, false);
    }

    private InteractionTargetResult entityAccessCheck(IPlayerConfigManager playerConfigs, IPlayerConfig claimConfig, class_1297 e, class_1297 from, class_1297 accessor, UUID accessorId, boolean attack, boolean emptyHand, boolean exceptions, boolean checkingInverted) {
        IPlayerConfigOptionSpecAPI<Integer> option;
        boolean optionProtects;
        boolean isProtectable;
        if (e instanceof class_1657 && e != accessor) {
            boolean chunkProtected = claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS);
            InteractionTargetResult result = InteractionTargetResult.ALLOW;
            if (chunkProtected) {
                class_1297 usedOptionBase;
                class_1297 class_12972 = usedOptionBase = claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_REDIRECT) != false ? accessor : from;
                if (usedOptionBase == null) {
                    if (this.hasAnEnabledOption(claimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_OTHER)) {
                        return InteractionTargetResult.PROTECT;
                    }
                } else {
                    IPlayerConfigOptionSpecAPI<Boolean> option2;
                    IPlayerConfigOptionSpecAPI<Boolean> iPlayerConfigOptionSpecAPI = usedOptionBase instanceof class_1657 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_PLAYERS : (option2 = usedOptionBase instanceof class_1309 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYERS_FROM_OTHER);
                    if (claimConfig.getEffective(option2).booleanValue()) {
                        return InteractionTargetResult.PROTECT;
                    }
                }
                result = InteractionTargetResult.PASS;
            }
            if (accessor instanceof class_1657 && !checkingInverted) {
                return this.entityAccessCheck(playerConfigs, this.getClaimConfig(playerConfigs, this.claimsManager.get(accessor.method_73183().method_27983().method_29177(), accessor.method_31476())), accessor, accessor == from ? e : from, e, null, attack, emptyHand, exceptions, true);
            }
            return result;
        }
        if (this.hasChunkAccess(claimConfig, accessor, accessorId)) {
            return InteractionTargetResult.ALLOW;
        }
        boolean bl = isProtectable = !exceptions || this.isProtectable(e);
        if (isProtectable) {
            class_3763 raider;
            if (accessor instanceof class_3763 && (raider = (class_3763)accessor).method_16481() && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_RAIDS).booleanValue()) {
                return InteractionTargetResult.PROTECT;
            }
        } else if (attack || emptyHand) {
            return InteractionTargetResult.ALLOW;
        }
        if (!(optionProtects = this.checkProtectionLeveledOption(option = this.getUsedEntityProtectionOption(claimConfig, from, accessor), claimConfig, accessor, accessorId)) && (attack || emptyHand || !this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, claimConfig, accessor, accessorId))) {
            return InteractionTargetResult.ALLOW;
        }
        if (!exceptions) {
            return optionProtects ? InteractionTargetResult.PROTECT : InteractionTargetResult.PASS;
        }
        class_1299 entityType = e.method_5864();
        if (attack && this.forcedKillExceptionEntities.contains(entityType)) {
            return InteractionTargetResult.ALLOW;
        }
        if (!attack && this.forcedAllowAnyItemEntities.contains(entityType)) {
            return InteractionTargetResult.ALLOW;
        }
        int exceptionAccessLevel = this.getExceptionAccessLevel(claimConfig, accessor, accessorId);
        boolean groupsAllowPass = false;
        for (ChunkProtectionExceptionGroup<class_1299<?>> group : this.entityExceptionGroups.values()) {
            if (group.getType() == ChunkProtectionExceptionType.BREAK != attack || !emptyHand && group.getType() == ChunkProtectionExceptionType.EMPTY_HAND_INTERACTION || !isProtectable && group.getType() != ChunkProtectionExceptionType.ANY_ITEM_INTERACTION || exceptionAccessLevel > claimConfig.getEffective(group.getPlayerConfigOption()) || !group.contains(entityType)) continue;
            if (attack || emptyHand || group.getType() == ChunkProtectionExceptionType.ANY_ITEM_INTERACTION) {
                return InteractionTargetResult.ALLOW;
            }
            groupsAllowPass = true;
        }
        if (groupsAllowPass || !optionProtects || !isProtectable) {
            return InteractionTargetResult.PASS;
        }
        if (this.entityHelper.isOwned(e, accessorId)) {
            return InteractionTargetResult.PASS;
        }
        if (!attack && this.forcedInteractionExceptionEntities.contains(entityType) && (emptyHand || !this.requiresEmptyHandEntities.contains(entityType))) {
            return InteractionTargetResult.PASS;
        }
        return InteractionTargetResult.PROTECT;
    }

    private IPlayerConfigOptionSpecAPI<Integer> getUsedEntityProtectionOption(IPlayerConfig claimConfig, class_1297 entity, class_1297 accessor) {
        class_1297 usedOptionBase;
        class_1297 class_12972 = usedOptionBase = !(entity instanceof class_1657) && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_REDIRECT) != false ? accessor : entity;
        if (usedOptionBase == null) {
            return this.getToughestProtectionLevelOption(claimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_OTHER);
        }
        return usedOptionBase instanceof class_1657 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_PLAYERS : (usedOptionBase instanceof class_1309 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_OTHER);
    }

    private IPlayerConfigOptionSpecAPI<Integer> getUsedBlockProtectionOption(IPlayerConfig claimConfig, class_1297 entity, class_1297 accessor) {
        class_1297 usedOptionBase;
        class_1297 class_12972 = usedOptionBase = !(entity instanceof class_1657) && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_REDIRECT) != false ? accessor : entity;
        if (usedOptionBase == null) {
            return this.getToughestProtectionLevelOption(claimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_OTHER);
        }
        return usedOptionBase instanceof class_1657 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_PLAYERS : (usedOptionBase instanceof class_1309 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_OTHER);
    }

    private boolean checkProtectionLeveledOption(IPlayerConfigOptionSpecAPI<Integer> option, IPlayerConfig claimConfig, class_1297 accessor, UUID accessorId) {
        int optionValue = claimConfig.getEffective(option);
        if (optionValue <= 0) {
            return false;
        }
        if (optionValue == 1) {
            return true;
        }
        int exceptionLevel = this.getExceptionAccessLevel(claimConfig, accessor, accessorId);
        return exceptionLevel >= optionValue;
    }

    private boolean checkExceptionLeveledOption(IPlayerConfigOptionSpecAPI<Integer> option, IPlayerConfig claimConfig, class_1297 accessor, UUID accessorId) {
        int optionValue = claimConfig.getEffective(option);
        if (optionValue >= 3) {
            return true;
        }
        if (optionValue == 0) {
            return false;
        }
        int exceptionLevel = this.getExceptionAccessLevel(claimConfig, accessor, accessorId);
        return exceptionLevel <= optionValue;
    }

    @Override
    public boolean checkProtectionLeveledOption(@Nonnull IPlayerConfigOptionSpecAPI<Integer> option, @Nonnull IPlayerConfigAPI claimConfig, @Nonnull class_1297 accessor) {
        return this.checkProtectionLeveledOption(option, (IPlayerConfig)claimConfig, accessor, null);
    }

    @Override
    public boolean checkExceptionLeveledOption(@Nonnull IPlayerConfigOptionSpecAPI<Integer> option, @Nonnull IPlayerConfigAPI claimConfig, @Nonnull class_1297 accessor) {
        return this.checkExceptionLeveledOption(option, (IPlayerConfig)claimConfig, accessor, null);
    }

    @Override
    public boolean checkProtectionLeveledOption(@Nonnull IPlayerConfigOptionSpecAPI<Integer> option, @Nonnull IPlayerConfigAPI claimConfig, @Nonnull UUID accessorId) {
        return this.checkProtectionLeveledOption(option, (IPlayerConfig)claimConfig, null, accessorId);
    }

    @Override
    public boolean checkExceptionLeveledOption(@Nonnull IPlayerConfigOptionSpecAPI<Integer> option, @Nonnull IPlayerConfigAPI claimConfig, @Nonnull UUID accessorId) {
        return this.checkExceptionLeveledOption(option, (IPlayerConfig)claimConfig, null, accessorId);
    }

    private boolean isIncludedByProtectedEntityLists(class_1297 e) {
        if (this.entityHelper.isHostile(e)) {
            return ServerConfig.CONFIG.hostileChunkProtectedEntityListType.get() == ServerConfig.ConfigListType.ALL_BUT && !this.hostileEntityList.contains(e.method_5864()) || ServerConfig.CONFIG.hostileChunkProtectedEntityListType.get() == ServerConfig.ConfigListType.ONLY && this.hostileEntityList.contains(e.method_5864());
        }
        return ServerConfig.CONFIG.friendlyChunkProtectedEntityListType.get() == ServerConfig.ConfigListType.ALL_BUT && !this.friendlyEntityList.contains(e.method_5864()) || ServerConfig.CONFIG.friendlyChunkProtectedEntityListType.get() == ServerConfig.ConfigListType.ONLY && this.friendlyEntityList.contains(e.method_5864());
    }

    private boolean isProtectable(class_1297 e) {
        return !(e instanceof class_1657) && this.isIncludedByProtectedEntityLists(e);
    }

    private boolean canGrief(class_1297 e, IPlayerConfig config, class_1297 accessor, UUID accessorId, boolean blocks, boolean entities, boolean items) {
        IPlayerConfigOptionSpecAPI<Integer> option;
        if (e == null) {
            return false;
        }
        if (blocks && !this.isAllowedToGrief(e, accessor, accessorId, config, true, this.entitiesAllowedToBreakBlocks, null, this.blockAccessEntityGroups) && this.checkProtectionLeveledOption(option = this.getUsedBlockProtectionOption(config, e, accessor), config, accessor, accessorId)) {
            return false;
        }
        if (entities && !this.isAllowedToGrief(e, accessor, accessorId, config, true, this.entitiesAllowedToKillEntities, null, this.entityAccessEntityGroups) && this.checkProtectionLeveledOption(option = this.getUsedEntityProtectionOption(config, e, accessor), config, accessor, accessorId)) {
            return false;
        }
        return !items || this.isAllowedToGrief(e, accessor, accessorId, config, true, this.entitiesAllowedToGriefDroppedItems, null, this.droppedItemAccessEntityGroups) || !this.checkProtectionLeveledOption(option = this.getUsedDroppedItemProtectionOption(config, e, accessor), config, accessor, accessorId);
    }

    private boolean isAllowedToGrief(class_1297 e, class_1297 accessor, UUID accessorId, IPlayerConfig config, boolean breaking, ChunkProtectionExceptionSet<class_1299<?>> breakingForcedSet, ChunkProtectionExceptionSet<class_1299<?>> interactForcedSet, Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> groups) {
        if (e == null) {
            return false;
        }
        class_1299 entityType = e.method_5864();
        if (breaking && breakingForcedSet.contains(entityType)) {
            return true;
        }
        if (!breaking && interactForcedSet.contains(entityType)) {
            return true;
        }
        for (ChunkProtectionExceptionGroup<class_1299<?>> group : groups.values()) {
            if (group.getType() != ChunkProtectionExceptionType.FULL && breaking != (group.getType() == ChunkProtectionExceptionType.BREAK) || !group.contains(entityType) || !this.checkExceptionLeveledOption(group.getPlayerConfigOption(), config, accessor, accessorId)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasChunkAccess(IPlayerConfigAPI claimConfig, class_1297 accessor, UUID accessorId) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return true;
        }
        if (claimConfig == null) return true;
        if (!claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return true;
        }
        if (accessor != null) {
            boolean isAServerPlayer;
            if (accessorId == null) {
                accessorId = accessor.method_5667();
            }
            if ((isAServerPlayer = accessor instanceof class_3222) && ServerPlayerDataAPI.from((class_3222)accessor).isClaimsNonallyMode()) {
                return false;
            }
            if (accessorId.equals(claimConfig.getPlayerId())) {
                return true;
            }
            if (!isAServerPlayer) return false;
            ServerPlayerDataAPI playerData = ServerPlayerDataAPI.from((class_3222)accessor);
            this.claimsManager.getPermissionHandler().ensureAdminModeStatusPermission((class_3222)accessor, playerData);
            if (playerData.isClaimsAdminMode()) return true;
            if (playerData.isClaimsServerMode() && this.claimsManager.getPermissionHandler().playerHasServerClaimPermission((class_3222)accessor) && claimConfig.getType() == PlayerConfigType.SERVER) {
                return true;
            }
        } else {
            if (accessorId == null) {
                return false;
            }
            if (accessorId.equals(claimConfig.getPlayerId())) {
                return true;
            }
        }
        if (claimConfig.getPlayerId() == null) {
            return false;
        }
        if (claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_PARTY).booleanValue() && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_ALLY_PARTIES).booleanValue()) {
            return false;
        }
        if (!this.playerPartySystemManager.isInAParty(claimConfig.getPlayerId())) {
            return false;
        }
        if (!claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_PARTY).booleanValue()) {
            if (this.playerPartySystemManager.areInSameParty(claimConfig.getPlayerId(), accessorId)) return true;
        }
        if (claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_ALLY_PARTIES) != false) return false;
        if (!this.playerPartySystemManager.isPlayerAllying(claimConfig.getPlayerId(), accessorId)) return false;
        return true;
    }

    @Override
    public boolean hasChunkAccess(@Nonnull IPlayerConfigAPI claimConfig, @Nonnull UUID accessorId) {
        return this.hasChunkAccess(claimConfig, null, accessorId);
    }

    @Override
    public boolean hasChunkAccess(@Nonnull IPlayerConfigAPI claimConfig, @Nonnull class_1297 accessor) {
        return this.hasChunkAccess(claimConfig, accessor, accessor.method_5667());
    }

    private int getExceptionAccessLevel(IPlayerConfig claimConfig, class_1297 accessor, UUID accessorId) {
        class_3222 player;
        if (accessor instanceof class_3222 && ServerPlayerData.from(player = (class_3222)accessor).isClaimsNonallyMode()) {
            return 3;
        }
        if (accessorId == null) {
            if (accessor == null) {
                return 3;
            }
            accessorId = accessor.method_5667();
        }
        if (accessorId.equals(claimConfig.getPlayerId())) {
            return 0;
        }
        if (!this.playerPartySystemManager.isInAParty(claimConfig.getPlayerId())) {
            return 3;
        }
        if (this.playerPartySystemManager.areInSameParty(claimConfig.getPlayerId(), accessorId)) {
            return 1;
        }
        if (this.playerPartySystemManager.isPlayerAllying(claimConfig.getPlayerId(), accessorId)) {
            return 2;
        }
        return 3;
    }

    private class_2338 getFakePlayerPos(class_1657 player) {
        class_2338 playerPos = player.method_24515();
        if (!class_2338.field_10980.equals((Object)playerPos)) {
            return playerPos;
        }
        class_243 position1 = player.method_30950(1.0f);
        if (!class_243.field_1353.equals((Object)position1)) {
            return class_2338.method_49638((class_2374)position1);
        }
        double specificallyX = player.method_23317();
        double specificallyY = player.method_23318();
        double specificallyZ = player.method_23321();
        if (specificallyX == 0.0 && specificallyY == 0.0 && specificallyZ == 0.0) {
            return class_2338.method_49638((class_2374)player.method_30950(0.0f));
        }
        return class_2338.method_49637((double)specificallyX, (double)specificallyY, (double)specificallyZ);
    }

    private boolean isAllowedStaticFakePlayerAction(IServerData<CM, ?> serverData, class_1657 player, class_2338 targetPos, class_2338 targetPos2) {
        if (player == null || !this.staticFakePlayerIds.contains(player.method_5667()) && !this.staticFakePlayerUsernames.contains(player.method_7334().name())) {
            return false;
        }
        if (this.isStaticFakePlayerExceptionClass((class_1297)player)) {
            return false;
        }
        class_2338 playerPos = this.getFakePlayerPos(player);
        class_2338 checkedPos = targetPos;
        class_2338.class_2339 possibleFakePlayerOrigin = new class_2338.class_2339();
        boolean shouldCheckTargetPos2 = targetPos2 != null && (targetPos.method_10263() >> 4 != targetPos2.method_10263() >> 4 || targetPos.method_10260() >> 4 != targetPos2.method_10260() >> 4);
        while (true) {
            int minX = 0;
            int maxX = 0;
            int minZ = 0;
            int maxZ = 0;
            int localX = checkedPos.method_10263() & 0xF;
            int localZ = checkedPos.method_10260() & 0xF;
            if (localX == 0) {
                minX = -1;
            } else if (localX == 15) {
                maxX = 1;
            }
            if (localZ == 0) {
                minZ = -1;
            } else if (localZ == 15) {
                maxZ = 1;
            }
            if (checkedPos == playerPos || minX != maxX || minZ != maxZ) {
                for (int i = minX; i <= maxX; ++i) {
                    for (int j = minZ; j <= maxZ; ++j) {
                        if (i == 0 && j == 0) {
                            possibleFakePlayerOrigin.method_10101((class_2382)checkedPos);
                        } else {
                            possibleFakePlayerOrigin.method_10103(checkedPos.method_10263() + i, checkedPos.method_10264(), checkedPos.method_10260() + j);
                        }
                        if (possibleFakePlayerOrigin.equals((Object)targetPos)) continue;
                        if (checkedPos == playerPos) {
                            int diffX = possibleFakePlayerOrigin.method_10263() - targetPos.method_10263();
                            int diffZ = possibleFakePlayerOrigin.method_10260() - targetPos.method_10260();
                            if (diffX * diffX <= 1 && diffZ * diffZ <= 1) continue;
                        }
                        if (this.hitsAnotherClaim(serverData, player.method_73183(), (class_2338)possibleFakePlayerOrigin, targetPos, null, true)) {
                            return false;
                        }
                        if (!shouldCheckTargetPos2 || !this.hitsAnotherClaim(serverData, player.method_73183(), (class_2338)possibleFakePlayerOrigin, targetPos2, null, true)) continue;
                        return false;
                    }
                }
            }
            if (checkedPos.equals((Object)playerPos)) break;
            checkedPos = playerPos;
        }
        return true;
    }

    private boolean isAllowedStaticFakePlayerAction(IServerData<CM, ?> serverData, class_1657 player, class_2338 targetPos) {
        return this.isAllowedStaticFakePlayerAction(serverData, player, targetPos, null);
    }

    public boolean onEntityDestroyBlock(IServerData<CM, ?> serverData, class_2680 blockState, class_1297 entity, class_3218 world, class_2338 pos, boolean messages) {
        return this.onBlockInteraction(serverData, blockState, entity, class_1268.field_5808, null, world, pos, class_2350.field_11036, true, messages);
    }

    public IPlayerConfig getClaimConfig(IPlayerConfigManager playerConfigs, IPlayerChunkClaim claim) {
        IPlayerConfig mainConfig = playerConfigs.getLoadedConfig(claim == null ? null : claim.getPlayerId());
        if (claim == null) {
            return mainConfig;
        }
        return mainConfig.getEffectiveSubConfig(claim.getSubConfigIndex());
    }

    @Override
    @Nonnull
    public IPlayerConfigAPI getClaimConfig(@Nullable IPlayerChunkClaimAPI claim) {
        return this.getClaimConfig(this.serverData.getPlayerConfigs(), (IPlayerChunkClaim)claim);
    }

    private InteractionTargetResult blockAccessCheck(class_2248 block, IPlayerConfig config, class_1297 entity, class_1297 accessor, UUID accessorId, boolean emptyHand, boolean breaking) {
        boolean chunkAccess = this.hasChunkAccess(config, accessor, accessorId);
        if (chunkAccess) {
            return InteractionTargetResult.ALLOW;
        }
        boolean optionProtects = this.checkProtectionLeveledOption(this.getUsedBlockProtectionOption(config, entity, accessor), config, accessor, accessorId);
        if (optionProtects) {
            boolean bl = optionProtects = entity instanceof class_1657 || !this.isAllowedToGrief(entity, accessor, accessorId, config, breaking, this.entitiesAllowedToBreakBlocks, this.entitiesAllowedToInteractWithBlocks, this.blockAccessEntityGroups);
        }
        if (!optionProtects && (breaking || emptyHand || !this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, config, accessor, accessorId))) {
            return InteractionTargetResult.ALLOW;
        }
        if (block == null) {
            return optionProtects ? InteractionTargetResult.PROTECT : InteractionTargetResult.PASS;
        }
        if (breaking && this.forcedBreakExceptionBlocks.contains(block)) {
            return InteractionTargetResult.ALLOW;
        }
        if (!breaking && this.forcedAllowAnyItemBlocks.contains(block)) {
            return InteractionTargetResult.ALLOW;
        }
        int exceptionAccessLevel = this.getExceptionAccessLevel(config, accessor, accessorId);
        boolean groupsAllowPass = false;
        for (ChunkProtectionExceptionGroup<class_2248> group : this.blockExceptionGroups.values()) {
            if (group.getType() == ChunkProtectionExceptionType.BREAK != breaking || !emptyHand && group.getType() == ChunkProtectionExceptionType.EMPTY_HAND_INTERACTION || exceptionAccessLevel > config.getEffective(group.getPlayerConfigOption()) || !group.contains(block)) continue;
            if (breaking || emptyHand || group.getType() == ChunkProtectionExceptionType.ANY_ITEM_INTERACTION) {
                return InteractionTargetResult.ALLOW;
            }
            groupsAllowPass = true;
        }
        if (!optionProtects) {
            return InteractionTargetResult.PASS;
        }
        if (groupsAllowPass) {
            return InteractionTargetResult.PASS;
        }
        if (!breaking && this.forcedInteractionExceptionBlocks.contains(block) && (emptyHand || !this.requiresEmptyHandBlocks.contains(block))) {
            return InteractionTargetResult.PASS;
        }
        return InteractionTargetResult.PROTECT;
    }

    private InteractionTargetResult onBlockAccess(IServerData<CM, ?> serverData, class_2248 block, IPlayerConfig config, class_1297 entity, class_1297 accessor, UUID accessorId, class_1268 hand, boolean emptyHand, boolean leftClick, class_2561 message, class_1297 messageReceiver) {
        InteractionTargetResult result = this.blockAccessCheck(block, config, entity, accessor, accessorId, emptyHand, leftClick);
        if (result == InteractionTargetResult.PROTECT && messageReceiver instanceof class_3222) {
            class_3222 player = (class_3222)messageReceiver;
            player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, hand == null ? this.CANT_INTERACT_BLOCK : (hand == class_1268.field_5808 ? this.CANT_INTERACT_BLOCK_MAIN : this.CANT_INTERACT_BLOCK_OFF)));
            if (message != null) {
                player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, message));
            }
        }
        return result;
    }

    public boolean onBlockInteraction(IServerData<CM, ?> serverData, class_2680 blockState, class_1297 entity, class_1268 hand, class_1799 heldItem, class_3218 world, class_2338 pos, class_2350 direction, boolean breaking, boolean messages) {
        boolean emptyHand;
        boolean itemMatters;
        class_1297 messageReceiver;
        class_2248 block;
        class_1297 accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(world, accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor == null ? null : accessor.method_5667();
        }
        class_2248 class_22482 = block = blockState == null ? null : blockState.method_26204();
        class_1297 class_12972 = !messages ? null : (messageReceiver = accessor == null ? entity : accessor);
        if (this.completelyDisabledBlocks.contains(block)) {
            if (messageReceiver instanceof class_3222) {
                class_3222 player = (class_3222)messageReceiver;
                player.method_64398(serverData.getAdaptiveLocalizer().getFor((class_3222)entity, this.BLOCK_DISABLED));
            }
            return true;
        }
        if (entity != null && this.hasActiveFullPass(entity)) {
            return false;
        }
        if (heldItem == null) {
            class_1799 class_17992;
            if (hand != null && entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                class_17992 = livingEntity.method_5998(hand);
            } else {
                class_17992 = class_1799.field_8037;
            }
            heldItem = class_17992;
        }
        boolean bl = itemMatters = !(emptyHand = heldItem.method_7960()) && !breaking;
        class_2561 message = !itemMatters ? null : (hand == class_1268.field_5808 ? this.BLOCK_TRY_EMPTY_MAIN : this.BLOCK_TRY_EMPTY_OFF);
        boolean itemUseAtTargetAllowed = false;
        boolean isPlayer = entity instanceof class_1657;
        class_1923 chunkPos = new class_1923(pos);
        IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        if (!isPlayer || !this.isAllowedStaticFakePlayerAction(serverData, (class_1657)entity, pos)) {
            IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
            InteractionTargetResult targetResult = this.onBlockAccess(serverData, block, config, entity, accessor, accessorId, hand, emptyHand, breaking, message, messageReceiver);
            if (targetResult == InteractionTargetResult.PROTECT) {
                return true;
            }
            if (isPlayer && !emptyHand && targetResult == InteractionTargetResult.ALLOW && !((class_1657)entity).method_21823()) {
                itemUseAtTargetAllowed = true;
            }
        }
        if (!itemMatters) {
            return false;
        }
        boolean itemUseAtOffsetAllowed = false;
        if (itemUseAtTargetAllowed) {
            if (this.isOnChunkEdge(pos)) {
                class_2338 offsetPos = pos.method_10081(direction.method_62675());
                class_1923 offsetChunkPos = new class_1923(offsetPos);
                if (!chunkPos.equals((Object)offsetChunkPos)) {
                    IPlayerChunkClaim offsetClaim = this.claimsManager.get(world.method_27983().method_29177(), offsetChunkPos);
                    if (offsetClaim != null && claim != offsetClaim) {
                        UUID offsetClaimOwnerId;
                        UUID claimOwnerId = claim == null ? null : claim.getPlayerId();
                        if (Objects.equals(claimOwnerId, offsetClaimOwnerId = offsetClaim.getPlayerId())) {
                            IPlayerConfig config = this.getClaimConfig(playerConfigs, offsetClaim);
                            InteractionTargetResult offsetResult = this.onBlockAccess(serverData, block, config, entity, accessor, accessorId, hand, emptyHand, breaking, message, messageReceiver);
                            itemUseAtOffsetAllowed = offsetResult == InteractionTargetResult.ALLOW;
                        }
                    } else {
                        itemUseAtOffsetAllowed = true;
                    }
                } else {
                    itemUseAtOffsetAllowed = true;
                }
            } else {
                itemUseAtOffsetAllowed = true;
            }
        }
        return this.onUseItemAt(serverData, entity, world, pos, direction, heldItem, hand, itemUseAtTargetAllowed, itemUseAtOffsetAllowed, messages);
    }

    @Override
    public boolean onBlockInteraction(@Nullable class_1297 entity, @Nullable class_1268 hand, @Nullable class_1799 heldItem, @Nonnull class_3218 world, @Nonnull class_2338 pos, @Nonnull class_2350 direction, boolean breaking, boolean messages) {
        return this.onBlockInteraction(entity, hand, heldItem, world, pos, direction, breaking, messages, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onBlockInteraction(@Nullable class_1297 entity, @Nullable class_1268 hand, @Nullable class_1799 heldItem, @Nonnull class_3218 world, @Nonnull class_2338 pos, @Nonnull class_2350 direction, boolean breaking, boolean messages, boolean targetExceptions) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onBlockInteraction(this.serverData, targetExceptions ? world.method_8320(pos) : null, entity, hand, heldItem, world, pos, direction, breaking, messages);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    public boolean onBlockSpecialInteraction(IServerData<CM, ?> serverData, class_1657 player, class_3218 world, class_2338 pos) {
        return this.onBlockInteraction(serverData, world.method_8320(pos), (class_1297)player, null, null, world, pos, class_2350.field_11036, false, true);
    }

    public boolean onEntityPlaceBlock(IServerData<CM, ?> serverData, class_1297 entity, class_3218 world, class_2338 pos, IPlayerConfigOptionSpecAPI<Integer> option) {
        class_1297 accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (entity != null && this.hasActiveFullPass(entity)) {
            return false;
        }
        class_1923 chunkPos = new class_1923(pos);
        IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(world, accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            UUID uUID = accessorId = accessor == null ? null : accessor.method_5667();
        }
        if (entity instanceof class_1657 && this.isAllowedStaticFakePlayerAction(serverData, (class_1657)entity, pos)) {
            return false;
        }
        return !(option != null && !this.checkProtectionLeveledOption(option, config, accessor, accessorId) || !(entity instanceof class_1657) && this.canGrief(entity, config, accessor, accessorId, true, false, false) || this.blockAccessCheck(null, config, entity, accessor, accessorId, false, false) != InteractionTargetResult.PROTECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onEntityPlaceBlock(@Nullable class_1297 entity, @Nonnull class_3218 world, @Nonnull class_2338 pos) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onEntityPlaceBlock(this.serverData, entity, world, pos, null);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    public boolean onEnchantmentEffectOnBlock(IServerData<CM, ?> serverData, class_1297 entity, class_3218 world, class_2338 pos) {
        return this.onEntityPlaceBlock(serverData, entity, world, pos, PlayerConfigOptions.PROTECT_CLAIMED_BLOCKS_FROM_ENCHANTMENTS);
    }

    public boolean onEnchantmentEffectOnBlockDisk(IServerData<CM, ?> serverData, class_1297 entity, class_3218 world, class_2338 pos, int radius) {
        int minBlockX = pos.method_10263() - radius;
        int minBlockZ = pos.method_10260() - radius;
        int maxBlockX = pos.method_10263() + radius;
        int maxBlockZ = pos.method_10260() + radius;
        int minChunkX = minBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkX = maxBlockX >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                this.reusableBlockPos.method_10103(chunkX << 4, pos.method_10264(), chunkZ << 4);
                if (!this.onEntityPlaceBlock(serverData, entity, world, (class_2338)this.reusableBlockPos, PlayerConfigOptions.PROTECT_CLAIMED_BLOCKS_FROM_ENCHANTMENTS)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isItemUseRestricted(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (this.itemUseProtectionExceptions.contains(item)) {
            return false;
        }
        return item instanceof class_1747 || !itemStack.method_57826(class_9334.field_50075) && !(item instanceof class_1812) && !(item instanceof class_1811) && !(item instanceof class_1835) && !(item instanceof class_1819) && !itemStack.method_57826(class_9334.field_55878) && !(item instanceof class_1743) && !(item instanceof class_1794) && !(item instanceof class_1749) && !itemStack.method_31573(class_3489.field_15536) && !itemStack.method_57826(class_9334.field_53964) && !itemStack.method_57826(class_9334.field_54196) && !itemStack.method_57826(class_9334.field_52175) || this.additionalBannedItems.contains(item);
    }

    public boolean onItemRightClick(IServerData<CM, ?> serverData, class_1268 hand, class_1799 itemStack, class_2338 pos, class_1309 entity, boolean messages) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        boolean shouldProtect = false;
        class_1792 item = itemStack.method_7909();
        if (this.completelyDisabledItems.contains(item)) {
            if (messages && entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                serverPlayer.method_64398(serverData.getAdaptiveLocalizer().getFor(serverPlayer, hand == null ? this.ITEM_DISABLED_ANY : (hand == class_1268.field_5808 ? this.ITEM_DISABLED_MAIN : this.ITEM_DISABLED_OFF)));
            }
            return true;
        }
        if (this.hasActiveFullPass((class_1297)entity)) {
            return false;
        }
        if (this.isItemUseRestricted(itemStack) && !(item instanceof class_1755) && !(item instanceof class_5634)) {
            IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
            class_1923 chunkPos = new class_1923(pos);
            boolean shouldCheckGroups = false;
            for (ChunkProtectionExceptionGroup<class_1792> group : this.itemExceptionGroups.values()) {
                if (!group.contains(itemStack.method_7909())) continue;
                shouldCheckGroups = true;
                break;
            }
            block1: for (int i = -1; i < 2; ++i) {
                block2: for (int j = -1; j < 2; ++j) {
                    class_1657 player;
                    IPlayerConfig config;
                    boolean isCurrentChunk;
                    class_1923 offsetChunkPos = new class_1923(chunkPos.field_9181 + i, chunkPos.field_9180 + j);
                    IPlayerChunkClaim claim = this.claimsManager.get(entity.method_73183().method_27983().method_29177(), offsetChunkPos);
                    boolean bl = isCurrentChunk = i == 0 && j == 0;
                    if (!isCurrentChunk && claim == null || !this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, config = this.getClaimConfig(playerConfigs, claim), (class_1297)entity, null) || !isCurrentChunk && !config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NEIGHBOR_CHUNKS_ITEM_USE).booleanValue() || this.hasChunkAccess(config, (class_1297)entity, null) || entity instanceof class_1657 && this.isAllowedStaticFakePlayerAction(serverData, player = (class_1657)entity, offsetChunkPos.method_33943(0))) continue;
                    if (shouldCheckGroups) {
                        int exceptionAccessLevel = this.getExceptionAccessLevel(config, (class_1297)entity, null);
                        for (ChunkProtectionExceptionGroup<class_1792> group : this.itemExceptionGroups.values()) {
                            if (exceptionAccessLevel > config.getEffective(group.getPlayerConfigOption()) || !group.contains(itemStack.method_7909())) continue;
                            continue block2;
                        }
                    }
                    shouldProtect = true;
                    continue block1;
                }
            }
        }
        if (messages && shouldProtect && entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            serverPlayer.method_64398(serverData.getAdaptiveLocalizer().getFor(serverPlayer, hand == null ? this.USE_ITEM_ANY : (hand == class_1268.field_5808 ? this.USE_ITEM_MAIN : this.USE_ITEM_OFF)));
        }
        return shouldProtect;
    }

    public boolean onMobGrief(IServerData<CM, ?> serverData, class_1297 entity, boolean items) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        boolean blocks = !items && !(entity instanceof class_1564) && !this.nonBlockGriefingMobs.contains(entity.method_5864());
        boolean entities = !items && (entity instanceof class_1564 || this.entityGriefingMobs.contains(entity.method_5864()));
        items = items || this.droppedItemGriefingMobs.contains(entity.method_5864());
        return this.onMobGrief(serverData, entity, blocks, entities, items);
    }

    private boolean onMobGrief(IServerData<CM, ?> serverData, class_1297 entity, boolean blocks, boolean entities, boolean items) {
        class_1297 accessor;
        UUID accessorId;
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.method_73183()), accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor.method_5667();
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                IPlayerConfig config;
                class_1923 chunkPos = new class_1923(entity.method_31476().field_9181 + i, entity.method_31476().field_9180 + j);
                IPlayerChunkClaim claim = this.claimsManager.get(entity.method_73183().method_27983().method_29177(), chunkPos);
                if ((i != 0 || j != 0) && claim == null || !(config = this.getClaimConfig(playerConfigs, claim)).getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_MOB_GRIEFING_OVERRIDE).booleanValue() || this.canGrief(entity, config, accessor, accessorId, blocks, entities, items) || this.hasChunkAccess(config, accessor, accessorId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onEntityInteraction(IServerData<CM, ?> serverData, class_1297 interactingEntityIndirect, class_1297 interactingEntity, class_1297 target, class_1799 heldItem, class_1268 hand, boolean attack, boolean messages, boolean targetExceptions) {
        class_1297 accessor;
        UUID accessorId;
        class_1297 messageReceiver;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        class_1297 class_12972 = !messages ? null : (messageReceiver = interactingEntityIndirect == null ? interactingEntity : interactingEntityIndirect);
        if (!attack && this.completelyDisabledEntities.contains(target.method_5864())) {
            if (hand != class_1268.field_5810 && messageReceiver instanceof class_3222) {
                class_3222 player = (class_3222)messageReceiver;
                player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, this.ENTITY_DISABLED));
            }
            return true;
        }
        if (interactingEntity != null && this.hasActiveFullPass(interactingEntity)) {
            return false;
        }
        if (interactingEntity instanceof class_1657 && this.isAllowedStaticFakePlayerAction(serverData, (class_1657)interactingEntity, target.method_24515())) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        class_1937 targetLevel = target.method_73183();
        class_3218 targetServerLevel = ServerLevelHelper.getServerLevel(targetLevel);
        IPlayerChunkClaim claim = this.claimsManager.get(target.method_73183().method_27983().method_29177(), target.method_31476());
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (heldItem == null) {
            class_1799 class_17992;
            if (hand != null && interactingEntity instanceof class_1309) {
                class_1309 living = (class_1309)interactingEntity;
                class_17992 = living.method_5998(hand);
            } else {
                class_17992 = class_1799.field_8037;
            }
            heldItem = class_17992;
        }
        boolean emptyHand = heldItem.method_7960();
        Object accessorInfo = this.getAccessorInfo(interactingEntityIndirect == null ? interactingEntity : interactingEntityIndirect);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(targetServerLevel, accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor == null ? null : accessor.method_5667();
        }
        boolean needsItemCheck = !attack && !emptyHand;
        boolean itemUseAtTargetAllowed = false;
        if (!(targetExceptions && target == accessor || this.isAllowedToGrief(interactingEntity, accessor, accessorId, config, attack, this.entitiesAllowedToKillEntities, this.entitiesAllowedToInteractWithEntities, this.entityAccessEntityGroups))) {
            class_1657 player;
            InteractionTargetResult targetResult = this.entityAccessCheck(playerConfigs, config, target, interactingEntity, accessor, accessorId, attack, emptyHand, targetExceptions);
            if (targetResult == InteractionTargetResult.PROTECT) {
                if (messageReceiver instanceof class_3222) {
                    class_3222 player2 = (class_3222)messageReceiver;
                    player2.method_64398(serverData.getAdaptiveLocalizer().getFor(player2, hand == null ? this.CANT_INTERACT_ENTITY : (hand == class_1268.field_5808 ? this.CANT_INTERACT_ENTITY_MAIN : this.CANT_INTERACT_ENTITY_OFF)));
                    if (needsItemCheck) {
                        class_2561 message = hand == class_1268.field_5808 ? this.ENTITY_TRY_EMPTY_MAIN : this.ENTITY_TRY_EMPTY_OFF;
                        player2.method_64398(serverData.getAdaptiveLocalizer().getFor(player2, message));
                    }
                }
                return true;
            }
            if (needsItemCheck && targetResult == InteractionTargetResult.ALLOW && interactingEntity instanceof class_1657 && !(player = (class_1657)interactingEntity).method_21823()) {
                itemUseAtTargetAllowed = true;
            }
        }
        if (!needsItemCheck) {
            return false;
        }
        return this.onUseItemAt(serverData, interactingEntity, targetServerLevel, target.method_24515(), null, heldItem, hand, itemUseAtTargetAllowed, false, messages);
    }

    @Override
    public boolean onEntityInteraction(@Nullable class_1297 interactingEntityIndirect, @Nullable class_1297 interactingEntity, @Nonnull class_1297 target, @Nullable class_1799 heldItem, @Nullable class_1268 hand, boolean attack, boolean messages) {
        return this.onEntityInteraction(interactingEntityIndirect, interactingEntity, target, heldItem, hand, attack, messages, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onEntityInteraction(@Nullable class_1297 interactingEntityIndirect, @Nullable class_1297 interactingEntity, @Nonnull class_1297 target, @Nullable class_1799 heldItem, @Nullable class_1268 hand, boolean attack, boolean messages, boolean targetExceptions) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onEntityInteraction(this.serverData, interactingEntityIndirect, interactingEntity, target, heldItem, hand, attack, messages, targetExceptions);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    public boolean onFishingHookedEntity(IServerData<CM, ?> serverData, class_1536 hook, class_1297 entity) {
        return this.onEntityInteraction(serverData, hook.method_24921(), (class_1297)hook, entity, class_1799.field_8037, class_1268.field_5808, true, false, true);
    }

    public boolean onEntityFire(IServerData<CM, ?> serverData, class_1297 target) {
        IPlayerChunkClaim claim;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim = this.claimsManager.get(target.method_73183().method_27983().method_29177(), target.method_31476()));
        return config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS) != false && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_FIRE) != false && this.isProtectable(target);
    }

    private boolean blockedByBarrierGroups(IPlayerConfig config, class_1297 entity, class_1297 accessor, UUID accessorId) {
        int exceptionAccessLevel = this.getExceptionAccessLevel(config, accessor, accessorId);
        for (ChunkProtectionExceptionGroup<class_1299<?>> group : this.entityBarrierGroups.values()) {
            int configValue = config.getEffective(group.getPlayerConfigOption());
            if (configValue <= 0 || exceptionAccessLevel < configValue || !group.contains(entity.method_5864())) continue;
            return true;
        }
        return false;
    }

    private boolean shouldPreventEntityChunkEntry(IServerData<CM, ?> serverData, IPlayerConfigManager playerConfigs, IPlayerChunkClaim toClaim, IPlayerChunkClaim fromClaim, IPlayerConfig config, IPlayerConfig fromConfig, class_1297 entity, class_4076 newSection, class_4076 oldSection) {
        UUID lootOwnerId;
        class_1297 accessor;
        UUID accessorId;
        if (toClaim == null && newSection != null) {
            toClaim = this.claimsManager.get(entity.method_73183().method_27983().method_29177(), newSection.method_18674(), newSection.method_18687());
        }
        if (config == null) {
            config = this.getClaimConfig(playerConfigs, toClaim);
        }
        class_3218 entityServerLevel = ServerLevelHelper.getServerLevel(entity.method_73183());
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(entityServerLevel, accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor.method_5667();
        }
        if (fromClaim == null && oldSection != null) {
            fromClaim = this.claimsManager.get(entity.method_73183().method_27983().method_29177(), oldSection.method_18674(), oldSection.method_18687());
        }
        boolean enteringProtectedChunk = toClaim != null && !this.hasChunkAccess(config, accessor, accessorId);
        boolean isBlockedEntity = enteringProtectedChunk && this.forcedEntityClaimBarrierList.contains(entity.method_5864());
        boolean madeAnException = false;
        if (enteringProtectedChunk) {
            class_1542 itemEntity;
            UUID throwerId;
            if (!isBlockedEntity) {
                isBlockedEntity = this.blockedByBarrierGroups(config, entity, accessor, accessorId);
                if (isBlockedEntity && !this.hitsAnotherClaim(serverData, fromClaim, toClaim, null, false)) {
                    fromConfig = this.getClaimConfig(playerConfigs, fromClaim);
                    isBlockedEntity = !this.blockedByBarrierGroups(fromConfig, entity, accessor, accessorId);
                    madeAnException = true;
                }
            } else {
                isBlockedEntity = this.hitsAnotherClaim(serverData, fromClaim, toClaim, null, false);
                madeAnException = true;
            }
            if (!isBlockedEntity) {
                class_3763 raider;
                boolean bl = isBlockedEntity = accessor instanceof class_3763 && (raider = (class_3763)accessor).method_16481() && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_RAIDS) != false;
            }
            if (!isBlockedEntity && entity instanceof class_1542 && (throwerId = ServerCore.getItemEntityThrower(itemEntity = (class_1542)entity)) != null) {
                if (fromConfig == null) {
                    fromConfig = this.getClaimConfig(playerConfigs, fromClaim);
                }
                class_1297 thrower = this.getEntityById(entityServerLevel, throwerId);
                boolean bl = isBlockedEntity = fromConfig != config && this.shouldPreventToss(config, itemEntity, thrower, throwerId, ServerCore.getThrowerAccessor(itemEntity)) != itemEntity;
            }
        }
        if (!isBlockedEntity && (lootOwnerId = ServerCore.getLootOwner(entity)) != null) {
            if (fromConfig == null) {
                fromConfig = this.getClaimConfig(playerConfigs, fromClaim);
            }
            if (fromConfig != config) {
                UUID deadPlayerId = ServerCore.getDeadPlayer(entity);
                if (deadPlayerId != null) {
                    class_1297 deadPlayer = this.getEntityById(entityServerLevel, deadPlayerId);
                    isBlockedEntity = this.checkExceptionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT, fromConfig, deadPlayer, deadPlayerId);
                } else if (enteringProtectedChunk) {
                    isBlockedEntity = this.shouldStopMobLoot(config, this.getEntityById(entityServerLevel, lootOwnerId), lootOwnerId);
                }
            }
        }
        if (enteringProtectedChunk && !isBlockedEntity && madeAnException && accessor != entity && (isBlockedEntity = this.blockedByBarrierGroups(config, accessor, accessor, accessorId))) {
            if (fromConfig == null) {
                fromConfig = this.getClaimConfig(playerConfigs, fromClaim);
            }
            isBlockedEntity = !this.blockedByBarrierGroups(fromConfig, accessor, accessor, accessorId);
        }
        return isBlockedEntity;
    }

    public void onEntityEnterChunk(IServerData<CM, ?> serverData, class_1297 entity, double goodX, double goodZ, class_4076 newSection, class_4076 oldSection) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        if (this.ignoreChunkEnter) {
            return;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        boolean isBlockedEntity = this.shouldPreventEntityChunkEntry(serverData, playerConfigs, null, null, null, null, entity, newSection, oldSection);
        if (isBlockedEntity) {
            this.ignoreChunkEnter = true;
            int goodXInt = (int)Math.floor(goodX);
            int goodZInt = (int)Math.floor(goodZ);
            double fixedX = (double)goodXInt + 0.5;
            double fixedZ = (double)goodZInt + 0.5;
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                MinecraftServer server = ServerLevelHelper.getServer((class_1297)player);
                server.method_63588((Runnable)server.method_16209(() -> {
                    class_3222 upToDatePlayer = server.method_3760().method_14602(player.method_5667());
                    if (upToDatePlayer != player) {
                        return;
                    }
                    player.method_5848();
                    player.field_13987.method_14363(fixedX, entity.method_23318(), fixedZ, entity.method_36454(), entity.method_36455());
                }));
            } else {
                entity.method_5848();
                entity.method_5808(fixedX, entity.method_23318(), fixedZ, entity.method_36454(), entity.method_36455());
            }
            this.ignoreChunkEnter = false;
        }
    }

    public void onExplosionDetonate(IServerData<CM, ?> serverData, class_3218 world, class_9892 explosion, List<class_1297> affectedEntities, List<class_2338> affectedBlocks) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        class_1309 damager = explosion.method_8347();
        if (damager != null && this.hasActiveFullPass((class_1297)damager)) {
            return;
        }
        Iterator<class_2338> positions = affectedBlocks.iterator();
        while (positions.hasNext()) {
            class_2338 blockPos = positions.next();
            class_1923 chunkPos = new class_1923(blockPos);
            IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), chunkPos);
            IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
            if (config != null && (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue() || !config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_EXPLOSIONS).booleanValue()) || config == null) continue;
            positions.remove();
        }
        Iterator<class_1297> entities = affectedEntities.iterator();
        class_1297 directDamager = explosion.method_46406();
        while (entities.hasNext()) {
            class_1297 entity = entities.next();
            IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), entity.method_31476());
            IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
            if (config != null && !config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
                config = null;
            }
            if (config == null || !config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_EXPLOSIONS).booleanValue() || (damager instanceof class_1657 || !this.isProtectable(entity)) && this.entityAccessCheck(playerConfigs, config, entity, directDamager, (class_1297)damager, null, true, true, true) != InteractionTargetResult.PROTECT) continue;
            entities.remove();
        }
    }

    public boolean onChorusFruitTeleport(IServerData<CM, ?> serverData, class_243 pos, class_1297 entity) {
        class_1297 accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        class_1923 chunkPos = new class_1923(class_2338.method_49638((class_2374)pos));
        IPlayerChunkClaim claim = this.claimsManager.get(entity.method_73183().method_27983().method_29177(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig claimConfig = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.method_73183()), accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor.method_5667();
        }
        if (this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_CHORUS_FRUIT, claimConfig, accessor, accessorId) && !this.hasChunkAccess(claimConfig, accessor, accessorId)) {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, this.CANT_CHORUS));
            }
            return true;
        }
        return false;
    }

    public void onLightningBolt(IServerData<CM, ?> serverData, class_1538 bolt) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue() || bolt.method_35052() == null) {
            return;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        block0: for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                IPlayerConfig config;
                class_1923 chunkPos = new class_1923(bolt.method_31476().field_9181 + i, bolt.method_31476().field_9180 + j);
                IPlayerChunkClaim claim = this.claimsManager.get(bolt.method_73183().method_27983().method_29177(), chunkPos);
                if ((i != 0 || j != 0) && claim == null || !this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_LIGHTNING, config = this.getClaimConfig(playerConfigs, claim), (class_1297)bolt.method_35052(), null) || this.hasChunkAccess(config, (class_1297)bolt.method_35052(), null) || this.isAllowedStaticFakePlayerAction(serverData, (class_1657)bolt.method_35052(), chunkPos.method_33943(0))) continue;
                bolt.method_29498(true);
                continue block0;
            }
        }
    }

    public boolean onFireSpread(IServerData<CM, ?> serverData, class_3218 world, class_2338 pos) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), new class_1923(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig claimConfig = this.getClaimConfig(playerConfigs, claim);
        return claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS) != false && claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FROM_FIRE_SPREAD) != false;
    }

    public boolean onCropTrample(IServerData<CM, ?> serverData, class_1297 entity, class_2338 pos) {
        class_1297 accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(entity.method_73183().method_27983().method_29177(), new class_1923(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig claimConfig = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.method_73183()), accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor == null ? null : accessor.method_5667();
        }
        return claimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_CROP_TRAMPLE) != false && !this.hasChunkAccess(claimConfig, accessor, accessorId);
    }

    public boolean onBucketUse(IServerData<CM, ?> serverData, class_1297 entity, class_3218 world, class_239 hitResult, class_1799 itemStack) {
        class_2338 pos;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (entity != null && this.hasActiveFullPass(entity)) {
            return false;
        }
        class_2350 direction = null;
        if (hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            pos = blockHitResult.method_17777();
            direction = blockHitResult.method_17780();
        } else {
            pos = class_2338.method_49638((class_2374)hitResult.method_17784());
        }
        return this.onUseItemAt(serverData, entity, world, pos, direction, itemStack, null, false, false, true);
    }

    public boolean onUseItemAt(IServerData<CM, ?> serverData, class_1297 entity, class_3218 world, class_2338 pos, class_2350 direction, class_1799 itemStack, class_1268 hand, boolean itemUseAtTargetAllowed, boolean itemUseAtOffsetAllowed, boolean messages) {
        class_1923 chunkPos2;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (this.completelyDisabledItems.contains(itemStack.method_7909())) {
            if (messages && entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, hand == class_1268.field_5808 ? this.ITEM_DISABLED_MAIN : this.ITEM_DISABLED_OFF));
            }
            return true;
        }
        if (entity != null && this.hasActiveFullPass(entity)) {
            return false;
        }
        if (!this.isItemUseRestricted(itemStack)) {
            return false;
        }
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            if (hand == null) {
                Object object = living.method_5998(class_1268.field_5808) == itemStack ? class_1268.field_5808 : (hand = living.method_5998(class_1268.field_5810) == itemStack ? class_1268.field_5810 : null);
            }
            if (this.additionalBannedItems.contains(itemStack.method_7909()) && this.onItemRightClick(serverData, hand, itemStack, pos, living, false)) {
                if (messages && living instanceof class_3222) {
                    class_3222 player = (class_3222)living;
                    player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, hand == null ? this.CANT_APPLY_ITEM_ANY : (hand == class_1268.field_5808 ? this.CANT_APPLY_ITEM_THIS_CLOSE_MAIN : this.CANT_APPLY_ITEM_THIS_CLOSE_OFF)));
                }
                return true;
            }
        }
        class_2338 pos2 = null;
        if (direction != null) {
            pos2 = pos.method_10081(direction.method_62675());
        }
        if (itemUseAtTargetAllowed && pos2 == null) {
            return false;
        }
        if (entity instanceof class_1657 && this.isAllowedStaticFakePlayerAction(serverData, (class_1657)entity, pos, pos2)) {
            return false;
        }
        class_1923 chunkPos = new class_1923(pos);
        if (!itemUseAtTargetAllowed && this.applyItemAccessCheck(serverData, chunkPos, entity, world, itemStack) || !itemUseAtOffsetAllowed && pos2 != null && !(chunkPos2 = new class_1923(pos2)).equals((Object)chunkPos) && this.applyItemAccessCheck(serverData, chunkPos2, entity, world, itemStack)) {
            if (messages && entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, hand == null ? this.CANT_APPLY_ITEM_ANY : (hand == class_1268.field_5808 ? this.CANT_APPLY_ITEM_MAIN : this.CANT_APPLY_ITEM_OFF)));
            }
            return true;
        }
        return false;
    }

    private boolean applyItemAccessCheck(IServerData<CM, ?> serverData, class_1923 chunkPos, class_1297 entity, class_3218 world, class_1799 itemStack) {
        class_1297 accessor;
        UUID accessorId;
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), chunkPos);
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(world, accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor.method_5667();
        }
        return this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, config, accessor, accessorId) && !this.hasChunkAccess(config, accessor, accessorId) && !this.isOptionalItemException(serverData, accessor, accessorId, itemStack, world, chunkPos);
    }

    private boolean isOptionalItemException(IServerData<CM, ?> serverData, class_1297 accessor, UUID accessorId, class_1799 itemStack, class_3218 world, class_1923 chunkPos) {
        IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        int exceptionAccessLevel = this.getExceptionAccessLevel(config, accessor, accessorId);
        for (ChunkProtectionExceptionGroup<class_1792> group : this.itemExceptionGroups.values()) {
            if (exceptionAccessLevel > config.getEffective(group.getPlayerConfigOption()) || !group.contains(itemStack.method_7909())) continue;
            return true;
        }
        return false;
    }

    private boolean isOnChunkEdge(class_2338 pos) {
        int chunkRelativeX = pos.method_10263() & 0xF;
        int chunkRelativeZ = pos.method_10260() & 0xF;
        return this.isOnChunkEdge(chunkRelativeX, chunkRelativeZ);
    }

    private boolean isOnChunkEdge(int chunkRelativeX, int chunkRelativeZ) {
        return chunkRelativeX == 0 || chunkRelativeX == 15 || chunkRelativeZ == 0 || chunkRelativeZ == 15;
    }

    private boolean isProtectionEnabled(IPlayerConfig config, IPlayerConfigOptionSpecAPI<?> option) {
        Integer integ;
        Boolean bool;
        Object value = config.getEffective(option);
        return value instanceof Boolean && (bool = (Boolean)value) != false || value instanceof Integer && (integ = (Integer)value) > 0;
    }

    private int compareProtectionLevels(IPlayerConfig config1, IPlayerConfig config2, IPlayerConfigOptionSpecAPI<? extends Comparable<?>> option, boolean isExceptionOption) {
        Comparable<?> value1 = config1.getEffective(option);
        Comparable<?> value2 = config2.getEffective(option);
        if (value1 instanceof Boolean) {
            Boolean bool1 = (Boolean)value1;
            int result = bool1.compareTo((Boolean)value2);
            return isExceptionOption ? -result : result;
        }
        Integer int1 = (Integer)value1;
        Integer int2 = (Integer)value2;
        if (int1.equals(int2)) {
            return 0;
        }
        if (!isExceptionOption) {
            if (int1 > 0 && int2 <= 0) {
                return 1;
            }
            if (int2 > 0 && int1 <= 0) {
                return -1;
            }
        }
        return int2.compareTo(int1);
    }

    private boolean hitsAnotherClaim(IServerData<CM, ?> serverData, IPlayerChunkClaim fromClaim, IPlayerChunkClaim toClaim, IPlayerConfigOptionSpecAPI<? extends Comparable<?>> optionSpec, boolean withBuildCheck) {
        if (toClaim == null || fromClaim == toClaim || fromClaim != null && fromClaim.isSameClaimType(toClaim)) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig toClaimConfig = this.getClaimConfig(playerConfigs, toClaim);
        if (!toClaimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue() || optionSpec != null && !this.isProtectionEnabled(toClaimConfig, optionSpec)) {
            return false;
        }
        if (fromClaim != null && fromClaim.getPlayerId().equals(toClaim.getPlayerId())) {
            IPlayerConfig fromClaimConfig = this.getClaimConfig(playerConfigs, fromClaim);
            if (!fromClaimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue() || optionSpec != null && this.compareProtectionLevels(fromClaimConfig, toClaimConfig, optionSpec, false) < 0) {
                return true;
            }
            if (withBuildCheck) {
                int toClaimItemUseProt = toClaimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE);
                if (toClaimItemUseProt == 0 && toClaimConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_PLAYERS) == 0) {
                    return false;
                }
                if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_PLAYERS, false) < 0) {
                    return true;
                }
                if (toClaimItemUseProt > 0) {
                    if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_USE, false) < 0) {
                        return true;
                    }
                    if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NEIGHBOR_CHUNKS_ITEM_USE, false) < 0) {
                        return true;
                    }
                }
                if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_MOBS, false) < 0) {
                    return true;
                }
                if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_OTHER, false) < 0) {
                    return true;
                }
                if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PISTON_BARRIER, false) < 0) {
                    return true;
                }
                for (ChunkProtectionExceptionGroup<class_1792> chunkProtectionExceptionGroup : this.itemExceptionGroups.values()) {
                    if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, chunkProtectionExceptionGroup.getPlayerConfigOption(), true) >= 0) continue;
                    return true;
                }
                for (ChunkProtectionExceptionGroup<class_1792> chunkProtectionExceptionGroup : this.entityBarrierGroups.values()) {
                    if (this.compareProtectionLevels(fromClaimConfig, toClaimConfig, chunkProtectionExceptionGroup.getPlayerConfigOption(), false) >= 0) continue;
                    return true;
                }
                for (ChunkProtectionExceptionGroup<class_1792> chunkProtectionExceptionGroup : this.blockExceptionGroups.values()) {
                    if (chunkProtectionExceptionGroup.getType() != ChunkProtectionExceptionType.INTERACTION && chunkProtectionExceptionGroup.getType() != ChunkProtectionExceptionType.ANY_ITEM_INTERACTION || this.compareProtectionLevels(fromClaimConfig, toClaimConfig, chunkProtectionExceptionGroup.getPlayerConfigOption(), true) >= 0) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean hitsAnotherClaim(IServerData<CM, ?> serverData, class_1937 world, class_2338 from, class_2338 to, IPlayerConfigOptionSpecAPI<? extends Comparable<?>> optionSpec, boolean withBuildCheck) {
        int fromChunkX = from.method_10263() >> 4;
        int fromChunkZ = from.method_10260() >> 4;
        int toChunkX = to.method_10263() >> 4;
        int toChunkZ = to.method_10260() >> 4;
        if (fromChunkX == toChunkX && fromChunkZ == toChunkZ) {
            return false;
        }
        IPlayerChunkClaim toClaim = this.claimsManager.get(world.method_27983().method_29177(), toChunkX, toChunkZ);
        IPlayerChunkClaim fromClaim = this.claimsManager.get(world.method_27983().method_29177(), fromChunkX, fromChunkZ);
        return this.hitsAnotherClaim(serverData, fromClaim, toClaim, optionSpec, withBuildCheck);
    }

    public boolean onFluidSpread(IServerData<CM, ?> serverData, class_3218 world, class_2338 from, class_2338 to) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        return this.isOnChunkEdge(from) && this.hitsAnotherClaim(serverData, (class_1937)world, from, to, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FLUID_BARRIER, true);
    }

    public boolean onDispenseFrom(IServerData<CM, ?> serverData, class_3218 serverLevel, class_2338 from) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (!this.isOnChunkEdge(from)) {
            return false;
        }
        class_2680 blockState = serverLevel.method_8320(from);
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)class_2318.field_10927);
        class_2338 to = from.method_10093(direction);
        return this.isOnChunkEdge(from) && this.hitsAnotherClaim(serverData, (class_1937)serverLevel, from, to, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_DISPENSER_BARRIER, true);
    }

    private boolean shouldStopPistonPush(IServerData<CM, ?> serverData, class_3218 world, class_2338 pushPos, int pistonChunkX, int pistonChunkZ, IPlayerChunkClaim pistonClaim) {
        int pushChunkX = pushPos.method_10263() >> 4;
        int pushChunkZ = pushPos.method_10260() >> 4;
        if (pushChunkX == pistonChunkX && pushChunkZ == pistonChunkZ) {
            return false;
        }
        IPlayerChunkClaim pushClaim = this.claimsManager.get(world.method_27983().method_29177(), pushChunkX, pushChunkZ);
        return this.hitsAnotherClaim(serverData, pistonClaim, pushClaim, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PISTON_BARRIER, true);
    }

    public boolean onPistonPush(IServerData<CM, ?> serverData, class_3218 world, List<class_2338> toPush, List<class_2338> toDestroy, class_2338 pistonPos, class_2350 direction, boolean extending) {
        class_2350 actualDirection;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim pistonClaim = this.claimsManager.get(world.method_27983().method_29177(), pistonPos);
        int pistonChunkX = pistonPos.method_10263() >> 4;
        int pistonChunkZ = pistonPos.method_10260() >> 4;
        class_2350 class_23502 = actualDirection = extending ? direction : direction.method_10153();
        if (toPush.isEmpty() && toDestroy.isEmpty()) {
            class_2338 pushPos = pistonPos.method_10093(direction);
            if (this.shouldStopPistonPush(serverData, world, pushPos, pistonChunkX, pistonChunkZ, pistonClaim)) {
                return true;
            }
            return this.shouldStopPistonPush(serverData, world, pushPos.method_10093(actualDirection), pistonChunkX, pistonChunkZ, pistonClaim);
        }
        Iterator posIterator = Iterators.concat(toPush.iterator(), toDestroy.iterator());
        while (posIterator.hasNext()) {
            class_2338 pushPos = (class_2338)posIterator.next();
            if (this.shouldStopPistonPush(serverData, world, pushPos, pistonChunkX, pistonChunkZ, pistonClaim)) {
                return true;
            }
            class_2338 pushedToPos = pushPos.method_10093(actualDirection);
            if (!this.shouldStopPistonPush(serverData, world, pushedToPos, pistonChunkX, pistonChunkZ, pistonClaim)) continue;
            return true;
        }
        return false;
    }

    private Object getAccessorInfo(class_1297 entity) {
        Object result = entity instanceof class_1676 ? ((class_1676)entity).method_24921() : (entity instanceof class_1634 ? ((class_1634)entity).method_7182() : (entity instanceof class_1669 ? ((class_1669)entity).method_7470() : (entity instanceof class_10255 ? entity.method_5642() : this.entityHelper.getOwnerId(entity))));
        return result == null ? entity : result;
    }

    public void onEntitiesPushBlock(IServerData<CM, ?> serverData, class_3218 world, class_2338 pos, class_2248 block, List<? extends class_1297> entities) {
        IPlayerConfigOptionSpecAPI<Integer> blockSpecificOption;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        Iterator<? extends class_1297> iterator = entities.iterator();
        IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), new class_1923(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return;
        }
        IPlayerConfigOptionSpecAPI<Integer> iPlayerConfigOptionSpecAPI = block instanceof class_2269 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BUTTONS_FROM_PROJECTILES : (blockSpecificOption = block instanceof class_4850 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_TARGETS_FROM_PROJECTILES : null);
        if (blockSpecificOption != null && config.getEffective(blockSpecificOption) <= 0) {
            return;
        }
        boolean everyoneExceptAccessHavers = blockSpecificOption != null && config.getEffective(blockSpecificOption) == 1;
        HashMap<UUID, HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>> cachedAccessorOptionResults = null;
        boolean isWeighted = block instanceof class_2557;
        boolean isTripwire = block instanceof class_2538;
        while (iterator.hasNext()) {
            boolean protect;
            Boolean cachedResult;
            HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean> resultsCachedForAccessor;
            class_1297 accessor;
            UUID accessorId;
            class_1297 e = iterator.next();
            if (blockSpecificOption == null && !isWeighted && e.method_5696()) continue;
            Object accessorInfo = this.getAccessorInfo(e);
            if (accessorInfo instanceof UUID) {
                accessorId = (UUID)accessorInfo;
                accessor = this.getEntityById(world, accessorId);
            } else {
                accessor = (class_1297)accessorInfo;
                accessorId = accessor.method_5667();
            }
            IPlayerConfigOptionSpecAPI<Integer> entitySpecificOption = blockSpecificOption;
            if (entitySpecificOption == null) {
                if (isTripwire) {
                    entitySpecificOption = e instanceof class_1657 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_TRIPWIRE_FROM_PLAYERS : (e instanceof class_1309 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_TRIPWIRE_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_TRIPWIRE_FROM_OTHER);
                } else {
                    IPlayerConfigOptionSpecAPI<Integer> iPlayerConfigOptionSpecAPI2 = e instanceof class_1657 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLATES_FROM_PLAYERS : (entitySpecificOption = e instanceof class_1309 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLATES_FROM_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLATES_FROM_OTHER);
                }
            }
            if (cachedAccessorOptionResults != null && (resultsCachedForAccessor = (HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>)cachedAccessorOptionResults.get(accessorId)) != null && (cachedResult = (Boolean)resultsCachedForAccessor.get(entitySpecificOption)) != null) {
                if (!cachedResult.booleanValue()) continue;
                iterator.remove();
                continue;
            }
            boolean bl = protect = (everyoneExceptAccessHavers || this.checkProtectionLeveledOption(entitySpecificOption, config, accessor, accessorId)) && !this.hasChunkAccess(config, accessor, accessorId);
            if (!protect && (blockSpecificOption == PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BUTTONS_FROM_PROJECTILES || blockSpecificOption == null && !isWeighted)) break;
            if (iterator.hasNext()) {
                if (cachedAccessorOptionResults == null) {
                    cachedAccessorOptionResults = new HashMap<UUID, HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>>();
                }
                if ((resultsCachedForAccessor = (Map)cachedAccessorOptionResults.get(accessorId)) == null) {
                    resultsCachedForAccessor = new HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>();
                    cachedAccessorOptionResults.put(accessorId, resultsCachedForAccessor);
                }
                resultsCachedForAccessor.put(entitySpecificOption, protect);
            }
            if (!protect) continue;
            iterator.remove();
        }
    }

    public void onEntitiesCollideWithEntity(IServerData<CM, ?> serverData, class_1297 entity, List<? extends class_1297> collidingEntities) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        class_1937 level = entity.method_73183();
        class_3218 serverLevel = ServerLevelHelper.getServerLevel(level);
        if (serverLevel == null) {
            return;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(level.method_27983().method_29177(), entity.method_31476());
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return;
        }
        if (config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_PLAYERS) == 0 && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_MOBS) == 0 && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_OTHER) == 0) {
            return;
        }
        HashMap<UUID, HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>> cachedAccessorOptionResults = null;
        Iterator<? extends class_1297> iterator = collidingEntities.iterator();
        boolean multipleCollisionsMatter = false;
        while (iterator.hasNext()) {
            boolean protect;
            Boolean cachedResult;
            HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean> accessorCache;
            class_1297 accessor;
            UUID accessorId;
            class_1297 collidingEntity = iterator.next();
            Object accessorInfo = this.getAccessorInfo(collidingEntity);
            if (accessorInfo instanceof UUID) {
                accessorId = (UUID)accessorInfo;
                accessor = this.getEntityById(serverLevel, accessorId);
            } else {
                accessor = (class_1297)accessorInfo;
                accessorId = accessor.method_5667();
            }
            IPlayerConfigOptionSpecAPI<Integer> option = this.getUsedEntityProtectionOption(config, collidingEntity, accessor);
            if (cachedAccessorOptionResults != null && (accessorCache = (HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>)cachedAccessorOptionResults.get(accessorId)) != null && (cachedResult = (Boolean)accessorCache.get(option)) != null) {
                if (!cachedResult.booleanValue()) continue;
                iterator.remove();
                continue;
            }
            boolean bl = protect = this.checkProtectionLeveledOption(option, config, accessor, accessorId) && !this.hasChunkAccess(config, accessor, accessorId);
            if (!protect && !multipleCollisionsMatter) break;
            if (iterator.hasNext()) {
                if (cachedAccessorOptionResults == null) {
                    cachedAccessorOptionResults = new HashMap<UUID, HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>>();
                }
                if ((accessorCache = (Map)cachedAccessorOptionResults.get(accessorId)) == null) {
                    accessorCache = new HashMap<IPlayerConfigOptionSpecAPI<Integer>, Boolean>();
                    cachedAccessorOptionResults.put(accessorId, accessorCache);
                }
                accessorCache.put(option, protect);
            }
            if (!protect) continue;
            iterator.remove();
        }
    }

    public void onEntityAffectsEntities(IServerData<CM, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_1297 entity, List<class_1297> targets) {
        double randomDrop;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        double d = randomDrop = entity instanceof class_10255 && (Boolean)ServerConfig.CONFIG.reducedBoatEntityCollisions.get() != false ? 0.9 : 0.0;
        if (randomDrop > 0.0 && Math.random() < randomDrop) {
            targets.clear();
            return;
        }
        Iterator<class_1297> iterator = targets.iterator();
        while (iterator.hasNext()) {
            class_1297 target = iterator.next();
            if (!this.onEntityInteraction(serverData, null, entity, target, null, null, true, false, true)) continue;
            iterator.remove();
        }
    }

    public boolean onEntityPushed(IServerData<CM, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, class_1297 target, class_1313 moverType) {
        if (moverType != class_1313.field_6309) {
            return false;
        }
        return this.onEntityInteraction(serverData, null, null, target, null, null, true, false, true);
    }

    public boolean onNetherPortal(IServerData<CM, ?> serverData, class_1297 entity, class_3218 world, class_2338 pos) {
        class_1297 accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), new class_1923(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return false;
        }
        if (config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_PLAYERS) == 0 && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_MOBS) == 0 && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_OTHER) == 0) {
            return false;
        }
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(world, accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor.method_5667();
        }
        IPlayerConfigOptionSpecAPI<Integer> option = entity instanceof class_1657 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_PLAYERS : (entity instanceof class_1309 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_MOBS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_NETHER_PORTALS_OTHER);
        return this.checkProtectionLeveledOption(option, config, accessor, accessorId) && !this.hasChunkAccess(config, accessor, accessorId);
    }

    public boolean onRaidSpawn(IServerData<CM, ?> serverData, class_3218 world, class_2338 pos) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(world.method_27983().method_29177(), new class_1923(pos));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        return config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS) != false && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_RAIDS) != false;
    }

    public boolean onMobSpawn(IServerData<CM, ?> serverData, class_1297 entity, double x, double y, double z, class_3730 spawnReason) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(entity.method_73183().method_27983().method_29177(), new class_1923(class_2338.method_49637((double)x, (double)y, (double)z)));
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return false;
        }
        boolean hostile = this.entityHelper.isHostile(entity);
        IPlayerConfigOptionSpecAPI<Boolean> option = spawnReason == class_3730.field_16469 ? (hostile ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_HOSTILE_SPAWNERS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FRIENDLY_SPAWNERS) : (hostile ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_HOSTILE_NATURAL_SPAWN : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_FRIENDLY_NATURAL_SPAWN);
        return config.getEffective(option);
    }

    public boolean onProjectileHitSpawnedEntity(IServerData<CM, ?> serverData, class_1297 projectile, class_1297 entity) {
        class_1297 accessor;
        UUID accessorId;
        if (!(entity instanceof class_1309)) {
            return false;
        }
        if (this.hasActiveFullPass(projectile)) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(entity.method_73183().method_27983().method_29177(), entity.method_31476());
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        Object accessorInfo = this.getAccessorInfo(projectile);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.method_73183()), accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor.method_5667();
        }
        if (this.hasChunkAccess(config, accessor, accessorId)) {
            return false;
        }
        IPlayerConfigOptionSpecAPI<Integer> option = this.entityHelper.isHostile(entity) ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PROJECTILE_HIT_HOSTILE_SPAWN : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PROJECTILE_HIT_FRIENDLY_SPAWN;
        return this.checkProtectionLeveledOption(option, config, accessor, accessorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onProjectileHitSpawnedEntity(@Nonnull class_1297 projectile, @Nonnull class_1297 entity) {
        this.fullPassesPaused = true;
        try {
            boolean bl = this.onProjectileHitSpawnedEntity(this.serverData, projectile, entity);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    public boolean onItemAddedToWorld(IServerData<CM, ?> serverData, class_1542 itemEntity) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        UUID throwerId = ServerCore.getItemEntityThrower(itemEntity);
        if (throwerId == null) {
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(itemEntity.method_73183().method_27983().method_29177(), itemEntity.method_31476());
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return false;
        }
        class_1297 thrower = this.getEntityById(ServerLevelHelper.getServerLevel(itemEntity.method_73183()), throwerId);
        class_1297 result = this.shouldPreventToss(config, itemEntity, thrower, throwerId, null);
        if (result != itemEntity) {
            class_1799 itemStack;
            class_1657 player;
            if (result instanceof class_1657 && !(player = (class_1657)result).method_68878() && !player.method_7270(itemStack = itemEntity.method_6983()) && thrower != player && !thrower.method_31476().equals((Object)player.method_31476())) {
                player.method_7328(itemStack, true);
            }
            return true;
        }
        return false;
    }

    private class_1297 shouldPreventToss(IPlayerConfig config, class_1542 itemEntity, class_1297 thrower, UUID throwerId, UUID throwerAccessorId) {
        class_1297 usedOptionBase;
        UUID accessorId;
        if (throwerId == null) {
            return itemEntity;
        }
        class_1297 accessor = null;
        if (throwerAccessorId == null) {
            if (thrower != null) {
                Object accessorInfo = this.getAccessorInfo(thrower);
                if (accessorInfo instanceof UUID) {
                    accessorId = (UUID)accessorInfo;
                    accessor = this.getEntityById(ServerLevelHelper.getServerLevel(itemEntity.method_73183()), accessorId);
                } else {
                    accessor = (class_1297)accessorInfo;
                    accessorId = accessor.method_5667();
                }
            } else {
                accessorId = throwerId;
            }
        } else {
            accessorId = throwerAccessorId;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(itemEntity.method_73183()), accessorId);
        }
        class_1297 class_12972 = usedOptionBase = config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_REDIRECT) == false ? thrower : accessor;
        IPlayerConfigOptionSpecAPI<Integer> option = usedOptionBase != null ? (!(usedOptionBase instanceof class_1309) ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_OTHER : (usedOptionBase instanceof class_1657 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_PLAYERS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_MOBS)) : this.getToughestProtectionLevelOption(config, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_TOSS_OTHER);
        if (this.checkProtectionLeveledOption(option, config, accessor, accessorId) && !this.hasChunkAccess(config, accessor, accessorId)) {
            return accessor;
        }
        return itemEntity;
    }

    private boolean hasAnEnabledOption(IPlayerConfig config, IPlayerConfigOptionSpecAPI<Boolean> option1, IPlayerConfigOptionSpecAPI<Boolean> option2, IPlayerConfigOptionSpecAPI<Boolean> option3) {
        return config.getEffective(option1) != false || config.getEffective(option2) != false || config.getEffective(option3) != false;
    }

    private IPlayerConfigOptionSpecAPI<Integer> getToughestProtectionLevelOption(IPlayerConfig config, IPlayerConfigOptionSpecAPI<Integer> option1, IPlayerConfigOptionSpecAPI<Integer> option2, IPlayerConfigOptionSpecAPI<Integer> option3) {
        int toughestProtectionLevel = config.getEffective(option1);
        IPlayerConfigOptionSpecAPI<Integer> toughestOption = option1;
        int protectionLevel = config.getEffective(option2);
        if (protectionLevel != 0 && (toughestProtectionLevel == 0 || protectionLevel < toughestProtectionLevel)) {
            toughestProtectionLevel = protectionLevel;
            toughestOption = option2;
        }
        if (option3 != null && (protectionLevel = config.getEffective(option3).intValue()) != 0 && (toughestProtectionLevel == 0 || protectionLevel < toughestProtectionLevel)) {
            return option3;
        }
        return toughestOption;
    }

    public boolean onLivingLootEntity(IServerData<CM, ?> serverData, class_1309 livingEntity, class_1297 lootEntity, class_1282 source) {
        class_1657 player;
        class_1297 accessor;
        UUID accessorId;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        boolean noKiller = source.method_5529() == null || source.method_5529() == livingEntity;
        Object accessorInfo = this.getAccessorInfo((class_1297)(noKiller ? livingEntity : source.method_5529()));
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(lootEntity.method_73183()), accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor.method_5667();
        }
        if (lootEntity instanceof class_1542) {
            class_1542 itemEntity = (class_1542)lootEntity;
            itemEntity.method_6981((class_1297)livingEntity);
        }
        ServerCore.setLootOwner(lootEntity, accessorId);
        if (livingEntity instanceof class_1657) {
            ServerCore.setDeadPlayer(lootEntity, livingEntity.method_5667());
            return false;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(lootEntity.method_73183().method_27983().method_29177(), lootEntity.method_31476());
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        if (!config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue()) {
            return false;
        }
        return this.shouldStopMobLoot(config, accessor, accessorId) && (!(accessor instanceof class_1657) || !this.isAllowedStaticFakePlayerAction(serverData, player = (class_1657)accessor, lootEntity.method_24515()));
    }

    private boolean shouldStopMobLoot(IPlayerConfig config, class_1297 accessor, UUID accessorId) {
        return !this.hasChunkAccess(config, accessor, accessorId) && this.checkProtectionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_MOB_LOOT, config, accessor, accessorId);
    }

    public boolean onEntityPickup(IServerData<CM, ?> serverData, class_1297 entity, class_1297 pickedEntity, UUID pickedEntityThrowerId, UUID pickedEntityOwnerId, Map<class_1297, Set<class_1923>> cantPickupCache, TriFunction<IPlayerConfig, class_1297, class_1297, IPlayerConfigOptionSpecAPI<Integer>> protectionOptionGetter) {
        IPlayerChunkClaim entityPosClaim;
        IPlayerConfig entityPosConfig;
        class_1923 entityChunkPos;
        class_1297 accessor;
        UUID accessorId;
        class_1297 deadPlayer;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (entity.method_5667().equals(pickedEntityThrowerId) || entity.method_5667().equals(pickedEntityOwnerId) || entity.method_5667().equals(ServerCore.getLootOwner(pickedEntity)) || this.hasActiveFullPass(entity)) {
            return false;
        }
        class_1923 chunkPos = pickedEntity.method_31476();
        Set<class_1923> cantPickupCached = cantPickupCache.get(entity);
        if (cantPickupCached != null && cantPickupCached.contains(chunkPos)) {
            return true;
        }
        IPlayerChunkClaim claim = this.claimsManager.get(pickedEntity.method_73183().method_27983().method_29177(), chunkPos);
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
        UUID deadPlayerId = ServerCore.getDeadPlayer(pickedEntity);
        if (deadPlayerId != null && this.checkExceptionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT, config, deadPlayer = this.getEntityById(ServerLevelHelper.getServerLevel(pickedEntity.method_73183()), deadPlayerId), deadPlayerId)) {
            return true;
        }
        boolean shouldPrevent = false;
        Object accessorInfo = this.getAccessorInfo(entity);
        if (accessorInfo instanceof UUID) {
            accessorId = (UUID)accessorInfo;
            accessor = this.getEntityById(ServerLevelHelper.getServerLevel(entity.method_73183()), accessorId);
        } else {
            accessor = (class_1297)accessorInfo;
            accessorId = accessor.method_5667();
        }
        if (this.isAllowedToGrief(entity, accessor, accessorId, config, true, this.entitiesAllowedToGriefDroppedItems, null, this.droppedItemAccessEntityGroups)) {
            return false;
        }
        if (config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS).booleanValue() && !this.hasChunkAccess(config, accessor, accessorId)) {
            IPlayerConfigOptionSpecAPI usedOption = (IPlayerConfigOptionSpecAPI)protectionOptionGetter.apply((Object)config, (Object)entity, (Object)accessor);
            shouldPrevent = this.checkProtectionLeveledOption(usedOption, config, accessor, accessorId);
        }
        if (!(shouldPrevent || entity instanceof class_1657 || chunkPos.equals((Object)(entityChunkPos = entity.method_31476())) || (entityPosConfig = this.getClaimConfig(playerConfigs, entityPosClaim = this.claimsManager.get(pickedEntity.method_73183().method_27983().method_29177(), entityChunkPos))) == config)) {
            shouldPrevent = this.shouldPreventEntityChunkEntry(serverData, playerConfigs, entityPosClaim, claim, entityPosConfig, config, pickedEntity, null, null);
        }
        if (shouldPrevent) {
            if (cantPickupCached == null) {
                cantPickupCached = new HashSet<class_1923>();
                cantPickupCache.put(entity, cantPickupCached);
            }
            cantPickupCached.add(chunkPos);
        }
        return shouldPrevent;
    }

    public boolean onItemPickup(IServerData<CM, ?> serverData, class_1297 entity, class_1542 itemEntity) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        if (entity.method_5667().equals(ServerCore.getThrowerAccessor(itemEntity))) {
            return false;
        }
        return this.onEntityPickup(serverData, entity, (class_1297)itemEntity, ServerCore.getItemEntityThrower(itemEntity), ServerCore.getItemEntityOwner(itemEntity), this.cantPickupItemsInTickCache, this.usedDroppedItemProtectionOptionGetter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onItemPickup(@Nonnull class_1297 entity, @Nonnull class_1542 itemEntity) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onItemPickup(this.serverData, entity, itemEntity);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    private IPlayerConfigOptionSpecAPI<Integer> getUsedDroppedItemProtectionOption(IPlayerConfig config, class_1297 entity, class_1297 accessor) {
        class_1297 usedOptionBase;
        class_1297 class_12972 = usedOptionBase = !(entity instanceof class_1657) && config.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_REDIRECT) != false ? accessor : entity;
        if (usedOptionBase == null) {
            return this.getToughestProtectionLevelOption(config, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_MOBS, null);
        }
        return usedOptionBase instanceof class_1657 ? PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_PLAYERS : PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_MOBS;
    }

    public boolean onEntityMerge(IServerData<CM, ?> serverData, class_1297 first, UUID firstThrower, UUID firstOwner, class_1297 second, UUID secondThrower, UUID secondOwner, IPlayerConfigOptionSpecAPI<Integer> playerOption, IPlayerConfigOptionSpecAPI<Integer> mobOption, IPlayerConfigOptionSpecAPI<Boolean> redirectOption) {
        boolean secondItemProtectionRedirect;
        boolean firstItemProtectionRedirect;
        int secondItemMobsProtection;
        int secondItemPlayerProtection;
        class_1923 secondChunkPos;
        int firstItemMobsProtection;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        class_1923 firstChunkPos = first.method_31476();
        IPlayerChunkClaim firstClaim = this.claimsManager.get(first.method_73183().method_27983().method_29177(), firstChunkPos);
        IPlayerConfig firstConfig = this.getClaimConfig(playerConfigs, firstClaim);
        boolean differentThrower = !Objects.equals(firstThrower, secondThrower);
        boolean differentOwner = !Objects.equals(firstOwner, secondOwner);
        boolean differentLootOwner = !Objects.equals(ServerCore.getLootOwner(first), ServerCore.getLootOwner(second));
        boolean firstProtected = firstConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS);
        int firstItemPlayerProtection = !firstProtected ? 0 : firstConfig.getEffective(playerOption);
        int n = firstItemMobsProtection = !firstProtected || mobOption == null ? 0 : firstConfig.getEffective(mobOption);
        if (differentThrower || differentOwner || differentLootOwner) {
            class_1297 secondDeadPlayer;
            class_1297 firstDeadPlayer;
            if (firstItemPlayerProtection > 0 || firstItemMobsProtection > 0) {
                return true;
            }
            UUID firstDeadPlayerId = ServerCore.getDeadPlayer(first);
            if (firstDeadPlayerId != null && this.checkExceptionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT, firstConfig, firstDeadPlayer = this.getEntityById(ServerLevelHelper.getServerLevel(first.method_73183()), firstDeadPlayerId), firstDeadPlayerId)) {
                return true;
            }
            UUID secondDeadPlayerId = ServerCore.getDeadPlayer(second);
            if (secondDeadPlayerId != null && this.checkExceptionLeveledOption(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_PLAYER_DEATH_LOOT, firstConfig, secondDeadPlayer = this.getEntityById(ServerLevelHelper.getServerLevel(first.method_73183()), secondDeadPlayerId), secondDeadPlayerId)) {
                return true;
            }
        }
        if ((secondChunkPos = second.method_31476()).equals((Object)firstChunkPos)) {
            return false;
        }
        IPlayerChunkClaim secondClaim = this.claimsManager.get(first.method_73183().method_27983().method_29177(), secondChunkPos);
        if (firstClaim == secondClaim) {
            return false;
        }
        IPlayerConfig secondConfig = this.getClaimConfig(playerConfigs, secondClaim);
        if (firstConfig == secondConfig) {
            return false;
        }
        UUID firstClaimOwner = firstConfig.getPlayerId();
        UUID secondClaimOwner = secondConfig.getPlayerId();
        boolean sameClaimOwner = Objects.equals(firstClaimOwner, secondClaimOwner);
        boolean secondProtected = secondConfig.getEffective(PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS);
        int n2 = secondItemPlayerProtection = !secondProtected ? 0 : secondConfig.getEffective(playerOption);
        if (firstItemPlayerProtection != secondItemPlayerProtection || !sameClaimOwner && secondItemPlayerProtection > 1) {
            return true;
        }
        int n3 = secondItemMobsProtection = !secondProtected || mobOption == null ? 0 : secondConfig.getEffective(mobOption);
        if (firstItemMobsProtection != secondItemMobsProtection || !sameClaimOwner && secondItemMobsProtection > 1) {
            return true;
        }
        if (firstItemPlayerProtection != firstItemMobsProtection && redirectOption != null && (firstItemProtectionRedirect = firstConfig.getEffective(redirectOption).booleanValue()) != (secondItemProtectionRedirect = secondConfig.getEffective(redirectOption).booleanValue())) {
            return true;
        }
        return this.shouldPreventEntityChunkEntry(serverData, playerConfigs, firstClaim, secondClaim, firstConfig, secondConfig, second, null, null);
    }

    public boolean onItemStackMerge(IServerData<CM, ?> serverData, class_1542 first, class_1542 second) {
        return this.onEntityMerge(serverData, (class_1297)first, ServerCore.getItemEntityThrower(first), ServerCore.getItemEntityOwner(first), (class_1297)second, ServerCore.getItemEntityThrower(second), ServerCore.getItemEntityOwner(second), PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_PLAYERS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_MOBS, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ITEM_PICKUP_REDIRECT);
    }

    public boolean onExperiencePickup(IServerData<CM, ?> serverData, class_1303 orb, class_1657 player) {
        return this.onEntityPickup(serverData, (class_1297)player, (class_1297)orb, null, null, this.cantPickupXPInTickCache, this.usedExperienceOrbProtectionOptionGetter);
    }

    public boolean onExperienceMerge(IServerData<CM, ?> serverData, class_1303 from, class_1303 into) {
        return this.onEntityMerge(serverData, (class_1297)into, null, null, (class_1297)from, null, null, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_XP_PICKUP, null, null);
    }

    public boolean onProjectileEntityImpact(IServerData<CM, ?> serverData, class_1676 projectile, class_3966 hitResult) {
        class_1297 class_12972;
        boolean shouldProtect = this.onEntityInteraction(serverData, projectile.method_24921(), (class_1297)projectile, hitResult.method_17782(), null, null, false, false, false);
        if (shouldProtect && (class_12972 = projectile.method_24921()) instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, ((ChunkProtection)serverData.getChunkProtection()).PROJECTILE_HIT_ENTITY));
        }
        return shouldProtect;
    }

    public boolean onProjectileBlockImpact(IServerData<CM, ?> serverData, class_1676 projectile, class_3965 hitResult) {
        class_1297 class_12972;
        class_3218 world = ServerLevelHelper.getServerLevel(projectile.method_73183());
        if (world == null) {
            return false;
        }
        boolean shouldProtect = this.onBlockInteraction(serverData, null, (class_1297)projectile, null, null, world, hitResult.method_17777(), null, false, false);
        if (!shouldProtect) {
            class_2338 offPos = hitResult.method_17777().method_10081(hitResult.method_17780().method_62675());
            shouldProtect = this.onBlockInteraction(serverData, null, (class_1297)projectile, null, null, world, offPos, null, false, false);
        }
        if (shouldProtect && (class_12972 = projectile.method_24921()) instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, this.PROJECTILE_HIT_BLOCK));
        }
        return shouldProtect;
    }

    public boolean onProjectileImpact(IServerData<CM, ?> serverData, class_1676 projectile, class_239 hitResult) {
        boolean result = false;
        if (hitResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)hitResult;
            result = this.onProjectileEntityImpact(serverData, projectile, entityHitResult);
        } else if (hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            result = this.onProjectileBlockImpact(serverData, projectile, blockHitResult);
        }
        if (result) {
            projectile.method_31472();
        }
        return result;
    }

    public void setThrowerAccessor(class_1542 itemEntity) {
        Object accessorInfo;
        UUID throwerId = ServerCore.getItemEntityThrower(itemEntity);
        class_1297 thrower = this.getEntityById(ServerLevelHelper.getServerLevel(itemEntity.method_73183()), throwerId);
        UUID accessorId = thrower != null ? ((accessorInfo = this.getAccessorInfo(thrower)) instanceof UUID ? (UUID)accessorInfo : ((class_1297)accessorInfo).method_5667()) : throwerId;
        ServerCore.setThrowerAccessor(itemEntity, accessorId);
    }

    private class_1297 getEntityById(class_3218 world, UUID id) {
        if (world == null) {
            return null;
        }
        class_3222 result = world.method_8503().method_3760().method_14602(id);
        return result != null ? result : world.method_66347(id);
    }

    private boolean onPosAffectedByAnotherPos(IServerData<CM, ?> serverData, IPlayerChunkClaim toClaim, IPlayerChunkClaim fromClaim, boolean affectsBlocks, boolean affectsEntities) {
        if (!this.hitsAnotherClaim(serverData, fromClaim, toClaim, null, true)) {
            return false;
        }
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        IPlayerConfig posClaimConfig = this.getClaimConfig(playerConfigs, toClaim);
        if (affectsBlocks && this.isProtectionEnabled(posClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_BLOCKS_FROM_OTHER)) {
            return true;
        }
        return affectsEntities && this.isProtectionEnabled(posClaimConfig, PlayerConfigOptions.PROTECT_CLAIMED_CHUNKS_ENTITIES_FROM_OTHER);
    }

    private boolean onPosAffectedByAnotherPos(IServerData<CM, ?> serverData, class_3218 world, IPlayerChunkClaim toClaim, int toChunkX, int toChunkZ, int fromChunkX, int fromChunkZ, boolean affectsBlocks, boolean affectsEntities) {
        if (toChunkX == fromChunkX && toChunkZ == fromChunkZ) {
            return false;
        }
        IPlayerChunkClaim anchorClaim = this.claimsManager.get(world.method_27983().method_29177(), fromChunkX, fromChunkZ);
        return this.onPosAffectedByAnotherPos(serverData, toClaim, anchorClaim, affectsBlocks, affectsEntities);
    }

    public boolean onPosAffectedByAnotherPos(IServerData<CM, ?> serverData, class_3218 toWorld, int toChunkX, int toChunkZ, class_3218 fromWorld, int fromChunkX, int fromChunkZ, boolean includeWilderness, boolean affectsBlocks, boolean affectsEntities) {
        if (toChunkX == fromChunkX && toChunkZ == fromChunkZ) {
            return false;
        }
        IPlayerChunkClaim toClaim = this.claimsManager.get(toWorld.method_27983().method_29177(), toChunkX, toChunkZ);
        if (!includeWilderness && toClaim == null) {
            return false;
        }
        IPlayerChunkClaim fromClaim = this.claimsManager.get(fromWorld.method_27983().method_29177(), fromChunkX, fromChunkZ);
        return this.onPosAffectedByAnotherPos(serverData, toClaim, fromClaim, affectsBlocks, affectsEntities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onPosAffectedByAnotherPos(@Nonnull class_3218 toWorld, @Nonnull class_1923 toChunk, @Nonnull class_3218 fromWorld, @Nonnull class_1923 fromChunk, boolean includeWilderness, boolean affectsBlocks, boolean affectsEntities) {
        try {
            this.fullPassesPaused = true;
            boolean bl = this.onPosAffectedByAnotherPos(this.serverData, toWorld, toChunk.field_9181, toChunk.field_9180, fromWorld, fromChunk.field_9181, fromChunk.field_9180, includeWilderness, affectsBlocks, affectsEntities);
            return bl;
        }
        finally {
            this.fullPassesPaused = false;
        }
    }

    private boolean onBlockBounds(IServerData<CM, ?> serverData, class_2338 from, class_2338 to, class_3222 player) {
        class_3218 level = player.method_51469();
        IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
        int fromChunkX = from.method_10263() >> 4;
        int fromChunkZ = from.method_10260() >> 4;
        int toChunkX = to.method_10263() >> 4;
        int toChunkZ = to.method_10260() >> 4;
        int minChunkX = Math.min(fromChunkX, toChunkX);
        int minChunkZ = Math.min(fromChunkZ, toChunkZ);
        int maxChunkX = Math.max(fromChunkX, toChunkX);
        int maxChunkZ = Math.max(fromChunkZ, toChunkZ);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                IPlayerChunkClaim claim = this.claimsManager.get(level.method_27983().method_29177(), chunkX, chunkZ);
                IPlayerConfig config = this.getClaimConfig(playerConfigs, claim);
                if (this.hasChunkAccess(config, (class_1297)player, player.method_5667())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean onBlockBoundsFromAnchor(IServerData<CM, ?> serverData, class_3218 level, class_2338 from, class_2338 to, class_2338 anchor) {
        IPlayerChunkClaim anchorClaim = this.claimsManager.get(level.method_27983().method_29177(), new class_1923(anchor));
        int fromChunkX = from.method_10263() >> 4;
        int fromChunkZ = from.method_10260() >> 4;
        int toChunkX = to.method_10263() >> 4;
        int toChunkZ = to.method_10260() >> 4;
        int minChunkX = Math.min(fromChunkX, toChunkX);
        int minChunkZ = Math.min(fromChunkZ, toChunkZ);
        int maxChunkX = Math.max(fromChunkX, toChunkX);
        int maxChunkZ = Math.max(fromChunkZ, toChunkZ);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                IPlayerChunkClaim claim = this.claimsManager.get(level.method_27983().method_29177(), chunkX, chunkZ);
                if (!this.onPosAffectedByAnotherPos(serverData, claim, anchorClaim, true, true)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean onCreateMod(IServerData<CM, ?> serverData, class_3218 world, int posChunkX, int posChunkZ, @Nullable class_2338 sourceOrAnchor, boolean checkNeighborBlocks, boolean affectsBlocks, boolean affectsEntities) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        IPlayerChunkClaim posClaim = this.claimsManager.get(world.method_27983().method_29177(), posChunkX, posChunkZ);
        if (posClaim == null) {
            return false;
        }
        if (sourceOrAnchor == null) {
            return this.onPosAffectedByAnotherPos(serverData, posClaim, null, affectsBlocks, affectsEntities);
        }
        int anchorChunkRelativeX = sourceOrAnchor.method_10263() & 0xF;
        int anchorChunkRelativeZ = sourceOrAnchor.method_10260() & 0xF;
        int anchorChunkX = sourceOrAnchor.method_10263() >> 4;
        int anchorChunkZ = sourceOrAnchor.method_10260() >> 4;
        if (!checkNeighborBlocks || !this.isOnChunkEdge(sourceOrAnchor)) {
            return this.onPosAffectedByAnotherPos(serverData, world, posClaim, posChunkX, posChunkZ, anchorChunkX, anchorChunkZ, affectsBlocks, affectsEntities);
        }
        int fromChunkOffX = anchorChunkRelativeX == 0 ? -1 : 0;
        int toChunkOffX = anchorChunkRelativeX == 15 ? 1 : 0;
        int fromChunkOffZ = anchorChunkRelativeZ == 0 ? -1 : 0;
        int toChunkOffZ = anchorChunkRelativeZ == 15 ? 1 : 0;
        for (int offX = fromChunkOffX; offX <= toChunkOffX; ++offX) {
            for (int offZ = fromChunkOffZ; offZ <= toChunkOffZ; ++offZ) {
                int effectiveAnchorChunkX = anchorChunkX + offX;
                int effectiveAnchorChunkZ = anchorChunkZ + offZ;
                if (!this.onPosAffectedByAnotherPos(serverData, world, posClaim, posChunkX, posChunkZ, effectiveAnchorChunkX, effectiveAnchorChunkZ, affectsBlocks, affectsEntities)) continue;
                return true;
            }
        }
        return false;
    }

    public <E> boolean onCreateModAffectPositionedObjects(IServerData<CM, ?> serverData, class_3218 world, List<E> objects, Function<E, class_1923> positionGetter, class_2338 contraptionAnchor, boolean checkNeighborBlocks, boolean removeInvalid, boolean affectsBlocks, boolean affectsEntities) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return false;
        }
        Iterator<E> objectIterator = objects.iterator();
        if (!objectIterator.hasNext()) {
            return false;
        }
        HashMap<class_1923, Boolean> chunkCache = new HashMap<class_1923, Boolean>();
        boolean result = false;
        while (objectIterator.hasNext()) {
            E object = objectIterator.next();
            class_1923 objectChunkPos = positionGetter.apply(object);
            Boolean cachedValue = (Boolean)chunkCache.get(objectChunkPos);
            if (cachedValue != null) {
                if (!cachedValue.booleanValue()) continue;
                objectIterator.remove();
                continue;
            }
            boolean shouldProtect = this.onCreateMod(serverData, world, objectChunkPos.field_9181, objectChunkPos.field_9180, contraptionAnchor, checkNeighborBlocks, affectsBlocks, affectsEntities);
            if (shouldProtect) {
                result = true;
                if (!removeInvalid) break;
                objectIterator.remove();
            }
            chunkCache.put(objectChunkPos, shouldProtect);
        }
        return result;
    }

    public boolean onCreateGlueSelection(IServerData<CM, ?> serverData, class_2338 from, class_2338 to, class_3222 player) {
        if (this.onBlockBounds(serverData, from, to, player)) {
            player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, this.CANT_USE_SUPER_GLUE));
            return true;
        }
        return false;
    }

    public boolean onCreateGlueRemoval(IServerData<CM, ?> serverData, int entityId, class_3222 player) {
        class_3218 level = player.method_51469();
        class_1297 superGlueEntity = level.method_8469(entityId);
        return superGlueEntity != null && this.onCreateGlueEntity(serverData, superGlueEntity, player);
    }

    public boolean onCreateGlueEntity(IServerData<CM, ?> serverData, class_1297 superGlueEntity, class_3222 player) {
        class_2338 maxPos;
        class_238 boundingBox = superGlueEntity.method_5829();
        class_2338 minPos = class_2338.method_49637((double)boundingBox.field_1323, (double)boundingBox.field_1322, (double)boundingBox.field_1321);
        if (this.onBlockBounds(serverData, minPos, maxPos = class_2338.method_49637((double)(boundingBox.field_1320 - 1.0), (double)(boundingBox.field_1325 - 1.0), (double)(boundingBox.field_1324 - 1.0)), player)) {
            player.method_64398(serverData.getAdaptiveLocalizer().getFor(player, this.CANT_REMOVE_SUPER_GLUE));
            return true;
        }
        return false;
    }

    public boolean onCreateGlueEntityFromAnchor(IServerData<CM, ?> serverData, class_1297 superGlueEntity, class_2338 anchor) {
        class_3218 level = ServerLevelHelper.getServerLevel(superGlueEntity.method_73183());
        class_238 boundingBox = superGlueEntity.method_5829();
        class_2338 minPos = class_2338.method_49637((double)boundingBox.field_1323, (double)boundingBox.field_1322, (double)boundingBox.field_1321);
        class_2338 maxPos = class_2338.method_49637((double)(boundingBox.field_1320 - 1.0), (double)(boundingBox.field_1325 - 1.0), (double)(boundingBox.field_1324 - 1.0));
        int fromChunkX = minPos.method_10263() >> 4;
        int fromChunkZ = minPos.method_10260() >> 4;
        int toChunkX = maxPos.method_10263() >> 4;
        int toChunkZ = maxPos.method_10260() >> 4;
        int minChunkX = Math.min(fromChunkX, toChunkX);
        int minChunkZ = Math.min(fromChunkZ, toChunkZ);
        int maxChunkX = Math.max(fromChunkX, toChunkX);
        int maxChunkZ = Math.max(fromChunkZ, toChunkZ);
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                if (!this.onCreateMod(serverData, level, chunkX, chunkZ, anchor, true, true, false)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateTagExceptions(MinecraftServer server) {
        this.friendlyEntityList.updateTagExceptions(server);
        this.hostileEntityList.updateTagExceptions(server);
        this.forcedInteractionExceptionBlocks.updateTagExceptions(server);
        this.forcedBreakExceptionBlocks.updateTagExceptions(server);
        this.requiresEmptyHandBlocks.updateTagExceptions(server);
        this.forcedAllowAnyItemBlocks.updateTagExceptions(server);
        this.forcedInteractionExceptionEntities.updateTagExceptions(server);
        this.forcedKillExceptionEntities.updateTagExceptions(server);
        this.requiresEmptyHandEntities.updateTagExceptions(server);
        this.forcedAllowAnyItemEntities.updateTagExceptions(server);
        this.forcedEntityClaimBarrierList.updateTagExceptions(server);
        this.entitiesAllowedToBreakBlocks.updateTagExceptions(server);
        this.entitiesAllowedToInteractWithBlocks.updateTagExceptions(server);
        this.entitiesAllowedToKillEntities.updateTagExceptions(server);
        this.entitiesAllowedToInteractWithEntities.updateTagExceptions(server);
        this.entitiesAllowedToGriefDroppedItems.updateTagExceptions(server);
        this.nonBlockGriefingMobs.updateTagExceptions(server);
        this.entityGriefingMobs.updateTagExceptions(server);
        this.droppedItemGriefingMobs.updateTagExceptions(server);
        this.additionalBannedItems.updateTagExceptions(server);
        this.itemUseProtectionExceptions.updateTagExceptions(server);
        this.completelyDisabledItems.updateTagExceptions(server);
        this.completelyDisabledBlocks.updateTagExceptions(server);
        this.completelyDisabledEntities.updateTagExceptions(server);
        this.blockExceptionGroups.values().forEach(g -> g.updateTagExceptions(server));
        this.entityExceptionGroups.values().forEach(g -> g.updateTagExceptions(server));
        this.itemExceptionGroups.values().forEach(g -> g.updateTagExceptions(server));
        this.entityBarrierGroups.values().forEach(g -> g.updateTagExceptions(server));
    }

    public void onServerTick() {
        this.cantPickupItemsInTickCache.clear();
        this.cantPickupXPInTickCache.clear();
    }

    public static enum InteractionTargetResult {
        PROTECT,
        ALLOW,
        PASS;

    }

    public static final class Builder<CM extends IServerClaimsManager<?, ?, ?>> {
        private MinecraftServer server;
        private CM claimsManager;
        private IPlayerPartySystemManager playerPartySystemManager;
        private Map<String, ChunkProtectionExceptionGroup<class_2248>> blockExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1792>> itemExceptionGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityBarrierGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> blockAccessEntityGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityAccessEntityGroups;
        private Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> droppedItemAccessEntityGroups;

        private Builder() {
        }

        public Builder<CM> setDefault() {
            this.setServer(null);
            this.setClaimsManager(null);
            this.setPlayerPartySystemManager(null);
            return this;
        }

        public Builder<CM> setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder<CM> setClaimsManager(CM claimsManager) {
            this.claimsManager = claimsManager;
            return this;
        }

        public Builder<CM> setPlayerPartySystemManager(IPlayerPartySystemManager playerPartySystemManager) {
            this.playerPartySystemManager = playerPartySystemManager;
            return this;
        }

        public Builder<CM> setBlockExceptionGroups(Map<String, ChunkProtectionExceptionGroup<class_2248>> blockExceptionGroups) {
            this.blockExceptionGroups = blockExceptionGroups;
            return this;
        }

        public Builder<CM> setEntityExceptionGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityExceptionGroups) {
            this.entityExceptionGroups = entityExceptionGroups;
            return this;
        }

        public Builder<CM> setItemExceptionGroups(Map<String, ChunkProtectionExceptionGroup<class_1792>> itemExceptionGroups) {
            this.itemExceptionGroups = itemExceptionGroups;
            return this;
        }

        public Builder<CM> setEntityBarrierGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityBarrierGroups) {
            this.entityBarrierGroups = entityBarrierGroups;
            return this;
        }

        public Builder<CM> setBlockAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> blockAccessEntityGroups) {
            this.blockAccessEntityGroups = blockAccessEntityGroups;
            return this;
        }

        public Builder<CM> setEntityAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> entityAccessEntityGroups) {
            this.entityAccessEntityGroups = entityAccessEntityGroups;
            return this;
        }

        public Builder<CM> setDroppedItemAccessEntityGroups(Map<String, ChunkProtectionExceptionGroup<class_1299<?>>> droppedItemAccessEntityGroups) {
            this.droppedItemAccessEntityGroups = droppedItemAccessEntityGroups;
            return this;
        }

        public ChunkProtection<CM> build() {
            if (this.server == null || this.claimsManager == null || this.playerPartySystemManager == null || this.blockExceptionGroups == null || this.entityExceptionGroups == null || this.itemExceptionGroups == null || this.entityBarrierGroups == null || this.blockAccessEntityGroups == null || this.entityAccessEntityGroups == null || this.droppedItemAccessEntityGroups == null) {
                throw new IllegalStateException();
            }
            ChunkProtectionExceptionSet.Builder<class_1299<?>> friendlyEntityList = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> hostileEntityList = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_2248> forcedInteractionExceptionBlocksBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<class_2248> forcedBreakExceptionBlocksBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<class_2248> requiresEmptyHandBlocksBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<class_2248> forcedAllowAnyItemBlocksBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> forcedInteractionExceptionEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> forcedKillExceptionEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> requiresEmptyHandEntitiesBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> forcedAllowAnyItemEntitiesBuilder = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> forcedEntityClaimBarrierList = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> entitiesAllowedToBreakBlocks = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> entitiesAllowedToInteractWithBlocks = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> entitiesAllowedToKillEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> entitiesAllowedToInteractWithEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> entitiesAllowedToGriefDroppedItems = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> nonBlockGriefingMobs = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> entityGriefingMobs = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> droppedItemGriefingMobs = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            ChunkProtectionExceptionSet.Builder<class_1792> additionalBannedItems = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ITEM);
            ChunkProtectionExceptionSet.Builder<class_1792> itemUseProtectionExceptions = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ITEM);
            ChunkProtectionExceptionSet.Builder<class_1792> completelyDisabledItems = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ITEM);
            ChunkProtectionExceptionSet.Builder<class_2248> completelyDisabledBlocks = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.BLOCK);
            ChunkProtectionExceptionSet.Builder<class_1299<?>> completelyDisabledEntities = ChunkProtectionExceptionSet.Builder.begin(ExceptionElementType.ENTITY_TYPE);
            WildcardResolver wildcardResolver = new WildcardResolver();
            this.onExceptionList(this.server, ServerConfig.CONFIG.friendlyChunkProtectedEntityList, friendlyEntityList::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.hostileChunkProtectedEntityList, hostileEntityList::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.forcedBlockProtectionExceptionList, null, forcedInteractionExceptionBlocksBuilder::addEither, forcedBreakExceptionBlocksBuilder::addEither, o -> {
                forcedInteractionExceptionBlocksBuilder.addEither((Either<class_2248, class_6862<class_2248>>)o);
                requiresEmptyHandBlocksBuilder.addEither((Either<class_2248, class_6862<class_2248>>)o);
            }, forcedAllowAnyItemBlocksBuilder::addEither, ExceptionElementType.BLOCK, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.forcedEntityProtectionExceptionList, null, forcedInteractionExceptionEntities::addEither, forcedKillExceptionEntities::addEither, o -> {
                forcedInteractionExceptionEntities.addEither((Either<class_1299<?>, class_6862<class_1299<?>>>)o);
                requiresEmptyHandEntitiesBuilder.addEither((Either<class_1299<?>, class_6862<class_1299<?>>>)o);
            }, forcedAllowAnyItemEntitiesBuilder::addEither, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.forcedEntityClaimBarrierList, forcedEntityClaimBarrierList::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.entitiesAllowedToGrief, e -> {
                entitiesAllowedToBreakBlocks.addEither((Either<class_1299<?>, class_6862<class_1299<?>>>)e);
                entitiesAllowedToInteractWithBlocks.addEither((Either<class_1299<?>, class_6862<class_1299<?>>>)e);
            }, entitiesAllowedToInteractWithBlocks::addEither, entitiesAllowedToBreakBlocks::addEither, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.entitiesAllowedToGriefEntities, e -> {
                entitiesAllowedToKillEntities.addEither((Either<class_1299<?>, class_6862<class_1299<?>>>)e);
                entitiesAllowedToInteractWithEntities.addEither((Either<class_1299<?>, class_6862<class_1299<?>>>)e);
            }, entitiesAllowedToInteractWithEntities::addEither, entitiesAllowedToKillEntities::addEither, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.entitiesAllowedToGriefDroppedItems, entitiesAllowedToGriefDroppedItems::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.nonBlockGriefingMobs, nonBlockGriefingMobs::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.entityGriefingMobs, entityGriefingMobs::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.droppedItemGriefingMobs, droppedItemGriefingMobs::addEither, null, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.additionalBannedItemsList, additionalBannedItems::addEither, null, null, null, null, ExceptionElementType.ITEM, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.itemUseProtectionExceptionList, null, itemUseProtectionExceptions::addEither, null, null, null, ExceptionElementType.ITEM, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.completelyDisabledItemInteractions, null, completelyDisabledItems::addEither, null, null, null, ExceptionElementType.ITEM, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.completelyDisabledBlockInteractions, null, completelyDisabledBlocks::addEither, null, null, null, ExceptionElementType.BLOCK, wildcardResolver);
            this.onExceptionList(this.server, ServerConfig.CONFIG.completelyDisabledEntityInteractions, null, completelyDisabledEntities::addEither, null, null, null, ExceptionElementType.ENTITY_TYPE, wildcardResolver);
            HashSet<String> staticFakePlayerUsernames = new HashSet<String>();
            HashSet<UUID> staticFakePlayerIds = new HashSet<UUID>();
            ((List)ServerConfig.CONFIG.staticFakePlayers.get()).forEach(e -> {
                try {
                    staticFakePlayerIds.add(UUID.fromString(e));
                }
                catch (IllegalArgumentException iae) {
                    staticFakePlayerUsernames.add((String)e);
                }
            });
            HashSet staticFakePlayerClassExceptions = new HashSet();
            ((List)ServerConfig.CONFIG.staticFakePlayerClassExceptions.get()).forEach(e -> {
                try {
                    staticFakePlayerClassExceptions.add(Class.forName(e));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            });
            HashSet<UUID> fullPasses = new HashSet<UUID>();
            return new ChunkProtection<CM>(this.claimsManager, this.playerPartySystemManager, new ChunkProtectionEntityHelper(), friendlyEntityList.build(), hostileEntityList.build(), forcedInteractionExceptionBlocksBuilder.build(), forcedBreakExceptionBlocksBuilder.build(), requiresEmptyHandBlocksBuilder.build(), forcedAllowAnyItemBlocksBuilder.build(), completelyDisabledBlocks.build(), forcedInteractionExceptionEntities.build(), forcedKillExceptionEntities.build(), requiresEmptyHandEntitiesBuilder.build(), forcedAllowAnyItemEntitiesBuilder.build(), forcedEntityClaimBarrierList.build(), entitiesAllowedToBreakBlocks.build(), entitiesAllowedToInteractWithBlocks.build(), entitiesAllowedToKillEntities.build(), entitiesAllowedToInteractWithEntities.build(), entitiesAllowedToGriefDroppedItems.build(), nonBlockGriefingMobs.build(), entityGriefingMobs.build(), droppedItemGriefingMobs.build(), staticFakePlayerUsernames, staticFakePlayerIds, staticFakePlayerClassExceptions, additionalBannedItems.build(), completelyDisabledItems.build(), itemUseProtectionExceptions.build(), completelyDisabledEntities.build(), this.blockExceptionGroups, this.entityExceptionGroups, this.itemExceptionGroups, this.entityBarrierGroups, this.blockAccessEntityGroups, this.entityAccessEntityGroups, this.droppedItemAccessEntityGroups, new class_2338.class_2339(), new HashMap<class_1297, Set<class_1923>>(), new HashMap<class_1297, Set<class_1923>>(), fullPasses);
        }

        private <T> void onExceptionList(MinecraftServer server, ModConfigSpec.ConfigValue<List<? extends String>> list, Consumer<Either<T, class_6862<T>>> defaultException, Consumer<Either<T, class_6862<T>>> interactException, Consumer<Either<T, class_6862<T>>> breakException, Consumer<Either<T, class_6862<T>>> handException, Consumer<Either<T, class_6862<T>>> anythingException, ExceptionElementType<T> elementType, WildcardResolver wildcardResolver) {
            class_2378 elementRegistry = elementType.getRegistry(server);
            Function<class_2960, Object> objectGetter = key -> elementRegistry.method_17966(key).orElse(null);
            Iterable iterable = elementType.getIterable();
            Function<Object, class_2960> keyGetter = arg_0 -> elementRegistry.method_10221(arg_0);
            Function<class_2960, class_6862> objectTagGetter = rl -> class_6862.method_40092((class_5321)elementRegistry.method_46765(), (class_2960)rl);
            Iterable tagIterable = elementType.getTagIterable();
            Function<class_6862, class_2960> tagKeyGetter = class_6862::comp_327;
            ((List)list.get()).forEach(s -> this.onExceptionListElement((String)s, defaultException, interactException, breakException, handException, anythingException, (Function)objectGetter, iterable, (Function)keyGetter, (Function)objectTagGetter, tagIterable, (Function)tagKeyGetter, wildcardResolver));
        }

        private <T> void onExceptionListElement(String element, Consumer<Either<T, class_6862<T>>> defaultException, Consumer<Either<T, class_6862<T>>> interactException, Consumer<Either<T, class_6862<T>>> breakException, Consumer<Either<T, class_6862<T>>> handException, Consumer<Either<T, class_6862<T>>> anythingException, Function<class_2960, T> objectGetter, Iterable<T> iterable, Function<T, class_2960> keyGetter, Function<class_2960, class_6862<T>> objectTagGetter, Iterable<class_6862<T>> tagIterable, Function<class_6862<T>, class_2960> tagKeyGetter, WildcardResolver wildcardResolver) {
            block5: {
                Consumer<Object> destination;
                String id;
                block6: {
                    id = element;
                    if (defaultException == null) {
                        defaultException = interactException;
                    }
                    destination = defaultException;
                    if (element.startsWith(ChunkProtection.BREAK_PREFIX) || element.startsWith(ChunkProtection.HAND_PREFIX) || element.startsWith(ChunkProtection.ANYTHING_PREFIX) || element.startsWith(ChunkProtection.INTERACT_PREFIX)) {
                        id = element.substring(element.indexOf("$") + 1);
                        destination = element.startsWith(ChunkProtection.BREAK_PREFIX) ? breakException : (element.startsWith(ChunkProtection.ANYTHING_PREFIX) ? anythingException : (element.startsWith(ChunkProtection.INTERACT_PREFIX) ? interactException : handException));
                    }
                    if (destination == null) break block5;
                    if (id.startsWith(ChunkProtection.TAG_PREFIX)) break block6;
                    List<T> objects = wildcardResolver.resolveIdentifiers(objectGetter, iterable, keyGetter, id);
                    if (objects == null) break block5;
                    for (T object : objects) {
                        destination.accept(Either.left(object));
                    }
                    break block5;
                }
                List<class_6862<T>> objectTags = wildcardResolver.resolveIdentifiers(objectTagGetter, tagIterable, tagKeyGetter, id = id.substring(ChunkProtection.TAG_PREFIX.length()));
                if (objectTags != null) {
                    for (class_6862<T> objectTag : objectTags) {
                        destination.accept(Either.right(objectTag));
                    }
                }
            }
        }

        public static <CM extends IServerClaimsManager<?, ?, ?>> Builder<CM> begin() {
            return new Builder<CM>().setDefault();
        }
    }
}

