/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.command.ClaimsClaimCommands;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigSubListCommand {
    public void register(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment) {
        Command<class_2168> regularExecutor = ConfigSubListCommand.getExecutor(PlayerConfigType.PLAYER);
        Command<class_2168> serverExecutor = ConfigSubListCommand.getExecutor(PlayerConfigType.SERVER);
        Predicate<class_2168> serverRequirement = ClaimsClaimCommands.getServerClaimCommandRequirement();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(this.getMainCommandPart(regularExecutor)));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(class_2170.method_9247((String)"player-config").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"for").requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(this.getMainCommandPart(regularExecutor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)class_2170.method_9247((String)"openpac").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"server-claims-config").requires(serverRequirement)).then(this.getMainCommandPart(serverExecutor)));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<class_2168> getMainCommandPart(Command<class_2168> executor) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"sub").then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"start-at", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(executor)));
    }

    private static Command<class_2168> getExecutor(PlayerConfigType type) {
        return context -> {
            UUID configPlayerUUID;
            class_3222 sourcePlayer = ((class_2168)context.getSource()).method_9207();
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            if (type == PlayerConfigType.PLAYER) {
                GameProfile inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<class_2168>)context, sourcePlayer, "gui.xaero_pac_config_sub_list_too_many_targets", "gui.xaero_pac_config_sub_list_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.getId();
            } else {
                configPlayerUUID = PlayerConfig.SERVER_CLAIM_UUID;
            }
            PlayerConfig playerConfig = (PlayerConfig)serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID);
            List<String> subConfigIds = playerConfig.getSubConfigIds();
            int startAt = IntegerArgumentType.getInteger((CommandContext)context, (String)"start-at");
            if (startAt >= subConfigIds.size()) {
                ((class_2168)context.getSource()).method_9213((class_2561)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_sub_list_bad_start", subConfigIds.size()));
                return 0;
            }
            if (startAt < 0) {
                startAt = 0;
            }
            int endAt = Math.min(startAt + 64, subConfigIds.size());
            class_5250 listMessage = adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_sub_list", startAt + 1, subConfigIds.size());
            for (int i = startAt; i < endAt; ++i) {
                if (i != startAt) {
                    listMessage.method_10855().add(adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_sub_list_separator", new Object[0]));
                }
                listMessage.method_10855().add(class_2561.method_43470((String)subConfigIds.get(i)));
            }
            if (endAt < subConfigIds.size()) {
                listMessage.method_10855().add(adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_sub_list_there_is_more", new Object[0]));
            }
            sourcePlayer.method_64398((class_2561)listMessage);
            return 1;
        };
    }
}

