/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.parties.party;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import xaero.pac.client.parties.party.IClientPartyMemberDynamicInfoSyncableStorage;
import xaero.pac.common.parties.party.PartyMemberDynamicInfoSyncable;

public class ClientPartyMemberDynamicInfoSyncableStorage
implements IClientPartyMemberDynamicInfoSyncableStorage<PartyMemberDynamicInfoSyncable> {
    private Map<UUID, PartyMemberDynamicInfoSyncable> storage;

    private ClientPartyMemberDynamicInfoSyncableStorage(Map<UUID, PartyMemberDynamicInfoSyncable> storage) {
        this.storage = storage;
    }

    @Override
    public PartyMemberDynamicInfoSyncable getForPlayer(@Nonnull UUID playerId) {
        return this.storage.get(playerId);
    }

    @Override
    public PartyMemberDynamicInfoSyncable getOrSetForPlayer(UUID playerId, PartyMemberDynamicInfoSyncable defaultInfo) {
        return this.storage.computeIfAbsent(playerId, i -> defaultInfo == null ? new PartyMemberDynamicInfoSyncable((UUID)i, true) : defaultInfo);
    }

    @Override
    public boolean removeForPlayer(UUID playerId) {
        return this.storage.remove(playerId) != null;
    }

    @Override
    public Stream<PartyMemberDynamicInfoSyncable> getTypedAllStream() {
        return this.storage.values().stream();
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    public static final class Builder {
        private Builder() {
        }

        public ClientPartyMemberDynamicInfoSyncableStorage build() {
            return new ClientPartyMemberDynamicInfoSyncableStorage(new HashMap<UUID, PartyMemberDynamicInfoSyncable>());
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

