/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.claims.ClaimsManager;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.result.api.AreaClaimResult;
import xaero.pac.common.claims.result.api.ClaimResult;
import xaero.pac.common.claims.tracker.ClaimsManagerTracker;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.ServerClaimStateHolder;
import xaero.pac.common.server.claims.ServerClaimsPermissionHandler;
import xaero.pac.common.server.claims.ServerDimensionClaimsManager;
import xaero.pac.common.server.claims.ServerRegionClaims;
import xaero.pac.common.server.claims.forceload.ForceLoadTicketManager;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfoManager;
import xaero.pac.common.server.claims.player.expiration.ServerPlayerClaimsExpirationHandler;
import xaero.pac.common.server.claims.player.io.PlayerClaimInfoManagerIO;
import xaero.pac.common.server.claims.player.task.PlayerClaimReplaceSpreadoutTask;
import xaero.pac.common.server.claims.sync.ClaimsManagerSynchronizer;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.permission.api.UsedPermissionNodes;
import xaero.pac.common.server.task.ServerSpreadoutQueuedTaskHandler;
import xaero.pac.common.util.linked.LinkedChain;

public final class ServerClaimsManager
extends ClaimsManager<ServerPlayerClaimInfo, ServerPlayerClaimInfoManager, ServerRegionClaims, ServerDimensionClaimsManager, ServerClaimStateHolder>
implements IServerClaimsManager<PlayerChunkClaim, ServerPlayerClaimInfo, ServerDimensionClaimsManager> {
    private final int MAX_REQUEST_SIZE = 100;
    private final ClaimsManagerSynchronizer claimsManagerSynchronizer;
    private final ServerSpreadoutQueuedTaskHandler<PlayerClaimReplaceSpreadoutTask> claimReplaceTaskHandler;
    private final ServerClaimsPermissionHandler permissionHandler;
    private final LinkedChain<ServerClaimStateHolder> linkedClaimStates;
    private boolean loaded;

    protected ServerClaimsManager(MinecraftServer server, ServerPlayerClaimInfoManager playerClaimInfoManager, IPlayerConfigManager configManager, Map<class_2960, ServerDimensionClaimsManager> dimensions, ClaimsManagerSynchronizer claimsManagerSynchronizer, Int2ObjectMap<PlayerChunkClaim> indexToClaimState, Map<PlayerChunkClaim, ServerClaimStateHolder> claimStates, ClaimsManagerTracker claimsManagerTracker, ServerSpreadoutQueuedTaskHandler<PlayerClaimReplaceSpreadoutTask> claimReplaceTaskHandler, ServerClaimsPermissionHandler permissionHandler, LinkedChain<ServerClaimStateHolder> linkedClaimStates) {
        super(playerClaimInfoManager, configManager, dimensions, indexToClaimState, claimStates, claimsManagerTracker);
        this.claimsManagerSynchronizer = claimsManagerSynchronizer;
        this.claimReplaceTaskHandler = claimReplaceTaskHandler;
        this.permissionHandler = permissionHandler;
        this.linkedClaimStates = linkedClaimStates;
    }

    public void setIo(PlayerClaimInfoManagerIO<?> io) {
        ((ServerPlayerClaimInfoManager)this.playerClaimInfoManager).setIo(io);
    }

    public void setExpirationHandler(ServerPlayerClaimsExpirationHandler expirationHandler) {
        ((ServerPlayerClaimInfoManager)this.playerClaimInfoManager).setExpirationHandler(expirationHandler);
    }

    public ServerPlayerClaimsExpirationHandler.Builder beginExpirationHandlerBuilder() {
        return ((ServerPlayerClaimsExpirationHandler.Builder)ServerPlayerClaimsExpirationHandler.Builder.begin().setManager((ServerPlayerClaimInfoManager)this.playerClaimInfoManager)).setClaimsManager(this);
    }

    @Override
    protected ServerDimensionClaimsManager create(class_2960 dimension, Long2ObjectMap<ServerRegionClaims> claims) {
        boolean playerClaimsSyncAllowed = (Boolean)ServerConfig.CONFIG.allowExistingClaimsInUnclaimableDimensions.get() != false || this.isClaimable(dimension);
        return new ServerDimensionClaimsManager(dimension, claims, new LinkedChain<ServerRegionClaims>(), this, playerClaimsSyncAllowed);
    }

    @Override
    protected ServerClaimStateHolder createStateHolder(PlayerChunkClaim claim) {
        return new ServerClaimStateHolder(claim);
    }

    public long countStateRegions(PlayerChunkClaim state, int direction) {
        ServerClaimStateHolder stateHolder = (ServerClaimStateHolder)this.claimStateHolders.get(state);
        stateHolder.countRegions(direction);
        if (stateHolder.getRegionCount() <= 0L) {
            this.removeClaimState(state);
        }
        return stateHolder.getRegionCount();
    }

    private boolean withinDistance(int fromX, int fromZ, int x, int z) {
        int maxClaimDistance = (Integer)ServerConfig.CONFIG.maxClaimDistance.get();
        return Math.abs(x - fromX) <= maxClaimDistance && Math.abs(z - fromZ) <= maxClaimDistance;
    }

    @Override
    public boolean isClaimable(@Nonnull class_2960 dimension) {
        return ((ServerPlayerClaimInfoManager)this.playerClaimInfoManager).isClaimable(dimension);
    }

    @Override
    protected void onClaimStateAdded(ServerClaimStateHolder stateHolder) {
        this.linkedClaimStates.add(stateHolder);
    }

    @Override
    protected void removeClaimState(PlayerChunkClaim state) {
        this.linkedClaimStates.remove((ServerClaimStateHolder)this.claimStateHolders.get(state));
        super.removeClaimState(state);
        this.claimsManagerSynchronizer.syncToPlayersRemoveClaimState(state);
    }

    @Override
    @Nullable
    public PlayerChunkClaim claim(@Nonnull class_2960 dimension, @Nonnull UUID id, int subConfigIndex, int x, int z, boolean forceload) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return null;
        }
        PlayerChunkClaim result = super.claim(dimension, id, subConfigIndex, x, z, forceload);
        if (this.loaded) {
            this.claimsManagerTracker.onChunkChange(dimension, x, z, result);
        }
        return result;
    }

    @Override
    public void unclaim(@Nonnull class_2960 dimension, int x, int z) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return;
        }
        super.unclaim(dimension, x, z);
        if (this.loaded) {
            this.claimsManagerTracker.onChunkChange(dimension, x, z, null);
        }
    }

    private ClaimResult<PlayerChunkClaim> tryToClaimHelper(class_2960 dimension, UUID playerId, int subConfigIndex, int fromX, int fromZ, int x, int z, boolean forceLoaded, boolean replace, boolean isServer) {
        boolean withinLimit;
        PlayerChunkClaim currentClaim = this.get(dimension, x, z);
        boolean claimCountUnaffected = false;
        if (currentClaim != null) {
            claimCountUnaffected = Objects.equals(currentClaim.getPlayerId(), playerId);
            if (!replace && !claimCountUnaffected) {
                return new ClaimResult<PlayerChunkClaim>(currentClaim, ClaimResult.Type.ALREADY_CLAIMED);
            }
        }
        ServerPlayerClaimInfo playerClaimInfo = (ServerPlayerClaimInfo)this.getPlayerInfo(playerId);
        if (!replace && playerClaimInfo.isReplacementInProgress()) {
            return new ClaimResult<Object>(null, ClaimResult.Type.REPLACEMENT_IN_PROGRESS);
        }
        boolean bl = withinLimit = claimCountUnaffected || isServer || playerClaimInfo.getClaimCount() < this.getPlayerBaseClaimLimit(playerId) + this.configManager.getLoadedConfig(playerId).getEffective(PlayerConfigOptions.BONUS_CHUNK_CLAIMS);
        if (withinLimit) {
            PlayerChunkClaim c;
            PlayerChunkClaim claim = new PlayerChunkClaim(playerId, subConfigIndex, forceLoaded, 0);
            if (Objects.equals(claim, currentClaim)) {
                return new ClaimResult<PlayerChunkClaim>(currentClaim, ClaimResult.Type.ALREADY_CLAIMED);
            }
            return new ClaimResult<PlayerChunkClaim>(c, Objects.equals(c = this.claim(dimension, claim.getPlayerId(), subConfigIndex, x, z, claim.isForceloadable()), claim) ? ClaimResult.Type.SUCCESSFUL_CLAIM : ClaimResult.Type.CLAIM_LIMIT_REACHED);
        }
        return new ClaimResult<PlayerChunkClaim>(currentClaim, ClaimResult.Type.CLAIM_LIMIT_REACHED);
    }

    @Override
    @Nonnull
    public ClaimResult<PlayerChunkClaim> tryToClaimTyped(@Nonnull class_2960 dimension, @Nonnull UUID playerId, int subConfigIndex, int fromX, int fromZ, int x, int z, boolean replace) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return new ClaimResult<Object>(null, ClaimResult.Type.CLAIMS_ARE_DISABLED);
        }
        boolean isServer = Objects.equals(playerId, PlayerConfig.SERVER_CLAIM_UUID);
        if (!isServer && !this.isClaimable(dimension)) {
            return new ClaimResult<Object>(null, ClaimResult.Type.UNCLAIMABLE_DIMENSION);
        }
        if (!replace && !this.withinDistance(fromX, fromZ, x, z)) {
            return new ClaimResult<Object>(null, ClaimResult.Type.TOO_FAR);
        }
        return this.tryToClaimHelper(dimension, playerId, subConfigIndex, fromX, fromZ, x, z, false, replace, isServer);
    }

    private ClaimResult<PlayerChunkClaim> tryToUnclaimHelper(class_2960 dimension, UUID id, int fromX, int fromZ, int x, int z, boolean replace) {
        PlayerChunkClaim currentClaim = this.get(dimension, x, z);
        if (currentClaim == null || !replace && !Objects.equals(id, currentClaim.getPlayerId())) {
            return new ClaimResult<PlayerChunkClaim>(currentClaim, ClaimResult.Type.NOT_CLAIMED_BY_USER);
        }
        this.unclaim(dimension, x, z);
        return new ClaimResult<Object>(null, ClaimResult.Type.SUCCESSFUL_UNCLAIM);
    }

    @Override
    @Nonnull
    public ClaimResult<PlayerChunkClaim> tryToUnclaimTyped(@Nonnull class_2960 dimension, @Nonnull UUID id, int fromX, int fromZ, int x, int z, boolean replace) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return new ClaimResult<Object>(null, ClaimResult.Type.CLAIMS_ARE_DISABLED);
        }
        if (!replace && !this.withinDistance(fromX, fromZ, x, z)) {
            return new ClaimResult<Object>(null, ClaimResult.Type.TOO_FAR);
        }
        return this.tryToUnclaimHelper(dimension, id, fromX, fromZ, x, z, replace);
    }

    private ClaimResult<PlayerChunkClaim> tryToForceloadHelper(class_2960 dimension, UUID id, int fromX, int fromZ, int x, int z, boolean enable, boolean replace, boolean isServer) {
        PlayerChunkClaim currentClaim = this.get(dimension, x, z);
        if (currentClaim != null && (replace || Objects.equals(currentClaim.getPlayerId(), id))) {
            boolean withinLimit;
            if (currentClaim.isForceloadable() == enable) {
                return new ClaimResult<PlayerChunkClaim>(currentClaim, enable ? ClaimResult.Type.ALREADY_FORCELOADABLE : ClaimResult.Type.ALREADY_UNFORCELOADED);
            }
            ServerPlayerClaimInfo playerClaimInfo = (ServerPlayerClaimInfo)this.getPlayerInfo(id);
            boolean bl = withinLimit = isServer || !enable || playerClaimInfo.getForceloadCount() < this.getPlayerBaseForceloadLimit(id) + this.configManager.getLoadedConfig(id).getEffective(PlayerConfigOptions.BONUS_CHUNK_FORCELOADS);
            if (!withinLimit) {
                return new ClaimResult<PlayerChunkClaim>(currentClaim, ClaimResult.Type.FORCELOAD_LIMIT_REACHED);
            }
            ClaimResult<PlayerChunkClaim> result = this.tryToClaimHelper(dimension, currentClaim.getPlayerId(), currentClaim.getSubConfigIndex(), fromX, fromZ, x, z, enable, true, isServer);
            if (result.getResultType() == ClaimResult.Type.SUCCESSFUL_CLAIM) {
                return new ClaimResult<PlayerChunkClaim>(result.getClaimResult(), enable ? ClaimResult.Type.SUCCESSFUL_FORCELOAD : ClaimResult.Type.SUCCESSFUL_UNFORCELOAD);
            }
            return result;
        }
        return new ClaimResult<PlayerChunkClaim>(currentClaim, ClaimResult.Type.NOT_CLAIMED_BY_USER_FORCELOAD);
    }

    @Override
    @Nonnull
    public ClaimResult<PlayerChunkClaim> tryToForceloadTyped(@Nonnull class_2960 dimension, @Nonnull UUID id, int fromX, int fromZ, int x, int z, boolean enable, boolean replace) {
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return new ClaimResult<Object>(null, ClaimResult.Type.CLAIMS_ARE_DISABLED);
        }
        boolean isServer = Objects.equals(id, PlayerConfig.SERVER_CLAIM_UUID);
        if (enable && !isServer && !this.isClaimable(dimension)) {
            return new ClaimResult<Object>(null, ClaimResult.Type.UNCLAIMABLE_DIMENSION);
        }
        if (!replace && !this.withinDistance(fromX, fromZ, x, z)) {
            return new ClaimResult<Object>(null, ClaimResult.Type.TOO_FAR);
        }
        return this.tryToForceloadHelper(dimension, id, fromX, fromZ, x, z, enable, replace, isServer);
    }

    public AreaClaimResult tryClaimActionOverArea(class_2960 dimension, UUID playerId, int subConfigIndex, int fromX, int fromZ, int left, int top, int right, int bottom, ClaimsManager.Action action, boolean replace) {
        int maxRequestLength;
        if (!((Boolean)ServerConfig.CONFIG.claimsEnabled.get()).booleanValue()) {
            return new AreaClaimResult(Sets.newHashSet((Object[])new ClaimResult.Type[]{ClaimResult.Type.CLAIMS_ARE_DISABLED}), left, top, right, bottom);
        }
        HashSet<ClaimResult.Type> resultTypes = new HashSet<ClaimResult.Type>();
        boolean isServer = Objects.equals(playerId, PlayerConfig.SERVER_CLAIM_UUID);
        if (!(isServer || action != ClaimsManager.Action.CLAIM && action != ClaimsManager.Action.FORCELOAD || this.isClaimable(dimension))) {
            resultTypes.add(ClaimResult.Type.UNCLAIMABLE_DIMENSION);
            return new AreaClaimResult(resultTypes, left, top, right, bottom);
        }
        int effectiveLeft = left;
        int effectiveTop = top;
        int effectiveRight = right;
        int effectiveBottom = bottom;
        if (!replace) {
            int maxClaimDistance = (Integer)ServerConfig.CONFIG.maxClaimDistance.get();
            boolean outOfBounds = false;
            if (effectiveLeft < fromX - maxClaimDistance) {
                effectiveLeft = fromX - maxClaimDistance;
                outOfBounds = true;
            }
            if (effectiveTop < fromZ - maxClaimDistance) {
                effectiveTop = fromZ - maxClaimDistance;
                outOfBounds = true;
            }
            if (effectiveRight > fromX + maxClaimDistance) {
                effectiveRight = fromX + maxClaimDistance;
                outOfBounds = true;
            }
            if (effectiveBottom > fromZ + maxClaimDistance) {
                effectiveBottom = fromZ + maxClaimDistance;
                outOfBounds = true;
            }
            if (outOfBounds) {
                resultTypes.add(ClaimResult.Type.TOO_FAR);
            }
        }
        if (effectiveRight - effectiveLeft >= (maxRequestLength = 32)) {
            effectiveRight = effectiveLeft + maxRequestLength - 1;
        }
        if (effectiveBottom - effectiveTop >= maxRequestLength) {
            effectiveBottom = effectiveTop + maxRequestLength - 1;
        }
        int total = effectiveLeft > effectiveRight || effectiveTop > effectiveBottom ? 0 : (1 + effectiveRight - effectiveLeft) * (1 + effectiveBottom - effectiveTop);
        int toAffect = total;
        if (total > 100) {
            toAffect = 100;
        }
        block0: for (int x = effectiveLeft; x <= effectiveRight; ++x) {
            for (int z = effectiveTop; z <= effectiveBottom; ++z) {
                ClaimResult<PlayerChunkClaim> result = null;
                if (action == ClaimsManager.Action.CLAIM) {
                    result = this.tryToClaimHelper(dimension, playerId, subConfigIndex, fromX, fromZ, x, z, false, replace, isServer);
                } else if (action == ClaimsManager.Action.UNCLAIM) {
                    result = this.tryToUnclaimHelper(dimension, playerId, fromX, fromZ, x, z, replace);
                } else if (action == ClaimsManager.Action.FORCELOAD) {
                    result = this.tryToForceloadHelper(dimension, playerId, fromX, fromZ, x, z, true, replace, isServer);
                } else {
                    if (action != ClaimsManager.Action.UNFORCELOAD) break block0;
                    result = this.tryToForceloadHelper(dimension, playerId, fromX, fromZ, x, z, false, replace, isServer);
                }
                resultTypes.add(result.getResultType());
                if (result.getResultType().success) {
                    if (toAffect <= 0) {
                        resultTypes.add(ClaimResult.Type.TOO_MANY_CHUNKS);
                        break block0;
                    }
                    --toAffect;
                }
                if (result.getResultType() == ClaimResult.Type.CLAIM_LIMIT_REACHED || result.getResultType() == ClaimResult.Type.FORCELOAD_LIMIT_REACHED || result.getResultType() == ClaimResult.Type.REPLACEMENT_IN_PROGRESS) break block0;
            }
        }
        return new AreaClaimResult(resultTypes, left, top, right, bottom);
    }

    @Override
    @Nonnull
    public AreaClaimResult tryToClaimArea(@Nonnull class_2960 dimension, @Nonnull UUID playerId, int subConfigIndex, int fromX, int fromZ, int left, int top, int right, int bottom, boolean replace) {
        return this.tryClaimActionOverArea(dimension, playerId, subConfigIndex, fromX, fromZ, left, top, right, bottom, ClaimsManager.Action.CLAIM, replace);
    }

    @Override
    @Nonnull
    public AreaClaimResult tryToUnclaimArea(@Nonnull class_2960 dimension, @Nonnull UUID id, int fromX, int fromZ, int left, int top, int right, int bottom, boolean replace) {
        return this.tryClaimActionOverArea(dimension, id, -1, fromX, fromZ, left, top, right, bottom, ClaimsManager.Action.UNCLAIM, replace);
    }

    @Override
    @Nonnull
    public AreaClaimResult tryToForceloadArea(@Nonnull class_2960 dimension, @Nonnull UUID id, int fromX, int fromZ, int left, int top, int right, int bottom, boolean enable, boolean replace) {
        return this.tryClaimActionOverArea(dimension, id, -1, fromX, fromZ, left, top, right, bottom, enable ? ClaimsManager.Action.FORCELOAD : ClaimsManager.Action.UNFORCELOAD, replace);
    }

    @Override
    @Nullable
    public PlayerChunkClaim get(@Nonnull class_2960 dimension, int x, int z) {
        PlayerChunkClaim actualClaim = super.get(dimension, x, z);
        if (actualClaim == null || ((Boolean)ServerConfig.CONFIG.allowExistingClaimsInUnclaimableDimensions.get()).booleanValue() || Objects.equals(actualClaim.getPlayerId(), PlayerConfig.SERVER_CLAIM_UUID) || Objects.equals(actualClaim.getPlayerId(), PlayerConfig.EXPIRED_CLAIM_UUID) || this.isClaimable(dimension)) {
            return actualClaim;
        }
        return null;
    }

    @Override
    public int getPlayerBaseClaimLimit(@Nonnull UUID playerId) {
        return ((ServerPlayerClaimInfoManager)this.playerClaimInfoManager).getPlayerBaseLimit(playerId, null, ServerConfig.CONFIG.maxPlayerClaims, UsedPermissionNodes.MAX_PLAYER_CLAIMS);
    }

    @Override
    public int getPlayerBaseForceloadLimit(@Nonnull UUID playerId) {
        return ((ServerPlayerClaimInfoManager)this.playerClaimInfoManager).getPlayerBaseLimit(playerId, null, ServerConfig.CONFIG.maxPlayerClaimForceloads, UsedPermissionNodes.MAX_PLAYER_FORCELOADS);
    }

    @Override
    public int getPlayerBaseClaimLimit(@Nonnull class_3222 player) {
        return ((ServerPlayerClaimInfoManager)this.playerClaimInfoManager).getPlayerBaseLimit(null, player, ServerConfig.CONFIG.maxPlayerClaims, UsedPermissionNodes.MAX_PLAYER_CLAIMS);
    }

    @Override
    public int getPlayerBaseForceloadLimit(@Nonnull class_3222 player) {
        return ((ServerPlayerClaimInfoManager)this.playerClaimInfoManager).getPlayerBaseLimit(null, player, ServerConfig.CONFIG.maxPlayerClaimForceloads, UsedPermissionNodes.MAX_PLAYER_FORCELOADS);
    }

    public Iterator<ServerClaimStateHolder> getClaimStateHolderIterator() {
        return this.linkedClaimStates.iterator();
    }

    @Override
    public ClaimsManagerSynchronizer getClaimsManagerSynchronizer() {
        return this.claimsManagerSynchronizer;
    }

    @Override
    public ServerSpreadoutQueuedTaskHandler<PlayerClaimReplaceSpreadoutTask> getClaimReplaceTaskHandler() {
        return this.claimReplaceTaskHandler;
    }

    @Override
    public ServerClaimsPermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void onLoad() {
        this.loaded = true;
    }

    public static final class Builder
    extends ClaimsManager.Builder<ServerPlayerClaimInfo, ServerPlayerClaimInfoManager, ServerRegionClaims, ServerDimensionClaimsManager, ServerClaimStateHolder, Builder> {
        private MinecraftServer server;
        private IPlayerConfigManager configManager;
        private ForceLoadTicketManager ticketManager;
        private ClaimsManagerSynchronizer claimsManagerSynchronizer;
        private ServerSpreadoutQueuedTaskHandler<PlayerClaimReplaceSpreadoutTask> claimReplaceTaskHandler;
        private ServerClaimsPermissionHandler permissionHandler;

        public static Builder begin() {
            return new Builder().setDefault();
        }

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setServer(null);
            this.setTicketManager(null);
            this.setClaimsManagerSynchronizer(null);
            this.setConfigManager(null);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public Builder setTicketManager(ForceLoadTicketManager ticketManager) {
            this.ticketManager = ticketManager;
            return this;
        }

        public Builder setClaimsManagerSynchronizer(ClaimsManagerSynchronizer claimsManagerSynchronizer) {
            this.claimsManagerSynchronizer = claimsManagerSynchronizer;
            return this;
        }

        public Builder setClaimReplaceTaskHandler(ServerSpreadoutQueuedTaskHandler<PlayerClaimReplaceSpreadoutTask> claimReplaceTaskHandler) {
            this.claimReplaceTaskHandler = claimReplaceTaskHandler;
            return this;
        }

        public Builder setConfigManager(IPlayerConfigManager configManager) {
            this.configManager = configManager;
            return (Builder)this.self;
        }

        public Builder setPermissionHandler(ServerClaimsPermissionHandler permissionHandler) {
            this.permissionHandler = permissionHandler;
            return (Builder)this.self;
        }

        public ServerClaimsManager build() {
            if (this.server == null || this.ticketManager == null || this.claimsManagerSynchronizer == null || this.configManager == null || this.claimReplaceTaskHandler == null || this.permissionHandler == null) {
                throw new IllegalStateException();
            }
            ServerPlayerClaimInfoManager playerInfoManager = new ServerPlayerClaimInfoManager(this.server, this.configManager, this.ticketManager, new HashMap<UUID, ServerPlayerClaimInfo>(), new LinkedChain<ServerPlayerClaimInfo>(), new HashSet<ServerPlayerClaimInfo>());
            this.setPlayerClaimInfoManager(playerInfoManager);
            ServerClaimsManager result = (ServerClaimsManager)super.build();
            playerInfoManager.setClaimsManager(result);
            this.claimsManagerSynchronizer.setClaimsManager(result);
            ((ServerPlayerClaimInfo)result.getPlayerInfo(PlayerConfig.SERVER_CLAIM_UUID)).setPlayerUsername("\"Server\"");
            ((ServerPlayerClaimInfo)result.getPlayerInfo(PlayerConfig.EXPIRED_CLAIM_UUID)).setPlayerUsername("\"Expiration\"");
            return result;
        }

        protected ServerClaimsManager buildInternally(Map<PlayerChunkClaim, ServerClaimStateHolder> claimStates, ClaimsManagerTracker claimsManagerTracker, Int2ObjectMap<PlayerChunkClaim> indexToClaimState) {
            LinkedChain<ServerClaimStateHolder> linkedClaimStates = new LinkedChain<ServerClaimStateHolder>();
            claimStates.values().forEach(linkedClaimStates::add);
            return new ServerClaimsManager(this.server, (ServerPlayerClaimInfoManager)this.playerClaimInfoManager, this.configManager, this.dimensions, this.claimsManagerSynchronizer, indexToClaimState, claimStates, claimsManagerTracker, this.claimReplaceTaskHandler, this.permissionHandler, linkedClaimStates);
        }
    }
}

