/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_3222;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.packet.config.PlayerConfigOptionValuePacket;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public class ServerboundPlayerConfigOptionValuePacket
extends PlayerConfigOptionValuePacket {
    public ServerboundPlayerConfigOptionValuePacket(PlayerConfigType type, String subId, UUID owner, List<PlayerConfigOptionValuePacket.Entry> entries) {
        super(type, subId, owner, entries);
    }

    public static class ServerHandler
    implements BiConsumer<ServerboundPlayerConfigOptionValuePacket, class_3222> {
        private <T extends Comparable<T>> IPlayerConfigAPI.SetResult setConfigUnchecked(IPlayerConfig config, IPlayerConfigOptionSpecAPI<T> option, Object value) {
            return config.tryToSet(option, (Comparable)value);
        }

        @Override
        public void accept(ServerboundPlayerConfigOptionValuePacket t, class_3222 serverPlayer) {
            IPlayerConfigAPI.SetResult result;
            IPlayerConfigOptionSpecAPI<?> option;
            IPlayerConfig config;
            UUID ownerId;
            if (t.entries.size() > 1) {
                OpenPartiesAndClaims.LOGGER.info("A player is attempting to modify multiple options in a single packet! Name: " + serverPlayer.method_7334().getName());
                return;
            }
            boolean isOP = serverPlayer.method_64475(2);
            PlayerConfigOptionValuePacket.Entry optionEntry = (PlayerConfigOptionValuePacket.Entry)t.entries.get(0);
            UUID uUID = t.getType() != PlayerConfigType.PLAYER ? null : (ownerId = t.owner == null ? serverPlayer.method_5667() : t.owner);
            if (!isOP) {
                if (t.getType() != PlayerConfigType.PLAYER) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to modify a config without required permissions! Name: " + serverPlayer.method_7334().getName());
                    return;
                }
                if (PlayerConfig.isOptionOPConfigurable(optionEntry.getId())) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to modify a op-only option! Name: " + serverPlayer.method_7334().getName());
                    return;
                }
                if (!Objects.equals(ownerId, serverPlayer.method_5667())) {
                    OpenPartiesAndClaims.LOGGER.info("Non-op player is attempting to modify another player's config! Name: " + serverPlayer.method_7334().getName());
                    return;
                }
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(serverPlayer.method_5682());
            IPlayerConfigManager playerConfigs = serverData.getPlayerConfigs();
            IPlayerConfig iPlayerConfig = t.getType() == PlayerConfigType.PLAYER ? playerConfigs.getLoadedConfig(ownerId) : (t.getType() == PlayerConfigType.SERVER ? playerConfigs.getServerClaimConfig() : (t.getType() == PlayerConfigType.EXPIRED ? playerConfigs.getExpiredClaimConfig() : (config = t.getType() == PlayerConfigType.WILDERNESS ? playerConfigs.getWildernessConfig() : playerConfigs.getDefaultConfig())));
            if (t.subId != null) {
                config = config.getSubConfig(t.subId);
            }
            if (config != null && (option = playerConfigs.getOptionForId(optionEntry.getId())) != null && (result = this.setConfigUnchecked(config, option, optionEntry.getValue())) != IPlayerConfigAPI.SetResult.SUCCESS && (config.getType() != PlayerConfigType.PLAYER || serverPlayer.method_5667().equals(config.getPlayerId()))) {
                playerConfigs.getSynchronizer().syncOptionToClient(serverPlayer, config, option);
            }
        }
    }

    public static class Codec
    extends PlayerConfigOptionValuePacket.Codec<ServerboundPlayerConfigOptionValuePacket> {
        @Override
        protected int getSizeLimit() {
            return 262144;
        }

        @Override
        protected ServerboundPlayerConfigOptionValuePacket create(PlayerConfigType type, String subId, UUID owner, List<PlayerConfigOptionValuePacket.Entry> entries) {
            return new ServerboundPlayerConfigOptionValuePacket(type, subId, owner, entries);
        }
    }
}

