/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server;

import net.minecraft.server.MinecraftServer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.io.PlayerClaimInfoManagerIO;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.system.impl.DefaultPlayerPartySystem;

public class ServerStartingCallback {
    private final PlayerClaimInfoManagerIO<?> playerClaimInfoManagerIO;

    public ServerStartingCallback(PlayerClaimInfoManagerIO<?> playerClaimInfoManagerIO) {
        this.playerClaimInfoManagerIO = playerClaimInfoManagerIO;
    }

    public void onLoad(MinecraftServer server) {
        IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
        try {
            serverData.getPlayerPermissionSystemManager().preRegister();
            serverData.getPlayerPartySystemManager().preRegister();
            serverData.getPlayerPartySystemManager().register("default", new DefaultPlayerPartySystem((IPartyManager<IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>>)serverData.getPartyManager()));
            OpenPartiesAndClaims.INSTANCE.getCommonEvents().fireAddonRegisterEvent(serverData);
        }
        finally {
            serverData.getPlayerPermissionSystemManager().postRegister();
            serverData.getPlayerPartySystemManager().postRegister();
        }
        this.playerClaimInfoManagerIO.load();
        serverData.getPlayerPermissionSystemManager().updateUsedSystem((String)ServerConfig.CONFIG.permissionSystem.get());
        serverData.getPlayerPartySystemManager().updatePrimarySystem((String)ServerConfig.CONFIG.primaryPartySystem.get());
    }
}

