/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.api.IServerClaimsManagerAPI;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ClaimsAboutCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        Command action = context -> {
            String subId;
            Object targetProfile;
            ServerPlayer casterPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                Collection profiles = GameProfileArgument.getGameProfiles((CommandContext)context, (String)"profile");
                targetProfile = profiles.size() == 1 ? (GameProfile)profiles.iterator().next() : null;
            }
            catch (IllegalArgumentException iae) {
                targetProfile = casterPlayer.getGameProfile();
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(casterPlayer.getServer());
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            if (targetProfile == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_claims_about_invalid_player", new Object[0]));
                return 0;
            }
            GameProfile profile = targetProfile;
            IPlayerConfigManager configManager = serverData.getPlayerConfigs();
            IServerClaimsManagerAPI claimsManager = serverData.getServerClaimsManager();
            IPlayerConfig playerConfig = configManager.getLoadedConfig(profile.getId());
            IPlayerConfig usedSubConfig = playerConfig.getUsedSubConfig();
            IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)claimsManager.getPlayerInfo(profile.getId());
            int claimLimit = claimsManager.getPlayerBaseClaimLimit(profile.getId()) + playerConfig.getEffective(PlayerConfigOptions.BONUS_CHUNK_CLAIMS);
            int forceloadLimit = claimsManager.getPlayerBaseForceloadLimit(profile.getId()) + playerConfig.getEffective(PlayerConfigOptions.BONUS_CHUNK_FORCELOADS);
            MutableComponent claimCountNumbers = new TextComponent(playerInfo.getClaimCount() + " / " + claimLimit).withStyle(s -> s.withColor(-5592406));
            Object claimName = usedSubConfig.getEffective(PlayerConfigOptions.CLAIMS_NAME);
            if (((String)claimName).isEmpty()) {
                claimName = "N/A";
            }
            if ((subId = usedSubConfig.getSubId()) == null) {
                subId = "main";
            }
            claimName = (String)claimName + " (" + subId + ")";
            MutableComponent claimNameComponent = new TextComponent((String)claimName).withStyle(s -> s.withColor(-5592406));
            MutableComponent forceloadCountNumbers = new TextComponent(playerInfo.getForceloadCount() + " / " + forceloadLimit).withStyle(s -> s.withColor(-5592406));
            casterPlayer.sendMessage((Component)new TextComponent(""), casterPlayer.getUUID());
            casterPlayer.sendMessage((Component)new TextComponent("===== Open Parties and Claims").withStyle(s -> s.withColor(ChatFormatting.GRAY)), casterPlayer.getUUID());
            casterPlayer.sendMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_pac_ui_claim_count", claimCountNumbers), casterPlayer.getUUID());
            casterPlayer.sendMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_pac_ui_forceload_count", forceloadCountNumbers), casterPlayer.getUUID());
            casterPlayer.sendMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_pac_ui_claims_name", claimNameComponent), casterPlayer.getUUID());
            int claimColor = usedSubConfig.getEffective(PlayerConfigOptions.CLAIMS_COLOR);
            MutableComponent colorComponent = new TextComponent(Integer.toUnsignedString(claimColor, 16).toUpperCase()).withStyle(s -> s.withColor(claimColor));
            casterPlayer.sendMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_pac_ui_claims_color", colorComponent), casterPlayer.getUUID());
            casterPlayer.sendMessage((Component)new TextComponent("=====").withStyle(s -> s.withColor(ChatFormatting.GRAY)), casterPlayer.getUUID());
            return 1;
        };
        SuggestionProvider suggestions = (context, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerlist.getPlayers().stream().map(targetPlayer -> targetPlayer.getGameProfile().getName()), (SuggestionsBuilder)builder);
        };
        LiteralArgumentBuilder normalCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"openpac-claims").requires(context -> (Boolean)ServerConfig.CONFIG.claimsEnabled.get())).then(Commands.literal((String)"about").executes(action));
        dispatcher.register(normalCommand);
        LiteralArgumentBuilder opTargetCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"openpac-claims").requires(c -> (Boolean)ServerConfig.CONFIG.claimsEnabled.get())).then(Commands.literal((String)"about").then(((RequiredArgumentBuilder)Commands.argument((String)"profile", (ArgumentType)GameProfileArgument.gameProfile()).requires(c -> c.hasPermission(2))).suggests(suggestions).executes(action)));
        dispatcher.register(opTargetCommand);
    }
}

