/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.claims;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.claims.ClientDimensionClaimsManager;
import xaero.pac.client.claims.ClientRegionClaims;
import xaero.pac.client.claims.IClientClaimsManager;
import xaero.pac.client.claims.player.ClientPlayerClaimInfo;
import xaero.pac.client.claims.player.ClientPlayerClaimInfoManager;
import xaero.pac.client.claims.tracker.result.ClaimsManagerClaimResultTracker;
import xaero.pac.common.claims.ClaimStateHolder;
import xaero.pac.common.claims.ClaimsManager;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.request.ClaimActionRequest;
import xaero.pac.common.claims.storage.RegionClaimsPaletteStorage;
import xaero.pac.common.claims.tracker.ClaimsManagerTracker;
import xaero.pac.common.packet.claims.ServerboundClaimActionRequestPacket;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.util.linked.LinkedChain;

public final class ClientClaimsManager
extends ClaimsManager<ClientPlayerClaimInfo, ClientPlayerClaimInfoManager, ClientRegionClaims, ClientDimensionClaimsManager, ClaimStateHolder>
implements IClientClaimsManager<PlayerChunkClaim, ClientPlayerClaimInfo, ClientDimensionClaimsManager> {
    private final ClaimsManagerClaimResultTracker claimResultTracker;
    private boolean loading;
    private int loadingClaimCount;
    private int loadingForceloadCount;
    private boolean alwaysUseLoadingValues;
    private int claimLimit;
    private int forceloadLimit;
    private int maxClaimDistance;
    private boolean adminMode;
    private boolean serverMode;
    private int currentSubConfigIndex;
    private int currentServerSubConfigIndex;
    private String currentSubConfigId;
    private String currentServerSubConfigId;

    private ClientClaimsManager(ClientPlayerClaimInfoManager playerClaimInfoManager, IPlayerConfigManager configManager, Map<ResourceLocation, ClientDimensionClaimsManager> dimensions, Int2ObjectMap<PlayerChunkClaim> indexToClaimState, Map<PlayerChunkClaim, ClaimStateHolder> claimStates, ClaimsManagerTracker claimsManagerTracker, ClaimsManagerClaimResultTracker claimResultTracker) {
        super(playerClaimInfoManager, configManager, dimensions, indexToClaimState, claimStates, claimsManagerTracker);
        this.claimResultTracker = claimResultTracker;
        this.currentSubConfigIndex = -1;
        this.currentServerSubConfigIndex = -1;
        this.currentSubConfigId = "main";
        this.currentServerSubConfigId = "main";
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public void setLoadingClaimCount(int loadingClaimCount) {
        this.loadingClaimCount = loadingClaimCount;
    }

    @Override
    public int getLoadingClaimCount() {
        return this.loadingClaimCount;
    }

    @Override
    public void setLoadingForceloadCount(int loadingForceloadCount) {
        this.loadingForceloadCount = loadingForceloadCount;
    }

    @Override
    public int getLoadingForceloadCount() {
        return this.loadingForceloadCount;
    }

    public void setAlwaysUseLoadingValues(boolean alwaysUseLoadingValues) {
        this.alwaysUseLoadingValues = alwaysUseLoadingValues;
    }

    @Override
    public boolean getAlwaysUseLoadingValues() {
        return this.alwaysUseLoadingValues;
    }

    @Override
    public void setClaimLimit(int claimLimit) {
        this.claimLimit = claimLimit;
    }

    @Override
    public int getClaimLimit() {
        return this.claimLimit;
    }

    @Override
    public void setForceloadLimit(int forceloadLimit) {
        this.forceloadLimit = forceloadLimit;
    }

    @Override
    public int getForceloadLimit() {
        return this.forceloadLimit;
    }

    @Override
    public void setMaxClaimDistance(int maxClaimDistance) {
        this.maxClaimDistance = maxClaimDistance;
    }

    @Override
    public int getMaxClaimDistance() {
        return this.maxClaimDistance;
    }

    @Override
    public boolean isAdminMode() {
        return this.adminMode;
    }

    public void setAdminMode(boolean adminMode) {
        this.adminMode = adminMode;
    }

    @Override
    public boolean isServerMode() {
        return this.serverMode;
    }

    public void setServerMode(boolean serverMode) {
        this.serverMode = serverMode;
    }

    @Override
    public void setCurrentSubConfigIndex(int currentSubConfigIndex) {
        this.currentSubConfigIndex = currentSubConfigIndex;
    }

    @Override
    public void setCurrentServerSubConfigIndex(int currentServerSubConfigIndex) {
        this.currentServerSubConfigIndex = currentServerSubConfigIndex;
    }

    @Override
    public void setCurrentSubConfigId(String currentSubConfigId) {
        this.currentSubConfigId = currentSubConfigId;
    }

    @Override
    public void setCurrentServerSubConfigId(String currentServerSubConfigId) {
        this.currentServerSubConfigId = currentServerSubConfigId;
    }

    @Override
    protected ClaimStateHolder createStateHolder(PlayerChunkClaim claim) {
        return new ClaimStateHolder(claim);
    }

    @Override
    public void addClaimState(PlayerChunkClaim claim) {
        super.addClaimState(claim);
    }

    @Override
    public void removeClaimState(PlayerChunkClaim state) {
        super.removeClaimState(state);
    }

    @Override
    public PlayerChunkClaim claim(ResourceLocation dimension, UUID id, int subConfigIndex, int x, int z, boolean forceload) {
        PlayerChunkClaim newClaim = super.claim(dimension, id, subConfigIndex, x, z, forceload);
        this.claimsManagerTracker.onChunkChange(dimension, x, z, newClaim);
        return newClaim;
    }

    @Override
    public void unclaim(ResourceLocation dimension, int x, int z) {
        super.unclaim(dimension, x, z);
        this.claimsManagerTracker.onChunkChange(dimension, x, z, null);
    }

    public void unclaimRegion(ResourceLocation dimension, int x, int z) {
        ClientDimensionClaimsManager dimensionClaims = (ClientDimensionClaimsManager)this.ensureDimension(dimension);
        dimensionClaims.unclaimRegion(x, z, (ClientPlayerClaimInfoManager)this.playerClaimInfoManager, this.configManager);
        this.claimsManagerTracker.onWholeRegionChange(dimension, x, z);
    }

    public void claimRegion(ResourceLocation dimension, int x, int z, RegionClaimsPaletteStorage regionStorage) {
        ClientDimensionClaimsManager dimensionClaims = (ClientDimensionClaimsManager)this.ensureDimension(dimension);
        dimensionClaims.claimRegion(x, z, regionStorage, (ClientPlayerClaimInfoManager)this.playerClaimInfoManager, this.configManager);
        this.claimsManagerTracker.onWholeRegionChange(dimension, x, z);
    }

    @Override
    protected ClientDimensionClaimsManager create(ResourceLocation dimension, Long2ObjectMap<ClientRegionClaims> claims) {
        return new ClientDimensionClaimsManager(dimension, claims, new LinkedChain<ClientRegionClaims>());
    }

    @Override
    public void reset() {
        super.reset();
        this.adminMode = false;
        this.serverMode = false;
        this.loadingClaimCount = 0;
        this.loadingForceloadCount = 0;
        this.claimLimit = 0;
        this.forceloadLimit = 0;
        this.maxClaimDistance = 0;
        this.alwaysUseLoadingValues = false;
    }

    @Override
    public void requestClaim(int x, int z, boolean byServer) {
        this.requestAreaClaim(x, z, x, z, byServer);
    }

    @Override
    public void requestUnclaim(int x, int z, boolean byServer) {
        this.requestAreaUnclaim(x, z, x, z, byServer);
    }

    @Override
    public void requestForceload(int x, int z, boolean enable, boolean byServer) {
        this.requestAreaForceload(x, z, x, z, enable, byServer);
    }

    @Override
    public void requestAreaClaim(int left, int top, int right, int bottom, boolean byServer) {
        OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToServer(new ServerboundClaimActionRequestPacket(new ClaimActionRequest(ClaimsManager.Action.CLAIM, left, top, right, bottom, byServer)));
    }

    @Override
    public void requestAreaUnclaim(int left, int top, int right, int bottom, boolean byServer) {
        OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToServer(new ServerboundClaimActionRequestPacket(new ClaimActionRequest(ClaimsManager.Action.UNCLAIM, left, top, right, bottom, byServer)));
    }

    @Override
    public void requestAreaForceload(int left, int top, int right, int bottom, boolean enable, boolean byServer) {
        OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToServer(new ServerboundClaimActionRequestPacket(new ClaimActionRequest(enable ? ClaimsManager.Action.FORCELOAD : ClaimsManager.Action.UNFORCELOAD, left, top, right, bottom, byServer)));
    }

    @Override
    protected void onClaimStateAdded(ClaimStateHolder stateHolder) {
    }

    public void removeSubClaim(UUID playerId, int subConfigIndex) {
        ((ClientPlayerClaimInfo)this.getPlayerInfo(playerId)).removeSubClaim(subConfigIndex);
    }

    @Override
    public PlayerChunkClaim getPotentialClaimStateReflection() {
        if (this.isServerMode()) {
            return new PlayerChunkClaim(PlayerConfig.SERVER_CLAIM_UUID, this.currentServerSubConfigIndex, false, 0);
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return null;
        }
        return new PlayerChunkClaim(Minecraft.m_91087_().f_91074_.m_142081_(), this.currentSubConfigIndex, false, 0);
    }

    @Override
    public int getCurrentSubConfigIndex() {
        return this.currentSubConfigIndex;
    }

    @Override
    public int getCurrentServerSubConfigIndex() {
        return this.currentServerSubConfigIndex;
    }

    @Override
    public String getCurrentSubConfigId() {
        return this.currentSubConfigId;
    }

    @Override
    public String getCurrentServerSubConfigId() {
        return this.currentServerSubConfigId;
    }

    @Override
    @Nonnull
    public ClaimsManagerClaimResultTracker getClaimResultTracker() {
        return this.claimResultTracker;
    }

    public static final class Builder
    extends ClaimsManager.Builder<ClientPlayerClaimInfo, ClientPlayerClaimInfoManager, ClientRegionClaims, ClientDimensionClaimsManager, ClaimStateHolder, Builder> {
        public static Builder begin() {
            return (Builder)new Builder().setDefault();
        }

        public ClientClaimsManager build() {
            this.setPlayerClaimInfoManager(new ClientPlayerClaimInfoManager((Map<UUID, ClientPlayerClaimInfo>)new HashMap<UUID, ClientPlayerClaimInfo>(), new LinkedChain<ClientPlayerClaimInfo>()));
            return (ClientClaimsManager)super.build();
        }

        protected ClientClaimsManager buildInternally(Map<PlayerChunkClaim, ClaimStateHolder> claimStates, ClaimsManagerTracker claimsManagerTracker, Int2ObjectMap<PlayerChunkClaim> indexToClaimState) {
            return new ClientClaimsManager((ClientPlayerClaimInfoManager)this.playerClaimInfoManager, null, this.dimensions, indexToClaimState, claimStates, claimsManagerTracker, ClaimsManagerClaimResultTracker.Builder.begin().build());
        }
    }
}

