/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.claims.api.IClientClaimsManagerAPI;
import xaero.pac.client.claims.player.IClientPlayerClaimInfo;
import xaero.pac.client.controls.keybinding.IKeyBindingHelper;
import xaero.pac.client.gui.ConfigMenu;
import xaero.pac.client.gui.XPACScreen;
import xaero.pac.client.gui.component.CachedComponentSupplier;
import xaero.pac.client.parties.party.IClientParty;
import xaero.pac.client.parties.party.IClientPartyAllyInfo;
import xaero.pac.client.parties.party.IClientPartyMemberDynamicInfoSyncableStorage;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.client.world.capability.ClientWorldMainCapability;
import xaero.pac.client.world.capability.api.ClientWorldCapabilityTypes;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.packet.LazyPacketsConfirmationPacket;
import xaero.pac.common.parties.party.IPartyMemberDynamicInfoSyncable;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.player.config.PlayerConfig;

public class MainMenu
extends XPACScreen {
    public static final TranslatableComponent NO_HANDSHAKE = new TranslatableComponent("gui.xaero_pac_ui_handshake_not_received");
    public static final TranslatableComponent NO_PARTIES = new TranslatableComponent("gui.xaero_pac_ui_parties_disabled");
    public static final TranslatableComponent NO_CLAIMS = new TranslatableComponent("gui.xaero_pac_ui_claims_disabled");
    public static final TranslatableComponent PARTY_SYNCING = new TranslatableComponent("gui.xaero_pac_ui_party_syncing");
    public static final TranslatableComponent CLAIMS_SYNCING = new TranslatableComponent("gui.xaero_pac_ui_claims_syncing");
    private static final Component ABOUT_PARTY_COMMAND = new TextComponent("/openpac-parties about");
    public static final TranslatableComponent CLAIM = new TranslatableComponent("gui.xaero_pac_ui_claim");
    public static final TranslatableComponent UNCLAIM = new TranslatableComponent("gui.xaero_pac_ui_unclaim");
    private static final Component CLAIM_COMMAND = new TextComponent("/openpac-claims claim");
    private static final Component UNCLAIM_COMMAND = new TextComponent("/openpac-claims unclaim");
    public static final TranslatableComponent FORCELOAD = new TranslatableComponent("gui.xaero_pac_ui_forceload");
    public static final TranslatableComponent UNFORCELOAD = new TranslatableComponent("gui.xaero_pac_ui_unforceload");
    private static final Component FORCELOAD_COMMAND = new TextComponent("/openpac-claims forceload");
    private static final Component UNFORCELOAD_COMMAND = new TextComponent("/openpac-claims unforceload");
    private static final CachedComponentSupplier partyNameSupplier = new CachedComponentSupplier(args -> {
        String currentPartyName = (String)args[0];
        return new TranslatableComponent("gui.xaero_pac_ui_party_name", new Object[]{new TextComponent(currentPartyName).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier ownerNameSupplier = new CachedComponentSupplier(args -> {
        String currentOwnerName = (String)args[0];
        return new TranslatableComponent("gui.xaero_pac_ui_party_owner", new Object[]{new TextComponent(currentOwnerName).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier memberCountSupplier = new CachedComponentSupplier(args -> {
        int currentMemberCount = (Integer)args[0];
        int currentMemberLimit = (Integer)args[1];
        return new TranslatableComponent("gui.xaero_pac_ui_party_member_count", new Object[]{new TextComponent(currentMemberCount + " / " + currentMemberLimit).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier allyCountSupplier = new CachedComponentSupplier(args -> {
        int currentAllyCount = (Integer)args[0];
        int currentAllyLimit = (Integer)args[1];
        return new TranslatableComponent("gui.xaero_pac_ui_party_ally_count", new Object[]{new TextComponent(currentAllyCount + " / " + currentAllyLimit).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier inviteCountSupplier = new CachedComponentSupplier(args -> {
        int currentInviteCount = (Integer)args[0];
        int currentInviteLimit = (Integer)args[1];
        return new TranslatableComponent("gui.xaero_pac_ui_party_invite_count", new Object[]{new TextComponent(currentInviteCount + " / " + currentInviteLimit).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier claimsNameSupplier = new CachedComponentSupplier(args -> {
        String currentClaimsName = (String)args[0];
        MutableComponent nameComponent = new TextComponent(currentClaimsName).m_130938_(s -> s.m_178520_(-5592406));
        return new TranslatableComponent("gui.xaero_pac_ui_claims_name", new Object[]{nameComponent});
    });
    private static final CachedComponentSupplier claimCountSupplier = new CachedComponentSupplier(args -> {
        int currentClaimCount = (Integer)args[0];
        int currentClaimLimit = (Integer)args[1];
        MutableComponent numbers = new TextComponent(currentClaimCount + " / " + currentClaimLimit).m_130938_(s -> s.m_178520_(-5592406));
        return new TranslatableComponent("gui.xaero_pac_ui_claim_count", new Object[]{numbers});
    });
    private static final CachedComponentSupplier forceloadCountSupplier = new CachedComponentSupplier(args -> {
        int currentForceloadCount = (Integer)args[0];
        int currentForceloadLimit = (Integer)args[1];
        return new TranslatableComponent("gui.xaero_pac_ui_forceload_count", new Object[]{new TextComponent(currentForceloadCount + " / " + currentForceloadLimit).m_130938_(s -> s.m_178520_(-5592406))});
    });
    private static final CachedComponentSupplier claimsColorSupplier = new CachedComponentSupplier(args -> {
        int currentClaimColor = (Integer)args[0];
        MutableComponent colorComponent = new TextComponent(Integer.toUnsignedString(currentClaimColor, 16).toUpperCase()).m_130938_(s -> s.m_178520_(currentClaimColor));
        return new TranslatableComponent("gui.xaero_pac_ui_claims_color", new Object[]{colorComponent});
    });
    private boolean serverHasMod;
    private boolean serverHasClaimsEnabled;
    private boolean serverHasPartiesEnabled;
    private Button configsButton;
    private Button aboutPartyButton;
    private Button claimButton;
    private Button forceloadButton;
    public static boolean TEST_TOGGLE;

    public MainMenu(Screen escape, Screen parent) {
        super(escape, parent, (Component)new TranslatableComponent("gui.xaero_pac_ui_main_menu"));
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.configsButton = new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 8, 200, 20, (Component)new TranslatableComponent("gui.xaero_pac_ui_config_menu"), this::onConfigsButton);
        this.m_142416_((GuiEventListener)this.configsButton);
        this.aboutPartyButton = new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 40, 70, 20, (Component)new TranslatableComponent("gui.xaero_pac_ui_about_party"), this::onAboutPartyButton, new Button.OnTooltip(){

            public void m_93752_(Button p_170019_, PoseStack p_170020_, int p_170021_, int p_170022_) {
                MainMenu.this.m_96602_(p_170020_, ABOUT_PARTY_COMMAND, p_170021_, p_170022_);
            }

            public void m_142753_(Consumer<Component> p_170017_) {
                p_170017_.accept(ABOUT_PARTY_COMMAND);
            }
        });
        this.claimButton = new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 112, 70, 20, (Component)CLAIM, this::onClaimButton, new Button.OnTooltip(){

            public void m_93752_(Button p_170019_, PoseStack p_170020_, int p_170021_, int p_170022_) {
                MainMenu.this.m_96602_(p_170020_, p_170019_.m_6035_() == CLAIM ? CLAIM_COMMAND : UNCLAIM_COMMAND, p_170021_, p_170022_);
            }

            public void m_142753_(Consumer<Component> p_170017_) {
                p_170017_.accept(MainMenu.this.claimButton.m_6035_() == CLAIM ? CLAIM_COMMAND : UNCLAIM_COMMAND);
            }
        });
        this.forceloadButton = new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 7 + 136, 70, 20, (Component)FORCELOAD, this::onForceloadButton, new Button.OnTooltip(){

            public void m_93752_(Button p_170019_, PoseStack p_170020_, int p_170021_, int p_170022_) {
                MainMenu.this.m_96602_(p_170020_, p_170019_.m_6035_() == FORCELOAD ? FORCELOAD_COMMAND : UNFORCELOAD_COMMAND, p_170021_, p_170022_);
            }

            public void m_142753_(Consumer<Component> p_170017_) {
                p_170017_.accept(MainMenu.this.claimButton.m_6035_() == FORCELOAD ? FORCELOAD_COMMAND : UNFORCELOAD_COMMAND);
            }
        });
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 168, 200, 20, (Component)new TranslatableComponent("gui.xaero_pac_back"), this::onBackButton));
        this.updateButtons();
        if (this.serverHasPartiesEnabled) {
            this.m_142416_((GuiEventListener)this.aboutPartyButton);
        }
        if (this.serverHasClaimsEnabled) {
            this.m_142416_((GuiEventListener)this.claimButton);
            this.m_142416_((GuiEventListener)this.forceloadButton);
        }
        this.f_96541_.f_91068_.m_90926_(true);
    }

    private void onTestToggle(Button button) {
        boolean bl = TEST_TOGGLE = !TEST_TOGGLE;
        if (!TEST_TOGGLE) {
            OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToServer(new LazyPacketsConfirmationPacket());
        }
        OpenPartiesAndClaims.LOGGER.info("test toggle set to " + TEST_TOGGLE);
    }

    private void updateButtons() {
        ClientWorldMainCapability mainCap = (ClientWorldMainCapability)OpenPartiesAndClaims.INSTANCE.getCapabilityHelper().getCapability(this.f_96541_.f_91073_, ClientWorldCapabilityTypes.MAIN_CAP);
        this.serverHasMod = this.configsButton.f_93623_ = mainCap.getClientWorldData().serverHasMod();
        this.serverHasClaimsEnabled = mainCap.getClientWorldData().serverHasClaimsEnabled();
        this.serverHasPartiesEnabled = mainCap.getClientWorldData().serverHasPartiesEnabled();
        this.aboutPartyButton.f_93623_ = this.serverHasMod && OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty() != null;
        this.forceloadButton.f_93623_ = false;
        this.claimButton.f_93623_ = false;
        if (this.serverHasMod && !OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isLoading()) {
            IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.f_96541_.f_91073_.m_46472_().m_135782_(), this.f_96541_.f_91074_.m_146902_().f_45578_, this.f_96541_.f_91074_.m_146902_().f_45579_);
            boolean adminMode = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isAdminMode();
            boolean serverMode = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isServerMode();
            UUID claimTargetUUID = serverMode ? PlayerConfig.SERVER_CLAIM_UUID : this.f_96541_.f_91074_.m_142081_();
            this.claimButton.f_93623_ = adminMode || currentClaim == null || currentClaim.getPlayerId().equals(claimTargetUUID);
            this.claimButton.m_93666_((Component)(this.wouldClaim(currentClaim) ? CLAIM : UNCLAIM));
            this.forceloadButton.f_93623_ = adminMode || currentClaim != null && currentClaim.getPlayerId().equals(claimTargetUUID);
            this.forceloadButton.m_93666_((Component)(currentClaim == null || !currentClaim.isForceloadable() ? FORCELOAD : UNFORCELOAD));
        }
    }

    private void onConfigsButton(Button b) {
        this.f_96541_.m_91152_((Screen)new ConfigMenu(this.escape, this));
    }

    private void onAboutPartyButton(Button b) {
        this.m_96615_(ABOUT_PARTY_COMMAND.getString());
        this.f_96541_.m_91152_(null);
    }

    private boolean wouldClaim(IPlayerChunkClaim currentClaim) {
        if (currentClaim == null) {
            return true;
        }
        IPlayerChunkClaim potentialClaimReflection = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().getPotentialClaimStateReflection();
        return !currentClaim.isSameClaimType(potentialClaimReflection);
    }

    private void onClaimButton(Button b) {
        IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.f_96541_.f_91073_.m_46472_().m_135782_(), this.f_96541_.f_91074_.m_146902_().f_45578_, this.f_96541_.f_91074_.m_146902_().f_45579_);
        if (this.wouldClaim(currentClaim)) {
            this.m_96615_(CLAIM_COMMAND.getString());
        } else {
            this.m_96615_(UNCLAIM_COMMAND.getString());
        }
        this.m_7379_();
    }

    private void onForceloadButton(Button b) {
        IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.f_96541_.f_91073_.m_46472_().m_135782_(), this.f_96541_.f_91074_.m_146902_().f_45578_, this.f_96541_.f_91074_.m_146902_().f_45579_);
        if (currentClaim == null) {
            return;
        }
        if (!currentClaim.isForceloadable()) {
            this.m_96615_(FORCELOAD_COMMAND.getString());
        } else {
            this.m_96615_(UNFORCELOAD_COMMAND.getString());
        }
        this.m_7379_();
    }

    private void onBackButton(Button b) {
        this.goBack();
    }

    private void drawPartyInfo(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        IClientPartyStorage<IClientPartyAllyInfo, IClientParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>, IClientPartyMemberDynamicInfoSyncableStorage<IPartyMemberDynamicInfoSyncable>> partyStorage = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage();
        String actualPartyName = partyStorage.getPartyName();
        if (actualPartyName == null || actualPartyName.isEmpty()) {
            actualPartyName = "N/A";
        }
        MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)partyNameSupplier.get(actualPartyName), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 42), (int)-1);
        if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty() != null) {
            String actualOwnerName = partyStorage.getParty().getOwner().getUsername();
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)ownerNameSupplier.get(actualOwnerName), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 54), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)memberCountSupplier.get(partyStorage.getUIMemberCount(), partyStorage.getMemberLimit()), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 66), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)allyCountSupplier.get(partyStorage.getUIAllyCount(), partyStorage.getAllyLimit()), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 78), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)inviteCountSupplier.get(partyStorage.getUIInviteCount(), partyStorage.getInviteLimit()), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 90), (int)-1);
        }
    }

    private void drawClaimsInfo(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        IClientClaimsManagerAPI claimsManager = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager();
        if (claimsManager.hasPlayerInfo(this.f_96541_.f_91074_.m_142081_())) {
            IClientPlayerClaimInfo playerInfo = (IClientPlayerClaimInfo)claimsManager.getPlayerInfo(this.f_96541_.f_91074_.m_142081_());
            boolean shouldUseLoadingValues = claimsManager.isLoading() || claimsManager.getAlwaysUseLoadingValues();
            int claimCount = shouldUseLoadingValues ? claimsManager.getLoadingClaimCount() : playerInfo.getClaimCount();
            int claimLimit = claimsManager.getClaimLimit();
            int forceloadCount = shouldUseLoadingValues ? claimsManager.getLoadingForceloadCount() : playerInfo.getForceloadCount();
            int forceloadLimit = claimsManager.getForceloadLimit();
            int currentSubConfigIndex = claimsManager.getCurrentSubConfigIndex();
            Object claimsName = playerInfo.getClaimsName(currentSubConfigIndex);
            if (claimsName == null && currentSubConfigIndex != -1) {
                claimsName = playerInfo.getClaimsName();
            }
            if (claimsName == null || ((String)claimsName).isEmpty()) {
                claimsName = "N/A";
            }
            claimsName = (String)claimsName + " (" + claimsManager.getCurrentSubConfigId() + ")";
            Integer claimsColor = playerInfo.getClaimsColor(currentSubConfigIndex);
            if (claimsColor == null && currentSubConfigIndex != -1) {
                claimsColor = playerInfo.getClaimsColor();
            }
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)claimCountSupplier.get(claimCount, claimLimit), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 114), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)forceloadCountSupplier.get(forceloadCount, forceloadLimit), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 126), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)claimsNameSupplier.get(claimsName), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 138), (int)-1);
            MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)claimsColorSupplier.get(claimsColor), (int)(this.f_96543_ / 2 - 24), (int)(this.f_96544_ / 7 + 150), (int)-1);
        }
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        this.updateButtons();
        this.m_7333_(poseStack);
        MainMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)16, (int)-1);
        super.m_6305_(poseStack, mouseX, mouseY, partial);
        if (!this.serverHasMod) {
            MainMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_HANDSHAKE, (int)(this.f_96543_ / 2), (int)27, (int)-43691);
        } else {
            if (this.serverHasPartiesEnabled) {
                if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().isLoading()) {
                    MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)PARTY_SYNCING, (int)(this.f_96543_ / 2 - 104 - this.f_96547_.m_92852_((FormattedText)PARTY_SYNCING)), (int)(this.f_96544_ / 7 + 42), (int)-1);
                }
                this.drawPartyInfo(poseStack, mouseX, mouseY, partial);
            } else {
                MainMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_PARTIES, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 42), (int)-5592406);
            }
            if (this.serverHasClaimsEnabled) {
                if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isLoading()) {
                    MainMenu.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)CLAIMS_SYNCING, (int)(this.f_96543_ / 2 - 104 - this.f_96547_.m_92852_((FormattedText)CLAIMS_SYNCING)), (int)(this.f_96544_ / 7 + 114), (int)-1);
                }
                this.drawClaimsInfo(poseStack, mouseX, mouseY, partial);
            } else {
                MainMenu.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)NO_CLAIMS, (int)(this.f_96543_ / 2), (int)(this.f_96544_ / 7 + 114), (int)-5592406);
            }
        }
    }

    public boolean m_7933_(int p_96552_, int p_96553_, int p_96554_) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        if (this.m_7222_() == null && keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).m_84868_() == InputConstants.Type.KEYSYM && p_96552_ == keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_96552_, p_96553_, p_96554_);
    }

    @Override
    public boolean m_6375_(double p_94695_, double p_94696_, int p_94697_) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        if (this.m_7222_() == null && keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).m_84868_() == InputConstants.Type.MOUSE && p_94697_ == keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).m_84873_()) {
            this.m_7379_();
            return true;
        }
        return super.m_6375_(p_94695_, p_94696_, p_94697_);
    }

    public void m_7522_(GuiEventListener l) {
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof EditBox) {
            ((EditBox)currentFocused).m_94178_(false);
        }
        super.m_7522_(l);
    }
}

