/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.player.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.pac.client.gui.OtherPlayerConfigWaitScreen;
import xaero.pac.client.gui.PlayerConfigScreen;
import xaero.pac.client.player.config.IPlayerConfigClientStorageManager;
import xaero.pac.client.player.config.PlayerConfigClientStorage;
import xaero.pac.common.misc.MapFactory;
import xaero.pac.common.player.config.dynamic.PlayerConfigDynamicOptions;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;

public class PlayerConfigClientStorageManager
implements IPlayerConfigClientStorageManager<PlayerConfigClientStorage> {
    private PlayerConfigClientStorage serverClaimsConfig;
    private PlayerConfigClientStorage expiredClaimsConfig;
    private PlayerConfigClientStorage wildernessConfig;
    private PlayerConfigClientStorage defaultPlayerConfig;
    private PlayerConfigClientStorage myPlayerConfig;
    private PlayerConfigClientStorage otherPlayerConfig;
    private PlayerConfigDynamicOptions dynamicOptions;
    private final Set<IPlayerConfigOptionSpecAPI<?>> overridableOptions;

    private PlayerConfigClientStorageManager(Set<IPlayerConfigOptionSpecAPI<?>> overridableOptions) {
        this.overridableOptions = overridableOptions;
    }

    private void set(PlayerConfigClientStorage serverClaimsConfig, PlayerConfigClientStorage expiredClaimsConfig, PlayerConfigClientStorage wildernessConfig, PlayerConfigClientStorage defaultPlayerConfig, PlayerConfigClientStorage myPlayerConfig) {
        this.serverClaimsConfig = serverClaimsConfig;
        this.expiredClaimsConfig = expiredClaimsConfig;
        this.wildernessConfig = wildernessConfig;
        this.defaultPlayerConfig = defaultPlayerConfig;
        this.myPlayerConfig = myPlayerConfig;
    }

    @Override
    @Nonnull
    public PlayerConfigClientStorage getServerClaimsConfig() {
        return this.serverClaimsConfig;
    }

    @Override
    @Nonnull
    public PlayerConfigClientStorage getExpiredClaimsConfig() {
        return this.expiredClaimsConfig;
    }

    @Override
    @Nonnull
    public PlayerConfigClientStorage getWildernessConfig() {
        return this.wildernessConfig;
    }

    @Override
    @Nonnull
    public PlayerConfigClientStorage getDefaultPlayerConfig() {
        return this.defaultPlayerConfig;
    }

    @Override
    @Nonnull
    public PlayerConfigClientStorage getMyPlayerConfig() {
        return this.myPlayerConfig;
    }

    public void reset() {
        this.serverClaimsConfig.reset();
        this.expiredClaimsConfig.reset();
        this.wildernessConfig.reset();
        this.defaultPlayerConfig.reset();
        this.myPlayerConfig.reset();
        this.otherPlayerConfig = null;
        this.dynamicOptions = null;
        this.overridableOptions.clear();
        this.overridableOptions.addAll(PlayerSubConfig.STATIC_OVERRIDABLE_OPTIONS);
    }

    @Override
    public void setOtherPlayerConfig(PlayerConfigClientStorage otherPlayerConfig) {
        this.otherPlayerConfig = otherPlayerConfig;
    }

    @Override
    public PlayerConfigClientStorage getOtherPlayerConfig() {
        return this.otherPlayerConfig;
    }

    @Override
    public void setDynamicOptions(PlayerConfigDynamicOptions dynamicOptions) {
        this.dynamicOptions = dynamicOptions;
        this.overridableOptions.clear();
        this.overridableOptions.addAll(PlayerSubConfig.STATIC_OVERRIDABLE_OPTIONS);
        this.overridableOptions.addAll(dynamicOptions.getOptions().values());
    }

    @Nullable
    public PlayerConfigDynamicOptions getDynamicOptions() {
        return this.dynamicOptions;
    }

    public PlayerConfigClientStorage.FinalBuilder beginConfigStorageBuild(MapFactory mapFactory) {
        return (PlayerConfigClientStorage.FinalBuilder)PlayerConfigClientStorage.FinalBuilder.begin(mapFactory).setManager(this);
    }

    @Override
    public void openServerClaimsConfigScreen(@Nullable Screen escape, @Nullable Screen parent) {
        PlayerConfigClientStorage config = this.getServerClaimsConfig();
        Minecraft.m_91087_().m_91152_((Screen)PlayerConfigScreen.Builder.begin(ArrayList::new).setParent(parent).setEscape(escape).setMainPlayerConfigData(this.getMyPlayerConfig()).setData(config).setManager(this).build());
    }

    @Override
    public void openExpiredClaimsConfigScreen(@Nullable Screen escape, @Nullable Screen parent) {
        PlayerConfigClientStorage config = this.getExpiredClaimsConfig();
        Minecraft.m_91087_().m_91152_((Screen)PlayerConfigScreen.Builder.begin(ArrayList::new).setParent(parent).setEscape(escape).setTitle((Component)new TranslatableComponent("gui.xaero_pac_ui_expired_claims_config")).setData(config).setManager(this).build());
    }

    @Override
    public void openWildernessConfigScreen(@Nullable Screen escape, @Nullable Screen parent) {
        PlayerConfigClientStorage config = this.getWildernessConfig();
        Minecraft.m_91087_().m_91152_((Screen)PlayerConfigScreen.Builder.begin(ArrayList::new).setParent(parent).setEscape(escape).setTitle((Component)new TranslatableComponent("gui.xaero_pac_ui_wilderness_config")).setData(config).setManager(this).build());
    }

    @Override
    public void openDefaultPlayerConfigScreen(@Nullable Screen escape, @Nullable Screen parent) {
        PlayerConfigClientStorage config = this.getDefaultPlayerConfig();
        Minecraft.m_91087_().m_91152_((Screen)PlayerConfigScreen.Builder.begin(ArrayList::new).setParent(parent).setEscape(escape).setTitle((Component)new TranslatableComponent("gui.xaero_pac_ui_default_player_config")).setData(config).setManager(this).build());
    }

    @Override
    public void openMyPlayerConfigScreen(@Nullable Screen escape, @Nullable Screen parent) {
        PlayerConfigClientStorage config = this.getMyPlayerConfig();
        Minecraft.m_91087_().m_91152_((Screen)PlayerConfigScreen.Builder.begin(ArrayList::new).setParent(parent).setEscape(escape).setData(config).setManager(this).setDefaultPlayerConfigData(this.getDefaultPlayerConfig()).build());
    }

    @Override
    public void openOtherPlayerConfigScreen(@Nullable Screen escape, @Nullable Screen parent, @Nonnull String playerName) {
        if (!playerName.isEmpty()) {
            Minecraft.m_91087_().m_91152_((Screen)new OtherPlayerConfigWaitScreen(escape, parent, playerName));
        }
    }

    @Override
    @Nonnull
    public Stream<IPlayerConfigOptionSpecAPI<?>> getAllOptionsStream() {
        return Stream.concat(PlayerConfigOptions.OPTIONS.values().stream(), this.dynamicOptions == null ? Stream.empty() : this.dynamicOptions.getOptions().values().stream());
    }

    public int getOptionCount() {
        return PlayerConfigOptions.OPTIONS.size() + (this.dynamicOptions == null ? 0 : this.dynamicOptions.getOptions().size());
    }

    @Override
    @Nullable
    public IPlayerConfigOptionSpecAPI<?> getOptionForId(@Nonnull String id) {
        IPlayerConfigOptionSpecAPI<?> result = PlayerConfigOptions.OPTIONS.get(id);
        if (result == null && this.dynamicOptions != null) {
            result = this.dynamicOptions.getOptions().get(id);
        }
        return result;
    }

    @Override
    public Set<IPlayerConfigOptionSpecAPI<?>> getOverridableOptions() {
        return this.overridableOptions;
    }

    public static final class Builder {
        private Builder() {
        }

        public Builder setDefault() {
            return this;
        }

        public PlayerConfigClientStorageManager build() {
            PlayerConfigClientStorageManager manager = new PlayerConfigClientStorageManager(new HashSet(PlayerSubConfig.STATIC_OVERRIDABLE_OPTIONS));
            PlayerConfigClientStorage serverClaimsConfig = ((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)PlayerConfigClientStorage.FinalBuilder.begin(LinkedHashMap::new).setType(PlayerConfigType.SERVER)).setOwner(PlayerConfig.SERVER_CLAIM_UUID)).setManager(manager)).build();
            PlayerConfigClientStorage expiredClaimsConfig = ((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)PlayerConfigClientStorage.FinalBuilder.begin(LinkedHashMap::new).setType(PlayerConfigType.EXPIRED)).setOwner(PlayerConfig.EXPIRED_CLAIM_UUID)).setManager(manager)).build();
            PlayerConfigClientStorage wildernessConfig = ((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)PlayerConfigClientStorage.FinalBuilder.begin(LinkedHashMap::new).setType(PlayerConfigType.WILDERNESS)).setOwner(null)).setManager(manager)).build();
            PlayerConfigClientStorage defaultPlayerConfig = ((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)PlayerConfigClientStorage.FinalBuilder.begin(LinkedHashMap::new).setType(PlayerConfigType.DEFAULT_PLAYER)).setOwner(null)).setManager(manager)).build();
            PlayerConfigClientStorage myPlayerConfig = ((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)((PlayerConfigClientStorage.FinalBuilder)PlayerConfigClientStorage.FinalBuilder.begin(LinkedHashMap::new).setType(PlayerConfigType.PLAYER)).setOwner(null)).setManager(manager)).build();
            manager.set(serverClaimsConfig, expiredClaimsConfig, wildernessConfig, defaultPlayerConfig, myPlayerConfig);
            return manager;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

