/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.api.IServerClaimsManagerAPI;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ClaimsAboutCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        Command action = context -> {
            String subId;
            Object targetProfile;
            ServerPlayer casterPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            try {
                Collection profiles = GameProfileArgument.m_94590_((CommandContext)context, (String)"profile");
                targetProfile = profiles.size() == 1 ? (GameProfile)profiles.iterator().next() : null;
            }
            catch (IllegalArgumentException iae) {
                targetProfile = casterPlayer.m_36316_();
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(casterPlayer.m_20194_());
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            if (targetProfile == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_claims_about_invalid_player", new Object[0]));
                return 0;
            }
            GameProfile profile = targetProfile;
            IPlayerConfigManager configManager = serverData.getPlayerConfigs();
            IServerClaimsManagerAPI claimsManager = serverData.getServerClaimsManager();
            IPlayerConfig playerConfig = configManager.getLoadedConfig(profile.getId());
            IPlayerConfig usedSubConfig = playerConfig.getUsedSubConfig();
            IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)claimsManager.getPlayerInfo(profile.getId());
            int claimLimit = claimsManager.getPlayerBaseClaimLimit(profile.getId()) + playerConfig.getEffective(PlayerConfigOptions.BONUS_CHUNK_CLAIMS);
            int forceloadLimit = claimsManager.getPlayerBaseForceloadLimit(profile.getId()) + playerConfig.getEffective(PlayerConfigOptions.BONUS_CHUNK_FORCELOADS);
            MutableComponent claimCountNumbers = new TextComponent(playerInfo.getClaimCount() + " / " + claimLimit).m_130938_(s -> s.m_178520_(-5592406));
            Object claimName = usedSubConfig.getEffective(PlayerConfigOptions.CLAIMS_NAME);
            if (((String)claimName).isEmpty()) {
                claimName = "N/A";
            }
            if ((subId = usedSubConfig.getSubId()) == null) {
                subId = "main";
            }
            claimName = (String)claimName + " (" + subId + ")";
            MutableComponent claimNameComponent = new TextComponent((String)claimName).m_130938_(s -> s.m_178520_(-5592406));
            MutableComponent forceloadCountNumbers = new TextComponent(playerInfo.getForceloadCount() + " / " + forceloadLimit).m_130938_(s -> s.m_178520_(-5592406));
            casterPlayer.m_6352_((Component)new TextComponent(""), casterPlayer.m_142081_());
            casterPlayer.m_6352_((Component)new TextComponent("===== Open Parties and Claims").m_130938_(s -> s.m_131140_(ChatFormatting.GRAY)), casterPlayer.m_142081_());
            casterPlayer.m_6352_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_pac_ui_claim_count", claimCountNumbers), casterPlayer.m_142081_());
            casterPlayer.m_6352_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_pac_ui_forceload_count", forceloadCountNumbers), casterPlayer.m_142081_());
            casterPlayer.m_6352_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_pac_ui_claims_name", claimNameComponent), casterPlayer.m_142081_());
            int claimColor = usedSubConfig.getEffective(PlayerConfigOptions.CLAIMS_COLOR);
            MutableComponent colorComponent = new TextComponent(Integer.toUnsignedString(claimColor, 16).toUpperCase()).m_130938_(s -> s.m_178520_(claimColor));
            casterPlayer.m_6352_((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_pac_ui_claims_color", colorComponent), casterPlayer.m_142081_());
            casterPlayer.m_6352_((Component)new TextComponent("=====").m_130938_(s -> s.m_131140_(ChatFormatting.GRAY)), casterPlayer.m_142081_());
            return 1;
        };
        SuggestionProvider suggestions = (context, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_();
            return SharedSuggestionProvider.m_82981_(playerlist.m_11314_().stream().map(targetPlayer -> targetPlayer.m_36316_().getName()), (SuggestionsBuilder)builder);
        };
        LiteralArgumentBuilder normalCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-claims").requires(context -> (Boolean)ServerConfig.CONFIG.claimsEnabled.get())).then(Commands.m_82127_((String)"about").executes(action));
        dispatcher.register(normalCommand);
        LiteralArgumentBuilder opTargetCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-claims").requires(c -> (Boolean)ServerConfig.CONFIG.claimsEnabled.get())).then(Commands.m_82127_((String)"about").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"profile", (ArgumentType)GameProfileArgument.m_94584_()).requires(c -> c.m_6761_(2))).suggests(suggestions).executes(action)));
        dispatcher.register(opTargetCommand);
    }
}

