/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyCommands;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class KickPartyCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<CommandSourceStack> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> mi.getRank().ordinal() >= PartyMemberRank.MODERATOR.ordinal());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"member").requires(requirement)).then(Commands.m_82127_((String)"kick").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).suggests(PartyCommands.getPartyMemberOrInviteSuggestor()).executes(context -> {
            boolean casterIsOwner;
            String targetUsername;
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_142081_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(playerId);
            IPartyMemberAPI targetPlayerInfo = playerParty.getMemberInfo(targetUsername = StringArgumentType.getString((CommandContext)context, (String)"name"));
            if (targetPlayerInfo == null) {
                targetPlayerInfo = playerParty.getInvite(targetUsername);
            }
            if (targetPlayerInfo == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_kick_not_member", targetUsername));
                return 0;
            }
            IPartyMemberAPI casterInfo = playerParty.getMemberInfo(playerId);
            boolean targetIsMember = targetPlayerInfo instanceof IPartyMember;
            boolean bl = casterIsOwner = playerParty.getOwner() == casterInfo;
            if (targetIsMember) {
                IPartyMember targetMember = (IPartyMember)targetPlayerInfo;
                if (targetMember == playerParty.getOwner()) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_kick_owner", new Object[0]));
                    return 0;
                }
                if (!casterIsOwner && targetMember.getRank().ordinal() > casterInfo.getRank().ordinal()) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_kick_higher_rank", new Object[0]));
                    return 0;
                }
            }
            playerParty.uninvitePlayer(targetPlayerInfo.getUUID());
            if (targetIsMember) {
                playerParty.removeMember(targetPlayerInfo.getUUID());
                UUID targetPlayerId = targetPlayerInfo.getUUID();
                ServerPlayer kickedPlayer = server.m_6846_().m_11259_(targetPlayerId);
                if (kickedPlayer != null) {
                    server.m_129892_().m_82095_(kickedPlayer);
                    MutableComponent acceptComponent = adaptiveLocalizer.getFor(kickedPlayer, "gui.xaero_parties_kick_target_message", playerParty.getDefaultName()).m_130938_(s -> s.m_131140_(ChatFormatting.RED));
                    kickedPlayer.m_6352_((Component)acceptComponent, playerId);
                }
            }
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (Component)new TranslatableComponent("gui.xaero_parties_kick_party_message", new Object[]{new TextComponent(casterInfo.getUsername()).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN)), new TextComponent(targetPlayerInfo.getUsername()).m_130938_(s -> s.m_131140_(ChatFormatting.RED))}));
            return 1;
        }))));
        dispatcher.register(command);
    }
}

