/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config.sync;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.packet.config.ClientboundPlayerConfigDynamicOptionsPacket;
import xaero.pac.common.packet.config.ClientboundPlayerConfigGeneralStatePacket;
import xaero.pac.common.packet.config.ClientboundPlayerConfigOptionValuePacket;
import xaero.pac.common.packet.config.ClientboundPlayerConfigRemoveSubPacket;
import xaero.pac.common.packet.config.ClientboundPlayerConfigSyncStatePacket;
import xaero.pac.common.packet.config.PlayerConfigOptionValuePacket;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.config.sync.IPlayerConfigSynchronizer;
import xaero.pac.common.server.player.data.ServerPlayerData;

public class PlayerConfigSynchronizer
implements IPlayerConfigSynchronizer {
    private final MinecraftServer server;
    private PlayerConfigManager<?, ?> configManager;

    public PlayerConfigSynchronizer(MinecraftServer server) {
        this.server = server;
    }

    public void setConfigManager(PlayerConfigManager<?, ?> configManager) {
        if (this.configManager != null) {
            throw new IllegalAccessError();
        }
        this.configManager = configManager;
    }

    private void sendToClient(ServerPlayer player, Object packet) {
        OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(player, packet);
    }

    private <T extends Comparable<T>> PlayerConfigOptionValuePacket.Entry getPacketOptionEntry(ServerPlayer player, PlayerConfig<?> syncedConfig, IPlayerConfigOptionSpecAPI<T> option, boolean afterReset) {
        boolean defaulted;
        boolean isOp = player.m_20310_(2);
        boolean mutable = isOp && syncedConfig.getType() != PlayerConfigType.PLAYER;
        boolean bl = defaulted = !mutable && syncedConfig.getType() == PlayerConfigType.PLAYER;
        if (defaulted) {
            mutable = PlayerConfig.isPlayerConfigurable(option);
            boolean bl2 = defaulted = !mutable;
            if (defaulted) {
                defaulted = !PlayerConfig.isOptionOPConfigurable(option);
                mutable = !defaulted && isOp;
            }
        }
        T value = syncedConfig.getRaw(option);
        if (mutable && syncedConfig instanceof PlayerSubConfig && !this.configManager.getOverridableOptions().contains(option)) {
            mutable = false;
            value = null;
        }
        if (afterReset && defaulted) {
            return null;
        }
        return new PlayerConfigOptionValuePacket.Entry(option.getId(), option.getType(), defaulted ? null : value, mutable, defaulted);
    }

    private void syncOptionsToClient(ServerPlayer player, PlayerConfig<?> config, List<PlayerConfigOptionValuePacket.Entry> entries) {
        UUID ownerId = Objects.equals(player.m_142081_(), config.getPlayerId()) ? null : config.getPlayerId();
        ClientboundPlayerConfigOptionValuePacket packet = new ClientboundPlayerConfigOptionValuePacket(config.getType(), config.getSubId(), ownerId, entries);
        this.sendToClient(player, packet);
    }

    @Override
    public <T extends Comparable<T>> void syncOptionToClient(ServerPlayer player, IPlayerConfig config, IPlayerConfigOptionSpecAPI<T> option) {
        PlayerConfigOptionValuePacket.Entry packetOptionEntry = this.getPacketOptionEntry(player, (PlayerConfig)config, option, false);
        if (packetOptionEntry != null) {
            this.syncOptionsToClient(player, (PlayerConfig)config, Lists.newArrayList((Object[])new PlayerConfigOptionValuePacket.Entry[]{packetOptionEntry}));
        }
    }

    public void syncToClient(ServerPlayer player, PlayerConfig<?> config, boolean afterReset) {
        ArrayList<PlayerConfigOptionValuePacket.Entry> entries = new ArrayList<PlayerConfigOptionValuePacket.Entry>(PlayerConfigOptions.OPTIONS.size());
        this.configManager.getAllOptionsStream().forEach(option -> {
            PlayerConfigOptionValuePacket.Entry packetOptionEntry = this.getPacketOptionEntry(player, config, (PlayerConfigOptionSpec)option, afterReset);
            if (packetOptionEntry != null) {
                entries.add(packetOptionEntry);
            }
        });
        this.syncOptionsToClient(player, config, entries);
        if (config.getType() == PlayerConfigType.PLAYER && !player.m_142081_().equals(config.getPlayerId())) {
            ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(player);
            playerData.setLastOtherConfigRequest(config.getPlayerId());
        }
        this.syncGeneralState(player, config);
    }

    @Override
    public void syncAllToClient(ServerPlayer player) {
        ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(player);
        playerData.getConfigSyncSpreadoutTask().addConfigToSync(this.configManager.getDefaultConfig());
        playerData.getConfigSyncSpreadoutTask().addConfigToSync(this.configManager.getLoadedConfig(player.m_142081_()));
        playerData.getConfigSyncSpreadoutTask().addConfigToSync(this.configManager.getWildernessConfig());
        playerData.getConfigSyncSpreadoutTask().addConfigToSync(this.configManager.getServerClaimConfig());
        playerData.getConfigSyncSpreadoutTask().addConfigToSync(this.configManager.getExpiredClaimConfig());
    }

    @Override
    public void syncOnLogin(ServerPlayer player) {
        ArrayList dynamicOptionEntries = new ArrayList(this.configManager.getDynamicOptions().getOptions().size());
        this.configManager.getDynamicOptions().getOptions().values().forEach(option -> dynamicOptionEntries.add((PlayerConfigOptionSpec)option));
        this.sendToClient(player, new ClientboundPlayerConfigDynamicOptionsPacket(dynamicOptionEntries));
        this.syncAllToClient(player);
    }

    public void sendSyncState(ServerPlayer player, PlayerConfig<?> config, boolean state) {
        ClientboundPlayerConfigSyncStatePacket packet = new ClientboundPlayerConfigSyncStatePacket(config.getType(), config.getType() == PlayerConfigType.PLAYER && !Objects.equals(player.m_142081_(), config.getPlayerId()), state);
        this.sendToClient(player, packet);
    }

    public void forAllRelevantClients(IPlayerConfig config, Consumer<ServerPlayer> action) {
        PlayerList serverPlayerList = this.server.m_6846_();
        if (config.getType() == PlayerConfigType.PLAYER) {
            ServerPlayer ownerPlayer = serverPlayerList.m_11259_(config.getPlayerId());
            if (ownerPlayer != null) {
                action.accept(ownerPlayer);
            }
        } else {
            List allPlayers = serverPlayerList.m_11314_();
            for (ServerPlayer player : allPlayers) {
                action.accept(player);
            }
        }
    }

    public <T extends Comparable<T>> void syncOptionToClients(PlayerConfig<?> config, PlayerConfigOptionSpec<T> option) {
        this.forAllRelevantClients(config, player -> this.syncOptionToClient((ServerPlayer)player, config, option));
    }

    private void syncGeneralState(ServerPlayer player, IPlayerConfig config, ClientboundPlayerConfigGeneralStatePacket packetOtherPlayer, ClientboundPlayerConfigGeneralStatePacket packetNotOtherPlayer) {
        ClientboundPlayerConfigGeneralStatePacket packet = config.getType() == PlayerConfigType.PLAYER && !Objects.equals(player.m_142081_(), config.getPlayerId()) ? packetOtherPlayer : packetNotOtherPlayer;
        this.sendToClient(player, packet);
    }

    @Override
    public void syncGeneralState(ServerPlayer player, IPlayerConfig config) {
        String subId = config.getSubId();
        if (subId == null) {
            subId = "main";
        }
        int subConfigLimit = config.getSubConfigLimit();
        ClientboundPlayerConfigGeneralStatePacket packetOtherPlayer = new ClientboundPlayerConfigGeneralStatePacket(config.getType(), true, subId, config.isBeingDeleted(), subConfigLimit);
        ClientboundPlayerConfigGeneralStatePacket packetNotOtherPlayer = new ClientboundPlayerConfigGeneralStatePacket(config.getType(), false, subId, config.isBeingDeleted(), subConfigLimit);
        if (player == null) {
            this.forAllRelevantClients(config, p -> this.syncGeneralState((ServerPlayer)p, config, packetOtherPlayer, packetNotOtherPlayer));
        } else {
            this.syncGeneralState(player, config, packetOtherPlayer, packetNotOtherPlayer);
        }
    }

    private void syncSubExistence(ServerPlayer player, PlayerSubConfig<?> config, boolean create, ClientboundPlayerConfigRemoveSubPacket removePacketOtherPlayer, ClientboundPlayerConfigRemoveSubPacket removePacketNotOtherPlayer) {
        if (create) {
            this.syncToClient(player, config, true);
            PlayerConfig<?> mainConfig = config.getMainConfig();
            this.confirmSubConfigCreationSync(player, mainConfig);
        } else {
            ClientboundPlayerConfigRemoveSubPacket packet = config.getType() == PlayerConfigType.PLAYER && !Objects.equals(player.m_142081_(), config.getPlayerId()) ? removePacketOtherPlayer : removePacketNotOtherPlayer;
            this.sendToClient(player, packet);
        }
    }

    @Override
    public void syncSubExistence(ServerPlayer player, IPlayerConfig subConfig, boolean create) {
        ClientboundPlayerConfigRemoveSubPacket packetNotOtherPlayer;
        ClientboundPlayerConfigRemoveSubPacket packetOtherPlayer;
        String subId = subConfig.getSubId();
        if (create) {
            packetOtherPlayer = null;
            packetNotOtherPlayer = null;
        } else {
            packetOtherPlayer = new ClientboundPlayerConfigRemoveSubPacket(subConfig.getType(), true, subId);
            packetNotOtherPlayer = new ClientboundPlayerConfigRemoveSubPacket(subConfig.getType(), false, subId);
        }
        if (player != null) {
            this.syncSubExistence(player, (PlayerSubConfig)subConfig, create, packetOtherPlayer, packetNotOtherPlayer);
        } else {
            this.forAllRelevantClients(subConfig, p -> this.syncSubExistence((ServerPlayer)p, (PlayerSubConfig)subConfig, create, packetOtherPlayer, packetNotOtherPlayer));
        }
        if (create) {
            this.configManager.getClaimsManager().getClaimsManagerSynchronizer().syncToPlayersSubClaimPropertiesUpdate(subConfig);
        } else {
            this.configManager.getClaimsManager().getClaimsManagerSynchronizer().syncToPlayersSubClaimPropertiesRemove(subConfig);
        }
    }

    @Override
    public void confirmSubConfigCreationSync(ServerPlayer player, IPlayerConfig mainConfig) {
        ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(player);
        if (!playerData.getConfigSyncSpreadoutTask().stillNeedsSyncing(mainConfig)) {
            this.sendSyncState(player, (PlayerConfig)mainConfig, false);
        }
    }
}

