/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.pac.client.gui.widget.dropdown.DropDownWidget;
import xaero.pac.client.gui.widget.dropdown.IDropDownContainer;

public class XPACScreen
extends Screen
implements IDropDownContainer {
    private static final Component XPAC_TITLE = Component.translatable((String)"gui.xaero_pac_ui_parties_and_claims");
    protected final Screen escape;
    protected final Screen parent;
    protected DropDownWidget openDropdown;

    protected XPACScreen(Screen escape, Screen parent, Component p_96550_) {
        super(p_96550_);
        this.escape = escape;
        this.parent = parent;
    }

    protected void init() {
        super.init();
        this.openDropdown = null;
    }

    public void onClose() {
        this.minecraft.setScreen(this.escape);
    }

    public void goBack() {
        this.minecraft.setScreen(this.parent);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.height)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                this.openDropdown.mouseClicked(mouseX, mouseY, button);
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double wheel) {
        if (this.openDropdown != null) {
            if (this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.height)) {
                return this.openDropdown.mouseScrolled(mouseX, mouseY, wheel);
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, wheel);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null && this.openDropdown.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void render(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        super.render(poseStack, mouseX, mouseY, partial);
        XPACScreen.drawCenteredString((PoseStack)poseStack, (Font)this.font, (Component)XPAC_TITLE, (int)(this.width / 2), (int)5, (int)-1);
        this.renderPreDropdown(poseStack, mouseX, mouseY, partial);
        if (this.openDropdown != null) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, 2.0);
            this.openDropdown.render(poseStack, mouseX, mouseY, this.height, false);
            poseStack.popPose();
        }
    }

    protected void renderPreDropdown(PoseStack poseStack, int mouseX, int mouseY, float partial) {
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }
}

