/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.data.api;

import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.data.IOpenPACServerPlayer;
import xaero.pac.common.server.player.data.ServerPlayerData;

public abstract class ServerPlayerDataAPI {
    public abstract boolean isClaimsAdminMode();

    public abstract boolean isClaimsNonallyMode();

    public abstract boolean isClaimsServerMode();

    @Nonnull
    public static ServerPlayerDataAPI from(@Nonnull ServerPlayer player) {
        ServerPlayer placedPlayer;
        ServerPlayerData data;
        ServerPlayerDataAPI result = ((IOpenPACServerPlayer)player).getXaero_OPAC_PlayerData();
        if (result == null) {
            result = new ServerPlayerData();
            ((IOpenPACServerPlayer)player).setXaero_OPAC_PlayerData(result);
        }
        if (!(data = (ServerPlayerData)result).hasHandledLogin() && player.connection != null && player.connection.getConnection() != null && !player.connection.getConnection().isConnecting() && (placedPlayer = player.getServer().getPlayerList().getPlayer(player.getUUID())) == player) {
            data.setHandledLogin(true);
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(player.getServer());
            serverData.getPlayerLoginHandler().handlePreWorldJoin(player, serverData);
            serverData.getPlayerWorldJoinHandler().onWorldJoin(serverData, player.getLevel(), player);
            serverData.getPlayerLoginHandler().handlePostWorldJoin(player, serverData);
        }
        return result;
    }
}

