/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import xaero.pac.client.gui.WidgetListElement;
import xaero.pac.client.gui.XPACScreen;

public abstract class WidgetListScreen
extends XPACScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int PER_PAGE = 12;
    private int page;
    private final int pageCount;
    protected final List<WidgetListElement<?>> elements;
    private final List<EditBox> tickableBoxes;
    private Component displayedTitle;
    private Button nextButton;
    private Button prevButton;

    protected WidgetListScreen(List<WidgetListElement<?>> elements, List<EditBox> tickableBoxes, Screen escape, Screen parent, Component p_96550_) {
        super(escape, parent, p_96550_);
        this.elements = elements;
        this.tickableBoxes = tickableBoxes;
        this.pageCount = (elements.size() + 12 - 1) / 12;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int xAnchor = this.f_96543_ / 2;
        int yAnchor = this.f_96544_ / 7;
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        this.tickableBoxes.clear();
        for (int index = startIndex; index < endIndex; ++index) {
            int indexOff = index - startIndex;
            int x = xAnchor - 205 + 210 * (indexOff / 6);
            int y = yAnchor + indexOff % 6 * 24;
            this.elements.get(index).screenInit(x, y, this, this.tickableBoxes);
        }
        this.m_142416_(new Button(xAnchor - 100, this.f_96544_ / 6 + 168, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_pac_back"), this::onBackButton));
        this.prevButton = new Button(this.f_96543_ / 2 - 205, yAnchor + 144, 75, 20, (Component)Component.m_237110_((String)"gui.xaero_pac_previous", (Object[])new Object[0]), this::onPrevButton);
        this.nextButton = new Button(this.f_96543_ / 2 + 131, yAnchor + 144, 75, 20, (Component)Component.m_237110_((String)"gui.xaero_pac_next", (Object[])new Object[0]), this::onNextButton);
        if (this.pageCount > 1) {
            this.m_142416_(this.prevButton);
            this.m_142416_(this.nextButton);
            this.prevButton.f_93623_ = this.page > 0;
            this.nextButton.f_93623_ = this.page < this.pageCount - 1;
        }
        this.displayedTitle = Component.m_237113_((String)"");
        this.displayedTitle.m_7360_().add(this.f_96539_);
        this.displayedTitle.m_7360_().add(Component.m_237113_((String)(" (" + (this.page + 1) + "/" + this.pageCount + ")")));
        this.f_96541_.f_91068_.m_90926_(true);
    }

    private int getStartIndex() {
        return this.page * 12;
    }

    private int getEndIndex() {
        return Math.min((this.page + 1) * 12, this.elements.size());
    }

    protected <T extends GuiEventListener & Widget> T m_142416_(T widget) {
        return (T)super.m_142416_(widget);
    }

    protected <T extends Widget> T m_169394_(T widget) {
        return (T)super.m_169394_(widget);
    }

    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T p_96625_) {
        return (T)super.m_7787_(p_96625_);
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        this.m_7333_(poseStack);
        WidgetListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.displayedTitle, (int)(this.f_96543_ / 2), (int)16, (int)-1);
        super.m_6305_(poseStack, mouseX, mouseY, partial);
    }

    @Override
    protected void renderPreDropdown(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        List<FormattedCharSequence> tooltip;
        super.renderPreDropdown(poseStack, mouseX, mouseY, partial);
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        WidgetListElement<?> tooltipElement = null;
        for (int index = startIndex; index < endIndex; ++index) {
            WidgetListElement<?> e = this.elements.get(index);
            e.render(poseStack);
            if (!e.isOver(mouseX, mouseY)) continue;
            tooltipElement = e;
        }
        if (this.openDropdown == null && tooltipElement != null && (tooltip = tooltipElement.getTooltip()) != null) {
            this.m_96617_(poseStack, tooltip, mouseX, mouseY + 24 + 10);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        for (EditBox editBox : this.tickableBoxes) {
            editBox.m_94120_();
        }
    }

    private void onPrevButton(Button b) {
        --this.page;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    private void onNextButton(Button b) {
        ++this.page;
        this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
    }

    protected void onBackButton(Button b) {
        this.goBack();
    }

    public void m_7522_(GuiEventListener l) {
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof EditBox) {
            ((EditBox)currentFocused).m_94178_(false);
        }
        super.m_7522_(l);
    }
}

