/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import xaero.pac.client.gui.WidgetListElement;
import xaero.pac.client.gui.XPACScreen;

public abstract class WidgetListScreen
extends XPACScreen {
    private static final int ROW_HEIGHT = 24;
    private static final int PER_PAGE = 12;
    private int page;
    private final int pageCount;
    protected final List<WidgetListElement<?>> elements;
    private final List<EditBox> tickableBoxes;
    private Component displayedTitle;
    private Button nextButton;
    private Button prevButton;

    protected WidgetListScreen(List<WidgetListElement<?>> elements, List<EditBox> tickableBoxes, Screen escape, Screen parent, Component p_96550_) {
        super(escape, parent, p_96550_);
        this.elements = elements;
        this.tickableBoxes = tickableBoxes;
        this.pageCount = (elements.size() + 12 - 1) / 12;
    }

    @Override
    protected void init() {
        super.init();
        int xAnchor = this.width / 2;
        int yAnchor = this.height / 7;
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        this.tickableBoxes.clear();
        for (int index = startIndex; index < endIndex; ++index) {
            int indexOff = index - startIndex;
            int x = xAnchor - 205 + 210 * (indexOff / 6);
            int y = yAnchor + indexOff % 6 * 24;
            this.elements.get(index).screenInit(x, y, this, this.tickableBoxes);
        }
        this.addRenderableWidget(Button.builder((Component)Component.translatable((String)"gui.xaero_pac_back"), this::onBackButton).bounds(xAnchor - 100, this.height / 6 + 168, 200, 20).build());
        this.prevButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_previous", (Object[])new Object[0]), this::onPrevButton).bounds(this.width / 2 - 205, yAnchor + 144, 75, 20).build();
        this.nextButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_next", (Object[])new Object[0]), this::onNextButton).bounds(this.width / 2 + 131, yAnchor + 144, 75, 20).build();
        if (this.pageCount > 1) {
            this.addRenderableWidget(this.prevButton);
            this.addRenderableWidget(this.nextButton);
            this.prevButton.active = this.page > 0;
            this.nextButton.active = this.page < this.pageCount - 1;
        }
        this.displayedTitle = Component.literal((String)"");
        this.displayedTitle.getSiblings().add(this.title);
        this.displayedTitle.getSiblings().add(Component.literal((String)(" (" + (this.page + 1) + "/" + this.pageCount + ")")));
    }

    private int getStartIndex() {
        return this.page * 12;
    }

    private int getEndIndex() {
        return Math.min((this.page + 1) * 12, this.elements.size());
    }

    protected <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        return (T)super.addRenderableWidget(widget);
    }

    protected <T extends Renderable> T addRenderableOnly(T widget) {
        return (T)super.addRenderableOnly(widget);
    }

    protected <T extends GuiEventListener & NarratableEntry> T addWidget(T p_96625_) {
        return (T)super.addWidget(p_96625_);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        this.renderBackground(guiGraphics);
        guiGraphics.drawCenteredString(this.font, this.displayedTitle, this.width / 2, 16, -1);
        super.render(guiGraphics, mouseX, mouseY, partial);
    }

    @Override
    protected void renderPreDropdown(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        List<FormattedCharSequence> tooltip;
        super.renderPreDropdown(guiGraphics, mouseX, mouseY, partial);
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        WidgetListElement<?> tooltipElement = null;
        for (int index = startIndex; index < endIndex; ++index) {
            WidgetListElement<?> e = this.elements.get(index);
            e.render(guiGraphics);
            if (!e.isOver(mouseX, mouseY)) continue;
            tooltipElement = e;
        }
        if (this.openDropdown == null && tooltipElement != null && (tooltip = tooltipElement.getTooltip()) != null) {
            guiGraphics.renderTooltip(this.font, tooltip, mouseX, mouseY + 24 + 10);
        }
    }

    public void tick() {
        super.tick();
        for (EditBox editBox : this.tickableBoxes) {
            editBox.tick();
        }
    }

    private void onPrevButton(Button b) {
        --this.page;
        this.init(this.minecraft, this.width, this.height);
    }

    private void onNextButton(Button b) {
        ++this.page;
        this.init(this.minecraft, this.width, this.height);
    }

    protected void onBackButton(Button b) {
        this.goBack();
    }
}

