/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.sync;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.result.api.AreaClaimResult;
import xaero.pac.common.packet.ClientboundLoadingPacket;
import xaero.pac.common.packet.claims.ClaimRegionsStartPacket;
import xaero.pac.common.packet.claims.ClientboundClaimLimitsPacket;
import xaero.pac.common.packet.claims.ClientboundClaimOwnerPropertiesPacket;
import xaero.pac.common.packet.claims.ClientboundClaimResultPacket;
import xaero.pac.common.packet.claims.ClientboundClaimStatesPacket;
import xaero.pac.common.packet.claims.ClientboundClaimsClaimUpdateNextXPosPacket;
import xaero.pac.common.packet.claims.ClientboundClaimsClaimUpdateNextZPosPacket;
import xaero.pac.common.packet.claims.ClientboundClaimsClaimUpdatePacket;
import xaero.pac.common.packet.claims.ClientboundClaimsClaimUpdatePosPacket;
import xaero.pac.common.packet.claims.ClientboundClaimsRegionPacket;
import xaero.pac.common.packet.claims.ClientboundCurrentSubClaimPacket;
import xaero.pac.common.packet.claims.ClientboundPlayerClaimsDimensionPacket;
import xaero.pac.common.packet.claims.ClientboundRemoveClaimStatePacket;
import xaero.pac.common.packet.claims.ClientboundRemoveSubClaimPacket;
import xaero.pac.common.packet.claims.ClientboundSubClaimPropertiesPacket;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.ServerClaimStateHolder;
import xaero.pac.common.server.claims.ServerClaimsManager;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfo;
import xaero.pac.common.server.claims.sync.IClaimsManagerSynchronizer;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.lazypacket.LazyPacket;
import xaero.pac.common.server.lazypacket.task.schedule.LazyPacketScheduleTaskHandler;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.sub.PlayerSubConfig;
import xaero.pac.common.server.player.data.ServerPlayerData;

public final class ClaimsManagerSynchronizer
implements IClaimsManagerSynchronizer {
    public static final int REGIONS_PER_TICK = 8192;
    public static final int REGIONS_PER_TICK_PER_PLAYER = 128;
    public static final int STATES_PER_TICK = 49152;
    public static final int STATES_PER_TICK_PER_PLAYER = 3072;
    public static final int OWNER_PROPERTIES_PER_TICK = 24576;
    public static final int OWNER_PROPERTIES_PER_TICK_PER_PLAYER = 1536;
    public static final int SUBCLAIM_PROPERTIES_PER_TICK = 16384;
    public static final int SUBCLAIM_PROPERTIES_PER_TICK_PER_PLAYER = 1024;
    private static final ClientboundClaimsClaimUpdateNextXPosPacket NEXT_X_PACKET = new ClientboundClaimsClaimUpdateNextXPosPacket();
    private static final ClientboundClaimsClaimUpdateNextZPosPacket NEXT_Z_PACKET = new ClientboundClaimsClaimUpdateNextZPosPacket();
    private final MinecraftServer server;
    private ServerClaimsManager claimsManager;
    private IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, ?> serverData;
    private final List<LazyPacketScheduleTaskHandler> schedulers;

    private ClaimsManagerSynchronizer(MinecraftServer server, List<LazyPacketScheduleTaskHandler> schedulers) {
        this.server = server;
        this.schedulers = schedulers;
    }

    public void setServerData(IServerData<?, ?> serverData) {
        if (this.serverData != null) {
            throw new IllegalAccessError();
        }
        this.serverData = serverData;
    }

    public void setClaimsManager(ServerClaimsManager claimsManager) {
        if (this.claimsManager != null) {
            throw new IllegalAccessError();
        }
        this.claimsManager = claimsManager;
    }

    private void sendToClient(ServerPlayer player, Object packet, boolean instant) {
        if (instant) {
            OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToPlayer(player, packet);
        } else {
            this.serverData.getServerTickHandler().getLazyPacketSender().enqueue(player, (LazyPacket)packet);
        }
    }

    private void startSyncing(ServerPlayer player) {
        if (ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.NOT_SYNCED) {
            return;
        }
        this.sendToClient(player, ClientboundLoadingPacket.START_CLAIMS, false);
    }

    public void endSyncing(ServerPlayer player) {
        if (ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.NOT_SYNCED) {
            return;
        }
        this.sendToClient(player, ClientboundLoadingPacket.END_CLAIMS, false);
    }

    public void trySyncClaimLimits(IPlayerConfigManager configManager, UUID playerId) {
        ServerPlayer player = this.server.getPlayerList().getPlayer(playerId);
        if (player != null) {
            IPlayerConfig config = configManager.getLoadedConfig(playerId);
            this.syncClaimLimits(config, player);
        }
    }

    @Override
    public void syncClaimLimits(IPlayerConfig config, ServerPlayer player) {
        int claimsLimit = this.claimsManager.getPlayerBaseClaimLimit(player) + config.getEffective(PlayerConfigOptions.BONUS_CHUNK_CLAIMS);
        int forceloadLimit = this.claimsManager.getPlayerBaseForceloadLimit(player) + config.getEffective(PlayerConfigOptions.BONUS_CHUNK_FORCELOADS);
        int maxClaimDistance = (Integer)ServerConfig.CONFIG.maxClaimDistance.get();
        boolean alwaysUseLoadingValues = ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.NOT_SYNCED;
        IServerPlayerClaimInfo playerInfo = (IServerPlayerClaimInfo)this.claimsManager.getPlayerInfo(player.getUUID());
        this.sendToClient(player, new ClientboundClaimLimitsPacket(playerInfo.getClaimCount(), playerInfo.getForceloadCount(), claimsLimit, forceloadLimit, maxClaimDistance, alwaysUseLoadingValues), false);
    }

    @Override
    public void updateClaimLimitsSyncOnTick(ServerPlayerData playerData, ServerPlayer player) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - playerData.getLastClaimLimitsCheckTime() < 1000L) {
            return;
        }
        playerData.setLastClaimLimitsCheckTime(currentTime);
        int currentBaseClaimLimit = this.claimsManager.getPlayerBaseClaimLimit(player);
        int currentBaseForceloadLimit = this.claimsManager.getPlayerBaseForceloadLimit(player);
        if (!playerData.checkBaseClaimLimitsSync(currentBaseClaimLimit, currentBaseForceloadLimit)) {
            return;
        }
        if (playerData.haveCheckedBaseForceloadLimitOnce()) {
            this.syncClaimLimits(this.serverData.getPlayerConfigs().getLoadedConfig(player.getUUID()), player);
            this.serverData.getForceLoadManager().updateTicketsFor(this.serverData.getPlayerConfigs(), player.getUUID(), false);
        }
        playerData.setCheckedBaseForceloadLimitOnce();
        playerData.setLastClaimLimitsSyncValues(currentBaseClaimLimit, currentBaseForceloadLimit);
    }

    @Override
    public void syncCurrentSubClaim(IPlayerConfig config, ServerPlayer player) {
        String currentServerSubConfigId;
        int currentSubConfigIndex = config.getUsedSubConfig().getSubIndex();
        int currentServerSubConfigIndex = config.getUsedServerSubConfig().getSubIndex();
        String currentSubConfigId = config.getUsedSubConfig().getSubId();
        if (currentSubConfigId == null) {
            currentSubConfigId = "main";
        }
        if ((currentServerSubConfigId = config.getUsedServerSubConfig().getSubId()) == null) {
            currentServerSubConfigId = "main";
        }
        this.sendToClient(player, new ClientboundCurrentSubClaimPacket(currentSubConfigIndex, currentServerSubConfigIndex, currentSubConfigId, currentServerSubConfigId), false);
    }

    public Iterator<ServerPlayerClaimInfo> getClaimPropertiesToSync(ServerPlayer player) {
        if (ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.NOT_SYNCED) {
            return List.of((ServerPlayerClaimInfo)this.claimsManager.getPlayerInfo(player.getUUID())).iterator();
        }
        if (ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.ALL) {
            return this.claimsManager.getPlayerInfoIterator();
        }
        return List.of((ServerPlayerClaimInfo)this.claimsManager.getPlayerInfo(player.getUUID()), (ServerPlayerClaimInfo)this.claimsManager.getPlayerInfo(PlayerConfig.SERVER_CLAIM_UUID)).iterator();
    }

    public void syncClaimOwnerProperties(List<ClientboundClaimOwnerPropertiesPacket.PlayerProperties> packetBuilder, ServerPlayer player) {
        this.sendToClient(player, new ClientboundClaimOwnerPropertiesPacket(packetBuilder), false);
    }

    public void syncSubClaimProperties(List<ClientboundSubClaimPropertiesPacket.SubClaimProperties> packetBuilder, ServerPlayer player) {
        this.sendToClient(player, new ClientboundSubClaimPropertiesPacket(packetBuilder), false);
    }

    private boolean claimInfoShouldReachEveryone(ServerConfig.ClaimsSyncType syncType, UUID playerId) {
        return syncType == ServerConfig.ClaimsSyncType.ALL || Objects.equals(PlayerConfig.SERVER_CLAIM_UUID, playerId);
    }

    @Override
    public void syncToPlayersClaimOwnerPropertiesUpdate(IServerPlayerClaimInfo<?> playerInfo) {
        ServerConfig.ClaimsSyncType syncType = (ServerConfig.ClaimsSyncType)((Object)ServerConfig.CONFIG.claimsSynchronization.get());
        if (syncType == ServerConfig.ClaimsSyncType.NOT_SYNCED) {
            return;
        }
        PlayerList players = this.server.getPlayerList();
        ArrayList packetBuilder = Lists.newArrayList((Object[])new ClientboundClaimOwnerPropertiesPacket.PlayerProperties[]{new ClientboundClaimOwnerPropertiesPacket.PlayerProperties(playerInfo.getPlayerId(), playerInfo.getPlayerUsername())});
        if (syncType == ServerConfig.ClaimsSyncType.ALL || Objects.equals(PlayerConfig.SERVER_CLAIM_UUID, playerInfo.getPlayerId())) {
            for (ServerPlayer player : players.getPlayers()) {
                this.syncClaimOwnerProperties(packetBuilder, player);
            }
        } else {
            ServerPlayer selfPlayer = players.getPlayer(playerInfo.getPlayerId());
            if (selfPlayer != null) {
                this.syncClaimOwnerProperties(packetBuilder, selfPlayer);
            }
        }
    }

    public ClientboundSubClaimPropertiesPacket.SubClaimProperties getSubClaimPropertiesForSync(IPlayerConfig subConfig, boolean afterReset) {
        Integer claimsColor;
        String claimsName;
        if (subConfig instanceof PlayerSubConfig) {
            claimsName = subConfig.getRaw(PlayerConfigOptions.CLAIMS_NAME);
            claimsColor = subConfig.applyDefaultReplacer(PlayerConfigOptions.CLAIMS_COLOR, subConfig.getRaw(PlayerConfigOptions.CLAIMS_COLOR));
        } else {
            claimsName = subConfig.getEffective(PlayerConfigOptions.CLAIMS_NAME);
            claimsColor = subConfig.getEffective(PlayerConfigOptions.CLAIMS_COLOR);
        }
        if (afterReset && claimsName == null && claimsColor == null) {
            return null;
        }
        return new ClientboundSubClaimPropertiesPacket.SubClaimProperties(subConfig.getPlayerId(), subConfig.getSubIndex(), claimsName, claimsColor);
    }

    @Override
    public void syncToPlayersSubClaimPropertiesUpdate(IPlayerConfig subConfig) {
        ServerConfig.ClaimsSyncType syncType = (ServerConfig.ClaimsSyncType)((Object)ServerConfig.CONFIG.claimsSynchronization.get());
        if (syncType == ServerConfig.ClaimsSyncType.NOT_SYNCED) {
            return;
        }
        PlayerList players = this.server.getPlayerList();
        ArrayList packetBuilder = Lists.newArrayList((Object[])new ClientboundSubClaimPropertiesPacket.SubClaimProperties[]{this.getSubClaimPropertiesForSync(subConfig, false)});
        if (this.claimInfoShouldReachEveryone(syncType, subConfig.getPlayerId())) {
            for (ServerPlayer player : players.getPlayers()) {
                this.syncSubClaimProperties(packetBuilder, player);
            }
        } else {
            ServerPlayer selfPlayer = players.getPlayer(subConfig.getPlayerId());
            if (selfPlayer != null) {
                this.syncSubClaimProperties(packetBuilder, selfPlayer);
            }
        }
    }

    @Override
    public void syncToPlayersSubClaimPropertiesRemove(IPlayerConfig subConfig) {
        ServerConfig.ClaimsSyncType syncType = (ServerConfig.ClaimsSyncType)((Object)ServerConfig.CONFIG.claimsSynchronization.get());
        if (syncType == ServerConfig.ClaimsSyncType.NOT_SYNCED) {
            return;
        }
        PlayerList players = this.server.getPlayerList();
        ClientboundRemoveSubClaimPacket packet = new ClientboundRemoveSubClaimPacket(subConfig.getPlayerId(), subConfig.getSubIndex());
        if (this.claimInfoShouldReachEveryone(syncType, subConfig.getPlayerId())) {
            for (ServerPlayer player : players.getPlayers()) {
                this.sendToClient(player, packet, false);
            }
        } else {
            ServerPlayer selfPlayer = players.getPlayer(subConfig.getPlayerId());
            if (selfPlayer != null) {
                this.sendToClient(selfPlayer, packet, false);
            }
        }
    }

    public void syncClaimStates(List<PlayerChunkClaim> packetBuilder, ServerPlayer player) {
        this.sendToClient(player, new ClientboundClaimStatesPacket(packetBuilder), false);
    }

    public void syncDimensionIdToClient(ResourceLocation dimension, ServerPlayer player) {
        this.sendToClient(player, new ClientboundPlayerClaimsDimensionPacket(dimension), false);
    }

    public void syncRegionClaimsToClient(int x, int z, int[] paletteInts, long[] storageData, int storageBits, ServerPlayer player) {
        this.sendToClient(player, new ClientboundClaimsRegionPacket(x, z, paletteInts, storageBits, storageData), false);
    }

    private void sendClaimUpdatePacketToPlayer(ServerPlayer player, PlayerChunkClaim claim, ResourceLocation dimension, int x, int z, ClientboundClaimsClaimUpdatePacket packet, ClientboundClaimsClaimUpdatePosPacket posPacket) {
        ServerPlayerData playerData = (ServerPlayerData)ServerPlayerData.from(player);
        if (playerData.getLastClaimUpdateState() == claim && playerData.getLastClaimUpdateDimension() == dimension) {
            if (playerData.getLastClaimUpdateX() == x && z - playerData.getLastClaimUpdateZ() == 1) {
                this.sendToClient(player, NEXT_Z_PACKET, false);
            } else if (playerData.getLastClaimUpdateZ() == z && x - playerData.getLastClaimUpdateX() == 1) {
                this.sendToClient(player, NEXT_X_PACKET, false);
            } else {
                this.sendToClient(player, posPacket, false);
            }
            playerData.setLastClaimUpdate(dimension, claim, x, z);
            return;
        }
        this.sendToClient(player, packet, false);
        playerData.setLastClaimUpdate(dimension, claim, x, z);
    }

    public void syncToPlayersClaimUpdate(ResourceLocation dimension, int x, int z, PlayerChunkClaim claim, PlayerChunkClaim oldClaim) {
        ServerConfig.ClaimsSyncType syncType = (ServerConfig.ClaimsSyncType)((Object)ServerConfig.CONFIG.claimsSynchronization.get());
        if (syncType == ServerConfig.ClaimsSyncType.NOT_SYNCED) {
            return;
        }
        PlayerList players = this.server.getPlayerList();
        UUID newPlayerId = claim == null ? null : claim.getPlayerId();
        int newSubConfigIndex = claim == null ? -1 : claim.getSubConfigIndex();
        ClientboundClaimsClaimUpdatePacket packet = new ClientboundClaimsClaimUpdatePacket(dimension, x, z, newPlayerId, newSubConfigIndex, claim != null && claim.isForceloadable(), claim != null ? claim.getSyncIndex() : -1);
        ClientboundClaimsClaimUpdatePosPacket posPacket = new ClientboundClaimsClaimUpdatePosPacket(x, z);
        if (this.claimInfoShouldReachEveryone(syncType, newPlayerId)) {
            for (ServerPlayer player : players.getPlayers()) {
                this.sendClaimUpdatePacketToPlayer(player, claim, dimension, x, z, packet, posPacket);
            }
        } else {
            ServerPlayer newPlayer;
            UUID oldPlayerId;
            UUID uUID = oldPlayerId = oldClaim == null ? null : oldClaim.getPlayerId();
            if (oldPlayerId != null && !Objects.equals(newPlayerId, oldPlayerId)) {
                ClientboundClaimsClaimUpdatePacket removalPacket = new ClientboundClaimsClaimUpdatePacket(dimension, x, z, null, -1, false, -1);
                if (Objects.equals(PlayerConfig.SERVER_CLAIM_UUID, oldPlayerId)) {
                    for (ServerPlayer player : players.getPlayers()) {
                        this.sendClaimUpdatePacketToPlayer(player, null, dimension, x, z, removalPacket, posPacket);
                    }
                } else {
                    ServerPlayer oldPlayer = players.getPlayer(oldPlayerId);
                    if (oldPlayer != null) {
                        this.sendClaimUpdatePacketToPlayer(oldPlayer, null, dimension, x, z, removalPacket, posPacket);
                    }
                }
            }
            if (newPlayerId != null && (newPlayer = players.getPlayer(newPlayerId)) != null) {
                this.sendClaimUpdatePacketToPlayer(newPlayer, claim, dimension, x, z, packet, posPacket);
            }
        }
    }

    public void syncToPlayersRemoveClaimState(PlayerChunkClaim state) {
        ServerConfig.ClaimsSyncType syncType = (ServerConfig.ClaimsSyncType)((Object)ServerConfig.CONFIG.claimsSynchronization.get());
        if (syncType == ServerConfig.ClaimsSyncType.NOT_SYNCED) {
            return;
        }
        PlayerList players = this.server.getPlayerList();
        ClientboundRemoveClaimStatePacket packet = new ClientboundRemoveClaimStatePacket(state.getSyncIndex());
        if (this.claimInfoShouldReachEveryone(syncType, state.getPlayerId())) {
            for (ServerPlayer player : players.getPlayers()) {
                this.sendToClient(player, packet, false);
            }
        } else {
            ServerPlayer player = players.getPlayer(state.getPlayerId());
            if (player != null) {
                this.sendToClient(player, packet, false);
            }
        }
    }

    public void syncToPlayerClaimActionResult(AreaClaimResult result, ServerPlayer player) {
        this.sendToClient(player, new ClientboundClaimResultPacket(result), true);
    }

    @Override
    public void syncOnLogin(ServerPlayer player) {
        IPlayerConfigManager configManager = this.serverData.getPlayerConfigs();
        IPlayerConfig config = configManager.getLoadedConfig(player.getUUID());
        this.startSyncing(player);
        this.syncClaimLimits(config, player);
        this.syncCurrentSubClaim(config, player);
        this.sendToClient(player, new ClaimRegionsStartPacket(), false);
    }

    public Iterator<ServerClaimStateHolder> getStateHolderIteratorForSync() {
        return this.claimsManager.getClaimStateHolderIterator();
    }

    @Override
    public void onLazyPacketsDropped(ServerPlayer player) {
        this.schedulers.forEach(s -> s.onLazyPacketsDropped(player));
    }

    @Override
    public void onServerTick() {
        this.schedulers.forEach(s -> s.onTick(this.serverData));
    }

    public static final class Builder {
        private MinecraftServer server;

        private Builder() {
        }

        public Builder setDefault() {
            this.setServer(null);
            return this;
        }

        public Builder setServer(MinecraftServer server) {
            this.server = server;
            return this;
        }

        public ClaimsManagerSynchronizer build() {
            if (this.server == null) {
                throw new IllegalStateException();
            }
            LazyPacketScheduleTaskHandler claimOwnerPropertiesScheduler = ((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)LazyPacketScheduleTaskHandler.Builder.begin().setPlayerTaskGetter(ServerPlayerData::getClaimsManagerPlayerClaimOwnerPropertiesSync)).setPerTickLimit(24576)).setPerTickPerTaskLimit(1536)).build();
            LazyPacketScheduleTaskHandler subClaimPropertiesScheduler = ((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)LazyPacketScheduleTaskHandler.Builder.begin().setPlayerTaskGetter(ServerPlayerData::getClaimsManagerPlayerSubClaimPropertiesSync)).setPerTickLimit(16384)).setPerTickPerTaskLimit(1024)).build();
            LazyPacketScheduleTaskHandler claimStateScheduler = ((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)LazyPacketScheduleTaskHandler.Builder.begin().setPlayerTaskGetter(ServerPlayerData::getClaimsManagerPlayerStateSync)).setPerTickLimit(49152)).setPerTickPerTaskLimit(3072)).build();
            int regionsPerTick = ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.OWNED_ONLY ? 5461 : 8192;
            int regionsPerTickPerPlayer = ServerConfig.CONFIG.claimsSynchronization.get() == ServerConfig.ClaimsSyncType.OWNED_ONLY ? 85 : 128;
            LazyPacketScheduleTaskHandler regionScheduler = ((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)((LazyPacketScheduleTaskHandler.Builder)LazyPacketScheduleTaskHandler.Builder.begin().setPlayerTaskGetter(ServerPlayerData::getClaimsManagerPlayerRegionSync)).setPerTickLimit(regionsPerTick)).setPerTickPerTaskLimit(regionsPerTickPerPlayer)).build();
            List<LazyPacketScheduleTaskHandler> schedulers = List.of(claimOwnerPropertiesScheduler, subClaimPropertiesScheduler, claimStateScheduler, regionScheduler);
            return new ClaimsManagerSynchronizer(this.server, schedulers);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

