/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundCurrentSubClaimPacket
extends LazyPacket<ClientboundCurrentSubClaimPacket> {
    public static final LazyPacket.Encoder<ClientboundCurrentSubClaimPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final int currentSubConfigIndex;
    private final int currentServerSubConfigIndex;
    private final String currentSubConfigId;
    private final String currentServerSubConfigId;

    public ClientboundCurrentSubClaimPacket(int currentSubConfigIndex, int currentServerSubConfigIndex, String currentSubConfigId, String currentServerSubConfigId) {
        this.currentSubConfigIndex = currentSubConfigIndex;
        this.currentServerSubConfigIndex = currentServerSubConfigIndex;
        this.currentSubConfigId = currentSubConfigId;
        this.currentServerSubConfigId = currentServerSubConfigId;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("i", this.currentSubConfigIndex);
        tag.m_128405_("si", this.currentServerSubConfigIndex);
        tag.m_128359_("s", this.currentSubConfigId);
        tag.m_128359_("ss", this.currentServerSubConfigId);
        u.m_130079_(tag);
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundCurrentSubClaimPacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundCurrentSubClaimPacket> {
        @Override
        public ClientboundCurrentSubClaimPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 4096) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                int currentSubConfigIndex = tag.m_128451_("i");
                int currentServerSubConfigIndex = tag.m_128451_("si");
                String currentSubConfigId = tag.m_128461_("s");
                String currentServerSubConfigId = tag.m_128461_("ss");
                if (currentSubConfigId.length() > 100 || currentServerSubConfigId.length() > 100) {
                    OpenPartiesAndClaims.LOGGER.info("Player config sub ID string is too long!");
                    return null;
                }
                return new ClientboundCurrentSubClaimPacket(currentSubConfigIndex, currentServerSubConfigIndex, currentSubConfigId, currentServerSubConfigId);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundCurrentSubClaimPacket> {
        @Override
        public void handle(ClientboundCurrentSubClaimPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onSubConfigIndices(t.currentSubConfigIndex, t.currentServerSubConfigIndex, t.currentSubConfigId, t.currentServerSubConfigId);
        }
    }
}

