/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundRemoveClaimStatePacket
extends LazyPacket<ClientboundRemoveClaimStatePacket> {
    public static final LazyPacket.Encoder<ClientboundRemoveClaimStatePacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final int syncIndex;

    public ClientboundRemoveClaimStatePacket(int syncIndex) {
        this.syncIndex = syncIndex;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("i", this.syncIndex);
        u.m_130079_(tag);
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundRemoveClaimStatePacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundRemoveClaimStatePacket> {
        @Override
        public ClientboundRemoveClaimStatePacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                CompoundTag tag = input.m_130261_();
                if (tag == null) {
                    return null;
                }
                int syncIndex = tag.m_128451_("i");
                return new ClientboundRemoveClaimStatePacket(syncIndex);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet ", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundRemoveClaimStatePacket> {
        @Override
        public void handle(ClientboundRemoveClaimStatePacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onClaimStateRemoved(t.syncIndex);
        }
    }
}

