/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.config;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.packet.config.PlayerConfigPacket;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public class PlayerConfigOptionValuePacket
extends PlayerConfigPacket {
    protected final PlayerConfigType type;
    protected final String subId;
    protected final UUID owner;
    protected final List<Entry> entries;

    public PlayerConfigOptionValuePacket(PlayerConfigType type, String subId, UUID owner, List<Entry> entries) {
        this.type = type;
        this.subId = subId;
        this.owner = owner;
        this.entries = entries;
    }

    public PlayerConfigType getType() {
        return this.type;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Stream<Entry> entryStream() {
        return this.entries.stream();
    }

    public int getSize() {
        return this.entries.size();
    }

    public String getSubId() {
        return this.subId;
    }

    public static final class Entry {
        private final String id;
        private final Class<?> type;
        private final Object value;
        private final boolean mutable;
        private final boolean defaulted;

        public Entry(String id, Class<?> type, Object value, boolean mutable, boolean defaulted) {
            this.id = id;
            this.type = type;
            this.value = value;
            this.mutable = mutable;
            this.defaulted = defaulted;
        }

        public String getId() {
            return this.id;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isMutable() {
            return this.mutable;
        }

        public boolean isDefaulted() {
            return this.defaulted;
        }
    }

    public static abstract class Codec<P extends PlayerConfigOptionValuePacket>
    implements BiConsumer<P, FriendlyByteBuf>,
    Function<FriendlyByteBuf, P> {
        protected abstract int getSizeLimit();

        protected abstract P create(PlayerConfigType var1, String var2, UUID var3, List<Entry> var4);

        @Override
        public P apply(FriendlyByteBuf input) {
            try {
                String subID;
                if (input.readableBytes() > this.getSizeLimit()) {
                    return null;
                }
                CompoundTag nbt = input.m_130261_();
                if (nbt == null) {
                    return null;
                }
                String typeString = nbt.m_128461_("t");
                if (typeString.length() > 100) {
                    OpenPartiesAndClaims.LOGGER.info("Player config type string is too long!");
                    return null;
                }
                PlayerConfigType type = null;
                try {
                    type = PlayerConfigType.valueOf(typeString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (type == null) {
                    OpenPartiesAndClaims.LOGGER.info("Received unknown player config type!");
                    return null;
                }
                String string = subID = nbt.m_128441_("si") ? nbt.m_128461_("si") : null;
                if (subID != null && subID.length() > 100) {
                    OpenPartiesAndClaims.LOGGER.info("Player config sub ID string is too long!");
                    return null;
                }
                UUID owner = type != PlayerConfigType.PLAYER || nbt.m_128471_("co") ? null : nbt.m_128342_("o");
                ListTag entryListTag = nbt.m_128437_("e", 10);
                if (entryListTag.size() < 0 || entryListTag.size() > 512) {
                    OpenPartiesAndClaims.LOGGER.info("Received an illegal player config option entry number: " + entryListTag.size());
                    return null;
                }
                ArrayList<Entry> entries = new ArrayList<Entry>(entryListTag.size());
                String warningToOutput = null;
                for (Tag e : entryListTag) {
                    Class valueType;
                    Object value;
                    CompoundTag entryTag = (CompoundTag)e;
                    String optionId = entryTag.m_128461_("i");
                    if (optionId.length() > 1000) {
                        OpenPartiesAndClaims.LOGGER.info("Received player config option id string is not allowed!");
                        return null;
                    }
                    if (!entryTag.m_128441_("v")) {
                        value = null;
                        valueType = null;
                    } else {
                        Tag valueTag = entryTag.m_128423_("v");
                        if (valueTag instanceof ByteTag) {
                            ByteTag byteTag = (ByteTag)valueTag;
                            value = byteTag.m_7063_() != 0;
                            valueType = Boolean.class;
                        } else if (valueTag instanceof IntTag) {
                            IntTag intTag = (IntTag)valueTag;
                            value = intTag.m_7047_();
                            valueType = Integer.class;
                        } else if (valueTag instanceof DoubleTag) {
                            DoubleTag doubleTag = (DoubleTag)valueTag;
                            value = doubleTag.m_7061_();
                            valueType = Double.class;
                        } else if (valueTag instanceof FloatTag) {
                            FloatTag floatTag = (FloatTag)valueTag;
                            value = Float.valueOf(floatTag.m_7057_());
                            valueType = Float.class;
                        } else if (valueTag instanceof StringTag) {
                            StringTag stringTag = (StringTag)valueTag;
                            value = stringTag.m_7916_();
                            valueType = String.class;
                            if (((String)value).length() > 1000) {
                                OpenPartiesAndClaims.LOGGER.info("Received a string option value that is too long: " + ((String)value).length());
                                return null;
                            }
                        } else {
                            if (warningToOutput != null) continue;
                            warningToOutput = "Received unknown player config option value tag type: " + String.valueOf(valueTag.m_6458_());
                            continue;
                        }
                    }
                    boolean mutable = entryTag.m_128471_("m");
                    boolean defaulted = entryTag.m_128471_("d");
                    Entry entry = new Entry(optionId, valueType, value, mutable, defaulted);
                    entries.add(entry);
                }
                if (warningToOutput != null) {
                    OpenPartiesAndClaims.LOGGER.info(warningToOutput);
                }
                return this.create(type, subID, owner, entries);
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(P t, FriendlyByteBuf u) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("t", ((PlayerConfigOptionValuePacket)t).getType().name());
            if (((PlayerConfigOptionValuePacket)t).subId != null) {
                nbt.m_128359_("si", ((PlayerConfigOptionValuePacket)t).subId);
            }
            if (((PlayerConfigOptionValuePacket)t).getType() == PlayerConfigType.PLAYER) {
                nbt.m_128379_("co", ((PlayerConfigOptionValuePacket)t).owner == null);
                if (((PlayerConfigOptionValuePacket)t).owner != null) {
                    nbt.m_128362_("o", ((PlayerConfigOptionValuePacket)t).owner);
                }
            }
            ListTag entryListTag = new ListTag();
            for (Entry entry : ((PlayerConfigOptionValuePacket)t).entries) {
                CompoundTag entryTag = new CompoundTag();
                Object entryValue = entry.getValue();
                entryTag.m_128359_("i", entry.getId());
                if (entryValue != null) {
                    if (entry.getType() == Boolean.class) {
                        entryTag.m_128379_("v", ((Boolean)entryValue).booleanValue());
                    } else if (entry.getType() == Integer.class) {
                        entryTag.m_128405_("v", ((Integer)entryValue).intValue());
                    } else if (entry.getType() == Double.class) {
                        entryTag.m_128347_("v", ((Double)entryValue).doubleValue());
                    } else if (entry.getType() == Float.class) {
                        entryTag.m_128350_("v", ((Float)entryValue).floatValue());
                    } else if (entry.getType() == String.class) {
                        entryTag.m_128359_("v", (String)entryValue);
                    } else {
                        OpenPartiesAndClaims.LOGGER.info("Sending an unknown player config option type: " + String.valueOf(entry.getType()));
                    }
                }
                entryTag.m_128379_("m", entry.isMutable());
                entryTag.m_128379_("d", entry.isDefaulted());
                entryListTag.add((Object)entryTag);
            }
            nbt.m_128365_("e", (Tag)entryListTag);
            u.m_130079_(nbt);
        }
    }
}

