/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundLoadingPacket
extends LazyPacket<ClientboundLoadingPacket> {
    public static final LazyPacket.Encoder<ClientboundLoadingPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    public static final ClientboundLoadingPacket START_PARTY = new ClientboundLoadingPacket(true, false);
    public static final ClientboundLoadingPacket END_PARTY = new ClientboundLoadingPacket(false, false);
    public static final ClientboundLoadingPacket START_CLAIMS = new ClientboundLoadingPacket(true, true);
    public static final ClientboundLoadingPacket END_CLAIMS = new ClientboundLoadingPacket(false, true);
    private final boolean start;
    private final boolean claims;

    private ClientboundLoadingPacket(boolean start, boolean claims) {
        this.start = start;
        this.claims = claims;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("s", this.start);
        tag.m_128379_("c", this.claims);
        u.m_130079_((Tag)tag);
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundLoadingPacket> getDecoder() {
        return DECODER;
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundLoadingPacket> {
        @Override
        public ClientboundLoadingPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                CompoundTag tag = (CompoundTag)input.m_130081_(NbtAccounter.m_301669_());
                if (tag == null) {
                    return null;
                }
                boolean start = tag.m_128471_("s");
                boolean claims = tag.m_128471_("c");
                return new ClientboundLoadingPacket(start, claims);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundLoadingPacket> {
        @Override
        public void handle(ClientboundLoadingPacket t) {
            if (!t.claims) {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().setLoading(t.start);
            } else {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onLoading(t.start);
            }
        }
    }
}

