/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet.claims;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.server.lazypacket.LazyPacket;

public class ClientboundRemoveSubClaimPacket
extends LazyPacket<ClientboundRemoveSubClaimPacket> {
    public static final LazyPacket.Encoder<ClientboundRemoveSubClaimPacket> ENCODER = new LazyPacket.Encoder();
    public static final Decoder DECODER = new Decoder();
    private final UUID playerId;
    private final int subConfigIndex;

    public ClientboundRemoveSubClaimPacket(UUID playerId, int subConfigIndex) {
        this.playerId = playerId;
        this.subConfigIndex = subConfigIndex;
    }

    @Override
    protected Function<FriendlyByteBuf, ClientboundRemoveSubClaimPacket> getDecoder() {
        return DECODER;
    }

    @Override
    protected void writeOnPrepare(FriendlyByteBuf u) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("p", this.playerId);
        nbt.m_128405_("s", this.subConfigIndex);
        u.m_130079_((Tag)nbt);
    }

    public String toString() {
        return String.format("[%s, %d]", this.playerId, this.subConfigIndex);
    }

    public static class Decoder
    implements Function<FriendlyByteBuf, ClientboundRemoveSubClaimPacket> {
        @Override
        public ClientboundRemoveSubClaimPacket apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 1024) {
                    return null;
                }
                CompoundTag nbt = (CompoundTag)input.m_130081_(NbtAccounter.m_301669_());
                if (nbt == null) {
                    return null;
                }
                UUID playerId = nbt.m_128342_("p");
                int subConfigIndex = nbt.m_128451_("s");
                return new ClientboundRemoveSubClaimPacket(playerId, subConfigIndex);
            }
            catch (Throwable t) {
                OpenPartiesAndClaims.LOGGER.error("invalid packet", t);
                return null;
            }
        }
    }

    public static class ClientHandler
    extends LazyPacket.Handler<ClientboundRemoveSubClaimPacket> {
        @Override
        public void handle(ClientboundRemoveSubClaimPacket t) {
            OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientClaimsSyncHandler().onRemoveSubClaim(t.playerId, t.subConfigIndex);
        }
    }
}

