/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.parties.party;

import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.parties.party.IPartyMemberDynamicInfoSyncable;

public class PartyMemberDynamicInfoSyncable
implements IPartyMemberDynamicInfoSyncable {
    private ResourceLocation dimension;
    private double x;
    private double y;
    private double z;
    private final UUID playerId;
    private boolean dirty;
    private final boolean active;
    private UUID partyId;
    private final PartyMemberDynamicInfoSyncable remover;

    public PartyMemberDynamicInfoSyncable(UUID playerId, boolean active) {
        this.playerId = playerId;
        this.active = active;
        this.remover = active ? new PartyMemberDynamicInfoSyncable(playerId, false) : null;
    }

    @Override
    @Nonnull
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    @Nullable
    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public void setDimension(ResourceLocation dimension) {
        if (!Objects.equals(dimension, this.dimension)) {
            this.dirty = true;
        }
        this.dimension = dimension;
    }

    public void setX(double x) {
        if (this.x != x) {
            this.dirty = true;
        }
        this.x = x;
    }

    public void setY(double y) {
        if (this.y != y) {
            this.dirty = true;
        }
        this.y = y;
    }

    public void setZ(double z) {
        if (this.z != z) {
            this.dirty = true;
        }
        this.z = z;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setPartyId(UUID partyId) {
        if (!Objects.equals(this.partyId, partyId)) {
            this.dirty = true;
        }
        this.partyId = partyId;
    }

    @Override
    public PartyMemberDynamicInfoSyncable getRemover() {
        return this.remover;
    }

    @Override
    public void update(ResourceLocation dimension, double x, double y, double z) {
        this.setDimension(dimension);
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    @Override
    public UUID getPartyId() {
        return this.partyId;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String toString() {
        return String.format("[%f, %f, %f, %s, %s]", this.x, this.y, this.z, this.dimension, this.active);
    }

    public static class ClientHandler
    implements Consumer<PartyMemberDynamicInfoSyncable> {
        @Override
        public void accept(PartyMemberDynamicInfoSyncable t) {
            if (t.active) {
                PlayerInfo playerInfo;
                PartyMemberDynamicInfoSyncable clientInfo = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getPartyMemberDynamicInfoSyncableStorage().getOrSetForPlayer(t.getPlayerId(), t);
                if (clientInfo != t) {
                    clientInfo.update(t.dimension, t.x, t.y, t.z);
                }
                String string = (playerInfo = Minecraft.m_91087_().m_91403_().m_104949_(t.getPlayerId())) == null ? "unknown" : playerInfo.m_105312_().getName();
            } else {
                OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getPartyMemberDynamicInfoSyncableStorage().removeForPlayer(t.playerId);
            }
        }
    }

    public static class Codec
    implements BiConsumer<PartyMemberDynamicInfoSyncable, FriendlyByteBuf>,
    Function<FriendlyByteBuf, PartyMemberDynamicInfoSyncable> {
        @Override
        public PartyMemberDynamicInfoSyncable apply(FriendlyByteBuf input) {
            try {
                if (input.readableBytes() > 16384) {
                    return null;
                }
                CompoundTag tag = (CompoundTag)input.m_130081_(NbtAccounter.m_301669_());
                UUID playerId = tag.m_128342_("i");
                boolean active = tag.m_128471_("a");
                if (!active) {
                    return new PartyMemberDynamicInfoSyncable(playerId, false);
                }
                String dimensionSpace = tag.m_128461_("ds");
                String dimensionPath = tag.m_128461_("dp");
                ResourceLocation dimension = new ResourceLocation(dimensionSpace, dimensionPath);
                double x = tag.m_128459_("x");
                double y = tag.m_128459_("y");
                double z = tag.m_128459_("z");
                PartyMemberDynamicInfoSyncable result = new PartyMemberDynamicInfoSyncable(playerId, true);
                result.update(dimension, x, y, z);
                result.dirty = false;
                return result;
            }
            catch (Throwable t) {
                return null;
            }
        }

        @Override
        public void accept(PartyMemberDynamicInfoSyncable t, FriendlyByteBuf u) {
            t.dirty = false;
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("i", t.playerId);
            tag.m_128379_("a", t.active);
            if (t.active) {
                tag.m_128359_("ds", t.dimension.m_135827_());
                tag.m_128359_("dp", t.dimension.m_135815_());
                tag.m_128347_("x", t.x);
                tag.m_128347_("y", t.y);
                tag.m_128347_("z", t.z);
            }
            u.m_130079_((Tag)tag);
        }
    }
}

