/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.player;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.common.ModConfigSpec;
import xaero.pac.common.claims.player.PlayerClaimInfoManager;
import xaero.pac.common.claims.player.PlayerDimensionClaims;
import xaero.pac.common.server.claims.ServerClaimsManager;
import xaero.pac.common.server.claims.forceload.ForceLoadTicketManager;
import xaero.pac.common.server.claims.player.ServerPlayerClaimInfo;
import xaero.pac.common.server.claims.player.expiration.ServerPlayerClaimsExpirationHandler;
import xaero.pac.common.server.claims.player.io.PlayerClaimInfoManagerIO;
import xaero.pac.common.server.claims.player.task.PlayerClaimReplaceSpreadoutTask;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.expiration.ObjectManagerIOExpirableObjectManager;
import xaero.pac.common.server.io.ObjectManagerIOManager;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.server.player.permission.api.IPermissionNodeAPI;
import xaero.pac.common.server.player.permission.api.IPlayerPermissionSystemAPI;
import xaero.pac.common.util.linked.LinkedChain;

public final class ServerPlayerClaimInfoManager
extends PlayerClaimInfoManager<ServerPlayerClaimInfo, ServerPlayerClaimInfoManager>
implements ObjectManagerIOManager<ServerPlayerClaimInfo, ServerPlayerClaimInfoManager>,
ObjectManagerIOExpirableObjectManager<ServerPlayerClaimInfo> {
    private final MinecraftServer server;
    private ServerClaimsManager claimsManager;
    private final IPlayerConfigManager configManager;
    private final ForceLoadTicketManager ticketManager;
    private final Set<ServerPlayerClaimInfo> toSave;
    private final Set<ResourceLocation> claimableDimensionsSet;
    private boolean loaded;
    private PlayerClaimInfoManagerIO<?> io;
    private ServerPlayerClaimsExpirationHandler expirationHandler;

    public ServerPlayerClaimInfoManager(MinecraftServer server, IPlayerConfigManager configManager, ForceLoadTicketManager ticketManager, Map<UUID, ServerPlayerClaimInfo> storage, LinkedChain<ServerPlayerClaimInfo> linkedPlayerInfo, Set<ServerPlayerClaimInfo> toSave) {
        super(storage, linkedPlayerInfo);
        this.server = server;
        this.configManager = configManager;
        this.ticketManager = ticketManager;
        this.toSave = toSave;
        this.claimableDimensionsSet = new HashSet<ResourceLocation>();
        for (String s : (List)ServerConfig.CONFIG.claimableDimensionsList.get()) {
            this.claimableDimensionsSet.add(new ResourceLocation(s));
        }
    }

    public void setClaimsManager(ServerClaimsManager claimsManager) {
        if (this.claimsManager != null) {
            throw new IllegalStateException();
        }
        this.claimsManager = claimsManager;
    }

    public void setIo(PlayerClaimInfoManagerIO<?> io) {
        if (this.io != null) {
            throw new IllegalStateException();
        }
        this.io = io;
    }

    public void setExpirationHandler(ServerPlayerClaimsExpirationHandler expirationHandler) {
        if (this.expirationHandler != null) {
            throw new IllegalStateException();
        }
        this.expirationHandler = expirationHandler;
    }

    public boolean isClaimable(ResourceLocation dimension) {
        boolean contains = this.claimableDimensionsSet.contains(dimension);
        return ServerConfig.CONFIG.claimableDimensionsListType.get() == ServerConfig.ConfigListType.ONLY && contains || ServerConfig.CONFIG.claimableDimensionsListType.get() == ServerConfig.ConfigListType.ALL_BUT && !contains;
    }

    @Override
    public void addToSave(ServerPlayerClaimInfo object) {
        this.toSave.add(object);
    }

    @Override
    public Iterable<ServerPlayerClaimInfo> getToSave() {
        return this.toSave;
    }

    public ForceLoadTicketManager getTicketManager() {
        return this.ticketManager;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void onLoad() {
        this.loaded = true;
    }

    public IPlayerConfig getConfig(UUID playerId) {
        return this.configManager.getLoadedConfig(playerId);
    }

    @Override
    protected ServerPlayerClaimInfo create(String username, UUID playerId, Map<ResourceLocation, PlayerDimensionClaims> claims) {
        return new ServerPlayerClaimInfo(this.getConfig(playerId), username, playerId, claims, this, new ArrayDeque<PlayerClaimReplaceSpreadoutTask>());
    }

    @Override
    protected void onAdd(ServerPlayerClaimInfo playerInfo) {
        super.onAdd(playerInfo);
        if (this.loaded) {
            this.getClaimsManager().getClaimsManagerSynchronizer().syncToPlayersSubClaimPropertiesUpdate(this.getConfig(playerInfo.getPlayerId()));
        }
    }

    @Override
    protected void onRemove(ServerPlayerClaimInfo playerInfo) {
        super.onRemove(playerInfo);
        this.io.delete(playerInfo);
        this.toSave.remove(playerInfo);
    }

    public int getPlayerBaseLimit(UUID playerId, ServerPlayer player, ModConfigSpec.IntValue limitConfig, IPermissionNodeAPI<Integer> permissionNode) {
        IPlayerPermissionSystemAPI permissionSystem = this.claimsManager.getPermissionHandler().getSystem();
        int defaultLimit = (Integer)limitConfig.get();
        if (permissionSystem == null) {
            return defaultLimit;
        }
        if (permissionNode == null || permissionNode.getNodeString().isEmpty()) {
            return defaultLimit;
        }
        if (player == null) {
            player = this.server.m_6846_().m_11259_(playerId);
        }
        if (player == null) {
            return defaultLimit;
        }
        return permissionSystem.getIntPermission(player, permissionNode).orElse(defaultLimit);
    }

    public ServerPlayerClaimsExpirationHandler getExpirationHandler() {
        return this.expirationHandler;
    }

    public ServerClaimsManager getClaimsManager() {
        return this.claimsManager;
    }

    @Override
    public Iterator<ServerPlayerClaimInfo> getExpirationIterator() {
        return this.iterator();
    }
}

