/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.command;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.command.ClaimsClaimCommands;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ConfigSubListCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        Command<CommandSourceStack> regularExecutor = ConfigSubListCommand.getExecutor(PlayerConfigType.PLAYER);
        Command<CommandSourceStack> serverExecutor = ConfigSubListCommand.getExecutor(PlayerConfigType.SERVER);
        Predicate<CommandSourceStack> serverRequirement = ClaimsClaimCommands.getServerClaimCommandRequirement();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"openpac").then(Commands.m_82127_((String)"player-config").then(this.getMainCommandPart(regularExecutor)));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.m_82127_((String)"openpac").then(Commands.m_82127_((String)"player-config").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"for").requires(sourceStack -> sourceStack.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).then(this.getMainCommandPart(regularExecutor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.m_82127_((String)"openpac").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"server-claims-config").requires(serverRequirement)).then(this.getMainCommandPart(serverExecutor)));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<CommandSourceStack> getMainCommandPart(Command<CommandSourceStack> executor) {
        return (LiteralArgumentBuilder)Commands.m_82127_((String)"sub").then(Commands.m_82127_((String)"list").then(Commands.m_82129_((String)"start-at", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(executor)));
    }

    private static Command<CommandSourceStack> getExecutor(PlayerConfigType type) {
        return context -> {
            UUID configPlayerUUID;
            ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            if (type == PlayerConfigType.PLAYER) {
                GameProfile inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<CommandSourceStack>)context, sourcePlayer, "gui.xaero_pac_config_sub_list_too_many_targets", "gui.xaero_pac_config_sub_list_invalid_target", adaptiveLocalizer);
                if (inputPlayer == null) {
                    return 0;
                }
                configPlayerUUID = inputPlayer.getId();
            } else {
                configPlayerUUID = PlayerConfig.SERVER_CLAIM_UUID;
            }
            PlayerConfig playerConfig = (PlayerConfig)serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID);
            List<String> subConfigIds = playerConfig.getSubConfigIds();
            int startAt = IntegerArgumentType.getInteger((CommandContext)context, (String)"start-at");
            if (startAt >= subConfigIds.size()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_sub_list_bad_start", subConfigIds.size()));
                return 0;
            }
            if (startAt < 0) {
                startAt = 0;
            }
            int endAt = Math.min(startAt + 64, subConfigIds.size());
            MutableComponent listMessage = adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_sub_list", startAt + 1, subConfigIds.size());
            for (int i = startAt; i < endAt; ++i) {
                if (i != startAt) {
                    listMessage.m_7360_().add(adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_sub_list_separator", new Object[0]));
                }
                listMessage.m_7360_().add(Component.m_237113_((String)subConfigIds.get(i)));
            }
            if (endAt < subConfigIds.size()) {
                listMessage.m_7360_().add(adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_pac_config_sub_list_there_is_more", new Object[0]));
            }
            sourcePlayer.m_213846_((Component)listMessage);
            return 1;
        };
    }
}

