/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.party.IPartyManager;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class AboutPartyCommand {
    private static final int MAX_MEMBER_COUNT = 32;
    private static final int MAX_ALLY_COUNT = 32;
    private static final int MAX_INVITES_COUNT = 16;

    private static <T> int createLimitedList(Component listComponent, int maxCount, Iterator<T> iterator, Consumer<T> adder) {
        int count = 0;
        while (iterator.hasNext()) {
            adder.accept(iterator.next());
            if (++count != maxCount) continue;
            listComponent.getSiblings().add(Component.literal((String)" ..."));
            break;
        }
        return count;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Command action = context -> {
            Object tooltipPrefix;
            Object targetProfile;
            ServerPlayer casterPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                Collection profiles = GameProfileArgument.getGameProfiles((CommandContext)context, (String)"profile");
                targetProfile = profiles.size() == 1 ? (NameAndId)profiles.iterator().next() : null;
            }
            catch (IllegalArgumentException iae) {
                try {
                    ServerPlayer inputPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"player");
                    targetProfile = inputPlayer != null ? inputPlayer.nameAndId() : null;
                }
                catch (IllegalArgumentException iae2) {
                    targetProfile = casterPlayer.nameAndId();
                }
            }
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(((CommandSourceStack)context.getSource()).getServer());
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            if (targetProfile == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_about_invalid_player", new Object[0]));
                return 0;
            }
            NameAndId profile = targetProfile;
            UUID casterPlayerId = casterPlayer.getUUID();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(profile.id());
            if (playerParty == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_about_no_party", profile.name()));
                return 0;
            }
            casterPlayer.sendSystemMessage((Component)Component.literal((String)""));
            casterPlayer.sendSystemMessage((Component)Component.literal((String)"===== Open Parties and Claims").withStyle(s -> s.withColor(ChatFormatting.GRAY)));
            casterPlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_player", new Object[0]).withStyle(s -> s.withColor(ChatFormatting.GOLD)));
            casterPlayer.sendSystemMessage((Component)Component.literal((String)profile.name()).withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)profile.id().toString())))));
            casterPlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_current_party", new Object[0]).withStyle(s -> s.withColor(ChatFormatting.GOLD)));
            String partyName = playerParty.getDefaultName();
            IPlayerConfig ownerConfig = serverData.getPlayerConfigs().getLoadedConfig(playerParty.getOwner().getUUID());
            String partyCustomName = ownerConfig.getEffective(PlayerConfigOptions.PARTY_NAME);
            Object object = tooltipPrefix = !partyCustomName.isEmpty() ? partyName + "\n" : "";
            if (!partyCustomName.isEmpty()) {
                partyName = partyCustomName;
            }
            casterPlayer.sendSystemMessage((Component)Component.literal((String)partyName).withStyle(arg_0 -> AboutPartyCommand.lambda$register$4((String)tooltipPrefix, (IServerParty)playerParty, arg_0)));
            casterPlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_members", playerParty.getMemberCount() + "/" + String.valueOf(ServerConfig.CONFIG.maxPartyMembers.get())).withStyle(s -> s.withColor(ChatFormatting.GOLD)));
            MutableComponent partyMembersComponent = Component.literal((String)"");
            Consumer<IPartyMember> partyMemberConsumer = arg_0 -> AboutPartyCommand.lambda$register$8((Component)partyMembersComponent, (IServerParty)playerParty, adaptiveLocalizer, casterPlayer, arg_0);
            int staffCount = AboutPartyCommand.createLimitedList((Component)partyMembersComponent, 32, playerParty.getTypedStaffInfoStream().iterator(), partyMemberConsumer);
            if (staffCount < 32) {
                AboutPartyCommand.createLimitedList((Component)partyMembersComponent, 32 - staffCount, playerParty.getTypedNonStaffInfoStream().iterator(), partyMemberConsumer);
            }
            casterPlayer.sendSystemMessage((Component)partyMembersComponent);
            casterPlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_allies", playerParty.getAllyCount() + "/" + String.valueOf(ServerConfig.CONFIG.maxPartyAllies.get())).withStyle(s -> s.withColor(ChatFormatting.GOLD)));
            MutableComponent partyAlliesComponent = Component.literal((String)"");
            AboutPartyCommand.createLimitedList((Component)partyAlliesComponent, 32, playerParty.getTypedAllyPartiesStream().iterator(), arg_0 -> AboutPartyCommand.lambda$register$11((IPartyManager)partyManager, (Component)partyAlliesComponent, serverData, arg_0));
            if (partyAlliesComponent.getSiblings().isEmpty()) {
                casterPlayer.sendSystemMessage((Component)Component.literal((String)"N/A").withStyle(s -> s.withColor(ChatFormatting.GRAY)));
            } else {
                casterPlayer.sendSystemMessage((Component)partyAlliesComponent);
            }
            casterPlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(casterPlayer, "gui.xaero_parties_party_invited", playerParty.getInviteCount() + "/" + String.valueOf(ServerConfig.CONFIG.maxPartyInvites.get())).withStyle(s -> s.withColor(ChatFormatting.GOLD)));
            MutableComponent invitedComponent = Component.literal((String)"");
            AboutPartyCommand.createLimitedList((Component)invitedComponent, 16, playerParty.getTypedInvitedPlayersStream().iterator(), arg_0 -> AboutPartyCommand.lambda$register$15((Component)invitedComponent, arg_0));
            if (invitedComponent.getSiblings().isEmpty()) {
                casterPlayer.sendSystemMessage((Component)Component.literal((String)"N/A").withStyle(s -> s.withColor(ChatFormatting.GRAY)));
            } else {
                casterPlayer.sendSystemMessage((Component)invitedComponent);
            }
            casterPlayer.sendSystemMessage((Component)Component.literal((String)"=====").withStyle(s -> s.withColor(ChatFormatting.GRAY)));
            return 1;
        };
        SuggestionProvider suggestions = (context, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerlist.getPlayers().stream().map(targetPlayer -> targetPlayer.getGameProfile().name()), (SuggestionsBuilder)builder);
        };
        LiteralArgumentBuilder normalCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(Commands.literal((String)"about").executes(action));
        dispatcher.register(normalCommand);
        LiteralArgumentBuilder targetCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(Commands.literal((String)"about").then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(c -> !c.hasPermission(2))).suggests(suggestions).executes(action)));
        dispatcher.register(targetCommand);
        LiteralArgumentBuilder opTargetCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(Commands.literal((String)"about").then(((RequiredArgumentBuilder)Commands.argument((String)"profile", (ArgumentType)GameProfileArgument.gameProfile()).requires(c -> c.hasPermission(2))).suggests(suggestions).executes(action)));
        dispatcher.register(opTargetCommand);
    }

    private static /* synthetic */ void lambda$register$15(Component invitedComponent, IPartyPlayerInfo pi) {
        if (!invitedComponent.getSiblings().isEmpty()) {
            invitedComponent.getSiblings().add(Component.literal((String)", "));
        }
        invitedComponent.getSiblings().add(Component.literal((String)pi.getUsername()).withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)pi.getUUID().toString())))));
    }

    private static /* synthetic */ void lambda$register$11(IPartyManager partyManager, Component partyAlliesComponent, IServerData serverData, IPartyAlly ally) {
        IServerPartyAPI allyParty = partyManager.getPartyById(ally.getPartyId());
        if (allyParty != null) {
            if (!partyAlliesComponent.getSiblings().isEmpty()) {
                partyAlliesComponent.getSiblings().add(Component.literal((String)", "));
            }
            IPlayerConfig allyOwnerConfig = serverData.getPlayerConfigs().getLoadedConfig(allyParty.getOwner().getUUID());
            String configuredAllyName = allyOwnerConfig.getEffective(PlayerConfigOptions.PARTY_NAME);
            String allyDefaultName = allyParty.getDefaultName();
            Object allyTooltipPrefix = !configuredAllyName.isEmpty() ? allyDefaultName + "\n" : "";
            partyAlliesComponent.getSiblings().add(Component.literal((String)(configuredAllyName.isEmpty() ? allyDefaultName : configuredAllyName)).withStyle(arg_0 -> AboutPartyCommand.lambda$register$10((String)allyTooltipPrefix, (IServerParty)allyParty, arg_0)));
        }
    }

    private static /* synthetic */ Style lambda$register$10(String allyTooltipPrefix, IServerParty allyParty, Style s) {
        return s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)(allyTooltipPrefix + allyParty.getId().toString()))));
    }

    private static /* synthetic */ void lambda$register$8(Component partyMembersComponent, IServerParty playerParty, AdaptiveLocalizer adaptiveLocalizer, ServerPlayer casterPlayer, IPartyMember mi) {
        if (!partyMembersComponent.getSiblings().isEmpty()) {
            partyMembersComponent.getSiblings().add(Component.literal((String)", "));
        }
        partyMembersComponent.getSiblings().add(Component.literal((String)mi.getUsername()).withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)mi.getUUID().toString())))));
        if (mi.getRank() != PartyMemberRank.MEMBER) {
            MutableComponent rankComponent = Component.literal((String)(playerParty.getOwner() == mi ? "OWNER" : mi.getRank().toString())).withStyle(s -> s.withColor(mi.getRank().getColor()));
            partyMembersComponent.getSiblings().add(adaptiveLocalizer.getFor(casterPlayer, "[%s]", rankComponent));
        }
    }

    private static /* synthetic */ Style lambda$register$4(String tooltipPrefix, IServerParty playerParty, Style s) {
        return s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)(tooltipPrefix + playerParty.getId().toString()))));
    }
}

