/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.mods.create;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.core.ServerCore;
import xaero.pac.common.server.core.accessor.ICreateContraptionEntity;
import xaero.pac.common.server.world.ServerLevelHelper;

public class CreateContraptionHelper {
    public static ResourceKey<Block> CONTRAPTION_CONTROLS_BLOCK = ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)"contraption_controls"));
    public static final String PLACEMENT_POS_TAG = "xaero_OPAC_placementPos";

    public static void handleCreateContraptionAdded(Entity entity, ICreateContraptionEntity contraptionEntity) {
        CompoundTag placementPosData;
        CompoundTag persistentData = Services.PLATFORM.getEntityAccess().getPersistentData(entity);
        if (ServerCore.isPlacingCreateContraption(ServerLevelHelper.getServer(entity))) {
            placementPosData = new CompoundTag();
            placementPosData.putInt("x", entity.blockPosition().getX());
            placementPosData.putInt("y", entity.blockPosition().getY());
            placementPosData.putInt("z", entity.blockPosition().getZ());
            persistentData.put(PLACEMENT_POS_TAG, (Tag)placementPosData);
        }
        if (persistentData.contains(PLACEMENT_POS_TAG)) {
            placementPosData = persistentData.getCompoundOrEmpty(PLACEMENT_POS_TAG);
            BlockPos persistentPlacementPos = new BlockPos(placementPosData.getIntOr("x", 0), placementPosData.getIntOr("y", 0), placementPosData.getIntOr("z", 0));
            contraptionEntity.getXaero_OPAC_contraption().setXaero_OPAC_placementPos(persistentPlacementPos);
        }
    }
}

