/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.expiration.task;

import java.util.Iterator;
import java.util.List;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.expiration.ObjectExpirationHandler;
import xaero.pac.common.server.expiration.ObjectManagerIOExpirableObject;
import xaero.pac.common.server.info.ServerInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.task.IServerSpreadoutQueuedTask;

public class ObjectExpirationCheckSpreadoutTask<T extends ObjectManagerIOExpirableObject>
implements IServerSpreadoutQueuedTask<ObjectExpirationCheckSpreadoutTask<?>> {
    private final ObjectExpirationHandler<T, ?> expirationHandler;
    private final Iterator<T> iterator;
    private boolean finished;

    public ObjectExpirationCheckSpreadoutTask(ObjectExpirationHandler<T, ?> expirationHandler, Iterator<T> iterator) {
        this.expirationHandler = expirationHandler;
        this.iterator = iterator;
    }

    @Override
    public void onQueued(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData) {
    }

    @Override
    public boolean shouldWork(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, ObjectExpirationCheckSpreadoutTask<?> holder) {
        return !this.shouldDrop(serverData, holder);
    }

    @Override
    public boolean shouldDrop(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, ObjectExpirationCheckSpreadoutTask<?> holder) {
        return this.finished;
    }

    @Override
    public void onTick(IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData, ObjectExpirationCheckSpreadoutTask<?> holder, int perTick, List<ObjectExpirationCheckSpreadoutTask<?>> tasksToAdd) {
        ServerInfo serverInfo = this.expirationHandler.getServerInfo();
        long expirationTime = this.expirationHandler.getExpirationTime();
        for (int stepsLeft = perTick; !this.expirationHandler.isExpiringAnElement() && this.iterator.hasNext() && stepsLeft > 0; --stepsLeft) {
            ObjectManagerIOExpirableObject object = (ObjectManagerIOExpirableObject)this.iterator.next();
            this.expirationHandler.preExpirationCheck(object);
            if (object.getRegisteredActivity() > serverInfo.getTotalUseTime()) {
                OpenPartiesAndClaims.LOGGER.warn("Mod use time seems to have been reset! This could happen due to the data/server-info.nbt file corruption, with a backup being likely created. Defaulting to the time of a registered activity...");
                serverInfo.setTotalUseTime(object.getRegisteredActivity());
                serverData.getServerInfoIO().save();
            }
            if (this.expirationHandler.checkIfActive(object)) {
                object.registerActivity(serverInfo);
                continue;
            }
            if (serverInfo.getTotalUseTime() - object.getRegisteredActivity() <= expirationTime) continue;
            OpenPartiesAndClaims.LOGGER.debug("Object expired and is being removed: " + String.valueOf(object));
            this.expirationHandler.onElementExpirationBegin();
            if (!this.expirationHandler.expire(object, serverData)) continue;
            this.expirationHandler.onElementExpirationDone();
            stepsLeft -= 2;
        }
        if (!this.iterator.hasNext()) {
            this.expirationHandler.onIterationDone();
            this.finished = true;
        }
    }
}

