/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.packet;

import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPlayPayloadHandler;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import xaero.pac.common.packet.payload.PacketPayload;
import xaero.pac.common.packet.type.PacketType;

public class PacketPayloadHandler
implements IPlayPayloadHandler<PacketPayload<?>> {
    public void handle(PacketPayload<?> payload, PlayPayloadContext context) {
        this.handleTyped(payload, context);
    }

    private <P> void handleTyped(PacketPayload<P> payload, PlayPayloadContext context) {
        PacketType packetType = payload.getPacketType();
        if (packetType == null) {
            return;
        }
        Object packet = payload.getPacket();
        if (packet == null) {
            return;
        }
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            if (packetType.getClientHandler() == null) {
                return;
            }
            context.workHandler().execute(() -> packetType.getClientHandler().accept(packet));
            return;
        }
        if (packetType.getServerHandler() == null) {
            return;
        }
        if (context.flow() != PacketFlow.SERVERBOUND) {
            return;
        }
        if (context.player().isEmpty()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)context.player().get();
        context.workHandler().execute(() -> packetType.getServerHandler().accept(packet, player));
    }
}

