/*
 * Open Parties and Claims - adds chunk claims and player parties to Minecraft
 * Copyright (C) 2022-2026, Xaero <xaero1996@gmail.com> and contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of version 3 of the GNU Lesser General Public License
 * (LGPL-3.0-only) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received copies of the GNU Lesser General Public License
 * and the GNU General Public License along with this program.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package xaero.pac.common.server.io.serialization.human;

import xaero.pac.common.server.io.serialization.SerializedDataFileIO;

import java.io.*;
import java.nio.charset.StandardCharsets;

public class HumanReadableSerializedDataFileIO
<
	S, 
	I
> 
	implements SerializedDataFileIO<S, I> {
	
	private final HumanReadableStringConverter<S,I> converter;
	
	public HumanReadableSerializedDataFileIO(HumanReadableStringConverter<S,I> converter) {
		this.converter = converter;
	}

	@Override
	public S read(I id, BufferedInputStream fileInput) throws IOException {
		try(BufferedReader reader = new BufferedReader(new InputStreamReader(fileInput, "UTF8"))){
			StringBuilder stringBuilder = new StringBuilder();
			reader.lines().forEach(line -> {stringBuilder.append(line); stringBuilder.append('\n');});
			return converter.convert(id, stringBuilder.toString());
		} 
	}

	@Override
	public void write(BufferedOutputStream fileOutput, S serializedData) throws IOException {
		try(OutputStreamWriter writer = new OutputStreamWriter(fileOutput, StandardCharsets.UTF_8);){
			writer.write(converter.convert(serializedData));
			writer.close();
		}
	}

}
