/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ExceptionElementType<T> {
    private static final List<ExceptionElementType<?>> TYPES = new ArrayList();
    public static final ExceptionElementType<Block> BLOCK = new ExceptionElementType(Registries.BLOCK, Block.class);
    public static final ExceptionElementType<EntityType<?>> ENTITY_TYPE = new ExceptionElementType(Registries.ENTITY_TYPE, EntityType.class);
    public static final ExceptionElementType<Item> ITEM = new ExceptionElementType(Registries.ITEM, Item.class);
    private final ResourceKey<Registry<T>> registryResourceKey;
    private Iterable<T> iterable;
    private Iterable<TagKey<T>> tagIterable;
    private Class<?> type;

    public ExceptionElementType(ResourceKey<Registry<T>> registryResourceKey, Class<?> type) {
        this.registryResourceKey = registryResourceKey;
        this.type = type;
        TYPES.add(this);
    }

    public Registry<T> getRegistry(MinecraftServer server) {
        return (Registry)server.registryAccess().registry(this.registryResourceKey).orElseThrow();
    }

    public Iterable<T> getIterable() {
        return this.iterable;
    }

    public Iterable<TagKey<T>> getTagIterable() {
        return this.tagIterable;
    }

    public static void updateAllIterables(MinecraftServer server) {
        TYPES.forEach(type -> type.updateIterables(server));
    }

    public Class<?> getType() {
        return this.type;
    }

    public static void clearAllIterables() {
        TYPES.forEach(type -> {
            type.iterable = null;
            type.tagIterable = null;
        });
    }

    private void updateIterables(MinecraftServer server) {
        Registry<T> registry = this.getRegistry(server);
        this.iterable = registry.stream().toList();
        this.tagIterable = registry.getTags().map(Pair::getFirst).toList();
    }
}

