/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.client.claims.api.IClientClaimsManagerAPI;
import xaero.pac.client.claims.player.IClientPlayerClaimInfo;
import xaero.pac.client.command.util.CommandUtil;
import xaero.pac.client.controls.keybinding.IKeyBindingHelper;
import xaero.pac.client.gui.ConfigMenu;
import xaero.pac.client.gui.XPACScreen;
import xaero.pac.client.gui.component.CachedComponentSupplier;
import xaero.pac.client.parties.party.IClientParty;
import xaero.pac.client.parties.party.IClientPartyAllyInfo;
import xaero.pac.client.parties.party.IClientPartyMemberDynamicInfoSyncableStorage;
import xaero.pac.client.parties.party.IClientPartyStorage;
import xaero.pac.client.world.capability.ClientWorldMainCapability;
import xaero.pac.client.world.capability.api.ClientWorldCapabilityTypes;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.packet.LazyPacketsConfirmationPacket;
import xaero.pac.common.parties.party.IPartyMemberDynamicInfoSyncable;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.platform.Services;
import xaero.pac.common.server.player.config.PlayerConfig;

public class MainMenu
extends XPACScreen {
    public static final Component NO_HANDSHAKE = Component.translatable((String)"gui.xaero_pac_ui_handshake_not_received");
    public static final Component NO_PARTIES = Component.translatable((String)"gui.xaero_pac_ui_parties_disabled");
    public static final Component NO_CLAIMS = Component.translatable((String)"gui.xaero_pac_ui_claims_disabled");
    public static final Component PARTY_SYNCING = Component.translatable((String)"gui.xaero_pac_ui_party_syncing");
    public static final Component CLAIMS_SYNCING = Component.translatable((String)"gui.xaero_pac_ui_claims_syncing");
    private static final Component ABOUT_PARTY_COMMAND = Component.literal((String)"/openpac-parties about");
    public static final Component CLAIM = Component.translatable((String)"gui.xaero_pac_ui_claim");
    public static final Component UNCLAIM = Component.translatable((String)"gui.xaero_pac_ui_unclaim");
    private static final Component CLAIM_COMMAND = Component.literal((String)"/openpac-claims claim");
    private static final Component UNCLAIM_COMMAND = Component.literal((String)"/openpac-claims unclaim");
    public static final Component FORCELOAD = Component.translatable((String)"gui.xaero_pac_ui_forceload");
    public static final Component UNFORCELOAD = Component.translatable((String)"gui.xaero_pac_ui_unforceload");
    private static final Component FORCELOAD_COMMAND = Component.literal((String)"/openpac-claims forceload");
    private static final Component UNFORCELOAD_COMMAND = Component.literal((String)"/openpac-claims unforceload");
    private static final CachedComponentSupplier partyNameSupplier = new CachedComponentSupplier(args -> {
        String currentPartyName = (String)args[0];
        return Component.translatable((String)"gui.xaero_pac_ui_party_name", (Object[])new Object[]{Component.literal((String)currentPartyName).withStyle(s -> s.withColor(-5592406))});
    });
    private static final CachedComponentSupplier ownerNameSupplier = new CachedComponentSupplier(args -> {
        String currentOwnerName = (String)args[0];
        return Component.translatable((String)"gui.xaero_pac_ui_party_owner", (Object[])new Object[]{Component.literal((String)currentOwnerName).withStyle(s -> s.withColor(-5592406))});
    });
    private static final CachedComponentSupplier memberCountSupplier = new CachedComponentSupplier(args -> {
        int currentMemberCount = (Integer)args[0];
        int currentMemberLimit = (Integer)args[1];
        return Component.translatable((String)"gui.xaero_pac_ui_party_member_count", (Object[])new Object[]{Component.literal((String)(currentMemberCount + " / " + currentMemberLimit)).withStyle(s -> s.withColor(-5592406))});
    });
    private static final CachedComponentSupplier allyCountSupplier = new CachedComponentSupplier(args -> {
        int currentAllyCount = (Integer)args[0];
        int currentAllyLimit = (Integer)args[1];
        return Component.translatable((String)"gui.xaero_pac_ui_party_ally_count", (Object[])new Object[]{Component.literal((String)(currentAllyCount + " / " + currentAllyLimit)).withStyle(s -> s.withColor(-5592406))});
    });
    private static final CachedComponentSupplier inviteCountSupplier = new CachedComponentSupplier(args -> {
        int currentInviteCount = (Integer)args[0];
        int currentInviteLimit = (Integer)args[1];
        return Component.translatable((String)"gui.xaero_pac_ui_party_invite_count", (Object[])new Object[]{Component.literal((String)(currentInviteCount + " / " + currentInviteLimit)).withStyle(s -> s.withColor(-5592406))});
    });
    private static final CachedComponentSupplier claimsNameSupplier = new CachedComponentSupplier(args -> {
        String currentClaimsName = (String)args[0];
        MutableComponent nameComponent = Component.literal((String)currentClaimsName).withStyle(s -> s.withColor(-5592406));
        return Component.translatable((String)"gui.xaero_pac_ui_claims_name", (Object[])new Object[]{nameComponent});
    });
    private static final CachedComponentSupplier claimCountSupplier = new CachedComponentSupplier(args -> {
        int currentClaimCount = (Integer)args[0];
        int currentClaimLimit = (Integer)args[1];
        MutableComponent numbers = Component.literal((String)(currentClaimCount + " / " + currentClaimLimit)).withStyle(s -> s.withColor(-5592406));
        return Component.translatable((String)"gui.xaero_pac_ui_claim_count", (Object[])new Object[]{numbers});
    });
    private static final CachedComponentSupplier forceloadCountSupplier = new CachedComponentSupplier(args -> {
        int currentForceloadCount = (Integer)args[0];
        int currentForceloadLimit = (Integer)args[1];
        return Component.translatable((String)"gui.xaero_pac_ui_forceload_count", (Object[])new Object[]{Component.literal((String)(currentForceloadCount + " / " + currentForceloadLimit)).withStyle(s -> s.withColor(-5592406))});
    });
    private static final CachedComponentSupplier claimsColorSupplier = new CachedComponentSupplier(args -> {
        int currentClaimColor = (Integer)args[0];
        MutableComponent colorComponent = Component.literal((String)Integer.toUnsignedString(currentClaimColor, 16).toUpperCase()).withStyle(s -> s.withColor(currentClaimColor));
        return Component.translatable((String)"gui.xaero_pac_ui_claims_color", (Object[])new Object[]{colorComponent});
    });
    private boolean serverHasMod;
    private boolean serverHasClaimsEnabled;
    private boolean serverHasPartiesEnabled;
    private Button configsButton;
    private Button aboutPartyButton;
    private Button claimButton;
    private Button forceloadButton;
    public static boolean TEST_TOGGLE;

    public MainMenu(Screen escape, Screen parent) {
        super(escape, parent, (Component)Component.translatable((String)"gui.xaero_pac_ui_main_menu"));
    }

    @Override
    protected void init() {
        super.init();
        this.configsButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_ui_config_menu"), this::onConfigsButton).bounds(this.width / 2 - 100, this.height / 7 + 8, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.configsButton);
        this.aboutPartyButton = Button.builder((Component)Component.translatable((String)"gui.xaero_pac_ui_about_party"), this::onAboutPartyButton).tooltip(Tooltip.create((Component)ABOUT_PARTY_COMMAND)).bounds(this.width / 2 - 100, this.height / 7 + 40, 70, 20).build();
        this.claimButton = Button.builder((Component)CLAIM, this::onClaimButton).tooltip(Tooltip.create((Component)CLAIM_COMMAND)).bounds(this.width / 2 - 100, this.height / 7 + 112, 70, 20).build();
        this.forceloadButton = Button.builder((Component)FORCELOAD, this::onForceloadButton).tooltip(Tooltip.create((Component)FORCELOAD_COMMAND)).bounds(this.width / 2 - 100, this.height / 7 + 136, 70, 20).build();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.xaero_pac_back"), this::onBackButton).bounds(this.width / 2 - 100, this.height / 6 + 168, 200, 20).build());
        this.updateButtons();
        if (this.serverHasPartiesEnabled) {
            this.addRenderableWidget((GuiEventListener)this.aboutPartyButton);
        }
        if (this.serverHasClaimsEnabled) {
            this.addRenderableWidget((GuiEventListener)this.claimButton);
            this.addRenderableWidget((GuiEventListener)this.forceloadButton);
        }
    }

    private void onTestToggle(Button button) {
        boolean bl = TEST_TOGGLE = !TEST_TOGGLE;
        if (!TEST_TOGGLE) {
            OpenPartiesAndClaims.INSTANCE.getPacketHandler().sendToServer(new LazyPacketsConfirmationPacket());
        }
        OpenPartiesAndClaims.LOGGER.info("test toggle set to " + TEST_TOGGLE);
    }

    private void updateButtons() {
        ClientWorldMainCapability mainCap = (ClientWorldMainCapability)OpenPartiesAndClaims.INSTANCE.getCapabilityHelper().getCapability(this.minecraft.level, ClientWorldCapabilityTypes.MAIN_CAP);
        this.serverHasMod = this.configsButton.active = mainCap.getClientWorldData().serverHasMod();
        this.serverHasClaimsEnabled = mainCap.getClientWorldData().serverHasClaimsEnabled();
        this.serverHasPartiesEnabled = mainCap.getClientWorldData().serverHasPartiesEnabled();
        this.aboutPartyButton.active = this.serverHasMod && OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty() != null;
        this.forceloadButton.active = false;
        this.claimButton.active = false;
        if (this.serverHasMod && !OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isLoading()) {
            IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.minecraft.level.dimension().location(), this.minecraft.player.chunkPosition().x, this.minecraft.player.chunkPosition().z);
            boolean adminMode = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isAdminMode();
            boolean serverMode = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isServerMode();
            UUID claimTargetUUID = serverMode ? PlayerConfig.SERVER_CLAIM_UUID : this.minecraft.player.getUUID();
            this.claimButton.active = adminMode || currentClaim == null || currentClaim.getPlayerId().equals(claimTargetUUID);
            boolean wouldClaim = this.wouldClaim(currentClaim);
            this.claimButton.setMessage(wouldClaim ? CLAIM : UNCLAIM);
            this.claimButton.setTooltip(Tooltip.create((Component)(wouldClaim ? CLAIM_COMMAND : UNCLAIM_COMMAND)));
            this.forceloadButton.active = adminMode || currentClaim != null && currentClaim.getPlayerId().equals(claimTargetUUID);
            boolean wouldForceload = currentClaim == null || !currentClaim.isForceloadable();
            this.forceloadButton.setMessage(wouldForceload ? FORCELOAD : UNFORCELOAD);
            this.forceloadButton.setTooltip(Tooltip.create((Component)(wouldForceload ? FORCELOAD_COMMAND : UNFORCELOAD_COMMAND)));
        }
    }

    private void onConfigsButton(Button b) {
        this.minecraft.setScreen((Screen)new ConfigMenu(this.escape, this));
    }

    private void onAboutPartyButton(Button b) {
        CommandUtil.sendCommand(this.minecraft, ABOUT_PARTY_COMMAND.getString().substring(1));
        this.minecraft.setScreen(null);
    }

    private boolean wouldClaim(IPlayerChunkClaim currentClaim) {
        if (currentClaim == null) {
            return true;
        }
        IPlayerChunkClaim potentialClaimReflection = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().getPotentialClaimStateReflection();
        return !currentClaim.isSameClaimType(potentialClaimReflection);
    }

    private void onClaimButton(Button b) {
        IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.minecraft.level.dimension().location(), this.minecraft.player.chunkPosition().x, this.minecraft.player.chunkPosition().z);
        if (this.wouldClaim(currentClaim)) {
            CommandUtil.sendCommand(this.minecraft, CLAIM_COMMAND.getString().substring(1));
        } else {
            CommandUtil.sendCommand(this.minecraft, UNCLAIM_COMMAND.getString().substring(1));
        }
        this.onClose();
    }

    private void onForceloadButton(Button b) {
        IPlayerChunkClaim currentClaim = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().get(this.minecraft.level.dimension().location(), this.minecraft.player.chunkPosition().x, this.minecraft.player.chunkPosition().z);
        if (currentClaim == null) {
            return;
        }
        if (!currentClaim.isForceloadable()) {
            CommandUtil.sendCommand(this.minecraft, FORCELOAD_COMMAND.getString().substring(1));
        } else {
            CommandUtil.sendCommand(this.minecraft, UNFORCELOAD_COMMAND.getString().substring(1));
        }
        this.onClose();
    }

    private void onBackButton(Button b) {
        this.goBack();
    }

    private void drawPartyInfo(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        IClientPartyStorage<IClientPartyAllyInfo, IClientParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>, IClientPartyMemberDynamicInfoSyncableStorage<IPartyMemberDynamicInfoSyncable>> partyStorage = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage();
        String actualPartyName = partyStorage.getPartyName();
        if (actualPartyName == null || actualPartyName.isEmpty()) {
            actualPartyName = "N/A";
        }
        guiGraphics.drawString(this.font, partyNameSupplier.get(actualPartyName), this.width / 2 - 24, this.height / 7 + 42, -1);
        if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().getParty() != null) {
            String actualOwnerName = partyStorage.getParty().getOwner().getUsername();
            guiGraphics.drawString(this.font, ownerNameSupplier.get(actualOwnerName), this.width / 2 - 24, this.height / 7 + 54, -1);
            guiGraphics.drawString(this.font, memberCountSupplier.get(partyStorage.getUIMemberCount(), partyStorage.getMemberLimit()), this.width / 2 - 24, this.height / 7 + 66, -1);
            guiGraphics.drawString(this.font, allyCountSupplier.get(partyStorage.getUIAllyCount(), partyStorage.getAllyLimit()), this.width / 2 - 24, this.height / 7 + 78, -1);
            guiGraphics.drawString(this.font, inviteCountSupplier.get(partyStorage.getUIInviteCount(), partyStorage.getInviteLimit()), this.width / 2 - 24, this.height / 7 + 90, -1);
        }
    }

    private void drawClaimsInfo(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        IClientClaimsManagerAPI claimsManager = OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager();
        if (claimsManager.hasPlayerInfo(this.minecraft.player.getUUID())) {
            IClientPlayerClaimInfo playerInfo = (IClientPlayerClaimInfo)claimsManager.getPlayerInfo(this.minecraft.player.getUUID());
            boolean shouldUseLoadingValues = claimsManager.isLoading() || claimsManager.getAlwaysUseLoadingValues();
            int claimCount = shouldUseLoadingValues ? claimsManager.getLoadingClaimCount() : playerInfo.getClaimCount();
            int claimLimit = claimsManager.getClaimLimit();
            int forceloadCount = shouldUseLoadingValues ? claimsManager.getLoadingForceloadCount() : playerInfo.getForceloadCount();
            int forceloadLimit = claimsManager.getForceloadLimit();
            int currentSubConfigIndex = claimsManager.getCurrentSubConfigIndex();
            Object claimsName = playerInfo.getClaimsName(currentSubConfigIndex);
            if (claimsName == null && currentSubConfigIndex != -1) {
                claimsName = playerInfo.getClaimsName();
            }
            if (claimsName == null || ((String)claimsName).isEmpty()) {
                claimsName = "N/A";
            }
            claimsName = (String)claimsName + " (" + claimsManager.getCurrentSubConfigId() + ")";
            Integer claimsColor = playerInfo.getClaimsColor(currentSubConfigIndex);
            if (claimsColor == null && currentSubConfigIndex != -1) {
                claimsColor = playerInfo.getClaimsColor();
            }
            guiGraphics.drawString(this.font, claimCountSupplier.get(claimCount, claimLimit), this.width / 2 - 24, this.height / 7 + 114, -1);
            guiGraphics.drawString(this.font, forceloadCountSupplier.get(forceloadCount, forceloadLimit), this.width / 2 - 24, this.height / 7 + 126, -1);
            guiGraphics.drawString(this.font, claimsNameSupplier.get(claimsName), this.width / 2 - 24, this.height / 7 + 138, -1);
            guiGraphics.drawString(this.font, claimsColorSupplier.get(claimsColor), this.width / 2 - 24, this.height / 7 + 150, -1);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partial);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 16, -1);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        this.updateButtons();
        super.render(guiGraphics, mouseX, mouseY, partial);
        if (!this.serverHasMod) {
            guiGraphics.drawCenteredString(this.font, NO_HANDSHAKE, this.width / 2, 27, -43691);
        } else {
            if (this.serverHasPartiesEnabled) {
                if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClientPartyStorage().isLoading()) {
                    guiGraphics.drawString(this.font, PARTY_SYNCING, this.width / 2 - 104 - this.font.width((FormattedText)PARTY_SYNCING), this.height / 7 + 42, -1);
                }
                this.drawPartyInfo(guiGraphics, mouseX, mouseY, partial);
            } else {
                guiGraphics.drawCenteredString(this.font, NO_PARTIES, this.width / 2, this.height / 7 + 42, -5592406);
            }
            if (this.serverHasClaimsEnabled) {
                if (OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getClaimsManager().isLoading()) {
                    guiGraphics.drawString(this.font, CLAIMS_SYNCING, this.width / 2 - 104 - this.font.width((FormattedText)CLAIMS_SYNCING), this.height / 7 + 114, -1);
                }
                this.drawClaimsInfo(guiGraphics, mouseX, mouseY, partial);
            } else {
                guiGraphics.drawCenteredString(this.font, NO_CLAIMS, this.width / 2, this.height / 7 + 114, -5592406);
            }
        }
    }

    public boolean keyPressed(KeyEvent event) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        if (this.getFocused() == null && keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).getType() == InputConstants.Type.KEYSYM && event.key() == keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).getValue()) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        IKeyBindingHelper keyBindingHelper = Services.PLATFORM.getKeyBindingHelper();
        if (this.getFocused() == null && keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).getType() == InputConstants.Type.MOUSE && event.button() == keyBindingHelper.getBoundKey(OpenPartiesAndClaims.INSTANCE.getClientDataInternal().getKeyBindings().openModMenu).getValue()) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }
}

