/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.ChunkPos;
import xaero.pac.common.claims.IDimensionClaimsManager;
import xaero.pac.common.claims.RegionClaims;
import xaero.pac.common.claims.api.IRegionClaimsAPI;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.PlayerClaimInfoManager;
import xaero.pac.common.claims.storage.RegionClaimsPaletteStorage;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.util.linked.LinkedChain;

public abstract class DimensionClaimsManager<M extends PlayerClaimInfoManager<?, M>, WRC extends RegionClaims<M, WRC>>
implements IDimensionClaimsManager<WRC> {
    private final Identifier dimension;
    private final Long2ObjectMap<WRC> regions;
    private final LinkedChain<WRC> linkedRegions;

    public DimensionClaimsManager(Identifier dimension, Long2ObjectMap<WRC> regions, LinkedChain<WRC> linkedRegions) {
        this.dimension = dimension;
        this.regions = regions;
        this.linkedRegions = linkedRegions;
    }

    @Override
    public int getCount() {
        return this.regions.size();
    }

    @Override
    @Nonnull
    public Stream<WRC> getTypedRegionStream() {
        return this.linkedRegions.stream();
    }

    public long getKey(int x, int z) {
        return PlayerChunkClaim.getLongCoordinatesFor(x, z);
    }

    @Nullable
    public WRC getRegion(int x, int z) {
        long key = this.getKey(x, z);
        return (WRC)((RegionClaims)this.regions.get(key));
    }

    protected void setRegion(int x, int z, WRC region) {
        long key = this.getKey(x, z);
        RegionClaims current = (RegionClaims)this.regions.get(key);
        this.regions.put(key, region);
        if (current != null) {
            this.onRegionRemoved(current);
        }
        if (region != null) {
            this.onRegionAdded(region);
        }
    }

    protected void removeRegion(int x, int z) {
        long key = this.getKey(x, z);
        this.onRegionRemoved((RegionClaims)this.regions.remove(key));
    }

    public PlayerChunkClaim get(int x, int z) {
        IRegionClaimsAPI region = this.getRegion(x >> 5, z >> 5);
        if (region == null) {
            return null;
        }
        return ((RegionClaims)region).get(x & 0x1F, z & 0x1F);
    }

    public PlayerChunkClaim get(ChunkPos chunkPos) {
        return this.get(chunkPos.x, chunkPos.z);
    }

    public PlayerChunkClaim get(BlockPos blockPos) {
        return this.get(blockPos.getX() >> 4, blockPos.getZ() >> 4);
    }

    private WRC ensureRegionForChunk(int chunkX, int chunkZ) {
        int regionX = chunkX >> 5;
        int regionZ = chunkZ >> 5;
        IRegionClaimsAPI region = this.getRegion(regionX, regionZ);
        if (region == null) {
            region = this.create(this.dimension, regionX, regionZ, null);
            this.setRegion(regionX, regionZ, region);
        }
        return (WRC)region;
    }

    private WRC getRegionForChunk(int chunkX, int chunkZ) {
        int regionX = chunkX >> 5;
        int regionZ = chunkZ >> 5;
        return (WRC)this.getRegion(regionX, regionZ);
    }

    protected abstract WRC create(Identifier var1, int var2, int var3, RegionClaimsPaletteStorage var4);

    public PlayerChunkClaim claim(int x, int z, PlayerChunkClaim claim, M playerClaimInfoManager, IPlayerConfigManager configManager) {
        WRC region = this.ensureRegionForChunk(x, z);
        return ((RegionClaims)region).claim(x, z, claim, playerClaimInfoManager, configManager);
    }

    public void unclaim(int x, int z, M playerClaimInfoManager, IPlayerConfigManager configManager) {
        WRC region = this.getRegionForChunk(x, z);
        if (region != null) {
            ((RegionClaims)region).claim(x, z, null, playerClaimInfoManager, configManager);
            if (((RegionClaims)region).isEmpty()) {
                this.removeRegion(((RegionClaims)region).getX(), ((RegionClaims)region).getZ());
            }
        }
    }

    protected void onRegionRemoved(WRC region) {
        this.linkedRegions.remove(region);
    }

    protected void onRegionAdded(WRC region) {
        this.linkedRegions.add(region);
    }

    @Override
    @Nonnull
    public Identifier getDimension() {
        return this.dimension;
    }

    public Iterator<WRC> iterator() {
        return this.linkedRegions.iterator();
    }
}

