/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.claims;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.Identifier;
import xaero.pac.common.claims.IRegionClaims;
import xaero.pac.common.claims.player.PlayerChunkClaim;
import xaero.pac.common.claims.player.PlayerClaimInfo;
import xaero.pac.common.claims.player.PlayerClaimInfoManager;
import xaero.pac.common.claims.storage.RegionClaimsPaletteStorage;
import xaero.pac.common.server.player.config.IPlayerConfigManager;
import xaero.pac.common.util.linked.ILinkedChainNode;

public abstract class RegionClaims<M extends PlayerClaimInfoManager<?, M>, WRC extends RegionClaims<M, WRC>>
implements IRegionClaims,
ILinkedChainNode<WRC> {
    protected final Identifier dimension;
    private final int x;
    private final int z;
    protected final RegionClaimsPaletteStorage storage;
    private boolean destroyed;
    private WRC nextInChain;
    private WRC previousInChain;

    public RegionClaims(Identifier dimension, int x, int z, RegionClaimsPaletteStorage storage) {
        if (storage == null) {
            throw new IllegalArgumentException();
        }
        this.storage = storage;
        this.dimension = dimension;
        this.x = x;
        this.z = z;
    }

    @Override
    public void onDestroyed() {
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public WRC getNext() {
        return this.nextInChain;
    }

    @Override
    public WRC getPrevious() {
        return this.previousInChain;
    }

    @Override
    public void setNext(WRC nextInChain) {
        this.nextInChain = nextInChain;
    }

    @Override
    public void setPrevious(WRC previousInChain) {
        this.previousInChain = previousInChain;
    }

    public static int getIndex(int x, int z) {
        return x << 5 | z;
    }

    @Override
    @Nullable
    public PlayerChunkClaim get(int x, int z) {
        return this.storage.get(x, z);
    }

    protected void set(int x, int z, PlayerChunkClaim value) {
        this.storage.set(x, z, value, this);
    }

    public RegionClaimsPaletteStorage getStorage() {
        return this.storage;
    }

    public PlayerChunkClaim claim(int x, int z, PlayerChunkClaim claim, M playerClaimsManager, IPlayerConfigManager configManager) {
        PlayerChunkClaim currentClaim = this.get(x & 0x1F, z & 0x1F);
        if (this.onClaimSet(x, z, currentClaim, claim, playerClaimsManager, configManager)) {
            this.set(x & 0x1F, z & 0x1F, claim);
        }
        return claim;
    }

    protected boolean onClaimSet(int x, int z, PlayerChunkClaim currentClaim, PlayerChunkClaim newClaim, M playerClaimsManager, IPlayerConfigManager configManager) {
        if (!Objects.equals(currentClaim, newClaim)) {
            PlayerClaimInfo newPlayerInfo;
            PlayerClaimInfo currentPlayerInfo = currentClaim == null ? null : (PlayerClaimInfo)((PlayerClaimInfoManager)playerClaimsManager).getInfo(currentClaim.getPlayerId());
            PlayerClaimInfo playerClaimInfo = newPlayerInfo = newClaim == null ? null : (PlayerClaimInfo)((PlayerClaimInfoManager)playerClaimsManager).getInfo(newClaim.getPlayerId());
            if (currentPlayerInfo != null) {
                currentPlayerInfo.onUnclaim(configManager, this.dimension, currentClaim, x, z);
            }
            if (newPlayerInfo != null) {
                newPlayerInfo.onClaim(configManager, this.dimension, newClaim, x, z);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public String toString() {
        return String.format("[%s, %d, %d]", this.dimension, this.x, this.z);
    }

    public void onAddedToPalette(RegionClaimsPaletteStorage paletteStorage, PlayerChunkClaim state) {
    }

    public void onRemovedFromPalette(RegionClaimsPaletteStorage paletteStorage, PlayerChunkClaim state) {
    }

    public static abstract class Builder<M extends PlayerClaimInfoManager<?, M>, WRC extends RegionClaims<M, WRC>, B extends Builder<M, WRC, B>> {
        protected final B self = this;
        protected Identifier dimension;
        protected int x;
        protected int z;
        protected RegionClaimsPaletteStorage storage;

        protected Builder() {
        }

        public B setDefault() {
            this.setDimension(null);
            this.setX(0);
            this.setZ(0);
            this.setStorage(null);
            return this.self;
        }

        public B setDimension(Identifier dimension) {
            this.dimension = dimension;
            return this.self;
        }

        public B setX(int x) {
            this.x = x;
            return this.self;
        }

        public B setZ(int z) {
            this.z = z;
            return this.self;
        }

        protected B setStorage(RegionClaimsPaletteStorage storage) {
            this.storage = storage;
            return this.self;
        }

        public RegionClaims<M, WRC> build() {
            if (this.dimension == null || this.storage == null) {
                throw new IllegalStateException();
            }
            return this.buildInternally();
        }

        protected abstract RegionClaims<M, WRC> buildInternally();
    }
}

