/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.command.ClaimsClaimCommands;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.command.ConfigCommandUtil;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.player.config.IPlayerConfig;
import xaero.pac.common.server.player.config.api.IPlayerConfigAPI;
import xaero.pac.common.server.player.config.api.IPlayerConfigOptionSpecAPI;
import xaero.pac.common.server.player.config.api.PlayerConfigOptions;
import xaero.pac.common.server.player.config.api.PlayerConfigType;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class ClaimsSubClaimUseCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment) {
        Command<CommandSourceStack> regularExecutor = ClaimsSubClaimUseCommand.getExecutor(PlayerConfigType.PLAYER);
        Command<CommandSourceStack> serverExecutor = ClaimsSubClaimUseCommand.getExecutor(PlayerConfigType.SERVER);
        SuggestionProvider<CommandSourceStack> playerSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.PLAYER);
        SuggestionProvider<CommandSourceStack> serverSubConfigSuggestionProvider = ConfigCommandUtil.getSubConfigSuggestionProvider(PlayerConfigType.SERVER);
        Predicate<CommandSourceStack> serverRequirement = ClaimsClaimCommands.getServerClaimCommandRequirement();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"openpac-claims").then(Commands.literal((String)"sub-claim").then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac-claims").then(Commands.literal((String)"sub-claim").then(((LiteralArgumentBuilder)Commands.literal((String)"for").requires(sourceStack -> Commands.LEVEL_GAMEMASTERS.check(sourceStack.permissions()))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(this.getMainCommandPart(playerSubConfigSuggestionProvider, regularExecutor)))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac-claims").then(((LiteralArgumentBuilder)Commands.literal((String)"server").requires(serverRequirement)).then(Commands.literal((String)"sub-claim").then(this.getMainCommandPart(serverSubConfigSuggestionProvider, serverExecutor))));
        dispatcher.register(command);
        command = (LiteralArgumentBuilder)Commands.literal((String)"openpac-claims").then(((LiteralArgumentBuilder)Commands.literal((String)"server").requires(serverRequirement)).then(Commands.literal((String)"sub-claim").then(((LiteralArgumentBuilder)Commands.literal((String)"for").requires(sourceStack -> Commands.LEVEL_GAMEMASTERS.check(sourceStack.permissions()))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(this.getMainCommandPart(serverSubConfigSuggestionProvider, serverExecutor))))));
        dispatcher.register(command);
    }

    private LiteralArgumentBuilder<CommandSourceStack> getMainCommandPart(SuggestionProvider<CommandSourceStack> subConfigSuggestionProvider, Command<CommandSourceStack> executor) {
        return (LiteralArgumentBuilder)Commands.literal((String)"use").then(Commands.argument((String)"sub-id", (ArgumentType)StringArgumentType.word()).suggests(subConfigSuggestionProvider).executes(executor));
    }

    private static Command<CommandSourceStack> getExecutor(PlayerConfigType type) {
        return context -> {
            ServerPlayer sourcePlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            String inputSubId = StringArgumentType.getString((CommandContext)context, (String)"sub-id");
            NameAndId inputPlayer = ConfigCommandUtil.getConfigInputPlayer((CommandContext<CommandSourceStack>)context, sourcePlayer, "gui.xaero_claims_sub_use_too_many_targets", "gui.xaero_claims_sub_use_invalid_target", adaptiveLocalizer);
            if (inputPlayer == null) {
                return 0;
            }
            UUID configPlayerUUID = inputPlayer.id();
            IPlayerConfig playerConfig = serverData.getPlayerConfigs().getLoadedConfig(configPlayerUUID);
            IPlayerConfigOptionSpecAPI<String> option = type == PlayerConfigType.SERVER ? PlayerConfigOptions.USED_SERVER_SUBCLAIM : PlayerConfigOptions.USED_SUBCLAIM;
            IPlayerConfig rootConfig = type == PlayerConfigType.SERVER ? serverData.getPlayerConfigs().getServerClaimConfig() : playerConfig;
            IPlayerConfig result = rootConfig.getSubConfig(inputSubId);
            if (result == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use_not_exist", new Object[0]));
                return 0;
            }
            IPlayerConfigAPI.SetResult setResult = playerConfig.tryToSet(option, inputSubId);
            if (setResult == IPlayerConfigAPI.SetResult.INVALID) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use_invalid_value", new Object[0]));
                return 0;
            }
            sourcePlayer.sendSystemMessage((Component)adaptiveLocalizer.getFor(sourcePlayer, "gui.xaero_claims_sub_use", inputSubId));
            return 1;
        };
    }
}

