/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.claims.protection;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.resources.Identifier;
import xaero.pac.OpenPartiesAndClaims;

public class WildcardResolver {
    private static final Pattern WILDCARD_FORMAT = Pattern.compile("[\\(\\)\\*\\|a-zA-Z0-9_\\-\\.\\/\\:]+");
    private static final Pattern WILDCARD_TO_REGEX_REPLACE_PATTERN = Pattern.compile("([\\.\\-\\:\\/])");
    private static final Function<String, String> WILDCARD_TO_REGEX = s -> WILDCARD_TO_REGEX_REPLACE_PATTERN.matcher((CharSequence)s).replaceAll("\\\\$1").replace("*", ".*");

    public <T> List<T> resolveIdentifiers(Function<Identifier, T> getter, Iterable<T> iterable, Function<T, Identifier> keyGetter, String string) {
        boolean validIdentifier;
        boolean bl = validIdentifier = this.isValidIdentifier(string) && !this.containsWildcardCharacters(string);
        if (validIdentifier) {
            T object = getter.apply(Identifier.parse((String)string));
            return object == null ? List.of() : List.of(object);
        }
        if (!WILDCARD_FORMAT.matcher(string).matches()) {
            OpenPartiesAndClaims.LOGGER.error("Invalid resource location or wildcard in the server config file: " + string + ". Additional characters allowed for wildcards are (, ), | and *.");
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        try {
            Pattern regexPattern = Pattern.compile(WILDCARD_TO_REGEX.apply(string));
            for (T element : iterable) {
                Identifier key = keyGetter.apply(element);
                if (!regexPattern.matcher(key.toString()).matches()) continue;
                result.add(element);
            }
        }
        catch (PatternSyntaxException pse) {
            OpenPartiesAndClaims.LOGGER.error("Invalid wildcard format in the server config file: " + string + ". Additional characters allowed for wildcards are (, ), | and *.", (Throwable)pse);
            return null;
        }
        return result;
    }

    private boolean isValidIdentifier(String string) {
        int separatorIndex = string.indexOf(58);
        String path = string.substring(separatorIndex + 1);
        if (!Identifier.isValidPath((String)path)) {
            return false;
        }
        if (separatorIndex == -1) {
            return true;
        }
        return Identifier.isValidNamespace((String)string.substring(0, separatorIndex));
    }

    private boolean containsWildcardCharacters(String string) {
        return string.contains("(") || string.contains(")") || string.contains("|") || string.contains("*");
    }
}

