/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.parties.party.member.PartyMemberRank;
import xaero.pac.common.parties.party.member.api.IPartyMemberAPI;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.parties.command.CommandRequirementProvider;
import xaero.pac.common.server.parties.command.PartyOnCommandUpdater;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;
import xaero.pac.common.server.player.localization.AdaptiveLocalizer;

public class AllyPartyCommand {
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection environment, CommandRequirementProvider commandRequirementProvider) {
        Predicate<CommandSourceStack> requirement = commandRequirementProvider.getMemberRequirement((party, mi) -> mi.getRank().ordinal() >= PartyMemberRank.MODERATOR.ordinal());
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"openpac-parties").requires(c -> (Boolean)ServerConfig.CONFIG.partiesEnabled.get())).then(((LiteralArgumentBuilder)Commands.literal((String)"ally").requires(requirement)).then(Commands.literal((String)"add").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).suggests((context, builder) -> {
            PlayerList playerlist = ((CommandSourceStack)context.getSource()).getServer().getPlayerList();
            return SharedSuggestionProvider.suggest(playerlist.getPlayers().stream().map(targetPlayer -> targetPlayer.getGameProfile().name()), (SuggestionsBuilder)builder);
        }).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            UUID playerId = player.getUUID();
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(server);
            AdaptiveLocalizer adaptiveLocalizer = serverData.getAdaptiveLocalizer();
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(playerId);
            ServerPlayer targetPlayer = EntityArgument.getPlayer((CommandContext)context, (String)"player");
            IServerPartyAPI targetPlayerParty = partyManager.getPartyByMember(targetPlayer.getUUID());
            if (targetPlayerParty == playerParty) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_ally_player_target_in_your_party", targetPlayer.getGameProfile().name()));
                return 0;
            }
            if (targetPlayerParty == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_ally_player_target_not_in_party", targetPlayer.getGameProfile().name()));
                return 0;
            }
            if (playerParty.isAlly(targetPlayerParty.getId())) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_ally_player_target_already_ally", targetPlayer.getGameProfile().name(), targetPlayerParty.getDefaultName()));
                return 0;
            }
            if (playerParty.getAllyCount() >= (Integer)ServerConfig.CONFIG.maxPartyAllies.get()) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)adaptiveLocalizer.getFor(player, "gui.xaero_parties_ally_limit", new Object[0]));
                return 0;
            }
            playerParty.addAllyParty(targetPlayerParty.getId());
            new PartyOnCommandUpdater().update(playerId, serverData, targetPlayerParty, serverData.getPlayerConfigs(), mi -> false, (Component)Component.translatable((String)"gui.xaero_parties_ally_player_target_party_info", (Object[])new Object[]{Component.literal((String)playerParty.getDefaultName()).withStyle(s -> s.withColor(ChatFormatting.DARK_GREEN)), targetPlayerParty.getDefaultName()}));
            IPartyMemberAPI casterInfo = playerParty.getMemberInfo(playerId);
            new PartyOnCommandUpdater().update(playerId, serverData, playerParty, serverData.getPlayerConfigs(), mi -> false, (Component)Component.translatable((String)"gui.xaero_parties_ally_caster_party_info", (Object[])new Object[]{Component.literal((String)casterInfo.getUsername()).withStyle(s -> s.withColor(ChatFormatting.DARK_GREEN)), Component.literal((String)targetPlayerParty.getDefaultName()).withStyle(s -> s.withColor(ChatFormatting.YELLOW))}));
            return 1;
        }))));
        dispatcher.register(command);
    }
}

