/*
 * Open Parties and Claims - adds chunk claims and player parties to Minecraft
 * Copyright (C) 2022-2026, Xaero <xaero1996@gmail.com> and contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of version 3 of the GNU Lesser General Public License
 * (LGPL-3.0-only) as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received copies of the GNU Lesser General Public License
 * and the GNU General Public License along with this program.
 * If not, see <https://www.gnu.org/licenses/>.
 */

package xaero.pac.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Vec3i;

import java.util.List;
import java.util.function.BiFunction;

public class SimpleWidgetListElement extends WidgetListElement<SimpleWidgetListElement> {
	
	protected SimpleWidgetListElement(int w, int h, boolean mutable, BiFunction<SimpleWidgetListElement, Vec3i, AbstractWidget> widgetSupplier, List<ClientTooltipComponent> tooltip) {
		super(w, h, mutable, widgetSupplier, tooltip);
	}
	
	@Override
	public final void render(GuiGraphics guiGraphics) {
		super.render(guiGraphics);
	}
	
	public static final class Builder extends WidgetListElement.Builder<SimpleWidgetListElement, Builder> {
		
		@Override
		protected SimpleWidgetListElement buildInternal(List<ClientTooltipComponent> clientTooltip) {
			return new SimpleWidgetListElement(w, h, mutable, widgetSupplier, clientTooltip);
		}
		
		public static Builder begin() {
			return new Builder().setDefault();
		}
		
	}

}
