/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.anim.MultiplyAnimationHelper;
import xaero.common.interfaces.InterfaceManager;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.module.MinimapSession;

public abstract class ModClientEvents {
    protected IXaeroMinimap modMain;
    private final Vector4f REUSABLE_ZERO_VECTOR4 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);

    public ModClientEvents(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public void handleTextureStitchEventPost(TextureAtlas texture) {
        if (texture.location().equals((Object)TextureAtlas.LOCATION_BLOCKS)) {
            InterfaceManager interfaceManager;
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().getMinimapWriter().setClearBlockColours(true);
                minimapSession.getMinimapProcessor().getMinimapWriter().resetShortBlocks();
            }
            if ((interfaceManager = this.modMain.getInterfaces()) != null) {
                interfaceManager.getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
                this.handleTextureStitchEventPost_onReset();
            }
        }
    }

    public void handleRenderModOverlay(PoseStack matrixStack, float partialTicks) {
        MultiplyAnimationHelper.tick();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (minimapSession != null) {
            this.REUSABLE_ZERO_VECTOR4.transform(matrixStack.last().pose());
            float currentDepth = this.REUSABLE_ZERO_VECTOR4.z();
            this.REUSABLE_ZERO_VECTOR4.set(0.0f, 0.0f, 0.0f, 1.0f);
            matrixStack.pushPose();
            matrixStack.setIdentity();
            matrixStack.translate(0.0, 0.0, (double)(currentDepth - 1.0f));
            this.modMain.getHudRenderer().render(this.modMain.getHud(), matrixStack, partialTicks);
            this.modMain.getMinimap().getWaypointGuiRenderer().drawSetChange(minimapSession, matrixStack, Minecraft.getInstance().getWindow());
            matrixStack.popPose();
        }
    }

    protected void handleTextureStitchEventPost_onReset() {
    }
}

