/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.Serializable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.commons.lang3.StringUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiMinimapSettings;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.common.config.option.ConfigOption;

public class GuiSlimeSeed
extends GuiMinimapSettings {
    public EditBox seedTextField;
    private final MinimapWorld minimapWorld;
    private final IXaeroMinimap modMain;
    private final MinimapSession session;

    public GuiSlimeSeed(IXaeroMinimap modMain, MinimapSession session, Screen parent, Screen escape, IEditConfigScreenContext context) {
        super((Component)new TranslatableComponent("gui.xaero_slime_chunks"), parent, escape, context);
        this.modMain = modMain;
        this.session = session;
        this.entries = new ISettingEntry[]{this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.SLIME_CHUNKS), this.optionEntry((ConfigOption)MinimapProfiledConfigOptions.OPEN_SLIME_CHUNKS_SCREEN)};
        this.minimapWorld = session.getWorldManager().getCurrentWorld();
    }

    public void init() {
        super.init();
        this.seedTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 68, 200, 20, (Component)new TranslatableComponent("gui.xaero_used_seed"));
        this.seedTextField.setValue("" + (Serializable)(this.minimapWorld.getSlimeChunkSeed() == null ? "" : this.minimapWorld.getSlimeChunkSeed()));
        this.addRenderableWidget((GuiEventListener)this.seedTextField);
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
    }

    @Override
    public void render(PoseStack matrixStack, int mouseX, int mouseY, float partial) {
        super.render(matrixStack, mouseX, mouseY, partial);
        this.seedTextField.render(matrixStack, mouseX, mouseY, partial);
        GuiSlimeSeed.drawCenteredString((PoseStack)matrixStack, (Font)this.font, (String)I18n.get((String)"gui.xaero_used_seed", (Object[])new Object[0]), (int)(this.width / 2), (int)(this.height / 7 + 55), (int)0xFFFFFF);
    }

    public void tick() {
        this.seedTextField.tick();
    }

    @Override
    public boolean keyPressed(int par1, int par2, int par3) {
        boolean result = super.keyPressed(par1, par2, par3);
        if (par1 == 257) {
            this.goBack();
        }
        this.updateSlimeSeed();
        return result;
    }

    public boolean charTyped(char par1, int par2) {
        boolean result = super.charTyped(par1, par2);
        this.updateSlimeSeed();
        return result;
    }

    private void updateSlimeSeed() {
        String s = this.seedTextField.getValue();
        if (!StringUtils.isEmpty((CharSequence)s)) {
            try {
                long j = Long.parseLong(s);
                this.minimapWorld.setSlimeChunkSeed(j);
            }
            catch (NumberFormatException numberformatexception) {
                this.minimapWorld.setSlimeChunkSeed(Long.valueOf(s.hashCode()));
            }
        }
        try {
            this.session.getWorldManagerIO().saveWorld(this.minimapWorld);
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }
}

