/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.mods;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.minimap.highlight.HighlighterRegistry;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.render.element.RadarRenderer;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.render.util.RenderBufferUtil;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.graphics.shader.LibShaders;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.context.BuiltInEditConfigScreenContexts;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiWorldMapSettings;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.texture.LeafRegionTexture;
import xaero.map.world.MapDimension;

public class SupportXaeroWorldmap {
    public static int WORLDMAP_COMPATIBILITY_VERSION = 20;
    public static final String MINIMAP_MW = "minimap";
    public int compatibilityVersion;
    private static final HashMap<MapTileChunk, Long> seedsUsed = new HashMap();
    public static final int black = -16777216;
    public static final int slime = -2142047936;
    private IXaeroMinimap modMain;
    private int destinationCaving = Integer.MAX_VALUE;
    private long lastDestinationCavingSwitch;
    private int previousRenderedCaveLayer = Integer.MAX_VALUE;
    private int lastRenderedCaveLayer = Integer.MAX_VALUE;
    private ArrayList<MapRegion> regionBuffer = new ArrayList();

    public SupportXaeroWorldmap(IXaeroMinimap modMain) {
        this.modMain = modMain;
        try {
            this.compatibilityVersion = WorldMap.MINIMAP_COMPATIBILITY_VERSION;
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        if (this.compatibilityVersion < 3) {
            throw new RuntimeException("Xaero's World Map 1.11.0 or newer required!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawMinimap(MinimapSession minimapSession, PoseStack matrixStack, MinimapRendererHelper helper, int xFloored, int zFloored, int minViewX, int minViewZ, int maxViewX, int maxViewZ, boolean zooming, double zoom, double mapDimensionScale, VertexConsumer overlayBufferBuilder, MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (!mapProcessor.isRenderingPaused()) {
                if (mapProcessor.getCurrentDimension() == null) {
                    return;
                }
                int compatibilityVersion = this.compatibilityVersion;
                String worldString = mapProcessor.getCurrentWorldId();
                if (worldString == null) {
                    return;
                }
                LibShaders.ensureShaders();
                int mapX = xFloored >> 4;
                int mapZ = zFloored >> 4;
                int chunkX = mapX >> 2;
                int chunkZ = mapZ >> 2;
                int tileX = mapX & 3;
                int tileZ = mapZ & 3;
                int insideX = xFloored & 0xF;
                int insideZ = zFloored & 0xF;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.enableBlend();
                int minX = (mapX >> 2) - 4;
                int maxX = (mapX >> 2) + 4;
                int minZ = (mapZ >> 2) - 4;
                int maxZ = (mapZ >> 2) + 4;
                ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
                SingleConfigManager wmPrimaryConfigManager = wmConfigManager.getPrimaryConfigManager();
                boolean wmHasCaveLayers = this.hasCaveLayers();
                boolean wmHasFullReload = compatibilityVersion >= 23;
                int globalRegionCacheHashCode = WorldMap.settings.getRegionCacheHashCode();
                boolean reloadEverything = (Boolean)wmPrimaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED);
                int globalReloadVersion = (Integer)wmPrimaryConfigManager.getEffective(WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED_VERSION);
                boolean slimeChunks = MinimapConfigClientUtils.getEffectiveSlimeChunks(minimapSession);
                boolean wmHasDimensionSwitch = this.hasDimensionSwitching();
                if (wmHasDimensionSwitch) {
                    mapProcessor.initMinimapRender(xFloored, zFloored);
                }
                if (!wmHasDimensionSwitch && wmHasCaveLayers) {
                    mapProcessor.updateCaveStart();
                }
                int renderedCaveLayer = wmHasCaveLayers ? mapProcessor.getCurrentCaveLayer() : 0;
                int globalCaveStart = !wmHasDimensionSwitch && wmHasCaveLayers ? mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().getLayer(renderedCaveLayer).getCaveStart() : 0;
                int globalCaveDepth = !wmHasDimensionSwitch && wmHasCaveLayers ? (Integer)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_DEPTH) : 0;
                float brightness = this.getMinimapBrightness();
                if (renderedCaveLayer != this.lastRenderedCaveLayer) {
                    this.previousRenderedCaveLayer = this.lastRenderedCaveLayer;
                }
                LocalPlayer player = Minecraft.getInstance().player;
                boolean noCaveMaps = !MinimapConfigClientUtils.getEffectiveCaveModeAllowed();
                boolean playerIsMoving = !wmHasDimensionSwitch && (player.xo != player.getX() || player.yo != player.getY() || player.zo != player.getZ());
                boolean shouldRequestLoading = true;
                LeveledRegion nextToLoadObj = null;
                if (!wmHasDimensionSwitch && compatibilityVersion >= 11) {
                    LeveledRegion nextToLoad;
                    shouldRequestLoading = false;
                    nextToLoadObj = nextToLoad = mapProcessor.getMapSaveLoad().getNextToLoadByViewing();
                    if (nextToLoad != null) {
                        if (wmHasFullReload) {
                            shouldRequestLoading = nextToLoad.shouldAllowAnotherRegionToLoad();
                        } else {
                            LeveledRegion leveledRegion = nextToLoad;
                            synchronized (leveledRegion) {
                                if (!(nextToLoad.reloadHasBeenRequested() || nextToLoad.hasRemovableSourceData() || nextToLoad instanceof MapRegion && ((MapRegion)nextToLoad).isRefreshing())) {
                                    shouldRequestLoading = true;
                                }
                            }
                        }
                    } else {
                        shouldRequestLoading = true;
                    }
                    this.regionBuffer.clear();
                    if (wmHasCaveLayers) {
                        int comparisonChunkX = (xFloored >> 4) - 16;
                        int comparisonChunkZ = (zFloored >> 4) - 16;
                        LeveledRegion.setComparison((int)comparisonChunkX, (int)comparisonChunkZ, (int)0, (int)comparisonChunkX, (int)comparisonChunkZ);
                    } else {
                        int comparisonRegionX = xFloored >> 9;
                        int comparisonRegionZ = zFloored >> 9;
                        LeveledRegion.setComparison((int)comparisonRegionX, (int)comparisonRegionZ, (int)0, (int)comparisonRegionX, (int)comparisonRegionZ);
                    }
                }
                MultiTextureRenderTypeRenderer mapWithLightRenderer = null;
                MultiTextureRenderTypeRenderer mapNoLightRenderer = null;
                if (compatibilityVersion >= 12) {
                    IntConsumer shaderBinder;
                    IntConsumer binder;
                    Runnable finalizer = null;
                    if (zooming) {
                        binder = t -> {
                            MultiTextureRenderTypeRendererProvider.defaultTextureBind(t);
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                        };
                        shaderBinder = t -> {
                            RenderSystem.setShaderTexture((int)0, (int)t);
                            MultiTextureRenderTypeRendererProvider.defaultTextureBind(t);
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                        };
                        finalizer = () -> GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    } else {
                        binder = MultiTextureRenderTypeRendererProvider::defaultTextureBind;
                        shaderBinder = t -> RenderSystem.setShaderTexture((int)0, (int)t);
                    }
                    mapWithLightRenderer = multiTextureRenderTypeRenderers.getRenderer(shaderBinder, binder, finalizer, CustomRenderTypes.MAP);
                    mapNoLightRenderer = multiTextureRenderTypeRenderers.getRenderer(shaderBinder, binder, finalizer, CustomRenderTypes.MAP);
                } else {
                    mapWithLightRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                    mapNoLightRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                }
                MinimapWorld world = minimapSession.getWorldManager().getAutoWorld();
                Long seed = !slimeChunks || world == null ? null : MinimapConfigClientUtils.getEffectiveSlimeChunksSeed(world);
                this.renderChunks(matrixStack, minX, maxX, minZ, maxZ, minViewX, maxViewX, minViewZ, maxViewZ, mapProcessor, renderedCaveLayer, shouldRequestLoading, reloadEverything, globalReloadVersion, globalRegionCacheHashCode, globalCaveStart, globalCaveDepth, playerIsMoving, noCaveMaps, slimeChunks, chunkX, chunkZ, tileX, tileZ, insideX, insideZ, seed, wmHasCaveLayers, brightness, zooming, mapWithLightRenderer, mapNoLightRenderer, helper, overlayBufferBuilder);
                LibShaders.WORLD_MAP.setBrightness(brightness);
                LibShaders.WORLD_MAP.setWithLight(true);
                multiTextureRenderTypeRenderers.draw(mapWithLightRenderer);
                LibShaders.WORLD_MAP.setWithLight(false);
                multiTextureRenderTypeRenderers.draw(mapNoLightRenderer);
                GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.disableBlend();
                this.lastRenderedCaveLayer = renderedCaveLayer;
                if (wmHasDimensionSwitch) {
                    mapProcessor.finalizeMinimapRender();
                } else if (compatibilityVersion >= 11) {
                    int toRequest = 1;
                    int counter = 0;
                    for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                        MapRegion region = this.regionBuffer.get(i);
                        if (region == nextToLoadObj && this.regionBuffer.size() > 1) continue;
                        MapRegion mapRegion = region;
                        synchronized (mapRegion) {
                            if (wmHasFullReload && !region.canRequestReload_unsynced()) {
                                continue;
                            }
                            if (!wmHasFullReload && (region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region instanceof MapRegion && region.isRefreshing() || region.getLoadState() != 0 && region.getLoadState() != 4 && (region.getLoadState() != 2 || !region.isBeingWritten()))) {
                                continue;
                            }
                            if (region.getLoadState() == 2) {
                                region.requestRefresh(mapProcessor);
                            } else {
                                mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap sorted", false);
                            }
                            if (counter == 0) {
                                mapProcessor.getMapSaveLoad().setNextToLoadByViewing((LeveledRegion)region);
                            }
                            ++counter;
                            if (region.getLoadState() == 4) {
                                break;
                            }
                            continue;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderChunks(PoseStack matrixStack, int minX, int maxX, int minZ, int maxZ, int minViewX, int maxViewX, int minViewZ, int maxViewZ, MapProcessor mapProcessor, int renderedCaveLayer, boolean shouldRequestLoading, boolean reloadEverything, int globalReloadVersion, int globalRegionCacheHashCode, int globalCaveStart, int globalCaveDepth, boolean playerIsMoving, boolean noCaveMaps, boolean slimeChunks, int chunkX, int chunkZ, int tileX, int tileZ, int insideX, int insideZ, Long seed, boolean wmHasCaveLayers, float brightness, boolean zooming, MultiTextureRenderTypeRenderer mapWithLightRenderer, MultiTextureRenderTypeRenderer mapNoLightRenderer, MinimapRendererHelper helper, VertexConsumer overlayBufferBuilder) {
        MapRegion prevRegion = null;
        Matrix4f matrix = matrixStack.last().pose();
        boolean wmHasFullReload = this.compatibilityVersion >= 23;
        boolean wmHasDimensionSwitch = this.hasDimensionSwitching();
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                MapTileChunk previousLayerChunk;
                MapRegion previousLayerRegion;
                boolean chunkIsVisible;
                MapRegion region;
                if (wmHasDimensionSwitch) {
                    region = mapProcessor.getMinimapMapRegion(i >> 3, j >> 3);
                    mapProcessor.beforeMinimapRegionRender(region);
                } else {
                    region = wmHasCaveLayers ? mapProcessor.getMapRegion(renderedCaveLayer, i >> 3, j >> 3, mapProcessor.regionExists(renderedCaveLayer, i >> 3, j >> 3)) : mapProcessor.getMapRegion(i >> 3, j >> 3, mapProcessor.regionExists(i >> 3, j >> 3));
                }
                if (!wmHasDimensionSwitch && region != null && region != prevRegion) {
                    MapRegion mapRegion = region;
                    synchronized (mapRegion) {
                        int regionHashCode = region.getCacheHashCode();
                        int regionReloadVersion = region.getReloadVersion();
                        if (shouldRequestLoading && (wmHasFullReload && region.canRequestReload_unsynced() || !wmHasFullReload && !region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (!(region instanceof MapRegion) || !region.isRefreshing())) && (region.getLoadState() == 0 || (region.getLoadState() == 4 || region.getLoadState() == 2 && region.isBeingWritten()) && (reloadEverything && regionReloadVersion != globalReloadVersion || regionHashCode != globalRegionCacheHashCode || wmHasCaveLayers && !playerIsMoving && region.caveStartOutdated(globalCaveStart, globalCaveDepth) || region.getVersion() != mapProcessor.getGlobalVersion() || this.compatibilityVersion >= 11 && (region.isMetaLoaded() || region.getLoadState() != 0 || !region.hasHadTerrain()) && region.getHighlightsHash() != region.getDim().getHighlightHandler().getRegionHash(region.getRegionX(), region.getRegionZ()) || region.getLoadState() != 2 && region.shouldCache()))) {
                            if (this.compatibilityVersion >= 11) {
                                if (!this.regionBuffer.contains(region)) {
                                    if (wmHasCaveLayers) {
                                        region.calculateSortingChunkDistance();
                                    } else {
                                        region.calculateSortingDistance();
                                    }
                                    Misc.addToListOfSmallest((int)10, this.regionBuffer, (Comparable)region);
                                }
                            } else if (region.getLoadState() == 2) {
                                region.requestRefresh(mapProcessor);
                            } else if (shouldRequestLoading) {
                                mapProcessor.getMapSaveLoad().requestLoad(region, "Minimap", false);
                                mapProcessor.getMapSaveLoad().setNextToLoadByViewing(region);
                            }
                        }
                    }
                }
                prevRegion = region;
                if (i < minViewX || i > maxViewX || j < minViewZ || j > maxViewZ) continue;
                MapTileChunk chunk = region == null ? null : region.getChunk(i & 7, j & 7);
                boolean bl = chunkIsVisible = chunk != null && chunk.getGlColorTexture() != -1;
                if (!(!wmHasCaveLayers || chunkIsVisible || noCaveMaps && this.previousRenderedCaveLayer != Integer.MAX_VALUE || (previousLayerRegion = wmHasDimensionSwitch ? mapProcessor.getLeafMapRegion(this.previousRenderedCaveLayer, i >> 3, j >> 3, false) : mapProcessor.getMapRegion(this.previousRenderedCaveLayer, i >> 3, j >> 3, false)) == null || (previousLayerChunk = previousLayerRegion.getChunk(i & 7, j & 7)) == null || previousLayerChunk.getGlColorTexture() == -1)) {
                    region = previousLayerRegion;
                    chunk = previousLayerChunk;
                    chunkIsVisible = true;
                }
                if (!chunkIsVisible) continue;
                this.bumpLoadedRegion(mapProcessor, region, wmHasCaveLayers);
                if (this.compatibilityVersion < 12) {
                    this.bindMapTextureWithLighting(chunk, zooming);
                }
                GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                int drawX = 64 * (chunk.getX() - chunkX) - 16 * tileX - insideX;
                int drawZ = 64 * (chunk.getZ() - chunkZ) - 16 * tileZ - insideZ;
                this.prepareMapTexturedRect(matrix, drawX, drawZ, 0, 0, 64.0f, 64.0f, chunk, mapNoLightRenderer, mapWithLightRenderer, helper);
                if (!slimeChunks) continue;
                this.renderSlimeChunks(chunk, seed, drawX, drawZ, matrixStack, helper, overlayBufferBuilder);
            }
        }
    }

    private void bumpLoadedRegion(MapProcessor mapProcessor, MapRegion region, boolean wmHasCaveLayers) {
        if (!mapProcessor.isUploadingPaused() && region.isLoaded()) {
            if (wmHasCaveLayers) {
                mapProcessor.getMapWorld().getCurrentDimension().getLayeredMapRegions().bumpLoadedRegion(region);
            } else {
                mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().bumpLoadedRegion(region);
            }
        }
    }

    public void renderSlimeChunks(MapTileChunk chunk, Long seed, int drawX, int drawZ, PoseStack matrixStack, MinimapRendererHelper helper, VertexConsumer overlayBufferBuilder) {
        boolean newSeed;
        Long savedSeed = seedsUsed.get(chunk);
        boolean bl = newSeed = seed == null && savedSeed != null || seed != null && !seed.equals(savedSeed);
        if (newSeed) {
            seedsUsed.put(chunk, seed);
        }
        for (int t = 0; t < 16; ++t) {
            if (newSeed || (chunk.getTileGridsCache()[t % 4][t / 4] & 1) == 0) {
                chunk.getTileGridsCache()[t % 4][t / 4] = (byte)(1 | (MinimapTile.isSlimeChunk(this.modMain.getSettings(), chunk.getX() * 4 + t % 4, chunk.getZ() * 4 + t / 4, seed) ? 2 : 0));
            }
            if ((chunk.getTileGridsCache()[t % 4][t / 4] & 2) == 0) continue;
            int slimeDrawX = drawX + 16 * (t % 4);
            int slimeDrawZ = drawZ + 16 * (t / 4);
            RenderBufferUtil.addColoredRect(matrixStack.last().pose(), overlayBufferBuilder, slimeDrawX, slimeDrawZ, 16, 16, -2142047936);
        }
    }

    public boolean getWorldMapWaypoints() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINTS);
    }

    public int getWorldMapColours() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Integer)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.BLOCK_COLORS);
    }

    public boolean getWorldMapFlowers() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.FLOWERS);
    }

    public boolean getWorldMapLighting() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.LIGHTING);
    }

    public boolean getWorldMapTerrainDepth() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_DEPTH);
    }

    public int getWorldMapTerrainSlopes() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Integer)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_SLOPES);
    }

    public boolean getWorldMapBiomeColorsVanillaMode() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.BIOME_COLORS_IN_VANILLA);
    }

    public boolean getWorldMapIgnoreHeightmaps() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return false;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        return mapProcessor.getMapWorld().isIgnoreHeightmaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryToGetMultiworldId(ResourceKey<Level> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        if (this.compatibilityVersion >= 15) {
            Object object = mapProcessor.uiPauseSync;
            synchronized (object) {
                if (mapProcessor.isUIPaused()) {
                    return null;
                }
                return this.getMultiworldIdUnsynced(mapProcessor, dimId);
            }
        }
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            return this.getMultiworldIdUnsynced(mapProcessor, dimId);
        }
    }

    private String getMultiworldIdUnsynced(MapProcessor mapProcessor, ResourceKey<Level> dimId) {
        MapDimension mapDim;
        MapDimension mapDimension = mapDim = !mapProcessor.isMapWorldUsable() || mapProcessor.isWaitingForWorldUpdate() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
        return mapDim == null ? null : (!mapDim.currentMultiworldWritable ? MINIMAP_MW : mapDim.getCurrentMultiworld());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPotentialMultiworldIds(ResourceKey<Level> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null || !mapProcessor.isWaitingForWorldUpdate() && mapDim.currentMultiworldWritable ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMultiworldIds(ResourceKey<Level> dimId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiSync;
        synchronized (object) {
            MapDimension mapDim = mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
            return mapDim == null ? null : mapDim.getMultiworldIdsCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tryToGetMultiworldName(ResourceKey<Level> dimId, String multiworldId) {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiPauseSync;
        synchronized (object) {
            if (mapProcessor.isUIPaused()) {
                return null;
            }
            return this.getMultiworldNameUnsynced(mapProcessor, dimId, multiworldId);
        }
    }

    private String getMultiworldNameUnsynced(MapProcessor mapProcessor, ResourceKey<Level> dimId, String multiworldId) {
        MapDimension mapDim = !mapProcessor.isMapWorldUsable() ? null : mapProcessor.getMapWorld().createDimensionUnsynced(dimId);
        return mapDim == null ? null : mapDim.getMultiworldName(multiworldId);
    }

    public void openSettings() {
        Screen current = Minecraft.getInstance().screen;
        Minecraft.getInstance().setScreen(this.getSettingsScreen(current));
    }

    public Screen getSettingsScreen(Screen current) {
        Screen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
        return this.getSettingsScreen(current, currentEscScreen);
    }

    public Screen getSettingsScreen(Screen current, Screen currentEscScreen) {
        return new GuiWorldMapSettings(current, currentEscScreen, BuiltInEditConfigScreenContexts.CLIENT);
    }

    public float getMinimapBrightness() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return 1.0f;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        boolean lightingConfig = (Boolean)HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getEffective((ConfigOption)MinimapProfiledConfigOptions.LIGHTING);
        return mapProcessor.getBrightness(lightingConfig);
    }

    private void bindMapTextureWithLighting(MapTileChunk chunk, boolean zooming) {
        chunk.getLeafTexture().bindColorTexture(false, zooming ? 9729 : 9728);
    }

    public void prepareMapTexturedRect(Matrix4f matrix, float x, float y, int textureX, int textureY, float width, float height, MapTileChunk chunk, MultiTextureRenderTypeRenderer noLightRenderer, MultiTextureRenderTypeRenderer withLightrenderer, MinimapRendererHelper helper) {
        LeafRegionTexture texture = chunk.getLeafTexture();
        int textureId = texture.getGlColorTexture();
        if (textureId == -1) {
            return;
        }
        helper.prepareMyTexturedModalRect(matrix, x, y, textureX, (int)height, width, height, -height, 64.0f, textureId, texture.getTextureHasLight() ? withLightrenderer : noLightRenderer);
    }

    public boolean getAdjustHeightForCarpetLikeBlocks() {
        if (this.compatibilityVersion < 10) {
            return false;
        }
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS);
    }

    public void registerHighlighters(HighlighterRegistry highlighterRegistry) {
        if (this.compatibilityVersion < 12) {
            return;
        }
        SupportMods.xaeroMinimap.registerMinimapHighlighters((Object)highlighterRegistry);
    }

    public void createRadarRenderWrapper(RadarRenderer radarRenderer) {
        if (this.compatibilityVersion < 12) {
            return;
        }
        SupportMods.xaeroMinimap.createRadarRendererWrapper((Object)radarRenderer);
    }

    public boolean worldMapIsRenderingRadar() {
        if (this.compatibilityVersion < 12) {
            return false;
        }
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.MINIMAP_RADAR);
    }

    public boolean usesPartialYFromWorldMap() {
        return this.compatibilityVersion >= 16;
    }

    public boolean getPartialYTeleport() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.PARTIAL_Y_TELEPORT);
    }

    public boolean isStainedGlassDisplayed() {
        if (this.compatibilityVersion < 17) {
            return true;
        }
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.STAINED_GLASS);
    }

    public boolean hasCaveLayers() {
        return this.compatibilityVersion >= 19;
    }

    public boolean isMultiplayerMap() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return false;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        return mapProcessor.getMapWorld().isMultiplayer();
    }

    public int getManualCaveStart() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        SingleConfigManager wmPrimaryConfigManager = wmConfigManager.getPrimaryConfigManager();
        int caveModeStart = (Integer)wmPrimaryConfigManager.getEffective(WorldMapPrimaryClientConfigOptions.CAVE_MODE_START);
        return caveModeStart == Integer.MAX_VALUE ? Integer.MAX_VALUE : caveModeStart;
    }

    public boolean hasEnabledCaveLayers() {
        return this.getCaveModeType() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaveModeType() {
        if (!this.hasCaveLayers() || !WorldMapClientConfigUtils.getEffectiveCaveModeAllowed()) {
            return 0;
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        int defaultCaveModeType = (Integer)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.DEFAULT_CAVE_MODE_TYPE);
        if (worldmapSession == null) {
            return defaultCaveModeType;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.uiPauseSync;
        synchronized (object) {
            if (mapProcessor.isUIPaused()) {
                return defaultCaveModeType;
            }
            MapDimension mapDim = mapProcessor.getMapWorld().getCurrentDimension();
            if (mapDim != null) {
                return mapDim.getCaveModeType();
            }
        }
        return defaultCaveModeType;
    }

    public Screen getWorldMapScreenForOption(ConfigOption<?> option, Screen current) {
        Screen currentEscScreen;
        if (Minecraft.getInstance().level == null) {
            return null;
        }
        Screen screen = currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
        if (currentEscScreen instanceof GuiMap) {
            currentEscScreen = null;
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        GuiMap screen2 = new GuiMap(current, currentEscScreen, mapProcessor, Minecraft.getInstance().getCameraEntity());
        if (option == MinimapProfiledConfigOptions.MANUAL_CAVE_MODE_START) {
            screen2.enableCaveModeOptions();
        }
        return screen2;
    }

    public int getCaveModeDepth() {
        if (!this.hasCaveLayers()) {
            return 30;
        }
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Integer)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_DEPTH);
    }

    public boolean isLegibleCaveMaps() {
        if (!this.hasCaveLayers()) {
            return false;
        }
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.LEGIBLE_CAVE_MAPS);
    }

    public boolean hasBiomeBlendingOption() {
        return this.compatibilityVersion >= 20;
    }

    public boolean getBiomeBlending() {
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.BIOME_BLENDING);
    }

    public boolean hasTrackedPlayerSystemSupport() {
        return this.compatibilityVersion >= 22;
    }

    public void confirmPlayerRadarRender(Player e) {
        if (this.hasTrackedPlayerSystemSupport()) {
            if (WorldMap.trackedPlayerRenderer.getCollector().playerExists(e.getUUID())) {
                WorldMap.trackedPlayerRenderer.getCollector().confirmPlayerRadarRender(e);
            }
            return;
        }
        if (SupportMods.xaeroPac.playerExists(e.getUUID())) {
            SupportMods.xaeroPac.confirmPlayerRadarRender(e);
        }
    }

    public boolean getDisplayClaims() {
        if (this.compatibilityVersion < 14) {
            return false;
        }
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Boolean)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS);
    }

    public int getClaimsBorderOpacity() {
        if (this.compatibilityVersion < 14) {
            return 80;
        }
        if (this.compatibilityVersion < 17) {
            return 80;
        }
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Integer)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS_BORDER_OPACITY);
    }

    public int getClaimsFillOpacity() {
        if (this.compatibilityVersion < 14) {
            return 46;
        }
        if (this.compatibilityVersion < 17) {
            return 46;
        }
        ClientConfigManager wmConfigManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        return (Integer)wmConfigManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS_FILL_OPACITY);
    }

    public void toggleChunkClaims() {
        if (this.compatibilityVersion >= 14) {
            WorldMapClientConfigUtils.tryTogglingCurrentProfileOption((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS);
        }
    }

    public boolean supportsPacPlayerRadarFilter() {
        return this.compatibilityVersion >= 21;
    }

    public boolean hasDimensionSwitching() {
        return this.compatibilityVersion >= 24;
    }

    public boolean caveLayersAreUsable() {
        boolean result = this.hasEnabledCaveLayers();
        if (result && this.hasDimensionSwitching()) {
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            if (worldmapSession == null) {
                return result;
            }
            Entity player = Minecraft.getInstance().getCameraEntity();
            if (player == null) {
                return result;
            }
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
            if (mapDimension == null) {
                return result;
            }
            if (mapDimension.getDimId() != player.level.dimension()) {
                return false;
            }
        }
        return result;
    }

    public boolean shouldPreventAutoCaveMode(Level world) {
        if (!this.hasDimensionSwitching()) {
            return false;
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return false;
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
        if (mapDimension == null) {
            return false;
        }
        return mapDimension.getDimId() != world.dimension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getMapDimensionScale() {
        if (!this.hasDimensionSwitching()) {
            return Minecraft.getInstance().level.dimensionType().coordinateScale();
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return Minecraft.getInstance().level.dimensionType().coordinateScale();
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        Object object = mapProcessor.renderThreadPauseSync;
        synchronized (object) {
            if (mapProcessor.isRenderingPaused()) {
                return 0.0;
            }
            Registry dimTypes = mapProcessor.getWorldDimensionTypeRegistry();
            if (dimTypes == null) {
                return 0.0;
            }
            if (this.compatibilityVersion < 25) {
                return mapProcessor.getMapWorld().getCurrentDimension().calculateDimScale(dimTypes);
            }
            return mapProcessor.getMapWorld().getCurrentDimension().calculateDimScale();
        }
    }

    public ResourceKey<Level> getMapDimension() {
        if (!this.hasDimensionSwitching()) {
            return Minecraft.getInstance().level.dimension();
        }
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return Minecraft.getInstance().level.dimension();
        }
        MapProcessor mapProcessor = worldmapSession.getMapProcessor();
        MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
        return mapDimension == null ? Minecraft.getInstance().level.dimension() : mapDimension.getDimId();
    }

    public boolean shouldAlwaysInitEffects() {
        return this.compatibilityVersion < 26;
    }
}

