/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import xaero.common.misc.Misc;
import xaero.hud.pvp.module.entityinfo.EntityInfoSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.pvp.BetterPVP;

public class EntityInfoRenderer
implements IModuleRenderer<EntityInfoSession> {
    private final Random random = new Random();

    @Override
    public void render(EntityInfoSession session, ModuleRenderContext c, PoseStack matrixStack, float partialTicks) {
        LivingEntity displayedEntity;
        Minecraft mc = Minecraft.getInstance();
        long time = System.currentTimeMillis();
        EntityHitResult objectMouseOver = session.getDetector().getMouseOver(mc, (Level)mc.level, session.getEntityInfoDistance(), partialTicks);
        if (objectMouseOver != null && objectMouseOver.getEntity() instanceof LivingEntity) {
            ServerLevel serverWorld;
            session.setDisplayedEntity((LivingEntity)objectMouseOver.getEntity());
            if (mc.getSingleplayerServer() != null && (serverWorld = mc.getSingleplayerServer().getLevel(mc.level.dimension())) != null) {
                session.setDisplayedServerEntity((LivingEntity)serverWorld.getEntity(objectMouseOver.getEntity().getUUID()));
            }
            session.setLastDetection(time);
        }
        if ((displayedEntity = session.getDisplayedEntity()) == null) {
            return;
        }
        if (time - session.getLastDetection() > 1000L * (long)session.getEntityInfoStay()) {
            return;
        }
        if (System.currentTimeMillis() - session.getLastEffectBlink() > 500L) {
            session.setLastEffectBlink(System.currentTimeMillis());
            session.setEffectBlink(!session.getEffectBlink());
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            int healthOff;
            boolean flippedVer = c.flippedVertically;
            boolean flippedHor = c.flippedHorizontally;
            float resize = 1.0f;
            if (displayedEntity.getBbWidth() > resize) {
                resize = displayedEntity.getBbWidth();
            }
            if (displayedEntity.getBbHeight() > resize * 2.0f) {
                resize = displayedEntity.getBbHeight() / 2.0f;
            }
            if (session.getEntityInfoShowEntityModel()) {
                matrixStack.translate(0.0, 0.0, -500.0);
                RenderSystem.enableDepthTest();
                this.drawEntityOnScreen(mc, matrixStack, c.x + (flippedHor ? c.w - 25 : 25), c.y + 35, (int)(30.0f / resize), displayedEntity, flippedHor);
                RenderSystem.disableDepthTest();
                matrixStack.translate(0.0, 0.0, 500.0);
            }
            LivingEntity displayedServerEntity = session.getDisplayedServerEntity();
            int n = healthOff = session.getEntityInfoShowEntityModel() ? 55 : 5;
            if (mc.getSingleplayerServer() != null && session.getEntityInfoEffects() && displayedServerEntity != null) {
                int effectsOffset = (int)this.drawPotionEffects(mc, matrixStack, session, displayedServerEntity, c.x + (flippedHor ? c.w - 3 : 3), c.y + (flippedVer ? c.h - 5 : 5), flippedVer ? c.y + c.h : c.screenHeight - c.y, flippedHor, flippedVer, c.screenScale);
                if (!session.getEntityInfoShowEntityModel() && effectsOffset != -1) {
                    healthOff += 3 + effectsOffset;
                }
            }
            boolean renderedArmor = session.getEntityInfoShowArmour() && this.drawArmourBar(mc, matrixStack, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0), flippedHor);
            this.drawHealthBar(mc, matrixStack, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0) + (renderedArmor ? 10 : 0) * (flippedVer ? -1 : 1), flippedHor, flippedVer);
            Component component = Misc.getFixedDisplayName((Entity)displayedEntity);
            if (component != null) {
                String name = component.getString();
                int xCoord = c.x + (flippedHor ? c.w - healthOff - mc.font.width(name) : healthOff);
                GuiComponent.drawString((PoseStack)matrixStack, (Font)mc.font, (String)name, (int)xCoord, (int)(c.y + 5 + (flippedVer ? 52 : 0)), (int)0xFFFFFF);
            }
        }
        catch (Exception e) {
            BetterPVP.LOGGER.error("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums/CurseForge!", (Throwable)e);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(Minecraft mc, PoseStack matrixStack, int x, int y, int scale, LivingEntity entity, boolean flip) {
        double cos;
        if (entity == null) {
            return;
        }
        EntityRenderDispatcher rendermanager = mc.getEntityRenderDispatcher();
        if (rendermanager.camera == null) {
            return;
        }
        float yBodyRotBU = entity.yBodyRot;
        float yRotBU = entity.getYRot();
        float yHeadRotBU = entity.yHeadRot;
        entity.yBodyRot = 0.0f;
        entity.setYRot(0.0f);
        entity.yHeadRot = yHeadRotBU - yBodyRotBU;
        matrixStack.pushPose();
        matrixStack.translate((double)x, (double)y, 50.0);
        matrixStack.scale((float)(-scale), (float)scale, (float)scale);
        matrixStack.mulPose(Vector3f.ZP.rotationDegrees(180.0f));
        matrixStack.mulPose(Vector3f.XP.rotationDegrees(30.0f));
        float width = entity.getBbWidth() * (float)scale / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        matrixStack.mulPose(Vector3f.YP.rotationDegrees(flip ? -rotation : rotation));
        matrixStack.translate(0.0, (double)(-entity.getBbHeight() / 2.0f), 0.0);
        rendermanager.setRenderShadow(false);
        Lighting.setupFor3DItems();
        boolean hideGUIBU = mc.options.hideGui;
        mc.options.hideGui = true;
        try {
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            GraphicsStatus graphicsModeBU = mc.options.graphicsMode;
            mc.options.graphicsMode = GraphicsStatus.FANCY;
            rendermanager.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (MultiBufferSource)bufferSource, 0xF000F0);
            mc.options.graphicsMode = graphicsModeBU;
            bufferSource.endBatch();
        }
        finally {
            mc.options.hideGui = hideGUIBU;
            rendermanager.setRenderShadow(true);
            RenderSystem.disableBlend();
            entity.yBodyRot = yBodyRotBU;
            entity.setYRot(yRotBU);
            entity.yHeadRot = yHeadRotBU;
            matrixStack.popPose();
        }
    }

    public boolean drawArmourBar(Minecraft mc, PoseStack matrixStack, EntityInfoSession session, LivingEntity e, int x, int y, boolean flip) {
        int armorValue = e.getArmorValue();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Gui.GUI_ICONS_LOCATION);
        if (armorValue > 0) {
            if (session.getEntityInfoArmourNumbers()) {
                mc.gui.blit(matrixStack, x - (flip ? 8 : 0), y, 34, 9, 9, 9);
                GuiComponent.drawString((PoseStack)matrixStack, (Font)mc.font, (String)(armorValue + "/20"), (int)(x + (flip ? -11 - mc.font.width(armorValue + "/20") : 11)), (int)y, (int)0xFFFFFF);
            } else {
                for (int iconIndex = 0; iconIndex < 10; ++iconIndex) {
                    int iconX = x + (flip ? -8 - iconIndex * 8 : iconIndex * 8);
                    if (iconIndex * 2 + 1 < armorValue) {
                        mc.gui.blit(matrixStack, iconX, y, 34, 9, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 == armorValue) {
                        mc.gui.blit(matrixStack, iconX, y, 25, 9, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 <= armorValue) continue;
                    mc.gui.blit(matrixStack, iconX, y, 16, 9, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(Minecraft mc, PoseStack matrixStack, EntityInfoSession session, LivingEntity e, int x, int y, boolean flip, boolean vertFlipped) {
        int health = Mth.ceil((float)e.getHealth());
        float maxHealth = Mth.ceil((double)e.getAttributeValue(Attributes.MAX_HEALTH));
        float absorptionAmount = Mth.ceil((float)e.getAbsorptionAmount());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (session.getEntityInfoHealthNumbers()) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            GuiComponent.drawString((PoseStack)matrixStack, (Font)mc.font, (String)text, (int)(x + (flip ? -11 - mc.font.width(text) : 11)), (int)y, (int)-1);
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)Gui.GUI_ICONS_LOCATION);
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = (int)session.getEntityInfoMaxHearts() * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = Mth.ceil((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        Matrix4f modelMatrix = matrixStack.last().pose();
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += this.random.nextInt(2);
            }
            this.blitFlippable(modelMatrix, heartX, heartY, 25, 0, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.blitFlippable(modelMatrix, heartX, heartY, 169, 0, 9, 9, flip);
                } else {
                    this.blitFlippable(modelMatrix, heartX, heartY, 160, 0, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.blitFlippable(modelMatrix, heartX, heartY, 52, 0, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.blitFlippable(modelMatrix, heartX, heartY, 61, 0, 9, 9, flip);
        }
        RenderSystem.disableBlend();
    }

    public double drawPotionEffects(Minecraft mc, PoseStack matrixStack, EntityInfoSession session, LivingEntity e, int x, int y, int h, boolean flippedHor, boolean flippedVer, double scale) {
        Collection effects = e.getActiveEffects();
        if (effects.isEmpty()) {
            return -1.0;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        matrixStack.pushPose();
        matrixStack.translate((double)x, (double)y, 0.0);
        RenderSystem.enableBlend();
        MobEffectTextureManager effectSprites = mc.getMobEffectTextures();
        double pixelSize = (double)session.getEntityInfoEffectsScale() / scale * session.getAutoUIScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        int place = 0;
        for (MobEffectInstance pe : effects) {
            TextureAtlasSprite sprite;
            if (pe == null || (sprite = effectSprites.get(pe.getEffect())) == null) continue;
            matrixStack.pushPose();
            matrixStack.scale((float)pixelSize, (float)pixelSize, 1.0f);
            int column = place / perColumn;
            int row = place % perColumn;
            matrixStack.translate(flippedHor ? (double)(-18 - 25 * column) : (double)(25 * column), flippedVer ? (double)(-18 - 25 * row) : (double)(25 * row), 0.0);
            if (pe.getDuration() <= 200 && !session.getEffectBlink()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlas().location());
            GuiComponent.blit((PoseStack)matrixStack, (int)0, (int)0, (int)0, (int)18, (int)18, (TextureAtlasSprite)sprite);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ++place;
            matrixStack.popPose();
        }
        matrixStack.popPose();
        int rows = (effects.size() + perColumn - 1) / perColumn;
        return effectSize * (double)rows - 7.0 * pixelSize;
    }

    public void blitFlippable(Matrix4f matrix, int x, int y, int textureX, int textureY, int width, int height, boolean flip) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder vertexbuffer = tessellator.getBuilder();
        vertexbuffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        vertexbuffer.vertex(matrix, (float)(x + 0), (float)(y + height), 0.0f).uv((float)(textureX + (flip ? width : 0)) * 0.00390625f, (float)(textureY + height) * 0.00390625f).endVertex();
        vertexbuffer.vertex(matrix, (float)(x + width), (float)(y + height), 0.0f).uv((float)(textureX + (flip ? 0 : width)) * 0.00390625f, (float)(textureY + height) * 0.00390625f).endVertex();
        vertexbuffer.vertex(matrix, (float)(x + width), (float)(y + 0), 0.0f).uv((float)(textureX + (flip ? 0 : width)) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).endVertex();
        vertexbuffer.vertex(matrix, (float)(x + 0), (float)(y + 0), 0.0f).uv((float)(textureX + (flip ? width : 0)) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).endVertex();
        tessellator.end();
    }
}

