/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.tooltip;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import xaero.common.gui.GuiEditMode;
import xaero.hud.pvp.module.tooltip.ItemTooltipSession;
import xaero.hud.pvp.module.tooltip.TooltipScreenInstance;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class ItemTooltipRenderer
implements IModuleRenderer<ItemTooltipSession> {
    public static final Method METHOD_renderTooltipInternal = ReflectionUtils.getMethodReflection(Screen.class, (String)"renderTooltipInternal", (String)"method_32633", (String)"(Lnet/minecraft/class_4587;Ljava/util/List;II)V", (String)"m_169383_", (Class[])new Class[]{PoseStack.class, List.class, Integer.TYPE, Integer.TYPE});

    @Override
    public void render(ItemTooltipSession session, ModuleRenderContext c, PoseStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack currentStack = mc.player.getInventory().getSelected();
        if (currentStack != session.getPreviousStack()) {
            session.setItemSwitchTime(System.currentTimeMillis());
            session.setPreviousStack(currentStack);
        }
        if (currentStack == null) {
            return;
        }
        if (currentStack.isEmpty()) {
            return;
        }
        if (!(mc.screen instanceof GuiEditMode) && System.currentTimeMillis() - session.getItemSwitchTime() > (long)((int)(session.getItemTooltipTime() * 1000.0))) {
            return;
        }
        TooltipScreenInstance screenInstance = session.getScreenInstance();
        screenInstance.setNecessaryFields(mc);
        int screenWidth = c.screenWidth;
        int screenHeight = c.screenHeight;
        List<ClientTooltipComponent> textLines = session.getTooltipHelper().getTooltipLines(mc, currentStack, c.screenWidth, c.screenHeight, screenInstance);
        if (textLines.size() >= session.getItemTooltipMinLines()) {
            int border = 5;
            int renderX = c.x + border;
            int renderY = c.y + border;
            int renderW = c.w - 2 * border;
            int renderH = c.h - 2 * border;
            if (session.isCentered() || c.flippedHorizontally) {
                int tooltipTextWidth = 0;
                for (ClientTooltipComponent textLine : textLines) {
                    int textLineWidth = textLine.getWidth(mc.font);
                    if (textLineWidth <= tooltipTextWidth) continue;
                    tooltipTextWidth = textLineWidth;
                }
                int tooltipWidth = tooltipTextWidth + 8;
                if (session.isCentered()) {
                    renderX += (renderW - tooltipWidth) / 2;
                } else {
                    screenWidth = renderX + renderW;
                    renderX += renderW - tooltipWidth;
                }
            }
            if (c.flippedVertically) {
                int tooltipHeight = 16;
                if (textLines.size() > 1) {
                    tooltipHeight += 2 + (textLines.size() - 1) * 10;
                }
                screenHeight = renderY + renderH + 2;
                renderY += renderH - tooltipHeight;
            }
            screenInstance.width = screenWidth;
            screenInstance.height = screenHeight;
            int renderXWithOffset = renderX - 8;
            int renderYWithOffset = renderY + 16;
            ReflectionUtils.getReflectMethodValue((Object)((Object)screenInstance), (Method)METHOD_renderTooltipInternal, (Object[])new Object[]{matrixStack, textLines, renderXWithOffset, renderYWithOffset});
            Lighting.setupFor3DItems();
        }
    }
}

